/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.NotFoundException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.auth.module.core.rest.client.json.CoreauthmoduleJSON;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.dao.api.NotUniqueFieldException;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.RestoreRootUserHubDtoBuidler;
import jetbrains.youtrack.ring.impl.BeansKt;
import jetbrains.youtrack.ring.impl.HubRootRestorer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/ring/impl/HubRootRestorer;", "", "()V", "gatherAllPermissions", "", "Ljetbrains/jetpass/rest/dto/PermissionJSON;", "getAuthModuleClient", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "postRestoredRootToHub", "", "restoreAdminRole", "restoreCoreAuthModule", "restoreRootUser", "Companion", "youtrack-ring-integration"})
public final class HubRootRestorer {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postRestoredRootToHub() {
        boolean suspended = HubReplicatingMarker.INSTANCE.areRingNotificationsForThreadSuspended();
        if (!suspended) {
            HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
        }
        try {
            this.restoreCoreAuthModule();
            this.restoreAdminRole();
            LegacySupportKt.flush();
            this.restoreRootUser();
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().syncNow();
            Companion.getLogger().info("Root user account has been reset");
        }
        finally {
            HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
        }
    }

    private final void restoreCoreAuthModule() {
        for (AuthmoduleJSON module : this.getAuthModuleClient().getAuthModulePage(null, null).getItems()) {
            if (!(module instanceof CoreauthmoduleJSON)) continue;
            module.setDisabled(Boolean.valueOf(false));
            AuthModuleClient authModuleClient = this.getAuthModuleClient();
            String string = module.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.getId()!!");
            authModuleClient.updateAuthModule(string, module);
        }
    }

    private final void restoreAdminRole() {
        XdRole admin2 = (XdRole)XdQueryKt.first((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdRole.Companion.all(), (Function2)restoreAdminRole.admin.1.INSTANCE));
        RoleJSON roleDto = new RoleJSON();
        roleDto.setPermissions((Iterable)this.gatherAllPermissions());
        HubSyncAdapter<XdRole> adapter2 = jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getRoleAdapter();
        if (adapter2.isExported(admin2) && jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().get(EntityExtensionsKt.getHubUuid((XdEntity)admin2)) != null) {
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().update(EntityExtensionsKt.getHubUuidNotNull((XdEntity)admin2), (IdItem)roleDto);
        } else {
            Role created;
            roleDto.setName(admin2.getName());
            roleDto.setDescription(admin2.getDescription());
            try {
                created = (Role)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().create((IdItem)roleDto);
            }
            catch (NotUniqueFieldException e) {
                roleDto.setName(roleDto.getName() + ' ' + RandomStringUtils.randomAlphabetic((int)5));
                created = (Role)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().create((IdItem)roleDto);
            }
            EntityExtensionsKt.setHubUuid((XdEntity)admin2, created.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionJSON> gatherAllPermissions() {
        void $receiver$iv$iv;
        Permission[] $receiver$iv;
        PermissionJSON permissionJSON;
        Object object;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        IdItem idItem = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().get(BeansKt.getHubServiceUuid());
        if (idItem == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"ringApi.serviceDAO.get(hubServiceUuid)!!");
        Iterable iterable = ((jetbrains.jetpass.api.Service)idItem).getPermissions();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"ringApi.serviceDAO.get(h\u2026erviceUuid)!!.permissions");
        Iterable iterable2 = $receiver$iv2 = iterable;
        Permission[] destination$iv$iv = (Permission[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void p1;
            jetbrains.jetpass.api.security.Permission permission2 = (jetbrains.jetpass.api.security.Permission)item$iv$iv;
            object = destination$iv$iv;
            permissionJSON = new PermissionJSON((jetbrains.jetpass.api.security.Permission)p1);
            object.add(permissionJSON);
        }
        List hubPermissions = (List)destination$iv$iv;
        destination$iv$iv = $receiver$iv = Permission.values();
        Collection destination$iv$iv2 = new ArrayList($receiver$iv.length);
        void var6_6 = $receiver$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void $i$f$map = item$iv$iv = var6_6[i];
            object = destination$iv$iv2;
            PermissionJSON permission3 = new PermissionJSON();
            permission3.setId(EntityExtensionsKt.getHubUuid((Permission)it));
            permissionJSON = permission3;
            object.add(permissionJSON);
        }
        List youtrackPermissions = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)hubPermissions, (Iterable)youtrackPermissions);
    }

    private final void restoreRootUser() {
        HubSyncAdapter<XdUser> adapter2 = jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getUserAdapter(new RestoreRootUserHubDtoBuidler());
        Entity entity = jetbrains.charisma.persistent.BeansKt.getSecurity().getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.root");
        XdUser root = (XdUser)XdExtensionsKt.toXd((Entity)entity);
        try {
            adapter2.update(root);
        }
        catch (NotFoundException e) {
            adapter2.add(root);
        }
    }

    private final AuthModuleClient getAuthModuleClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getAuthModuleClient();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubRootRestorer$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

