/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.net.URL;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.authority.User;
import jetbrains.youtrack.api.ring.RingUrls;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import webr.framework.url.UrlUtil;

@Service(value="ringUrls")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/ring/impl/RingUrlsImpl;", "Ljetbrains/youtrack/api/ring/RingUrls;", "()V", "base", "Ljavax/ws/rs/core/UriBuilder;", "getAbsoluteHubUserAvatarUrl", "", "user", "Ljetbrains/exodus/entitystore/Entity;", "getCreateHubProjectUrl", "getHubUrl", "getHubUserAvatarUrl", "getRelativeHubUrl", "absoluteUrl", "getRingSetupPageUrl", "youtrack-ring-integration"})
public final class RingUrlsImpl
implements RingUrls {
    @NotNull
    public String getHubUrl() {
        String string = this.base().build(new Object[0]).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"base().build().toString()");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getHubUserAvatarUrl(@NotNull Entity user2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        String uuid2 = EntityExtensionsKt.getHubUuid(user2);
        if (uuid2 == null) {
            String string2 = this.base().path("api").path("rest").path("avatar").path("default").queryParam("s", new Object[]{"48"}).build(new Object[0]).toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"base().path(\"api\").path(\u2026 \"48\").build().toString()");
            return string;
        }
        User user3 = (User)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(uuid2);
        String url = user3 != null && (user3 = user3.getProfile()) != null && (user3 = user3.getAvatar()) != null ? user3.getUrl() : null;
        UriBuilder builder = this.base().path("api").path("rest").path("avatar").path("{id}").queryParam("s", new Object[]{"48"});
        String string3 = url;
        String string4 = (string3 != null && StringsKt.contains$default((CharSequence)string3, (CharSequence)"etag", (boolean)false, (int)2, null) ? builder.queryParam("etag", new Object[]{CollectionsKt.last((List)StringsKt.split$default((CharSequence)url, (String[])new String[]{"etag"}, (boolean)false, (int)0, (int)6, null))}) : builder).build(new Object[]{uuid2}).toString();
        string = string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"if (url?.contains(\"etag\"\u2026 }.build(uuid).toString()");
        return string;
    }

    @NotNull
    public String getAbsoluteHubUserAvatarUrl(@NotNull Entity user2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            URL url;
            XdNotificationsConfig notificationConfig = (XdNotificationsConfig)XdNotificationsConfig.Companion.wrap((Entity)jetbrains.charisma.persistent.BeansKt.getNotificationsConfig());
            String string2 = notificationConfig.getBaseUrl();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String portPart = (url = new URL(string2)).getPort() == -1 ? "" : "" + ':' + url.getPort();
            string = url.getProtocol() + "://" + url.getHost() + portPart + this.getHubUserAvatarUrl(user2);
        } else {
            string = this.getHubUserAvatarUrl(user2);
        }
        return string;
    }

    @NotNull
    public String getRingSetupPageUrl() {
        UrlUtil.Url url;
        UrlUtil.Url $receiver = url = new UrlUtil.Url();
        $receiver.setIsLocal();
        $receiver.addPathElements(new String[]{"admin", "ring"});
        String string = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UrlUtil.Url().apply {\n  \u2026 \"ring\")\n    }.toString()");
        return string;
    }

    @NotNull
    public String getCreateHubProjectUrl() {
        String string = this.base().path("projects").path("new").build(new Object[0]).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"base().path(\"projects\").\u2026\"new\").build().toString()");
        return string;
    }

    private final UriBuilder base() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getUrl();
        if (string == null) {
            throw (Throwable)new IllegalStateException("No Hub URL configured yet");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.getRelativeHubUrl(string));
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromPath(getR\u2026ub URL configured yet\")))");
        return uriBuilder;
    }

    private final String getRelativeHubUrl(String absoluteUrl) {
        if (BeansKt.getRingConfig().hasEmbeddedHub() && !StringsKt.startsWith$default((String)absoluteUrl, (String)"/", (boolean)false, (int)2, null)) {
            String string;
            CharSequence charSequence;
            URL url = new URL(absoluteUrl);
            String query = url.getQuery();
            if (query != null && (charSequence = (CharSequence)query).length() > 0) {
                string = url.getPath() + "?" + query;
            } else {
                String string2 = url.getPath();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
            }
            return string;
        }
        return absoluteUrl;
    }
}

