/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.maintenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.PermissionClient;
import jetbrains.jetpass.client.accounts.ProjectTeamClient;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.client.accounts.UserGroupClient;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.BeansKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.RingAuditLog;
import jetbrains.youtrack.ring.client.AuthClientWrapper;
import jetbrains.youtrack.ring.maintenance.HubIntegrationUserActionJob;
import jetbrains.youtrack.ring.persistence.quickfix.XdGroupMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdResourceLocationQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdRoleMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdUnknownResourceQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdUserMappingQuickFix;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/ring/maintenance/HubMappingValidationJob;", "Ljetbrains/youtrack/ring/maintenance/HubIntegrationUserActionJob;", "()V", "ordinal", "", "getOrdinal", "()I", "uiDescription", "", "getUiDescription", "()Ljava/lang/String;", "uiName", "getUiName", "collectIds", "", "items", "", "Ljetbrains/jetpass/api/IdItem;", "preloadHubUuids", "loader", "Lkotlin/Function1;", "Ljetbrains/jetpass/client/Filter;", "run", "", "validateGroups", "validatePermissions", "validateProjects", "validateRoles", "validateTeams", "validateUsers", "youtrack-ring-integration"})
public final class HubMappingValidationJob
extends HubIntegrationUserActionJob {
    private final int ordinal = 2;

    @Override
    @NotNull
    public String getUiName() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("HubMappingValidationJob.Run_diagnostics", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026tionJob.Run_diagnostics\")");
        return string;
    }

    @Override
    @NotNull
    public String getUiDescription() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("HubMappingValidationJob.Detect_broken_or_missing_links_between_YouTrack_and_Hub_data", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026n_YouTrack_and_Hub_data\")");
        return string;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    protected void run() {
        RingAuditLog ringAuditLog = BeansKt.getRingAuditLog();
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        ringAuditLog.withActivity(string, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("Hub mapping validation job started");
                try {
                    if (jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled()) {
                        HubMappingValidationJob.access$validatePermissions(this.this$0);
                        HubMappingValidationJob.access$validateRoles(this.this$0);
                        HubMappingValidationJob.access$validateProjects(this.this$0);
                        HubMappingValidationJob.access$validateGroups(this.this$0);
                        HubMappingValidationJob.access$validateTeams(this.this$0);
                        HubMappingValidationJob.access$validateUsers(this.this$0);
                    } else {
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Can't validate Hub mappings: No connection to Hub");
                    }
                }
                catch (Exception e) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Hub mapping validation job failed: " + e.getMessage());
                    throw (Throwable)e;
                }
                finally {
                    this.this$0.setStatus("Hub mapping validation job completed");
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info(this.this$0.getStatus());
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(0);
            }
        }));
    }

    private final void validateUsers() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                Iterable<E> $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user mapping...");
                UserClient client = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient();
                Partial partial = Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.ALIAS_IDS});
                Set hubUsers = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends UserJSON>>(client, partial){
                    final /* synthetic */ UserClient $client;
                    final /* synthetic */ Partial $partial;
                    {
                        this.$client = userClient;
                        this.$partial = partial;
                        super(1);
                    }

                    @NotNull
                    public final List<UserJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getUserPage((BaseFilter)filter, (FieldPartial)this.$partial).getUsers();
                    }
                });
                List brokenUsers = new ArrayList<E>();
                int procesed = 0;
                List userBatch = XdQueryKt.toList((XdQuery)XdQueryKt.take((XdQuery)XdUser.Companion.all(), (int)500));
                do {
                    void $receiver$iv$iv;
                    Iterable iterable = userBatch;
                    List list = brokenUsers;
                    Iterator<E> iterator2 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        XdUser localUser2 = (XdUser)element$iv$iv;
                        if (!(!CollectionsKt.contains((Iterable)hubUsers, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localUser2)) && !localUser2.isService() && !localUser2.isSystem())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    list.addAll(list2);
                } while (!($receiver$iv = (Collection)(userBatch = XdQueryKt.toList((XdQuery)XdQueryKt.take((XdQuery)XdQueryKt.drop((XdQuery)XdUser.Companion.all(), (int)(procesed += 500)), (int)500)))).isEmpty());
                if (brokenUsers.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All users have valid mappings in Hub");
                } else {
                    $receiver$iv = brokenUsers;
                    for (E element$iv : $receiver$iv) {
                        XdUser user2 = (XdUser)element$iv;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)user2);
                        String message2 = string == null ? "User " + user2.getLogin() + " is not exported to hub" : "User " + user2.getLogin() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdUserMappingQuickFix.Companion.new(user2));
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void validateGroups() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user group mapping...");
                UserGroupClient ugClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserGroupClient();
                Partial partial = Partial.userGroup((Partial.UserGroup[])new Partial.UserGroup[]{Partial.UserGroup.ID, Partial.UserGroup.ALIAS_IDS});
                Set hubGroups = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends UserGroupJSON>>(ugClient, partial){
                    final /* synthetic */ UserGroupClient $ugClient;
                    final /* synthetic */ Partial $partial;
                    {
                        this.$ugClient = userGroupClient;
                        this.$partial = partial;
                        super(1);
                    }

                    @NotNull
                    public final List<UserGroupJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$ugClient.getUserGroupPage((BaseFilter)filter, (FieldPartial)this.$partial).getUsergroups();
                    }
                });
                Iterable $receiver$iv = XdQueryKt.toList((XdQuery)XdUserGroup.Companion.all());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    XdUserGroup localGroup2 = (XdUserGroup)element$iv$iv;
                    if (!(!EntityExtensionsKt.isTeam(localGroup2) && !CollectionsKt.contains((Iterable)hubGroups, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localGroup2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenGroups = (List)destination$iv$iv;
                if (brokenGroups.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All user groups have valid mappings in Hub");
                } else {
                    $receiver$iv = brokenGroups;
                    for (E element$iv : $receiver$iv) {
                        XdUserGroup group2 = (XdUserGroup)element$iv;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)group2);
                        String message2 = string == null ? "User group " + group2.getName() + " is not exported to hub" : "User group " + group2.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdGroupMappingQuickFix.Companion.new(group2));
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void validateTeams() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub project team mapping...");
                Object object = ServiceLocator.getBean((String)"hubClient");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.ring.client.AuthClientWrapper");
                }
                ProjectTeamClient client = ((AuthClientWrapper)object).getAccountsClient().getProjectTeamClient();
                Partial partial = Partial.projectTeam((Partial.ProjectTeam[])new Partial.ProjectTeam[]{Partial.ProjectTeam.ID});
                Set hubTeams = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends ProjectTeamJSON>>(client, partial){
                    final /* synthetic */ ProjectTeamClient $client;
                    final /* synthetic */ Partial $partial;
                    {
                        this.$client = projectTeamClient;
                        this.$partial = partial;
                        super(1);
                    }

                    @NotNull
                    public final List<ProjectTeamJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getProjectTeamPage((BaseFilter)filter, (FieldPartial)this.$partial).getProjectteams();
                    }
                });
                Iterable $receiver$iv = XdQueryKt.toList((XdQuery)XdUserGroup.Companion.all());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    XdUserGroup localGroup2 = (XdUserGroup)element$iv$iv;
                    if (!(EntityExtensionsKt.isTeam(localGroup2) && !CollectionsKt.contains((Iterable)hubTeams, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localGroup2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenTeams = (List)destination$iv$iv;
                if (brokenTeams.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All project teams have valid mappings in Hub");
                } else {
                    $receiver$iv = brokenTeams;
                    for (E element$iv : $receiver$iv) {
                        XdUserGroup group2 = (XdUserGroup)element$iv;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)group2);
                        String message2 = string == null ? "User " + group2.getName() + " is not exported to hub" : "User " + group2.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdGroupMappingQuickFix.Companion.new(group2));
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void validatePermissions() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Object $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub permission mapping...");
                Filter filter = new Filter(null, 1, null);
                filter.query("service: 0-0-0-0-0 or service: " + jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
                PermissionClient.Page page = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getPermissionClient().getPermissionPage((BaseFilter)filter, (FieldPartial)Partial.permission((Partial.Permission[])new Partial.Permission[]{Partial.Permission.ID}));
                Set hubPermissions = HubMappingValidationJob.access$collectIds(this.this$0, page.getItems());
                Object object = $receiver$iv = Permission.values();
                Collection destination$iv$iv = new ArrayList<E>();
                for (void element$iv$iv : $receiver$iv$iv) {
                    void localPermission = element$iv$iv;
                    if (!(!CollectionsKt.contains((Iterable)hubPermissions, (Object)EntityExtensionsKt.getHubUuid((Permission)localPermission)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenPermissions = (List)destination$iv$iv;
                if (brokenPermissions.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All permissions have valid mappings in Hub");
                } else {
                    $receiver$iv = brokenPermissions;
                    object = $receiver$iv.iterator();
                    while (object.hasNext()) {
                        String string;
                        E element$iv = object.next();
                        Permission permission2 = (Permission)element$iv;
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error((string = EntityExtensionsKt.getHubUuid(permission2)) == null ? "Permission " + permission2.name() + " is not exported to Hub" : "Permission " + permission2.name() + " has invalid Hub mapping");
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void validateRoles() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user role mapping...");
                Object object = ServiceLocator.getBean((String)"hubClient");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.ring.client.AuthClientWrapper");
                }
                RoleClient client = ((AuthClientWrapper)object).getAccountsClient().getRoleClient();
                Partial partial = Partial.role((Partial.Role[])new Partial.Role[]{Partial.Role.ID, Partial.Role.ALIAS_IDS});
                Set hubRoles = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends RoleJSON>>(client, partial){
                    final /* synthetic */ RoleClient $client;
                    final /* synthetic */ Partial $partial;
                    {
                        this.$client = roleClient;
                        this.$partial = partial;
                        super(1);
                    }

                    @NotNull
                    public final List<RoleJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getRolePage((BaseFilter)filter, (FieldPartial)this.$partial).getRoles();
                    }
                });
                Iterable $receiver$iv = XdQueryKt.toList((XdQuery)XdRole.Companion.all());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    XdRole localRole = (XdRole)element$iv$iv;
                    if (!(!CollectionsKt.contains((Iterable)hubRoles, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localRole)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenRoles = (List)destination$iv$iv;
                if (brokenRoles.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All roles have valid mappings in Hub");
                } else {
                    $receiver$iv = brokenRoles;
                    for (E element$iv : $receiver$iv) {
                        XdRole role = (XdRole)element$iv;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)role);
                        String message2 = string == null ? "Role " + role.getName() + " is not exported to hub" : "Role " + role.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdRoleMappingQuickFix.Companion.new(role));
                    }
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final void validateProjects() {
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(@NotNull TransientStoreSession it) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                XdProject project;
                Iterable<Object> element$iv2;
                void $receiver$iv$iv2;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub project mapping...");
                ServiceClient serviceClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getServiceClient();
                String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                ServiceClient.ResourceClient client = serviceClient.getResourcesClient(string);
                Partial partial = Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.ID, Partial.Resource.ALIAS_IDS});
                Set hubResources = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends ResourceJSON>>(client, partial){
                    final /* synthetic */ ServiceClient.ResourceClient $client;
                    final /* synthetic */ Partial $partial;
                    {
                        this.$client = resourceClient;
                        this.$partial = partial;
                        super(1);
                    }

                    @NotNull
                    public final List<ResourceJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getResourcePage((BaseFilter)filter, (FieldPartial)this.$partial).getResources();
                    }
                });
                Iterable $receiver$iv2 = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                Iterator<Object> iterator2 = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv2) {
                    XdProject project2 = (XdProject)element$iv$iv;
                    if (!(!CollectionsKt.contains((Iterable)hubResources, (Object)EntityExtensionsKt.getHubUuid((XdEntity)project2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenProjects = (List)destination$iv$iv;
                if (brokenProjects.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All projects have valid mappings in Hub ");
                    if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
                        $receiver$iv2 = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                        for (Iterable<Object> element$iv2 : $receiver$iv2) {
                            project = (XdProject)element$iv2;
                            ResourceJSON resource = client.getResource(EntityExtensionsKt.getHubUuidNotNull((XdEntity)project), (FieldPartial)Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.PROJECT((Partial.Project[])new Partial.Project[]{Partial.Project.NAME})}));
                            ProjectJSON projectJSON = resource.getProject();
                            if (!(Intrinsics.areEqual((Object)project.getName(), (Object)(projectJSON != null ? projectJSON.getName() : null)) ^ true)) continue;
                            XdResourceLocationQuickFix fix = XdResourceLocationQuickFix.Companion.new(project);
                            ProjectJSON projectJSON2 = resource.getProject();
                            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Project " + project.getName() + " has wrong location in Hub (" + (projectJSON2 != null ? projectJSON2.getName() : null) + ')', fix);
                        }
                    }
                } else {
                    $receiver$iv2 = brokenProjects;
                    for (Iterable<Object> element$iv2 : $receiver$iv2) {
                        project = (XdProject)element$iv2;
                        if (EntityExtensionsKt.getHubUuid((XdEntity)project) == null) {
                            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Project " + project.getName() + " is not exported to Hub");
                            continue;
                        }
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Project " + project.getName() + " has invalid Hub mapping");
                    }
                }
                element$iv2 = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                Set set = hubResources;
                project = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    XdProject $i$f$forEach = (XdProject)item$iv$iv;
                    collection = destination$iv$iv2;
                    String string2 = EntityExtensionsKt.getHubUuid((XdEntity)it2);
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv2;
                for (String unknownUuid : CollectionsKt.filterNotNull((Iterable)SetsKt.minus((Set)set, (Iterable)collection))) {
                    ResourceJSON resource = client.getResource(unknownUuid, (FieldPartial)Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.KEY}));
                    XdUnknownResourceQuickFix fix = XdUnknownResourceQuickFix.Companion.new(unknownUuid, resource.getKey());
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Resource " + resource.getKey() + " belongs to 'YouTrack', but does not have a valid project associated", fix);
                }
                return Unit.INSTANCE;
            }
        }), (int)7, null);
    }

    private final Set<String> preloadHubUuids(Function1<? super Filter, ? extends List<? extends IdItem>> loader) {
        List items;
        Collection collection;
        int hubPageSize = 250;
        HashSet uuids = new HashSet();
        Filter filter = new Filter(null, 1, null);
        int skip = 0;
        filter.top(hubPageSize);
        do {
            items = (List)loader.invoke((Object)filter);
            uuids.addAll(this.collectIds(items));
            filter.skip(skip += hubPageSize);
        } while (!(collection = (Collection)items).isEmpty());
        return uuids;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectIds(List<? extends IdItem> items) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)items;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            IdItem idItem = (IdItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getId();
            collection.add(string);
        }
        List ids = (List)destination$iv$iv;
        Iterable $receiver$iv2 = items;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list;
            IdItem item = (IdItem)element$iv$iv;
            if (item.getAliases() != null) {
                void $receiver$iv$iv3;
                Iterable $receiver$iv3;
                Iterable $i$f$map = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    void it;
                    Alias alias = (Alias)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    void v0 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                    String string = v0.getId();
                    collection.add(string);
                }
                list = (List)destination$iv$iv3;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List aliases = (List)destination$iv$iv2;
        return CollectionsKt.union((Iterable)ids, (Iterable)aliases);
    }

    public HubMappingValidationJob() {
        super("Hub mapping validation job");
    }

    public static final /* synthetic */ void access$validatePermissions(HubMappingValidationJob $this) {
        $this.validatePermissions();
    }

    public static final /* synthetic */ void access$validateRoles(HubMappingValidationJob $this) {
        $this.validateRoles();
    }

    public static final /* synthetic */ void access$validateProjects(HubMappingValidationJob $this) {
        $this.validateProjects();
    }

    public static final /* synthetic */ void access$validateGroups(HubMappingValidationJob $this) {
        $this.validateGroups();
    }

    public static final /* synthetic */ void access$validateTeams(HubMappingValidationJob $this) {
        $this.validateTeams();
    }

    public static final /* synthetic */ void access$validateUsers(HubMappingValidationJob $this) {
        $this.validateUsers();
    }

    @NotNull
    public static final /* synthetic */ Set access$preloadHubUuids(HubMappingValidationJob $this, @NotNull Function1 loader) {
        return $this.preloadHubUuids((Function1<? super Filter, ? extends List<? extends IdItem>>)loader);
    }

    @NotNull
    public static final /* synthetic */ Set access$collectIds(HubMappingValidationJob $this, @NotNull List items) {
        return $this.collectIds(items);
    }
}

