/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.refactoring;

import java.util.Calendar;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringFixDefaultAdminAccount;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "meta", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "getName", "", "Companion", "youtrack-ring-integration"})
public final class RefactoringFixDefaultAdminAccount
extends XdRefactoring {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "Fix the default admin account (JPS-4145)";
    }

    public void apply(@NotNull XdApplicationMetaData meta) {
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        try {
            Filter filter = new Filter(null, 1, null);
            filter.query("name: default_admin_name");
            Partial partial = Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.LOGIN, Partial.User.CREATION_TIME});
            UserClient client = BeansKt.getHubClient().getAccountsClient().getUserClient();
            for (UserJSON user2 : client.getUserPage((BaseFilter)filter, (FieldPartial)partial).getItems()) {
                Calendar calendar = user2.getCreationTime();
                if (calendar == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"user.creationTime!!");
                if (calendar.getTimeInMillis() <= 1472688000000L) continue;
                RefactoringFixDefaultAdminAccount.access$getLog$p$s-1021457600().info((Object)("Fixing default admin username for user " + user2.getLogin()));
                user2.setName(user2.getLogin());
                String string = user2.getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id!!");
                client.updateUser(string, user2);
            }
            this.markApplied();
        }
        catch (Exception e) {
            Companion.getLogger().warn("Failed to override default admin username", (Throwable)e);
        }
    }

    public static final /* synthetic */ Log access$getLog$p$s-1021457600() {
        return Refactoring.log;
    }

    public static final /* synthetic */ void access$setLog$p$s-1021457600(Log log2) {
        Refactoring.log = log2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringFixDefaultAdminAccount$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

