/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.refactoring;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.persistent.XdApplicationMetaData;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncGuest;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "meta", "Ljetbrains/youtrack/persistent/XdApplicationMetaData;", "getName", "", "Companion", "youtrack-ring-integration"})
public final class RefactoringSyncGuest
extends XdRefactoring {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "Sync guest user data from Hub";
    }

    public void apply(@NotNull XdApplicationMetaData meta) {
        Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
        try {
            Entity entity = BeansKt.getSecurity().getGuest();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.guest");
            new RingUser(EntityExtensionsKt.getHubUuidNotNull(XdExtensionsKt.toXd((Entity)entity))).resolveAndSync();
            this.markApplied();
        }
        catch (Exception e) {
            Companion.getLogger().warn("Guest sync refactoring cannot be applied", (Throwable)e);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/refactoring/RefactoringSyncGuest$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

