/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.http.HttpServletRequest;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/ring/sync/RedirectUriRegistry;", "", "()V", "client", "Ljetbrains/jetpass/client/accounts/ServiceClient;", "getClient", "()Ljetbrains/jetpass/client/accounts/ServiceClient;", "redirectUris", "", "", "ensureRedirectUriExists", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "shouldAppendPortToRedirectUri", "", "updateRedirectUris", "uris", "updateServiceRedirectUris", "newRedirectUri", "Companion", "youtrack-ring-integration"})
public final class RedirectUriRegistry {
    private volatile Set<String> redirectUris = new HashSet();
    private static final String[] REDIRECT_URI_PATTERNS;
    public static final Companion Companion;

    private final ServiceClient getClient() {
        return BeansKt.getHubClient().getAccountsClient().getServiceClient();
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureRedirectUriExists(@NotNull HttpServletRequest req) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            StringBuilder builder = new StringBuilder(req.getScheme());
            builder.append("://").append(req.getServerName());
            if (this.shouldAppendPortToRedirectUri(req)) {
                builder.append(":").append(req.getServerPort());
            }
            String string = req.getContextPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"req.contextPath");
            CharSequence charSequence = string;
            if (charSequence.length() > 0) {
                builder.append(req.getContextPath());
            }
            String string2 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
            String uri = string2;
            String[] stringArray = REDIRECT_URI_PATTERNS;
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var7_8 = $receiver$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var7_8[i];
                if (!(!this.redirectUris.contains(uri + (String)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                this.updateServiceRedirectUris(uri);
            }
        }
        catch (Exception e) {
            Companion.getLogger().warn("Failed to register redirect uri in Hub", (Throwable)e);
        }
    }

    public final void updateRedirectUris(@NotNull Set<String> uris) {
        Intrinsics.checkParameterIsNotNull(uris, (String)"uris");
        this.redirectUris = new ConcurrentSkipListSet(uris);
    }

    public final synchronized void updateServiceRedirectUris(@NotNull String newRedirectUri) {
        Object object;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)newRedirectUri, (String)"newRedirectUri");
        Service service = (Service)BeansKt.getRingApi().getServiceDAO().get(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        ServiceJSON updatedService = new ServiceJSON();
        TreeSet<String> redirectUris = new TreeSet<String>();
        Object object2 = service;
        if (object2 != null && (object2 = object2.getRedirectUris()) != null) {
            $receiver$iv = object2;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                String it = (String)element$iv;
                redirectUris.add(it);
            }
        }
        object = $receiver$iv = REDIRECT_URI_PATTERNS;
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object it = element$iv = object[i];
            redirectUris.add(newRedirectUri + (String)it);
            redirectUris.add('.' + (String)it);
        }
        updatedService.setRedirectUris((Iterable)redirectUris);
        ServiceClient serviceClient = this.getClient();
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        serviceClient.updateService(string, updatedService);
        this.redirectUris = redirectUris;
    }

    private final boolean shouldAppendPortToRedirectUri(HttpServletRequest req) {
        return !(StringsKt.equals((String)"http", (String)req.getScheme(), (boolean)true) && req.getServerPort() == 80 || StringsKt.equals((String)"https", (String)req.getScheme(), (boolean)true) && req.getServerPort() == 443);
    }

    static {
        Companion = new Companion(null);
        REDIRECT_URI_PATTERNS = new String[]{"/admin/hub", "/oauth"};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/sync/RedirectUriRegistry$Companion;", "Lmu/KLogging;", "()V", "REDIRECT_URI_PATTERNS", "", "", "[Ljava/lang/String;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

