/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.Locale;
import java.util.NoSuchElementException;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.jetpass.api.authority.Profile;
import jetbrains.jetpass.api.authority.User;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserDetailsSync;", "", "()V", "syncContacts", "", "user", "Ljetbrains/youtrack/persistent/XdUser;", "remoteUser", "Ljetbrains/jetpass/api/authority/User;", "syncGuestDetails", "localUser", "syncLocale", "syncLogin", "hubLogin", "", "syncUserDetails", "Companion", "youtrack-ring-integration"})
public final class RingUserDetailsSync {
    public static final Companion Companion = new Companion(null);

    public final void syncUserDetails(@NotNull XdUser localUser2, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)localUser2, (String)"localUser");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        Companion.getLogger().trace("Syncing user data: " + localUser2.getLogin());
        this.syncLogin(localUser2, remoteUser.getLogin());
        this.syncContacts(localUser2, remoteUser);
        if (remoteUser.getName() != null) {
            String string = remoteUser.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteUser.name");
            localUser2.setFullName(string);
        }
        if (remoteUser.isBanned() != null) {
            Boolean bl = remoteUser.isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"remoteUser.isBanned");
            localUser2.setBanned(bl.booleanValue());
        }
    }

    public final void syncGuestDetails(@NotNull XdUser localUser2, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)localUser2, (String)"localUser");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        Companion.getLogger().trace("Syncing user data: guest");
        if (remoteUser.isBanned() != null) {
            Boolean bl = remoteUser.isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"remoteUser.isBanned");
            localUser2.setBanned(bl.booleanValue());
        }
    }

    private final void syncLogin(XdUser user2, String hubLogin) {
        if (hubLogin == null) {
            Companion.getLogger().warn("Received null login for user " + user2.getLogin() + " from Hub. Local login will be preserved.");
        } else if (Intrinsics.areEqual((Object)hubLogin, (Object)user2.getLogin()) ^ true) {
            if (XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUser.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUser, Unit>(hubLogin){
                final /* synthetic */ String $hubLogin;

                public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdUser it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    $receiver.eq((Comparable)((Object)it.getLogin()), (Comparable)((Object)this.$hubLogin));
                }
                {
                    this.$hubLogin = string;
                    super(2);
                }
            })))) {
                user2.setLogin(hubLogin);
            } else {
                Companion.getLogger().warn("Cannnot update login field for user " + user2.getLogin() + ". Login value from Hub (" + hubLogin + ") is not unique.");
            }
        }
    }

    private final void syncContacts(XdUser user2, User remoteUser) {
        Profile profile = remoteUser.getProfile();
        user2.setEmail(profile != null && (profile = profile.getEmail()) != null ? profile.getEmail() : null);
        Profile profile2 = remoteUser.getProfile();
        user2.setJabberAccountName(profile2 != null && (profile2 = profile2.getJabber()) != null ? profile2.getJabber() : null);
    }

    public final void syncLocale(@NotNull XdUser user2, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        if (remoteUser.getProfile() != null) {
            Profile profile = remoteUser.getProfile();
            Intrinsics.checkExpressionValueIsNotNull((Object)profile, (String)"remoteUser.profile");
            jetbrains.jetpass.api.settings.Locale hubLocale = profile.getLocale();
            if (hubLocale != null) {
                Object element$iv2;
                block3: {
                    Iterable iterable = BeansKt.getLocalizer().getSupportedLocales();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"localizer.supportedLocales");
                    Iterable $receiver$iv = iterable;
                    for (Object element$iv2 : $receiver$iv) {
                        LocaleEntry it;
                        LocaleEntry localeEntry = it = (LocaleEntry)element$iv2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry, (String)"it");
                        Locale locale = localeEntry.getLocale();
                        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"it.locale");
                        if (!Intrinsics.areEqual((Object)locale.getLanguage(), (Object)hubLocale.getLanguage())) continue;
                        break block3;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                LocaleEntry localeEntry = (LocaleEntry)element$iv2;
                GeneralUserProfile generalUserProfile = jetbrains.charisma.service.BeansKt.getUserProfileService().getGeneralUserProfile(user2);
                LocaleEntry localeEntry2 = localeEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry2, (String)"localeEntry");
                generalUserProfile.setLocale(localeEntry2.getLocale());
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserDetailsSync$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

