/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.loader;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.springframework.configuration.runtime.MyPathMatchingResourcePatternResolver;
import jetbrains.youtrack.scripts.loader.BeansKt;
import jetbrains.youtrack.scripts.loader.ScriptFile;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.loader.ScriptsLoader;
import jetbrains.youtrack.scripts.packageJson.PackageJsonMarshallerImpl;
import jetbrains.youtrack.scripts.packageJson.Pkg;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/scripts/loader/ScriptPackagesLoader;", "Ljetbrains/youtrack/scripts/loader/ScriptsLoader;", "rootFolderPath", "", "(Ljava/lang/String;)V", "getRootFolderPath", "()Ljava/lang/String;", "getScripts", "", "Ljetbrains/youtrack/scripts/loader/ScriptSource;", "processPackage", "pathPrefix", "json", "Lorg/springframework/core/io/Resource;", "scripts", "youtrack-scripts"})
public class ScriptPackagesLoader
extends ScriptsLoader {
    @NotNull
    private final String rootFolderPath;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Iterable<ScriptSource> getScripts() {
        void $receiver$iv$iv;
        Resource[] $receiver$iv;
        String f = (StringsKt.startsWith$default((String)this.rootFolderPath, (String)"/", (boolean)false, (int)2, null) ? "" : "/") + this.rootFolderPath + (StringsKt.endsWith$default((String)this.rootFolderPath, (String)"/", (boolean)false, (int)2, null) ? "" : "/");
        MyPathMatchingResourcePatternResolver resolver = new MyPathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader());
        Resource[] jsons = resolver.getResources("classpath*:" + f + "**/*.json");
        Resource[] scripts = resolver.getResources("classpath*:" + f + "**/*.js");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsons, (String)"jsons");
        Resource[] resourceArray = $receiver$iv = jsons;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var8_8 = $receiver$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void $receiver$iv$iv2;
            Resource[] $receiver$iv2;
            String path;
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)v0.getURL().toString(), (String)"it.url.toString()");
            String pathPrefix = StringsKt.removeSuffix((String)path, (CharSequence)"package.json");
            Intrinsics.checkExpressionValueIsNotNull((Object)scripts, (String)"scripts");
            Resource[] resourceArray2 = $receiver$iv2 = scripts;
            Collection destination$iv$iv2 = new ArrayList();
            void var18_18 = $receiver$iv$iv2;
            int n2 = ((void)var18_18).length;
            for (int j = 0; j < n2; ++j) {
                void element$iv$iv;
                void it2;
                void v1 = it2 = (element$iv$iv = var18_18[j]);
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                String string = v1.getURL().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.url.toString()");
                if (!StringsKt.startsWith$default((String)string, (String)pathPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List scriptsInPackage = (List)destination$iv$iv2;
            Iterable<ScriptSource> iterable = this.processPackage(pathPrefix, (Resource)it, scriptsInPackage);
            collection.add(iterable);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<ScriptSource> processPackage(String pathPrefix, Resource json, Iterable<? extends Resource> scripts) {
        void $receiver$iv$iv;
        Iterable<? extends Resource> $receiver$iv;
        PackageJsonMarshallerImpl packageJsonMarshallerImpl = BeansKt.getPackageJsonMarshaller();
        InputStream inputStream = json.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"json.inputStream");
        Pkg pkg = packageJsonMarshallerImpl.unmarshall(inputStream);
        String string = pkg.getName();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException(json.getURL() + " does not declare package name");
        }
        String packageName = string;
        Iterable<? extends Resource> iterable = $receiver$iv = scripts;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String path;
            void it;
            Resource resource = (Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            URL url = it.getURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)url.toString(), (String)"url.toString()");
            ScriptFile scriptFile = new ScriptFile(packageName + "/" + StringsKt.removeSuffix((String)StringsKt.removePrefix((String)path, (CharSequence)pathPrefix), (CharSequence)".js"), url).setVersion(0).setReadOnly(pkg.getYouTrackAttributes().getReadOnly()).setAutoAttached(pkg.getYouTrackAttributes().getAutoAttached());
            String string2 = pkg.getTitle();
            if (string2 == null) {
                string2 = pkg.getName();
            }
            ScriptFile scriptFile2 = scriptFile.setTitle(string2);
            collection.add(scriptFile2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getRootFolderPath() {
        return this.rootFolderPath;
    }

    public ScriptPackagesLoader(@NotNull String rootFolderPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootFolderPath, (String)"rootFolderPath");
        this.rootFolderPath = rootFolderPath;
    }
}

