/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.loader;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.persistence.PackageLanguageImpl;
import jetbrains.youtrack.scripts.persistence.ScriptFullName;
import jetbrains.youtrack.scripts.persistence.ScriptImpl;
import jetbrains.youtrack.scripts.persistence.WorkflowImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;

public abstract class ScriptsLoader {
    private static final String SCRIPT_SOURCE_ROOT = System.getProperty("jetbrains.youtrack.scriptSourceRoot");
    protected static Log log = LogFactory.getLog(ScriptsLoader.class);
    private String myScriptType;
    private String myScriptGroup;
    private int myPriority;
    private String myVersion;
    private String myLanguage;

    public ScriptsLoader() {
        this.setPriority(0);
    }

    protected abstract Iterable<ScriptSource> getScripts();

    public void load() {
        ISequence scriptsSources = Sequence.fromIterable(this.getScripts()).sort((_FunctionTypes._return_P1_E0)new ISelector<ScriptSource, Comparable<?>>(){

            public Comparable<?> select(ScriptSource it) {
                return new ScriptFullName(it.getName()).getPkg();
            }
        }, true);
        Entity currentPackage = null;
        for (ScriptSource scriptSource : scriptsSources) {
            ScriptFullName fullName = new ScriptFullName(scriptSource.getName());
            if (!EntityOperations.equals(currentPackage, null) && ScriptsLoader.neq_1bjczx_a0a2a2a1(PrimitiveAssociationSemantics.get(currentPackage, (String)"name", String.class, null), fullName.getPkg())) {
                this.packageProcessed(currentPackage);
                DnqUtils.getCurrentTransientSession().flush();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Package processed: " + (String)PrimitiveAssociationSemantics.get((Entity)currentPackage, (String)"name", String.class, null)));
                }
            }
            if (EntityOperations.equals(currentPackage, null) || ScriptsLoader.neq_1bjczx_a0a4a2a1(PrimitiveAssociationSemantics.get(currentPackage, (String)"name", String.class, null), fullName.getPkg())) {
                currentPackage = this.findOrCreatePackage(fullName.getPkg(), scriptSource.getVersion(), scriptSource.isReadOnly(), scriptSource.isAutoAttached());
            }
            if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)currentPackage, (String)"allowAutoUpdate", Boolean.class, null)).booleanValue() && ScriptsLoader.eq_1bjczx_a0a5a2a1(PrimitiveAssociationSemantics.get((Entity)currentPackage, (String)"name", String.class, null), "@jetbrains/youtrack-workflow-clone-issue")) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not update " + (String)PrimitiveAssociationSemantics.get((Entity)currentPackage, (String)"name", String.class, null) + " because package's autoUpdate was 'false'"));
                continue;
            }
            this.processScript(scriptSource, currentPackage);
        }
        if (!EntityOperations.equals(currentPackage, null)) {
            this.packageProcessed(currentPackage);
            DnqUtils.getCurrentTransientSession().flush();
        }
    }

    protected Entity findOrCreatePackage(String name, int version, boolean readOnly, boolean autoAttached) {
        Entity pl;
        Entity currentPackage = this.findOrCreatePackage(name, version, readOnly);
        Entity entity = pl = ((String)PrimitiveAssociationSemantics.get((Entity)PackageLanguageImpl.KT.get(), (String)"name", String.class, null)).equalsIgnoreCase(this.getLanguage()) ? PackageLanguageImpl.KT.get() : PackageLanguageImpl.JS.get();
        if (EntityOperations.isNew((Entity)currentPackage)) {
            PrimitiveAssociationSemantics.set((Entity)currentPackage, (String)"autoAttach", (Comparable)Boolean.valueOf(autoAttached), Boolean.class);
            DirectedAssociationSemantics.setToOne((Entity)currentPackage, (String)"language", (Entity)pl);
        } else if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)currentPackage, (String)"language"), (Object)pl)) {
            throw new IllegalStateException("Existing package is in " + AssociationSemantics.getToOne((Entity)currentPackage, (String)"language") + " whereas declared package is in " + this.getLanguage());
        }
        return currentPackage;
    }

    protected Entity findOrCreatePackage(String name, int version, boolean readOnly) {
        Entity currentPackage = WorkflowImpl.findOrCreate(name, version, new String[]{"name", "version"});
        if ((Boolean)PrimitiveAssociationSemantics.get((Entity)currentPackage, (String)"readOnly", Boolean.class, null) != readOnly) {
            PrimitiveAssociationSemantics.set((Entity)currentPackage, (String)"readOnly", (Comparable)Boolean.valueOf(readOnly), Boolean.class);
        }
        return currentPackage;
    }

    protected void processScript(ScriptSource scriptSource, Entity pkg, Entity existingScript) {
        String action;
        String scriptBody;
        ScriptFullName fullName = new ScriptFullName(scriptSource.getName());
        Long updated = scriptSource.getUpdated();
        if (ScriptsLoader.neq_1bjczx_a0c0e(scriptSource.getTitle(), PrimitiveAssociationSemantics.get((Entity)pkg, (String)"title", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)pkg, (String)"title", (Comparable)((Object)scriptSource.getTitle()), String.class);
            this.packageModified(pkg, updated);
        }
        Entity script2 = !EntityOperations.equals((Entity)existingScript, null) ? existingScript : QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Script", (NodeBase)new And((NodeBase)new PropertyEqual("name", (Comparable)((Object)fullName.getName())), (NodeBase)new LinkEqual("workflow", pkg))));
        try {
            scriptBody = this.readString(scriptSource.getBody());
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to read script content. Script name: " + scriptSource.getName()), (Throwable)e);
            }
            return;
        }
        if (EntityOperations.equals((Entity)script2, null)) {
            action = "Created new";
            script2 = ScriptImpl.constructor(fullName.getName());
            PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)script2, (String)"script", (String)scriptBody);
            AggregationAssociationSemantics.setManyToOne((Entity)pkg, (String)"rules", (String)"workflow", (Entity)script2);
            this.scriptModified(script2, updated);
        } else if (ScriptsLoader.neq_1bjczx_a0a0i0e(PrimitiveAssociationSemantics.getBlobAsString((Entity)script2, (String)"script"), scriptBody) || ScriptsLoader.neq_1bjczx_a0a0i0e_0(PrimitiveAssociationSemantics.get((Entity)script2, (String)"name", String.class, null), fullName.getName())) {
            action = "Modified";
            PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)script2, (String)"script", (String)scriptBody);
            PrimitiveAssociationSemantics.set((Entity)script2, (String)"name", (Comparable)((Object)fullName.getName()), String.class);
            this.scriptModified(script2, updated);
        } else {
            action = "Skipped (as not modified)";
        }
        boolean readOnly = scriptSource.isReadOnly();
        if ((Boolean)PrimitiveAssociationSemantics.get((Entity)script2, (String)"readOnly", Boolean.class, null) != readOnly) {
            PrimitiveAssociationSemantics.set((Entity)script2, (String)"readOnly", (Comparable)Boolean.valueOf(readOnly), Boolean.class);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(action + " script of type " + this.getScriptGroup() + " named " + scriptSource.getName() + "(readOnly=" + readOnly + ")"));
        }
    }

    private void scriptModified(Entity script2, Long updated) {
        PrimitiveAssociationSemantics.set((Entity)script2, (String)"updated", (Comparable)updated);
        DirectedAssociationSemantics.setToOne((Entity)script2, (String)"updatedBy", null);
        this.packageModified(AssociationSemantics.getToOne((Entity)script2, (String)"workflow"), updated);
    }

    private void packageModified(Entity pkg, Long updated) {
        if (DateTimeOperations.compare((Long)updated, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond()) && (DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)pkg, (String)"updated", null)), (CompareType)CompareType.EQ, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond()) || DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)pkg, (String)"updated", null)), (CompareType)CompareType.LT, (Long)updated, (DateTimeFieldType)DateTimeFieldType.millisOfSecond()))) {
            PrimitiveAssociationSemantics.set((Entity)pkg, (String)"updated", (Comparable)updated);
            DirectedAssociationSemantics.setToOne((Entity)pkg, (String)"updatedBy", null);
        }
    }

    protected void processScript(ScriptSource scriptSource, Entity pkg) {
        this.processScript(scriptSource, pkg, null);
    }

    protected void packageProcessed(Entity pkg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readString(InputStream is) throws IOException {
        StringWriter sw = new StringWriter();
        try (InputStreamReader r = null;){
            r = new InputStreamReader(is, "UTF-8");
            IOUtils.copy((Reader)r, (Writer)sw);
            String string = sw.toString();
            return string;
        }
    }

    protected int versionNumber() {
        if (this.getVersion() == null) {
            return 0;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.getVersion(), ".");
        if (tokenizer.countTokens() != 3) {
            throw new IllegalArgumentException("Version " + this.getVersion() + " has invalid format. Should have three parts: Major.Minor.Bugfix");
        }
        return Integer.parseInt(tokenizer.nextToken()) * 10000000 + Integer.parseInt(tokenizer.nextToken()) * 100000 + Integer.parseInt(tokenizer.nextToken());
    }

    public String getScriptType() {
        return this.myScriptType;
    }

    public void setScriptType(String value) {
        this.myScriptType = value;
    }

    public String getScriptGroup() {
        return this.myScriptGroup;
    }

    public void setScriptGroup(String value) {
        this.myScriptGroup = value;
    }

    public int getPriority() {
        return this.myPriority;
    }

    public void setPriority(int value) {
        this.myPriority = value;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String value) {
        this.myVersion = value;
    }

    public String getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(String value) {
        this.myLanguage = value;
    }

    private static boolean neq_1bjczx_a0a2a2a1(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean neq_1bjczx_a0a4a2a1(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean eq_1bjczx_a0a5a2a1(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean neq_1bjczx_a0c0e(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean neq_1bjczx_a0a0i0e(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean neq_1bjczx_a0a0i0e_0(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

