/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistence;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.scripts.persistence.ScriptFullName;
import jetbrains.youtrack.scripts.persistence.ScriptImpl;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;

public class ScriptSourceProvider
extends UrlModuleSourceProvider {
    private int apiVersion;
    private Entity mainPackageLanguage;

    public ScriptSourceProvider(URI root, int apiVersion, Entity mainPackageLanguage) {
        super((Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new URI[]{root}), null);
        this.apiVersion = apiVersion;
        this.mainPackageLanguage = mainPackageLanguage;
    }

    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        Entity script2;
        if (validator != null) {
            return ModuleSourceProvider.NOT_MODIFIED;
        }
        String uriString = uri.toString();
        if (ScriptSourceProvider.eq_v4n2ij_a0c0a(uriString, "kotlin")) {
            uriString = "@jetbrains/kotlin/kotlin";
        } else if (ScriptSourceProvider.eq_v4n2ij_a0a2a0(uriString, "kotlin-workflow-api")) {
            uriString = "@jetbrains/kotlin-workflow-api/kotlin-workflow-api";
        }
        ScriptFullName sfn = new ScriptFullName(uriString);
        if (ScriptSourceProvider.eq_v4n2ij_a0e0a(sfn.getPkg(), "v1")) {
            sfn = new ScriptFullName("@jetbrains/youtrack-scripting-api", sfn.getName());
        } else if (ScriptSourceProvider.eq_v4n2ij_a0a4a0(sfn.getPkg(), "v1/import")) {
            sfn = new ScriptFullName("@jetbrains/youtrack-scripting-api-import", sfn.getName());
        }
        if (ScriptSourceProvider.eq_v4n2ij_a0a5a0_0(sfn.getPkg(), "@jetbrains/youtrack-scripting-api") || ScriptSourceProvider.eq_v4n2ij_a0a5a0(sfn.getPkg(), "@jetbrains/youtrack-scripting-api-import")) {
            sfn.setVersion(this.apiVersion);
        }
        if (EntityOperations.equals((Entity)(script2 = ScriptImpl.find(sfn)), null)) {
            throw new IllegalArgumentException("Script " + sfn + " not found");
        }
        return new ModuleSource((Reader)new StringReader(PrimitiveAssociationSemantics.getBlobAsString((Entity)script2, (String)"script")), null, uri, base, (Object)Boolean.TRUE);
    }

    private static boolean eq_v4n2ij_a0c0a(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_v4n2ij_a0a2a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_v4n2ij_a0e0a(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_v4n2ij_a0a4a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_v4n2ij_a0a5a0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_v4n2ij_a0a5a0_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

