/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistence;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import jetbrains.charisma.misc.FileUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequenceClosure;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.features.FeatureFlag;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.scripts.loader.ScriptFilesLoader;
import jetbrains.youtrack.scripts.persistence.PackageAccessController;
import jetbrains.youtrack.scripts.persistence.PackageAccessControllers;
import jetbrains.youtrack.scripts.persistence.PackageJsonMarshaller;
import jetbrains.youtrack.scripts.persistence.PackageLanguageImpl;
import jetbrains.youtrack.scripts.persistence.ScriptImpl;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class WorkflowImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Workflow";
    public static final String PACKAGE_SUFFIX = ".zip";
    public static final String PREDEFINED_PREFIX_OLD = "jetbrains-youtrack-";
    public static final String JETBRAINS_PREFIX = "@jetbrains/";
    public static final String PREDEFINED_PREFIX = "@jetbrains/youtrack-workflow-";
    public static final String OBSOLETE_API_PACKAGE = "v1";
    public static final String API_PACKAGE = "@jetbrains/youtrack-scripting-api";
    public static String IMPORT_PACKAGE = "jetbrains/youtrack/imports/jira";
    public static final String README = "README.md";
    public static final int CURRENT_API_VERSION = 10000000;
    protected static Log log = LogFactory.getLog(WorkflowImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"version", (Comparable)Integer.valueOf(0), Integer.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"language", (Entity)PackageLanguageImpl.JS.get());
        return entity;
    }

    protected Entity _constructor(String name, String _entityType_) {
        Entity entity = this._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        return entity;
    }

    protected Entity _constructor(String name, int version, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"title", (Comparable)((Object)name), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"version", (Comparable)Integer.valueOf(version), Integer.class);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"language", (Entity)PackageLanguageImpl.JS.get());
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("updatedBy".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return WorkflowImpl.getUserRemoveerrorMessage(QueryOperations.getSize(linkedEntities));
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (!((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).isMpsPackage(entity)) {
            if (EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String[])new String[]{"name", "rules"})) {
                ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).resetUpdatedDate(entity);
            }
            if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String[])new String[]{"rules"}) && ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)).startsWith(PREDEFINED_PREFIX)) {
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"allowAutoUpdate", (Comparable)Boolean.valueOf(((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).isPredefinedUnmodified(entity)), Boolean.class);
            }
        }
    }

    public Entity findRule(String name, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"rules"), (String)"Script", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public boolean isAccessible(Operation operation, Entity entity) {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).isAccessible(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), operation, entity);
    }

    public boolean isAccessible(Entity user, Operation operation, Entity entity) {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).getAccessMessage(user, operation, entity) == null;
    }

    public String getAccessMessage(Operation operation, Entity entity) {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).getAccessMessage(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), operation, entity);
    }

    public String getAccessMessage(Entity user, Operation operation, Entity entity) {
        if (operation == Operation.DELETE) {
            operation = Operation.UPDATE;
        }
        String noPermissionsMessage = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.Can_t_{update}_workflow_{1}_becase_you_have_no_rights", new Object[]{operation.name().toLowerCase(), PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)});
        if (operation != Operation.READ && ((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"readOnly", Boolean.class, null)).booleanValue() && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.Can_t_update_readOnly_workflow", new Object[0]);
        }
        if (operation == Operation.READ) {
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_PROJECT, user) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.ADMIN_READ_APP, user)) {
                return null;
            }
            return noPermissionsMessage;
        }
        for (PackageAccessController pac : ((PackageAccessControllers)ServiceLocator.getBean((String)"packageAccessControllers")).getControllers()) {
            String accessMessage = pac.getAccessMessage(entity, user, operation);
            if (accessMessage == null) continue;
            return accessMessage;
        }
        if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_PROJECT, user) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.ADMIN_UPDATE_APP, user)) {
            return noPermissionsMessage;
        }
        return null;
    }

    public void zip(File file, Entity entity) throws IOException {
        ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).zip(file, (Iterable<File>)Sequence.fromIterable(Collections.emptyList()), entity);
    }

    public void zip(File file, Iterable<File> additionalFiles, Entity entity) throws IOException {
        ZipArchiveOutputStream zip = new ZipArchiveOutputStream(file);
        if (this.isMpsPackage(entity)) {
            Entity m = AssociationSemantics.getToOne((Entity)entity, (String)"model");
            if (EntityOperations.equals((Entity)m, null)) {
                throw new IllegalStateException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.Workflow_is_corrupted_It_contains_no_workflow_source_code", new Object[0]));
            }
            WorkflowImpl.putEntry(zip, (String)PrimitiveAssociationSemantics.get((Entity)m, (String)"name", String.class, null), (Long)PrimitiveAssociationSemantics.get((Entity)m, (String)"size", Long.class, null), PrimitiveAssociationSemantics.getBlob((Entity)m, (String)"content"));
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ((PackageJsonMarshaller)ServiceLocator.getBean((String)"workflowPackageJsonMarshaller")).marshall(entity, output);
            WorkflowImpl.putEntry(zip, "package.json", output.size(), new ByteArrayInputStream(output.toByteArray()));
            if (PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"readme") != null) {
                byte[] bytes = PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"readme").getBytes(StandardCharsets.UTF_8);
                WorkflowImpl.putEntry(zip, README, bytes.length, new ByteArrayInputStream(bytes));
            }
        }
        try {
            for (Entity rule : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"rules"))) {
                String content = PrimitiveAssociationSemantics.getBlobAsString((Entity)rule, (String)"script");
                byte[] jsContent = content != null ? content.getBytes(StandardCharsets.UTF_8) : new byte[]{};
                WorkflowImpl.putEntry(zip, ScriptFilesLoader.encodeFileName((String)PrimitiveAssociationSemantics.get((Entity)rule, (String)"name", String.class, null)) + ".js", jsContent.length, new ByteArrayInputStream(jsContent));
                if (PrimitiveAssociationSemantics.getBlobAsString((Entity)rule, (String)"html") == null) continue;
                byte[] htmlContent = PrimitiveAssociationSemantics.getBlobAsString((Entity)rule, (String)"html").getBytes(StandardCharsets.UTF_8);
                WorkflowImpl.putEntry(zip, ScriptFilesLoader.encodeFileName((String)PrimitiveAssociationSemantics.get((Entity)rule, (String)"name", String.class, null)) + ".html", htmlContent.length, new ByteArrayInputStream(htmlContent));
            }
            for (File additionalFile : Sequence.fromIterable(additionalFiles)) {
                WorkflowImpl.putEntry(zip, additionalFile.getName(), additionalFile.length(), new FileInputStream(additionalFile));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        zip.close();
    }

    public void resetUpdatedDate(Entity entity) {
        if (!EntityOperations.equals((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), null)) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"updated", (Comparable)Long.valueOf(System.currentTimeMillis()));
            DirectedAssociationSemantics.setToOne((Entity)entity, (String)"updatedBy", (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        }
    }

    public int getApiVersion(Entity entity) {
        return 10000000;
    }

    public boolean isPredefinedUnmodified(Entity entity) {
        if (((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).isMpsPackage(entity)) {
            return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"allowAutoUpdate", Boolean.class, null);
        }
        IListSequence rules2 = Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"rules")).toListSequence();
        return ((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"originalScriptsCount", Integer.class, null) == 0 || (Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"originalScriptsCount", Integer.class, null) == QueryOperations.getSize((Iterable)rules2)) && Sequence.fromIterable((Iterable)rules2).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((ScriptImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Script")).isPredefinedUnmodified(it);
            }
        });
    }

    public boolean isMpsPackage(Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"model"), null);
    }

    public String toBase64String(Entity entity) throws IOException {
        File tmpFile = FileUtil.createTempFile((String)"workflow", (String)"zip");
        tmpFile.deleteOnExit();
        ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Workflow")).zip(tmpFile, entity);
        byte[] byteArray = IOUtils.toByteArray((InputStream)new FileInputStream(tmpFile));
        byte[] stringBytes = Base64.encodeBase64((byte[])byteArray);
        return new String(stringBytes);
    }

    public static Entity constructor() {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String name) {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, __ENTITY_TYPE__);
    }

    public static Entity constructor(String name, int version) {
        return ((WorkflowImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, version, __ENTITY_TYPE__);
    }

    public static Entity find(String name) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Workflow", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }

    public static Entity update(DiskFileItem fileItem) throws IOException, ZipException, UnsupportedOperationException {
        try (ZipFile zipFile = WorkflowImpl.getZipFile(fileItem);){
            Entity entity = WorkflowImpl.updateManually(FilenameUtils.getBaseName((String)fileItem.getName()), zipFile);
            return entity;
        }
    }

    public static Entity updateManually(String name, ZipFile zipFile) throws IOException, UnsupportedOperationException {
        if (EntityOperations.equals((Entity)WorkflowImpl.find(name), null) && ((FeatureFlag)ServiceLocator.getBean((String)"preventFromCreatingWorkflowsViaWFE")).isEnabled()) {
            throw new UnsupportedOperationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.Creating_new_workflows_via_this_editor_is_prohibited_Please_use_scripting_workflow_editor_or_upload_a_workflow_via_UI_instead", new Object[0]));
        }
        Entity workflow2 = WorkflowImpl.update(name, zipFile, true, false);
        return workflow2;
    }

    public static Entity update(String name, ZipFile zipFile, boolean writeContent, boolean calculateHash) throws IOException {
        Entity workflow2 = WorkflowImpl.find(name);
        if (EntityOperations.equals((Entity)workflow2, null)) {
            if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.UPDATE_PROJECT, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                throw new SecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.You_have_no_rights_to_create_workflows", new Object[0]));
            }
            workflow2 = WorkflowImpl.constructor(name);
        } else {
            String m = ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)workflow2, (String)"Workflow")).getAccessMessage(Operation.UPDATE, workflow2);
            if (m != null) {
                throw new SecurityException(m);
            }
        }
        IListSequence processedRules = ListSequence.fromList(new ArrayList());
        boolean uploadedConverted = true;
        boolean packageJsonExists = false;
        boolean readmeExists = false;
        for (ZipArchiveEntry entry : Sequence.fromIterable(WorkflowImpl.getZipEntries(zipFile)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ZipArchiveEntry>(){

            public boolean accept(ZipArchiveEntry it) {
                return !it.getName().startsWith("__MACOSX/");
            }
        })) {
            block21: {
                if (FilenameUtils.isExtension((String)entry.getName(), (String)"mps") && writeContent) {
                    DirectedAssociationSemantics.setToOne((Entity)workflow2, (String)"model", (Entity)PersistentFileImpl.constructor((InputStream)zipFile.getInputStream(entry), (String)entry.getName()));
                    uploadedConverted = false;
                    PrimitiveAssociationSemantics.set((Entity)workflow2, (String)"updated", (Comparable)Long.valueOf(entry.getTime()));
                }
                if (FilenameUtils.isExtension((String)entry.getName(), (String)"json") && writeContent) {
                    try {
                        ((PackageJsonMarshaller)ServiceLocator.getBean((String)"workflowPackageJsonMarshaller")).unmarshall(workflow2, zipFile.getInputStream(entry));
                        packageJsonExists = true;
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block21;
                        log.warn((Object)("Cannot parse " + entry.getName()), (Throwable)e);
                    }
                }
            }
            if (FilenameUtils.isExtension((String)entry.getName(), (String)"js")) {
                String scriptBody = WorkflowImpl.readString(zipFile, entry);
                String wrName = ScriptFilesLoader.decodeFileName(FilenameUtils.getBaseName((String)entry.getName()));
                Entity wr = ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)workflow2, (String)"Workflow")).findRule(wrName, workflow2);
                if (writeContent) {
                    if (EntityOperations.equals((Entity)wr, null)) {
                        Entity created = ScriptImpl.constructor(wrName);
                        AggregationAssociationSemantics.createOneToMany((Entity)workflow2, (String)"rules", (String)"workflow", (Entity)created);
                        wr = created;
                    }
                    PrimitiveAssociationSemantics.set((Entity)workflow2, (String)"updated", (Comparable)Long.valueOf(entry.getTime()));
                    PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)wr, (String)"script", (String)scriptBody);
                }
                if (calculateHash) {
                    PrimitiveAssociationSemantics.set((Entity)wr, (String)"originalHash", (Comparable)((Object)ScriptImpl.calculateScriptHash(scriptBody)), String.class);
                }
                ListSequence.fromList((List)processedRules).addElement((Object)wr);
                continue;
            }
            if (FilenameUtils.isExtension((String)entry.getName(), (String)"html") || FilenameUtils.isExtension((String)entry.getName(), (String)"properties")) continue;
            if (FilenameUtils.isExtension((String)entry.getName(), (String)"md")) {
                PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)workflow2, (String)"readme", (String)WorkflowImpl.readString(zipFile, entry));
                readmeExists = true;
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("Unknown file in workflow [" + entry.getName() + "]"));
        }
        if (!readmeExists) {
            PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)workflow2, (String)"readme", null);
        }
        if (packageJsonExists && !uploadedConverted) {
            throw new BadRequestException("Problem with workflow named '" + name + "'. Workflow contains both .mps file(s) and a package.jsonFile");
        }
        if (!EntityOperations.isNew((Entity)workflow2) && !((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)workflow2, (String)"Workflow")).isMpsPackage(workflow2) ^ uploadedConverted) {
            throw new BadRequestException("Problem with workflow named '" + name + "'. Replacing a workflow written on plain JS with the one written in MPS or vice versa is prohibited");
        }
        if (writeContent) {
            for (ZipArchiveEntry e : Sequence.fromIterable(WorkflowImpl.getZipEntries(zipFile))) {
                if (!FilenameUtils.isExtension((String)e.getName(), (String)"html")) continue;
                String wrName = ScriptFilesLoader.decodeFileName(FilenameUtils.getBaseName((String)e.getName()));
                Entity wr = ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)workflow2, (String)"Workflow")).findRule(wrName, workflow2);
                if (!EntityOperations.equals((Entity)wr, null)) {
                    PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)wr, (String)"html", (String)WorkflowImpl.readString(zipFile, e));
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Html file without corresponding js file [" + e.getName() + "]"));
            }
            Sequence.fromIterable((Iterable)QueryOperations.exclude((Iterable)AssociationSemantics.getToMany((Entity)workflow2, (String)"rules"), (Iterable)processedRules)).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity rule) {
                    block2: {
                        try {
                            EntityOperations.remove((Entity)rule);
                        }
                        catch (EntityRemovedInDatabaseException ex) {
                            if (!log.isWarnEnabled()) break block2;
                            log.warn((Object)"Simultaneous workflow update", (Throwable)ex);
                        }
                    }
                }
            });
            Entity user = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
                DirectedAssociationSemantics.setToOne((Entity)workflow2, (String)"updatedBy", (Entity)user);
            }
        }
        return workflow2;
    }

    private static String readString(ZipFile zipFile, ZipArchiveEntry e) throws ZipException, IOException, UnsupportedEncodingException {
        return IOUtils.toString((Reader)new InputStreamReader(zipFile.getInputStream(e), StandardCharsets.UTF_8));
    }

    private static void putEntry(ZipArchiveOutputStream zip, String fileName, long size, InputStream content) throws IOException {
        ZipArchiveEntry e = new ZipArchiveEntry(fileName);
        e.setSize(size);
        zip.putArchiveEntry((ArchiveEntry)e);
        IOUtils.copy((InputStream)content, (OutputStream)zip);
        zip.closeArchiveEntry();
    }

    private static ZipFile getZipFile(DiskFileItem f) throws ZipException, FileNotFoundException, IOException {
        ZipFile zf;
        if (f.isInMemory()) {
            InputStream inputStream = f.getInputStream();
            File file = WorkflowImpl.copyToTempFile(inputStream);
            zf = new ZipFile(file);
        } else {
            zf = new ZipFile(f.getStoreLocation());
        }
        return zf;
    }

    private static File copyToTempFile(InputStream inputStream) throws IOException, FileNotFoundException, IOException, IOException {
        File file = FileUtil.createTempFile((String)"workflow", (String)"zip");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        out.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFromBase64(String name, String base64) throws IOException {
        byte[] bytes = Base64.decodeBase64((String)base64);
        try (ZipFile zipFile = null;){
            File tempFile = WorkflowImpl.copyToTempFile(new ByteArrayInputStream(bytes));
            zipFile = new ZipFile(tempFile);
            WorkflowImpl.update(name, zipFile, true, false);
        }
    }

    public static Iterable<ZipArchiveEntry> getZipEntries(final ZipFile zipFile) {
        return Sequence.fromClosure((_FunctionTypes._return_P0_E0)new ISequenceClosure<ZipArchiveEntry>(){

            public Iterable<ZipArchiveEntry> iterable() {
                return new Iterable<ZipArchiveEntry>(){

                    @Override
                    public Iterator<ZipArchiveEntry> iterator() {
                        return new YieldingIterator<ZipArchiveEntry>(){
                            private int __CP__ = 0;
                            private Enumeration _3_entries;

                            protected boolean moveToNext() {
                                block7: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 4: {
                                            if (this._3_entries.hasMoreElements()) {
                                                this.__CP__ = 5;
                                                continue block7;
                                            }
                                            this.__CP__ = 1;
                                            continue block7;
                                        }
                                        case 6: {
                                            this.__CP__ = 4;
                                            this.yield((ZipArchiveEntry)this._3_entries.nextElement());
                                            return true;
                                        }
                                        case 0: {
                                            this._3_entries = zipFile.getEntries();
                                            this.__CP__ = 4;
                                            continue block7;
                                        }
                                        case 5: {
                                            this.__CP__ = 6;
                                            continue block7;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }

    public static ZipArchiveEntry getMpsFileEntry(ZipFile zipFile) {
        return (ZipArchiveEntry)Sequence.fromIterable(WorkflowImpl.getZipEntries(zipFile)).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<ZipArchiveEntry>(){

            public boolean accept(ZipArchiveEntry it) {
                return FilenameUtils.isExtension((String)it.getName(), (String)"mps");
            }
        });
    }

    private static String getUserRemoveerrorMessage(int wfsCount) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Workflow.User_is_owner_of_{0}workflows", new Object[]{wfsCount});
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, String name, int version, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final String __var__name = name;
        final String __var__title = name;
        final int __var__version = version;
        final Entity __var__language = PackageLanguageImpl.JS.get();
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("name")) {
                    result = QueryOperations.query((Iterable)result, (String)"Workflow", (NodeBase)new PropertyEqual("name", (Comparable)((Object)__var__name)));
                }
                if (queriedParams.contains("title")) {
                    result = QueryOperations.query((Iterable)result, (String)"Workflow", (NodeBase)new PropertyEqual("title", (Comparable)((Object)__var__title)));
                }
                if (queriedParams.contains("version")) {
                    result = QueryOperations.query((Iterable)result, (String)"Workflow", (NodeBase)new PropertyEqual("version", (Comparable)Integer.valueOf(__var__version)));
                }
                if (queriedParams.contains("language")) {
                    result = QueryOperations.query((Iterable)result, (String)"Workflow", (NodeBase)new LinkEqual("language", __var__language));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)__var__name), String.class);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"title", (Comparable)((Object)__var__title), String.class);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"version", (Comparable)Integer.valueOf(__var__version), Integer.class);
                DirectedAssociationSemantics.setToOne((Entity)entity, (String)"language", (Entity)__var__language);
            }
        };
    }

    public static Entity findOrCreate(String name, int version, String[] queriedParams) {
        return WorkflowImpl.getEntityCreator(__ENTITY_TYPE__, name, version, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }
}

