/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.workflow.wrappers.IterableWrapperFactory;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.TypedValueResolver;
import jetbrains.youtrack.scripts.wrappers.EnumReference;
import jetbrains.youtrack.scripts.wrappers.EnumReferenceResolver;
import jetbrains.youtrack.scripts.wrappers.ValueResolveUtil;
import jetbrains.youtrack.scripts.wrappers.ValueResolverImpl;
import org.jetbrains.annotations.Nullable;

public class EntityValueResolver
extends ValueResolverImpl
implements TypedValueResolver {
    protected String typeName;
    protected EnumReferenceResolver enumReferenceResolver;
    private boolean multi;
    @Nullable
    protected Entity project;

    public EntityValueResolver(IterableWrapperFactory iterableWrapperFactory, @Nullable Entity project2, String typeName, boolean multi, EnumReferenceResolver referenceResolver) {
        super(iterableWrapperFactory);
        this.project = project2;
        this.typeName = typeName;
        this.multi = multi;
        this.enumReferenceResolver = referenceResolver;
    }

    public EntityValueResolver(IterableWrapperFactory iterableWrapperFactory, Entity project2, AssociationEndMetaData associationEndMetaData, EnumReferenceResolver enumReferenceResolver) {
        this(iterableWrapperFactory, project2, associationEndMetaData.getOppositeEntityMetaData().getType(), associationEndMetaData.getCardinality().isMultiple(), enumReferenceResolver);
    }

    public Class getType() {
        return this.multi ? Iterable.class : Entity.class;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isMultiple() {
        return this.multi;
    }

    @Override
    public Object unwrap(Object wrapper) {
        Object res = super.unwrap(wrapper);
        if (res instanceof EnumReference && (res = this.resolveEnumReference(((EnumReference)wrapper).getValue())) == null) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("EntityValueResolver.Can_t_find_{0}_{1}", new Object[]{this.typeName, wrapper}));
        }
        return res;
    }

    public Object resolveEnumReference(String enumReference) {
        Object resolvedValue = null;
        if (this.enumReferenceResolver != null) {
            resolvedValue = this.enumReferenceResolver.resolve(enumReference);
        }
        return resolvedValue;
    }

    @Nullable
    public PropertyValueResolver resolveProperty(String name) {
        return this.internalResolveProperty(this.typeName, name);
    }

    @Nullable
    protected PropertyValueResolver internalResolveProperty(String entityType, String name) {
        return ((ValueResolveUtil)ServiceLocator.getBean((String)"valueResolveUtil")).getPropertyValueResolver(null, this.project, entityType, name);
    }
}

