/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.persistence.customfields.meta.YField;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.query.metadata.PropertyType;
import jetbrains.exodus.query.metadata.SimplePropertyMetaDataImpl;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.workflow.wrappers.IterableWrapperFactory;
import jetbrains.youtrack.scripts.model.OperationMode;
import jetbrains.youtrack.scripts.wrappers.SimplePropertyValueResolver;
import jetbrains.youtrack.scripts.ydata.ICustomFieldAccessControl;

public class PredefinedSimpleFieldValueResolver
extends SimplePropertyValueResolver {
    private SimplePropertyMetaDataImpl propertyMetaData;
    private String apiName;

    public PredefinedSimpleFieldValueResolver(IterableWrapperFactory iterableWrapperFactory, SimplePropertyMetaDataImpl propertyMetaData, String propertyName, String apiName) {
        super(iterableWrapperFactory, propertyName, propertyMetaData.getPrimitiveTypeName() == null ? null : propertyMetaData.getPrimitiveTypeName().toLowerCase());
        this.propertyMetaData = propertyMetaData;
        this.apiName = apiName;
    }

    public Object get(Entity entity) {
        this.getYField(entity.getType(), true);
        switch (this.propertyMetaData.getType()) {
            case PRIMITIVE: {
                return PrimitiveAssociationSemantics.get((Entity)entity, (String)this.getPropertyName(), null);
            }
            case TEXT: {
                return PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)this.getPropertyName());
            }
        }
        throw new IllegalArgumentException(this.unsupportedPropertyMsg());
    }

    @Override
    public Object getOldValue(TransientEntity entity) {
        this.getYField(entity.getType(), true);
        switch (this.propertyMetaData.getType()) {
            case PRIMITIVE: {
                return super.getOldValue(entity);
            }
            case TEXT: {
                PersistentStoreTransaction snapshot = entity.getStore().getThreadSession().getTransientChangesTracker().getSnapshot();
                return entity.getPersistentEntity().getSnapshot(snapshot).getBlobString(this.getPropertyName());
            }
        }
        throw new IllegalArgumentException(this.unsupportedPropertyMsg());
    }

    public boolean has(Entity entity) {
        return PrimitiveAssociationSemantics.get((Entity)entity, (String)this.getPropertyName(), null) != null;
    }

    public boolean isAccessible(Entity entity, Entity user, boolean write) {
        YField yField2 = this.getYField(entity.getType(), false);
        return yField2 != null && (!write || !yField2.isReadOnly());
    }

    public void set(Entity entity, Object value) {
        String typeName = entity.getType();
        YField field = this.getYField(typeName, true);
        if (field.isReadOnly()) {
            throw new UnsupportedOperationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("PredefinedSimpleFieldValueResolver.Field_{0}_of_type_{1}_is_readonly", new Object[]{this.getPropertyName(), typeName}));
        }
        if ((value = this.unwrap(value)) instanceof Comparable || value == null) {
            Comparable comparable = (Comparable)value;
            switch (this.propertyMetaData.getType()) {
                case PRIMITIVE: {
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)this.getPropertyName(), (Comparable)comparable);
                    break;
                }
                case TEXT: {
                    PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)this.getPropertyName(), (String)((String)((Object)comparable)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("PredefinedSimpleFieldValueResolver.Fields_of_type_{0}_not_supported", new Object[]{this.propertyMetaData.getType()}));
                }
            }
        } else {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("PredefinedSimpleFieldValueResolver.Value_should_be_of_type_Comparable", new Object[0]));
        }
    }

    private YField getYField(String typeName, boolean checkAccess) {
        YField yField2 = ((ICustomFieldAccessControl)ServiceLocator.getBean((String)"customFieldsAccessControl")).getYClazz(typeName, ((OperationMode)ServiceLocator.getBean((String)"operationMode")).getCurrentControlDomain()).findField(this.apiName);
        if (checkAccess && yField2 == null) {
            throw new UnsupportedOperationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("PredefinedSimpleFieldValueResolver.Field_{0}_of_type_{1}_is_not_accessible", new Object[]{this.getPropertyName(), typeName}));
        }
        return yField2;
    }

    private String unsupportedPropertyMsg() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("PredefinedSimpleFieldValueResolver.Fields_of_type_{0}{1}", new Object[]{PropertyType.BLOB, this.propertyMetaData.getType()});
    }
}

