(function (_, Kotlin, $module$_jetbrains_youtrack_scripting_api_entities) {
  'use strict';
  var throwCCE = Kotlin.throwCCE;
  var toString = Kotlin.toString;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var Unit = Kotlin.kotlin.Unit;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var User$Companion = $module$_jetbrains_youtrack_scripting_api_entities.User;
  var ensureNotNull = Kotlin.ensureNotNull;
  var UserGroup$Companion = $module$_jetbrains_youtrack_scripting_api_entities.UserGroup;
  var Project$Companion = $module$_jetbrains_youtrack_scripting_api_entities.Project;
  var Issue$Companion = $module$_jetbrains_youtrack_scripting_api_entities.Issue;
  var Field$Companion = $module$_jetbrains_youtrack_scripting_api_entities.Field;
  var EnumField$Companion = $module$_jetbrains_youtrack_scripting_api_entities.EnumField;
  var State$Companion = $module$_jetbrains_youtrack_scripting_api_entities.State;
  var Build$Companion = $module$_jetbrains_youtrack_scripting_api_entities.Build;
  var OwnedField$Companion = $module$_jetbrains_youtrack_scripting_api_entities.OwnedField;
  var ProjectVersion$Companion = $module$_jetbrains_youtrack_scripting_api_entities.ProjectVersion;
  var Any = Object;
  requiredUser$lambda$ObjectLiteral.prototype = Object.create(EntityGetterDelegate.prototype);
  requiredUser$lambda$ObjectLiteral.prototype.constructor = requiredUser$lambda$ObjectLiteral;
  requiredUserGroup$lambda$ObjectLiteral.prototype = Object.create(EntityGetterDelegate.prototype);
  requiredUserGroup$lambda$ObjectLiteral.prototype.constructor = requiredUserGroup$lambda$ObjectLiteral;
  requiredProject$lambda$ObjectLiteral.prototype = Object.create(EntityGetterDelegate.prototype);
  requiredProject$lambda$ObjectLiteral.prototype.constructor = requiredProject$lambda$ObjectLiteral;
  requiredIssue$lambda$ObjectLiteral.prototype = Object.create(EntityGetterDelegate.prototype);
  requiredIssue$lambda$ObjectLiteral.prototype.constructor = requiredIssue$lambda$ObjectLiteral;
  RuleBuilder.prototype = Object.create(Builder.prototype);
  RuleBuilder.prototype.constructor = RuleBuilder;
  OnChangeBuilder.prototype = Object.create(RuleBuilder.prototype);
  OnChangeBuilder.prototype.constructor = OnChangeBuilder;
  ActionBuilder.prototype = Object.create(OnChangeBuilder.prototype);
  ActionBuilder.prototype.constructor = ActionBuilder;
  OnScheduleBuilder.prototype = Object.create(OnChangeBuilder.prototype);
  OnScheduleBuilder.prototype.constructor = OnScheduleBuilder;
  TransitionBuilder.prototype = Object.create(OnChangeBuilder.prototype);
  TransitionBuilder.prototype.constructor = TransitionBuilder;
  StateBuilder.prototype = Object.create(Builder.prototype);
  StateBuilder.prototype.constructor = StateBuilder;
  StateMachineBuilder.prototype = Object.create(RuleBuilder.prototype);
  StateMachineBuilder.prototype.constructor = StateMachineBuilder;
  function ensureFieldExists($receiver, name) {
    var tmp$;
    if (!(typeof (tmp$ = $receiver.fields.hasOwnProperty(name)) === 'boolean' ? tmp$ : throwCCE())) {
      throw IllegalArgumentException_init('No field named ' + name + ' is defined for issue ' + toString($receiver.id));
    }
  }
  function get_0($receiver, name) {
    ensureFieldExists($receiver, name);
    return $receiver.fields[name];
  }
  function set($receiver, name, value) {
    ensureFieldExists($receiver, name);
    $receiver.fields[name] = value;
  }
  var map;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  function getActualName(name, property) {
    var tmp$;
    return (tmp$ = !isBlank(name) ? name : null) != null ? tmp$ : property.callableName;
  }
  function getFromMap(property) {
    var tmp$;
    tmp$ = map.get_11rb$(property);
    if (tmp$ == null) {
      throw IllegalStateException_init('No delegate is registered for property ' + property);
    }
    return tmp$;
  }
  function FieldAccessDelegateProvider(requiredFieldType, fieldName) {
    if (requiredFieldType === void 0)
      requiredFieldType = null;
    this.requiredFieldType_0 = requiredFieldType;
    this.fieldName_0 = fieldName;
  }
  FieldAccessDelegateProvider.prototype.provideDelegate_kgvvnx$ = function (thisRef, prop) {
    var tmp$;
    var actualName = getActualName(this.fieldName_0, prop);
    map.put_xwzc9p$(prop, actualName);
    if ((tmp$ = this.requiredFieldType_0) != null) {
      requirements.field_6hosri$(prop.callableName, tmp$, actualName);
    }
    return new FieldAccessDelegate();
  };
  FieldAccessDelegateProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldAccessDelegateProvider',
    interfaces: []
  };
  function FieldAccessDelegate() {
  }
  FieldAccessDelegate.prototype.getValue_587rqu$ = function (issue, property) {
    return get_0(issue, getFromMap(property));
  };
  FieldAccessDelegate.prototype.setValue_rmzo7j$ = function (issue, property, value) {
    set(issue, getFromMap(property), value);
  };
  FieldAccessDelegate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldAccessDelegate',
    interfaces: []
  };
  function FieldValueAccessDelegateProvider(parentFieldProperty, valueName) {
    this.parentFieldProperty_0 = parentFieldProperty;
    this.valueName_0 = valueName;
  }
  FieldValueAccessDelegateProvider.prototype.provideDelegate_d6mtq7$ = function (thisRef, prop) {
    requirements.fieldValue_6hosri$(this.parentFieldProperty_0.callableName, prop.callableName, getActualName(this.valueName_0, prop));
    return new FieldValueAccessDelegate(this.parentFieldProperty_0.callableName, prop.callableName);
  };
  FieldValueAccessDelegateProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldValueAccessDelegateProvider',
    interfaces: []
  };
  function FieldValueAccessDelegate(fieldObjectKey, valueObjectKey) {
    this.fieldObjectKey_0 = fieldObjectKey;
    this.valueObjectKey_0 = valueObjectKey;
  }
  FieldValueAccessDelegate.prototype.getValue_d6mtq7$ = function (n, property) {
    var cc = ctx.get().getObject('_ctx_');
    return cc[this.fieldObjectKey_0][this.valueObjectKey_0];
  };
  FieldValueAccessDelegate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldValueAccessDelegate',
    interfaces: []
  };
  var fieldValue = defineInlineFunction('kotlin-workflow-api.com.jetbrains.youtrack.workflow.api.fieldValue_uoqaze$', wrapFunction(function () {
    var FieldValueAccessDelegateProvider_init = _.com.jetbrains.youtrack.workflow.api.FieldValueAccessDelegateProvider;
    return function (V_0, isV, property, valueName) {
      if (valueName === void 0)
        valueName = '';
      return new FieldValueAccessDelegateProvider_init(property, valueName);
    };
  }));
  function EntityAccessDelegateProvider(name, typeName, propertyName, create) {
    this.name_0 = name;
    this.typeName_0 = typeName;
    this.propertyName_0 = propertyName;
    this.create_0 = create;
  }
  EntityAccessDelegateProvider.prototype.provideDelegate_d6mtq7$ = function (n, prop) {
    requirements.entity_w74nik$(prop.callableName, this.typeName_0, this.propertyName_0, getActualName(this.name_0, prop));
    return this.create_0();
  };
  EntityAccessDelegateProvider.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EntityAccessDelegateProvider',
    interfaces: []
  };
  function requiredUser$lambda$ObjectLiteral(name) {
    EntityGetterDelegate.call(this, name);
  }
  requiredUser$lambda$ObjectLiteral.prototype.find_61zpoe$ = function (actualName) {
    return ensureNotNull(User$Companion.findByLogin(actualName));
  };
  requiredUser$lambda$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [EntityGetterDelegate]
  };
  function requiredUser$lambda(closure$login) {
    return function () {
      return new requiredUser$lambda$ObjectLiteral(closure$login);
    };
  }
  function requiredUser(login) {
    if (login === void 0)
      login = '';
    return new EntityAccessDelegateProvider(login, 'User', 'login', requiredUser$lambda(login));
  }
  function requiredUserGroup$lambda$ObjectLiteral(name) {
    EntityGetterDelegate.call(this, name);
  }
  requiredUserGroup$lambda$ObjectLiteral.prototype.find_61zpoe$ = function (actualName) {
    return ensureNotNull(UserGroup$Companion.findByName(actualName));
  };
  requiredUserGroup$lambda$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [EntityGetterDelegate]
  };
  function requiredUserGroup$lambda(closure$name) {
    return function () {
      return new requiredUserGroup$lambda$ObjectLiteral(closure$name);
    };
  }
  function requiredUserGroup(name) {
    if (name === void 0)
      name = '';
    return new EntityAccessDelegateProvider(name, 'UserGroup', 'name', requiredUserGroup$lambda(name));
  }
  function requiredProject$lambda$ObjectLiteral(name) {
    EntityGetterDelegate.call(this, name);
  }
  requiredProject$lambda$ObjectLiteral.prototype.find_61zpoe$ = function (actualName) {
    return ensureNotNull(Project$Companion.findByKey(actualName));
  };
  requiredProject$lambda$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [EntityGetterDelegate]
  };
  function requiredProject$lambda(closure$key) {
    return function () {
      return new requiredProject$lambda$ObjectLiteral(closure$key);
    };
  }
  function requiredProject(key) {
    if (key === void 0)
      key = '';
    return new EntityAccessDelegateProvider(key, 'Project', 'key', requiredProject$lambda(key));
  }
  function requiredIssue$lambda$ObjectLiteral(name) {
    EntityGetterDelegate.call(this, name);
  }
  requiredIssue$lambda$ObjectLiteral.prototype.find_61zpoe$ = function (actualName) {
    return ensureNotNull(Issue$Companion.findById(actualName));
  };
  requiredIssue$lambda$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [EntityGetterDelegate]
  };
  function requiredIssue$lambda(closure$id) {
    return function () {
      return new requiredIssue$lambda$ObjectLiteral(closure$id);
    };
  }
  function requiredIssue(id) {
    if (id === void 0)
      id = '';
    return new EntityAccessDelegateProvider(id, 'Issue', 'id', requiredIssue$lambda(id));
  }
  function EntityGetterDelegate(name) {
    this.name = name;
  }
  EntityGetterDelegate.prototype.getValue_d6mtq7$ = function (n, property) {
    return this.find_61zpoe$(getActualName(this.name, property));
  };
  EntityGetterDelegate.prototype.transformName_61zpoe$ = function (name) {
    return name;
  };
  EntityGetterDelegate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EntityGetterDelegate',
    interfaces: []
  };
  function dateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableDateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredDateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.dateType, name);
  }
  function requiredNullableDateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.dateType, name);
  }
  function dateTimeField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableDateTimeField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredDateTimeField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.dateTimeType, name);
  }
  function requiredNullableDateTimeField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.dateTimeType, name);
  }
  function floatField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableFloatField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredFloatField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.floatType, name);
  }
  function requiredNullableFloatField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.floatType, name);
  }
  function integerField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableIntegerField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredIntegerField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.integerType, name);
  }
  function requiredNullableIntegerField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.integerType, name);
  }
  function stringField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableStringField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredStringField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.stringType, name);
  }
  function requiredNullableStringField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Field$Companion.stringType, name);
  }
  function enumField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableEnumField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredEnumField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(EnumField$Companion.fieldType, name);
  }
  function requiredNullableEnumField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(EnumField$Companion.fieldType, name);
  }
  function stateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableStateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredStateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(State$Companion.fieldType, name);
  }
  function requiredNullableStateField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(State$Companion.fieldType, name);
  }
  function userField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableUserField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredUserField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(User$Companion.fieldType, name);
  }
  function requiredNullableUserField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(User$Companion.fieldType, name);
  }
  function userGroupField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableUserGroupField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredUserGroupField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(UserGroup$Companion.fieldType, name);
  }
  function requiredNullableUserGroupField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(UserGroup$Companion.fieldType, name);
  }
  function buildField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableBuildField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredBuildField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Build$Companion.fieldType, name);
  }
  function requiredNullableBuildField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(Build$Companion.fieldType, name);
  }
  function ownedField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableOwnedField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredOwnedField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(OwnedField$Companion.fieldType, name);
  }
  function requiredNullableOwnedField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(OwnedField$Companion.fieldType, name);
  }
  function versionField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function nullableVersionField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(void 0, name);
  }
  function requiredVersionField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(ProjectVersion$Companion.fieldType, name);
  }
  function requiredNullableVersionField(name) {
    if (name === void 0)
      name = '';
    return new FieldAccessDelegateProvider(ProjectVersion$Companion.fieldType, name);
  }
  function required($receiver, message) {
    castReceiver($receiver).required(getName($receiver), message);
  }
  function becomes($receiver, expected) {
    return castReceiver($receiver).becomes(getName($receiver), expected);
  }
  function get_isChanged($receiver) {
    return castReceiver($receiver).isChanged(getName($receiver));
  }
  function get_oldValue($receiver) {
    var tmp$;
    return (tmp$ = castReceiver($receiver).oldValue(getName($receiver))) == null || Kotlin.isType(tmp$, Any) ? tmp$ : throwCCE();
  }
  function canBeReadBy($receiver, user) {
    return castReceiver($receiver).canBeReadBy(getName($receiver), user);
  }
  function canBeWrittenBy($receiver, user) {
    return castReceiver($receiver).canBeWrittenBy(getName($receiver), user);
  }
  function get_added($receiver) {
    return $receiver.k_p0.added;
  }
  function get_removed($receiver) {
    return $receiver.k_p0.removed;
  }
  function get_isChanged_0($receiver) {
    return $receiver.k_p0.removed;
  }
  function castReceiver(property) {
    return property.k_p0;
  }
  function getName(property) {
    return property.callableName;
  }
  function RequirementsCollector() {
    this.o = {};
  }
  RequirementsCollector.prototype.entity_w74nik$ = function (objectKey, type, propertyName, propertyValue) {
    var r = {type: {}};
    r.type['$type'] = type;
    r[propertyName] = propertyValue;
    this.o[objectKey] = r;
  };
  RequirementsCollector.prototype.field_6hosri$ = function (objectKey, type, name) {
    var r = {};
    r.type = type;
    r.name = name;
    this.o[objectKey] = r;
  };
  RequirementsCollector.prototype.fieldValue_6hosri$ = function (fieldObjectKey, valueObjectKey, valueName) {
    if (this.o.hasOwnProperty(fieldObjectKey)) {
      var v = {};
      v.name = valueName;
      this.o[fieldObjectKey][valueObjectKey] = v;
    }
  };
  RequirementsCollector.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RequirementsCollector',
    interfaces: []
  };
  var requirements;
  function onChange(title, body) {
    var $receiver = new OnChangeBuilder(title);
    body($receiver);
    return $receiver.build();
  }
  function action(title, command, body) {
    var $receiver = new ActionBuilder(title, command);
    body($receiver);
    return $receiver.build();
  }
  function onSchedule(title, cron, body) {
    var $receiver = new OnScheduleBuilder(title, cron);
    body($receiver);
    return $receiver.build();
  }
  var stateMachine = defineInlineFunction('kotlin-workflow-api.com.jetbrains.youtrack.workflow.api.stateMachine_54nqlv$', wrapFunction(function () {
    var StateMachineBuilder_init = _.com.jetbrains.youtrack.workflow.api.StateMachineBuilder;
    return function (V_0, isV, title, fieldName, states, body) {
      var $receiver = new StateMachineBuilder_init(title, fieldName, states);
      body($receiver);
      return $receiver.build();
    };
  }));
  function Builder() {
  }
  Builder.prototype.build = function () {
    var o = {};
    this.build_za3rmp$(o);
    return o;
  };
  Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  function RuleBuilder(title) {
    Builder.call(this);
    this.title_x0h06v$_0 = title;
  }
  RuleBuilder.prototype.build_za3rmp$ = function (o) {
    o.title = this.title_x0h06v$_0;
  };
  RuleBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RuleBuilder',
    interfaces: [Builder]
  };
  function OnChangeBuilder(title) {
    RuleBuilder.call(this, title);
    this.action = null;
    this.guard = null;
    this.ruleType_2dlkik$_0 = 'onChange';
  }
  OnChangeBuilder.prototype.makeAccessibleViaExecutionCtx_z8ycqa$_0 = function ($receiver) {
    var abstractScriptExecutionContext = ctx.get();
    abstractScriptExecutionContext.setObject('_ctx_', $receiver);
  };
  function OnChangeBuilder$guard$lambda(this$OnChangeBuilder, closure$body) {
    return function ($receiver) {
      this$OnChangeBuilder.makeAccessibleViaExecutionCtx_z8ycqa$_0($receiver);
      return closure$body($receiver);
    };
  }
  OnChangeBuilder.prototype.guard_pab4nr$ = function (body) {
    this.guard = OnChangeBuilder$guard$lambda(this, body);
  };
  function OnChangeBuilder$action$lambda(this$OnChangeBuilder, closure$body) {
    return function ($receiver) {
      this$OnChangeBuilder.makeAccessibleViaExecutionCtx_z8ycqa$_0($receiver);
      closure$body($receiver);
      return Unit;
    };
  }
  OnChangeBuilder.prototype.action_e8d4yv$ = function (body) {
    this.action = OnChangeBuilder$action$lambda(this, body);
  };
  Object.defineProperty(OnChangeBuilder.prototype, 'ruleType', {
    get: function () {
      return this.ruleType_2dlkik$_0;
    }
  });
  OnChangeBuilder.prototype.build_za3rmp$ = function (o) {
    RuleBuilder.prototype.build_za3rmp$.call(this, o);
    o.guard = this.guard;
    o.action = this.action;
    o.target = 'Issue';
    o.ruleType = this.ruleType;
    o.requirements = requirements.o;
  };
  OnChangeBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OnChangeBuilder',
    interfaces: [RuleBuilder]
  };
  function ActionBuilder(title, command) {
    OnChangeBuilder.call(this, title);
    this.command_0 = command;
    this.ruleType_5plgzv$_0 = 'action';
  }
  Object.defineProperty(ActionBuilder.prototype, 'ruleType', {
    get: function () {
      return this.ruleType_5plgzv$_0;
    }
  });
  ActionBuilder.prototype.build_za3rmp$ = function (o) {
    OnChangeBuilder.prototype.build_za3rmp$.call(this, o);
    o.command = this.command_0;
  };
  ActionBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ActionBuilder',
    interfaces: [OnChangeBuilder]
  };
  function OnScheduleBuilder(title, cron) {
    OnChangeBuilder.call(this, title);
    this.cron_0 = cron;
    this.ruleType_db56ej$_0 = 'action';
    this.search_0 = null;
  }
  Object.defineProperty(OnScheduleBuilder.prototype, 'ruleType', {
    get: function () {
      return this.ruleType_db56ej$_0;
    }
  });
  OnScheduleBuilder.prototype.search_h4ejuu$ = function (search) {
    this.search_0 = search;
  };
  OnScheduleBuilder.prototype.build_za3rmp$ = function (o) {
    OnChangeBuilder.prototype.build_za3rmp$.call(this, o);
    o.cron = this.cron_0;
    o.search = this.search_0;
  };
  OnScheduleBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OnScheduleBuilder',
    interfaces: [OnChangeBuilder]
  };
  function TransitionBuilder(sourceState, after) {
    OnChangeBuilder.call(this, '');
    this.after_0 = after;
    this.targetState_0 = sourceState;
  }
  TransitionBuilder.prototype.targetState_gz1pr5$ = function (value) {
    this.targetState_0 = value();
  };
  TransitionBuilder.prototype.build_za3rmp$ = function (o) {
    OnChangeBuilder.prototype.build_za3rmp$.call(this, o);
    o.targetState = this.targetState_0;
  };
  TransitionBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TransitionBuilder',
    interfaces: [OnChangeBuilder]
  };
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  function StateBuilder(state) {
    Builder.call(this);
    this.state_0 = state;
    this.transitions_0 = LinkedHashMap_init();
    this.initial_0 = false;
    this.onEnter_0 = null;
    this.onExit_0 = null;
  }
  StateBuilder.prototype.initial_u332lz$ = function (value) {
    this.initial_0 = value();
  };
  StateBuilder.prototype.onEnter_e8d4yv$ = function (body) {
    this.onEnter_0 = body;
  };
  StateBuilder.prototype.onExit_e8d4yv$ = function (body) {
    this.onExit_0 = body;
  };
  StateBuilder.prototype.build_za3rmp$ = function (o) {
    o.initial = this.initial_0;
    o.onEnter = this.onEnter_0;
    o.onExit = this.onExit_0;
    o.transitions = {};
    var tmp$;
    tmp$ = this.transitions_0.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.key;
      var value = element.value;
      o.transitions[key] = value;
    }
  };
  StateBuilder.prototype.transits_7nd2gr$ = function ($receiver, transition) {
    var tmp$ = this.transitions_0;
    var $receiver_0 = new TransitionBuilder(this.state_0, null);
    transition($receiver_0);
    var value = $receiver_0.build();
    tmp$.put_xwzc9p$($receiver, value);
  };
  StateBuilder.prototype.schedules_7nd2gr$ = function ($receiver, transition) {
    var name = this.state_0.name + '_' + $receiver;
    var tmp$ = this.transitions_0;
    var $receiver_0 = new TransitionBuilder(this.state_0, $receiver);
    transition($receiver_0);
    var value = $receiver_0.build();
    tmp$.put_xwzc9p$(name, value);
  };
  StateBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StateBuilder',
    interfaces: [Builder]
  };
  function StateMachineBuilder(title, fieldName, states) {
    RuleBuilder.call(this, title);
    this.fieldName_0 = fieldName;
    this.states_0 = states;
    this.statesMap_0 = LinkedHashMap_init();
  }
  StateMachineBuilder.prototype.build_za3rmp$ = function (o) {
    RuleBuilder.prototype.build_za3rmp$.call(this, o);
    o.fieldName = this.fieldName_0;
    o.states = {};
    var tmp$;
    tmp$ = this.statesMap_0.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.key;
      var value = element.value;
      o.states[key] = value;
    }
  };
  StateMachineBuilder.prototype.defines_omxgu0$ = function ($receiver, definition) {
    var tmp$ = this.statesMap_0;
    var $receiver_0 = new StateBuilder($receiver);
    definition($receiver_0);
    var value = $receiver_0.build();
    tmp$.put_xwzc9p$($receiver, value);
  };
  StateMachineBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StateMachineBuilder',
    interfaces: [RuleBuilder]
  };
  var package$com = _.com || (_.com = {});
  var package$jetbrains = package$com.jetbrains || (package$com.jetbrains = {});
  var package$youtrack = package$jetbrains.youtrack || (package$jetbrains.youtrack = {});
  var package$workflow = package$youtrack.workflow || (package$youtrack.workflow = {});
  var package$api = package$workflow.api || (package$workflow.api = {});
  package$api.get_xy436r$ = get_0;
  package$api.set_5x7647$ = set;
  package$api.getFromMap_12czou$ = getFromMap;
  package$api.FieldAccessDelegateProvider = FieldAccessDelegateProvider;
  package$api.FieldAccessDelegate = FieldAccessDelegate;
  package$api.FieldValueAccessDelegateProvider = FieldValueAccessDelegateProvider;
  package$api.FieldValueAccessDelegate = FieldValueAccessDelegate;
  package$api.EntityAccessDelegateProvider = EntityAccessDelegateProvider;
  package$api.requiredUser_61zpoe$ = requiredUser;
  package$api.requiredUserGroup_61zpoe$ = requiredUserGroup;
  package$api.requiredProject_61zpoe$ = requiredProject;
  package$api.requiredIssue_61zpoe$ = requiredIssue;
  package$api.EntityGetterDelegate = EntityGetterDelegate;
  package$api.dateField_61zpoe$ = dateField;
  package$api.nullableDateField_61zpoe$ = nullableDateField;
  package$api.requiredDateField_61zpoe$ = requiredDateField;
  package$api.requiredNullableDateField_61zpoe$ = requiredNullableDateField;
  package$api.dateTimeField_61zpoe$ = dateTimeField;
  package$api.nullableDateTimeField_61zpoe$ = nullableDateTimeField;
  package$api.requiredDateTimeField_61zpoe$ = requiredDateTimeField;
  package$api.requiredNullableDateTimeField_61zpoe$ = requiredNullableDateTimeField;
  package$api.floatField_61zpoe$ = floatField;
  package$api.nullableFloatField_61zpoe$ = nullableFloatField;
  package$api.requiredFloatField_61zpoe$ = requiredFloatField;
  package$api.requiredNullableFloatField_61zpoe$ = requiredNullableFloatField;
  package$api.integerField_61zpoe$ = integerField;
  package$api.nullableIntegerField_61zpoe$ = nullableIntegerField;
  package$api.requiredIntegerField_61zpoe$ = requiredIntegerField;
  package$api.requiredNullableIntegerField_61zpoe$ = requiredNullableIntegerField;
  package$api.stringField_61zpoe$ = stringField;
  package$api.nullableStringField_61zpoe$ = nullableStringField;
  package$api.requiredStringField_61zpoe$ = requiredStringField;
  package$api.requiredNullableStringField_61zpoe$ = requiredNullableStringField;
  package$api.enumField_61zpoe$ = enumField;
  package$api.nullableEnumField_61zpoe$ = nullableEnumField;
  package$api.requiredEnumField_61zpoe$ = requiredEnumField;
  package$api.requiredNullableEnumField_61zpoe$ = requiredNullableEnumField;
  package$api.stateField_61zpoe$ = stateField;
  package$api.nullableStateField_61zpoe$ = nullableStateField;
  package$api.requiredStateField_61zpoe$ = requiredStateField;
  package$api.requiredNullableStateField_61zpoe$ = requiredNullableStateField;
  package$api.userField_61zpoe$ = userField;
  package$api.nullableUserField_61zpoe$ = nullableUserField;
  package$api.requiredUserField_61zpoe$ = requiredUserField;
  package$api.requiredNullableUserField_61zpoe$ = requiredNullableUserField;
  package$api.userGroupField_61zpoe$ = userGroupField;
  package$api.nullableUserGroupField_61zpoe$ = nullableUserGroupField;
  package$api.requiredUserGroupField_61zpoe$ = requiredUserGroupField;
  package$api.requiredNullableUserGroupField_61zpoe$ = requiredNullableUserGroupField;
  package$api.buildField_61zpoe$ = buildField;
  package$api.nullableBuildField_61zpoe$ = nullableBuildField;
  package$api.requiredBuildField_61zpoe$ = requiredBuildField;
  package$api.requiredNullableBuildField_61zpoe$ = requiredNullableBuildField;
  package$api.ownedField_61zpoe$ = ownedField;
  package$api.nullableOwnedField_61zpoe$ = nullableOwnedField;
  package$api.requiredOwnedField_61zpoe$ = requiredOwnedField;
  package$api.requiredNullableOwnedField_61zpoe$ = requiredNullableOwnedField;
  package$api.versionField_61zpoe$ = versionField;
  package$api.nullableVersionField_61zpoe$ = nullableVersionField;
  package$api.requiredVersionField_61zpoe$ = requiredVersionField;
  package$api.requiredNullableVersionField_61zpoe$ = requiredNullableVersionField;
  package$api.required_zhfskx$ = required;
  package$api.becomes_nwjuog$ = becomes;
  package$api.get_isChanged_texjl9$ = get_isChanged;
  package$api.get_oldValue_ck9vd2$ = get_oldValue;
  package$api.canBeReadBy_s04q5a$ = canBeReadBy;
  package$api.canBeWrittenBy_s04q5a$ = canBeWrittenBy;
  package$api.get_added_ymyg12$ = get_added;
  package$api.get_removed_ymyg12$ = get_removed;
  package$api.get_isChanged_ymyg12$ = get_isChanged_0;
  package$api.RequirementsCollector = RequirementsCollector;
  Object.defineProperty(package$api, 'requirements', {
    get: function () {
      return requirements;
    }
  });
  package$api.onChange_dktmyv$ = onChange;
  package$api.action_sbr766$ = action;
  package$api.onSchedule_qrlqmx$ = onSchedule;
  package$api.Builder = Builder;
  package$api.RuleBuilder = RuleBuilder;
  package$api.OnChangeBuilder = OnChangeBuilder;
  package$api.ActionBuilder = ActionBuilder;
  package$api.OnScheduleBuilder = OnScheduleBuilder;
  package$api.TransitionBuilder = TransitionBuilder;
  package$api.StateBuilder = StateBuilder;
  package$api.StateMachineBuilder = StateMachineBuilder;
  map = HashMap_init();
  requirements = new RequirementsCollector();
  Kotlin.defineModule('kotlin-workflow-api', _);
  return _;
}(module.exports, require('kotlin'), require('@jetbrains/youtrack-scripting-api/entities')));