var model = JavaImporter(Packages.jetbrains.youtrack.workflow.model);
var templateComponent = JavaImporter(Packages.jetbrains.mps.webr.runtime.templateComponent);
var joda = JavaImporter(Packages.org.joda.time);
var requirement = JavaImporter(Packages.jetbrains.youtrack.workflow.requirement);
var forEach = function (_iter, callback, filter) {
  var iter = _iter.hasNext ?_iter :_iter.iterator();
  while (iter.hasNext()) {
    var next = iter.next();
    if (filter && filter(next)) {
      if (callback(next)) {
                break;

      }

    }

  }

};
var assert = function (ctx, condition, failMessage) {
  Packages.jetbrains.youtrack.workflow.model.Assertion.check(ctx, condition, failMessage);
};
var message = function (ctx, message) {
  Packages.jetbrains.charisma.misc.Message.show(message, ctx.issue);
};
var equals = function (left, right) {
  if (left == right) {
    return true;
  }

  if (left == null || right == null) {
    return false;
  }

  if (left.equals) {
    return left.equals(right);
  }

  if (right.equals) {
    return right.equals(left);
  }

  return false;
};
var require = function (ctx, entity, fieldName, failMessage) {
  Packages.jetbrains.youtrack.workflow.model.Assertion.require(ctx, entity, fieldName, failMessage ?failMessage :null);
};
var print = function (msg) {
  Packages.org.apache.commons.logging.LogFactory.getLog("jetbrains.youtrack.workflow.print").info(msg);
};
var log = function (level, msg, ctx) {
  var ruleName = ctx.ruleFqName || "NamelessScript";
  Packages.org.apache.commons.logging.LogFactory.getLog("jetbrains.youtrack.workflow." + ruleName)[level](msg);
};
var find = function (value, type) {
  var result = new Packages.jetbrains.youtrack.scripts.wrappers.EnumReference(value);
  if (type) {
    result = type.wrap(type.unwrap(result));
  }

  return result;
};
var datetime = function (year, month, day, hour, minute, second) {
  var chr = Packages.org.joda.time.chrono.ISOChronology.getInstance();
  var instant = joda.DateTimeUtils.currentTimeMillis();
  var isSet = false;
  var props = [chr.year(), chr.monthOfYear(), chr.dayOfMonth(), chr.hourOfDay(), chr.minuteOfHour(), chr.secondOfMinute()];
  var values = [year, month, day, hour, minute, second];
  for (var i = 0; i < props.length; ++i) {
    if (values[i] > 0) {
      instant = props[i].set(instant, values[i]);
      isSet = true;
    } else if (isSet) {
      instant = props[i].set(instant, props[i].getMinimumValue(instant));
    }

  }

  return instant;
};
var now = function () {
  return joda.DateTimeUtils.currentTimeMillis();
};
var formatDateTime = function (ctx, timestamp, dateTimeFormatter) {
  var value;
  if (dateTimeFormatter) {
    var dt = new joda.DateTime(timestamp, ctx.timeZone);
    value = dateTimeFormatter.print(dt);
  } else {
    value = new Date(timestamp).toUTCString();
  }

  return value;
};
var predefinedDateTimeFormat = function (dateTimeFormatterName) {
  return safeCall(Packages.org.joda.time.format.DateTimeFormat, dateTimeFormatterName, []);
};
var patternDateTimeFormat = Packages.org.joda.time.format.DateTimeFormat.forPattern;
var valuesFor = Packages.jetbrains.youtrack.workflow.wrappers.WorkflowOperations.getValuesFor;
var classType = function (ctx, typeName, multiple) {
  return Packages.jetbrains.youtrack.workflow.wrappers.WorkflowOperations.getProjectEntityValueResolver(ctx, null, typeName, multiple);
};
var getIssues = Packages.jetbrains.youtrack.workflow.wrappers.WorkflowOperations.getIssues;


var invoke = function (ctx, instance, methodName, params) {
  assert(ctx, instance != null, "Can't call method [" + methodName + "] on null object.");
  return instance.invoke(methodName, params);
};
var invokeConstructor = function (ctx, entityType, params) {
  assert(ctx, entityType != null, "Can't call constructor of null type.");
  return Packages.jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper.invokeConstructor(entityType, ctx, params);
};
var invokeStatic = function (ctx, entityType, methodName, params) {
  assert(ctx, entityType != null && methodName != null, "Can't call method [" + methodName + "] on entity of type " + entityType);
  return Packages.jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper.invokeStatic(entityType, methodName, ctx, params);
};
var getEnumElement = function (ctx, entityType, elementName) {
  assert(ctx, entityType != null && elementName != null, "Can't get element [" + elementName + "] on enum entity of type " + entityType);
  return Packages.jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper.getEnumElement(entityType, elementName, ctx);
};


var safeCall = function (instance, methodName, params, defaultReturnValue) {
  if (instance == null) {
    return defaultReturnValue;
  }

  var method = instance[methodName];
  if (method == null) {
    return defaultReturnValue;
  }

  return method.apply(instance, params);
};
var rule;
//----------------- State Machine related stuff ----------------------------
var StateBuilder = {};
StateBuilder = function (sourceStatePath) {
  this.targetState = null;
  this.event = null;
  this.period = null;
  this.condition = null;
  this.action = null;
  this.stateMachine = rule;
  this.sourceState = this.parseState(sourceStatePath);
};
StateBuilder.prototype.on = function (e) {
  this.event = e;
  return this;
};
StateBuilder.prototype.after = function (t) {
  this.period = t;
  return this;
};
StateBuilder.prototype.onEnter = function (f) {
  if (f) {
    this.sourceState.enter = new Packages.jetbrains.youtrack.workflow.model.Action({action: f});
  }

  return this;
};
StateBuilder.prototype.onExit = function (f) {
  if (f) {
    this.sourceState.exit = new Packages.jetbrains.youtrack.workflow.model.Action({action: f});
  }

  return this;
};
StateBuilder.prototype.when = function (f) {
  if (f) {
    this.condition = new Packages.jetbrains.youtrack.workflow.model.Guard({guard: f});
  }

  return this;
};
StateBuilder.prototype.perform = function (f) {
  if (f) {
    this.action = new Packages.jetbrains.youtrack.workflow.model.Action({action: f});
  }

  return this;
};
StateBuilder.prototype.transitTo = function (targetStatePath) {
  this.targetState = this.parseState(arguments);
  this.create();
  return this;
};
StateBuilder.prototype.loop = function () {
  this.create();
  return this;
};
StateBuilder.prototype.create = function () {
  if (this.period != null) {
    this.sourceState.addTransition(this.sourceState.createTimeEvent(this.stateMachine, this.period), this.condition, this.action, this.targetState);
  } else {
    this.sourceState.addTransition(this.sourceState.createEvent(this.event), this.condition, this.action, this.targetState);
  }

  this.clear();
};
StateBuilder.prototype.clear = function () {
  this.event = null;
  this.period = null;
  this.condition = null;
  this.action = null;
  this.targetState = null;
};
StateBuilder.prototype.parseState = function (statePath) {
  var p = [];
  for (var i = 0; i < statePath.length; ++i) {
    p.push(statePath[i]);
  }

  return this.stateMachine.getState(true, p);
};
var from = function (statePath) {
  return new StateBuilder(arguments);
};


var statemachine = function (name, fieldName) {
  rule = new Packages.jetbrains.youtrack.workflow.model.StateMachine(name, fieldName);
  return rule;
};
//-----------End of State Machine related stuff ----------------------------






//---------------- Stateless Rule related stuff ----------------------------
var statelessrule = function (name, event, guard, action) {
  rule = new Packages.jetbrains.youtrack.workflow.model.StatelessRule(name, event, guard ?new Packages.jetbrains.youtrack.workflow.model.Guard({guard: guard}) :null, new Packages.jetbrains.youtrack.workflow.model.Action({action: action}));
  return rule;
};
var onschedulestatelessrule = function (name, event, cron, where, action) {
  rule = new Packages.jetbrains.youtrack.workflow.model.StatelessOnScheduleRule(name, event, cron, where ?new Packages.jetbrains.youtrack.workflow.model.IWhere({build: where}) :null, new Packages.jetbrains.youtrack.workflow.model.Action({action: action}));
  return rule;
};
//----------End of Stateless Rule related stuff ----------------------------


//----------------Binary operations-----------------------------------------
var datePlusPeriod = function (millis, period) {
  if (millis == null) {
    return null;
  }

  if (period == null) {
    return millis;
  }

  var date = new joda.DateTime(millis);
  return date.plus(period).getMillis();
};
var datePlusDuration = function (millis, duration) {
  if (millis == null) {
    return null;
  }

  if (duration == null) {
    return millis;
  }

  var date = new joda.DateTime(millis);
  return date.plus(duration).getMillis();
};
var dateMinusPeriod = function (millis, period) {
  if (millis == null) {
    return null;
  }

  if (period == null) {
    return millis;
  }

  var date = new joda.DateTime(millis);
  return date.minus(period).getMillis();
};
var dateMinusDuration = function (millis, duration) {
  if (millis == null) {
    return null;
  }

  if (duration == null) {
    return millis;
  }

  var date = new joda.DateTime(millis);
  return date.minus(duration).getMillis();
};
var dateMinusDate = function (toMillis, fromMillis) {
  if (toMillis == null || fromMillis == null) {
    return null;
  }

  var toDate = new joda.DateTime(toMillis);
  var fromDate = new joda.DateTime(fromMillis);
  return new joda.Duration(fromDate, toDate);
};
var durationToPeriod = function (fromDuration) {
  if (fromDuration == null) {
    return null;
  }

  return new joda.Period(fromDuration);
};
//----------End Binary operations ------------------------------------------


//----------Start string operations ------------------------------------------
var strOp = function (operationName, operand, otherParameters) {
  //Inderect call is used because there is no other way to unwrap arrays to sequences
  var parameters = [];
  for (var i = 1; i < arguments.length; ++i) {
    parameters.push(arguments[i]);
  }

  var result = Packages.org.apache.commons.lang.StringUtils[operationName].apply(null, parameters);
  if (Packages.jetbrains.youtrack.scripts.wrappers.ArrayWrapper.isArray(result)) {
    result = new Packages.jetbrains.youtrack.scripts.wrappers.ArrayWrapper(result);
  }

  return result;
};
//----------End string operations ------------------------------------------


//----------Start util operations ------------------------------------------
var jsArrayToList = function (jsArray) {
  //Force lazy initialization
  var capacity = jsArray.length + 0;
  var result = new Packages.java.util.ArrayList(capacity);
  for (var i = 0; i < capacity; ++i) {
    result.add(jsArray[i]);
  }

  return result;
};
var requirements = function (jsArray, type) {
  if (!type) {
    type = "type";
  }

  //Force lazy initialization
  var capacity = jsArray.length + 0;
  var result = new Packages.java.util.ArrayList(capacity);
  for (var i = 0; i < capacity; ++i) {
    result.add(json2requirement(jsArray[i], type));
  }

  return result;
};
var json2requirement = function (json, type) {
  var res;
  var type = type.toLowerCase();
  if (type.indexOf("type") > -1) {
    res = new Packages.jetbrains.youtrack.workflow.requirement.TypeRequirement();
  } else if (type.indexOf("field") > -1) {
    res = new Packages.jetbrains.youtrack.workflow.requirement.FieldRequirement();
  } else if (type.indexOf("method") > -1) {
    res = new Packages.jetbrains.youtrack.workflow.requirement.MethodRequirement();
  } else if (type.indexOf("value") > -1) {
    return json;
  } else {
    throw "Unknown type [" + type + "]";
  }

  for ( var propName in json) {
    var value = json[propName];
    var type = typeof value;
    if (type === "string") {
      //If string do not convert
    } else if (type === "boolean") {
      //If boolean do not convert
    } else if (type === "object") {
      //Ok, this is object, check what instance is it
      if (value instanceof Array) {
        //Array of requirements
        value = requirements(value, propName);
      } else {
        //This is JSON type object
        value = json2requirement(value, propName);
      }

    } else {
      throw "Unknown type [" + type + "]";
    }

    res[propName] = value;
  }

  return res;
};
var localize = function (messageId, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
  var parameters = [];
  for (var i = 1; i < arguments.length; ++i) {
    parameters.push(arguments[i]);
  }

  return Packages.jetbrains.youtrack.workflow.wrappers.WFLocalizer.getMessage(messageId, jsArrayToList(parameters));
};
//----------End util operations ------------------------------------------
