/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="agileCache")
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0013R\u00020\u00000\u00112\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0013R\u00020\u00000\u00112\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache;", "", "()V", "data", "Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheData;", "getAgilesWithoutCardSubtasks", "", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "getDefaultSprints", "", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getImplicitAgiles", "getProjectData", "Ljetbrains/youtrack/agile/persistence/AgileCache$ProjectCacheItem;", "getSyncPrototypes", "", "", "Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "getTimePrototypes", "init", "", "AgileCacheData", "AgileCacheItem", "ProjectCacheItem", "youtrack-scrumboard"})
public final class AgileCache {
    private volatile AgileCacheData data;

    public final void init() {
        this.data = new AgileCacheData();
    }

    @NotNull
    public final List<XdSprint> getDefaultSprints(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectCacheItem projectCacheItem = this.getProjectData(project2);
        if (projectCacheItem == null) {
            return CollectionsKt.emptyList();
        }
        ProjectCacheItem result2 = projectCacheItem;
        return result2.getDefaultSprints();
    }

    @NotNull
    public final Map<String, AgileCacheItem> getTimePrototypes(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectCacheItem projectCacheItem = this.getProjectData(project2);
        if (projectCacheItem == null) {
            return MapsKt.emptyMap();
        }
        ProjectCacheItem result2 = projectCacheItem;
        return result2.getTimePrototypes();
    }

    @NotNull
    public final Map<String, AgileCacheItem> getSyncPrototypes(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectCacheItem projectCacheItem = this.getProjectData(project2);
        if (projectCacheItem == null) {
            return MapsKt.emptyMap();
        }
        ProjectCacheItem result2 = projectCacheItem;
        return result2.getSyncPrototypes();
    }

    private final ProjectCacheItem getProjectData(XdProject project2) throws IllegalStateException {
        AgileCacheData agileCacheData = this.data;
        if (agileCacheData == null) {
            throw (Throwable)new IllegalStateException("Cache not initialized");
        }
        AgileCacheData d = agileCacheData;
        return d.getProjectItems().get(project2);
    }

    @NotNull
    public final Set<XdAgile> getImplicitAgiles(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectCacheItem projectCacheItem = this.getProjectData(project2);
        if (projectCacheItem == null) {
            return SetsKt.emptySet();
        }
        ProjectCacheItem data = projectCacheItem;
        return data.getImplicitAgiles();
    }

    @NotNull
    public final Set<XdAgile> getAgilesWithoutCardSubtasks(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ProjectCacheItem projectCacheItem = this.getProjectData(project2);
        if (projectCacheItem == null) {
            return SetsKt.emptySet();
        }
        ProjectCacheItem data = projectCacheItem;
        return data.getNoCardSubtasksAgiles();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheData;", "", "(Ljetbrains/youtrack/agile/persistence/AgileCache;)V", "projectItems", "Ljava/util/HashMap;", "Ljetbrains/youtrack/persistent/XdProject;", "Ljetbrains/youtrack/agile/persistence/AgileCache$ProjectCacheItem;", "Ljetbrains/youtrack/agile/persistence/AgileCache;", "getProjectItems", "()Ljava/util/HashMap;", "youtrack-scrumboard"})
    public final class AgileCacheData {
        @NotNull
        private final HashMap<XdProject, ProjectCacheItem> projectItems = new HashMap();

        @NotNull
        public final HashMap<XdProject, ProjectCacheItem> getProjectItems() {
            return this.projectItems;
        }

        public AgileCacheData() {
            Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)XdAgile.Companion.all());
            for (Object element$iv : $receiver$iv) {
                XdAgile agile2 = (XdAgile)((Object)element$iv);
                XdCustomFieldPrototype timePrototype = agile2.getTimePrototype();
                XdCustomFieldPrototype syncPrototype = agile2.getSprintSyncField();
                XdSprint defaultSprint = agile2.getDefaultSprint();
                boolean isExplicit2 = agile2.isExplicit();
                boolean hideSubtasksOfCards = agile2.getHideSubtasksOfCards();
                if (defaultSprint == null && timePrototype == null && syncPrototype == null && isExplicit2 && !hideSubtasksOfCards) continue;
                Sequence $receiver$iv2 = XdQueryKt.asSequence((XdQuery)((XdQuery)agile2.getProjects()));
                Iterator iterator2 = $receiver$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    Map $receiver$iv3 = this.projectItems;
                    Object element$iv2 = iterator2.next();
                    XdProject it = (XdProject)element$iv2;
                    Object value$iv = $receiver$iv3.get(it);
                    if (value$iv == null) {
                        ProjectCacheItem answer$iv = new ProjectCacheItem();
                        $receiver$iv3.put(it, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ProjectCacheItem item = (ProjectCacheItem)object;
                    if (!isExplicit2) {
                        item.getImplicitAgiles().add(agile2);
                    }
                    if (hideSubtasksOfCards) {
                        item.getNoCardSubtasksAgiles().add(agile2);
                    }
                    if (defaultSprint != null && !defaultSprint.getArchived()) {
                        item.getDefaultSprints().add(defaultSprint);
                    }
                    if (timePrototype != null) {
                        item.putTimePrototype(timePrototype.getId(), timePrototype, agile2);
                    }
                    if (syncPrototype == null) continue;
                    item.putSyncPrototype(syncPrototype.getId(), syncPrototype, agile2);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nJ\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00130\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00130\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache$ProjectCacheItem;", "", "(Ljetbrains/youtrack/agile/persistence/AgileCache;)V", "defaultSprints", "Ljava/util/ArrayList;", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getDefaultSprints", "()Ljava/util/ArrayList;", "implicitAgiles", "Ljava/util/HashSet;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "getImplicitAgiles", "()Ljava/util/HashSet;", "noCardSubtasksAgiles", "getNoCardSubtasksAgiles", "syncPrototypes", "Ljava/util/HashMap;", "", "Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "Ljetbrains/youtrack/agile/persistence/AgileCache;", "getSyncPrototypes", "()Ljava/util/HashMap;", "timePrototypes", "getTimePrototypes", "putSyncPrototype", "", "id", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "agile", "putTimePrototype", "youtrack-scrumboard"})
    public final class ProjectCacheItem {
        @NotNull
        private final ArrayList<XdSprint> defaultSprints = new ArrayList(10);
        @NotNull
        private final HashMap<String, AgileCacheItem> timePrototypes = new HashMap();
        @NotNull
        private final HashMap<String, AgileCacheItem> syncPrototypes = new HashMap();
        @NotNull
        private final HashSet<XdAgile> implicitAgiles = new HashSet();
        @NotNull
        private final HashSet<XdAgile> noCardSubtasksAgiles = new HashSet();

        @NotNull
        public final ArrayList<XdSprint> getDefaultSprints() {
            return this.defaultSprints;
        }

        @NotNull
        public final HashMap<String, AgileCacheItem> getTimePrototypes() {
            return this.timePrototypes;
        }

        @NotNull
        public final HashMap<String, AgileCacheItem> getSyncPrototypes() {
            return this.syncPrototypes;
        }

        @NotNull
        public final HashSet<XdAgile> getImplicitAgiles() {
            return this.implicitAgiles;
        }

        @NotNull
        public final HashSet<XdAgile> getNoCardSubtasksAgiles() {
            return this.noCardSubtasksAgiles;
        }

        public final void putTimePrototype(@NotNull String id, @NotNull XdCustomFieldPrototype prototype, @NotNull XdAgile agile2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
            Map $receiver$iv = this.timePrototypes;
            Object value$iv = $receiver$iv.get(id);
            if (value$iv == null) {
                AgileCacheItem answer$iv = new AgileCacheItem(prototype);
                $receiver$iv.put(id, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((AgileCacheItem)object).getAgiles().add(agile2);
        }

        public final void putSyncPrototype(@NotNull String id, @NotNull XdCustomFieldPrototype prototype, @NotNull XdAgile agile2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
            Map $receiver$iv = this.syncPrototypes;
            Object value$iv = $receiver$iv.get(id);
            if (value$iv == null) {
                AgileCacheItem answer$iv = new AgileCacheItem(prototype);
                $receiver$iv.put(id, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((AgileCacheItem)object).getAgiles().add(agile2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/agile/persistence/AgileCache$AgileCacheItem;", "", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "(Ljetbrains/youtrack/agile/persistence/AgileCache;Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;)V", "agiles", "Ljava/util/HashSet;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "getAgiles", "()Ljava/util/HashSet;", "getPrototype", "()Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "youtrack-scrumboard"})
    public final class AgileCacheItem {
        @NotNull
        private final HashSet<XdAgile> agiles;
        @NotNull
        private final XdCustomFieldPrototype prototype;

        @NotNull
        public final HashSet<XdAgile> getAgiles() {
            return this.agiles;
        }

        @NotNull
        public final XdCustomFieldPrototype getPrototype() {
            return this.prototype;
        }

        public AgileCacheItem(XdCustomFieldPrototype prototype) {
            Intrinsics.checkParameterIsNotNull((Object)prototype, (String)"prototype");
            this.prototype = prototype;
            this.agiles = new HashSet();
        }
    }
}

