/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.query;

import java.util.Collection;
import java.util.List;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.agile.Localization;
import jetbrains.youtrack.agile.persistence.BacklogUtil_klKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.query.AgileQueryAnalyzer;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLoggable;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="agileQueryAnalyzer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/agile/persistence/query/AgileQueryAnalyzers;", "", "()V", "analyzers", "", "Ljetbrains/youtrack/agile/persistence/query/AgileQueryAnalyzer;", "getAnalyzers", "()Ljava/util/List;", "setAnalyzers", "(Ljava/util/List;)V", "analyzeAgileQuery", "", "agile", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "warnings", "", "", "errors", "Companion", "youtrack-scrumboard"})
public final class AgileQueryAnalyzers {
    @Autowired
    @NotNull
    public List<? extends AgileQueryAnalyzer> analyzers;
    @NotNull
    private static final KLogger logger;
    public static final Companion Companion;

    @NotNull
    public final List<AgileQueryAnalyzer> getAnalyzers() {
        List<AgileQueryAnalyzer> list = this.analyzers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analyzers");
        }
        return list;
    }

    public final void setAnalyzers(@NotNull List<? extends AgileQueryAnalyzer> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.analyzers = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean analyzeAgileQuery(@NotNull XdAgile agile2, @NotNull XdUser user, @NotNull List<String> warnings, @NotNull List<String> errors) {
        IParseResult parseResult;
        IParseResult iParseResult;
        Intrinsics.checkParameterIsNotNull((Object)((Object)agile2), (String)"agile");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull(warnings, (String)"warnings");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        Object object = agile2.getExplicitQuery();
        if (object == null || object.length() == 0 || !(object = (Collection)errors).isEmpty()) {
            return true;
        }
        Context ctx = new Context();
        Entity user$iv$iv = user.getEntity();
        Object _principalManager$iv$iv = BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            iParseResult = jetbrains.charisma.persistent.BeansKt.getParser().parse(agile2.getProjects().getEntityIterable(), agile2.getExplicitQuery(), (IContext)ctx);
        }
        finally {
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
        }
        IParseResult iParseResult2 = parseResult = iParseResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)iParseResult2, (String)"parseResult");
        Iterable parseErrors = iParseResult2.getSyntaxErrors();
        if (CollectionUtilKt.isNotEmpty((Iterable)parseErrors)) {
            errors.add((String)Localization.INSTANCE.getAgileQueryIsInvalid().invoke());
            return false;
        }
        try {
            void $receiver$iv;
            boolean initial$iv;
            List<? extends AgileQueryAnalyzer> list = this.analyzers;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"analyzers");
            }
            _principalManager$iv$iv = list;
            boolean accumulator$iv = initial$iv = true;
            for (Object element$iv : $receiver$iv) {
                void it;
                AgileQueryAnalyzer agileQueryAnalyzer = (AgileQueryAnalyzer)element$iv;
                boolean seed = accumulator$iv;
                accumulator$iv = seed && it.analyzeQuery(agile2, parseResult, warnings, errors);
            }
            return accumulator$iv;
        }
        catch (Throwable e) {
            BacklogUtil_klKt.getLog().error("Failed to analyze agile query", e);
            return false;
        }
    }

    static {
        Companion = new Companion(null);
        logger = Companion.logger();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/agile/persistence/query/AgileQueryAnalyzers$Companion;", "Lmu/KLoggable;", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "youtrack-scrumboard"})
    public static final class Companion
    implements KLoggable {
        @NotNull
        public KLogger getLogger() {
            return logger;
        }

        private Companion() {
        }

        @NotNull
        public KLogger logger() {
            return KLoggable.DefaultImpls.logger((KLoggable)this);
        }

        @NotNull
        public KLogger logger(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return KLoggable.DefaultImpls.logger((KLoggable)this, (String)name2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

