/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.main.RestEntityUtilsKt;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.persistent.issueFolders.SavedQuery;
import jetbrains.charisma.persistent.security.UserGroup;
import jetbrains.dnq.lang.PersistentClassesKt;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.gap.resource.SecurityFiltersKt;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.gap.resource.components.impl.DelegateBasedSubResourceGetter;
import jetbrains.gap.resource.components.impl.entity.RootEntitySequenceResource;
import jetbrains.gap.resource.pojo.POJO;
import jetbrains.gap.resource.pojo.POJOKt;
import jetbrains.youtrack.agile.Localization;
import jetbrains.youtrack.agile.persistence.AgileCloner;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.builder.AgileAccessSettings;
import jetbrains.youtrack.agile.persistence.builder.AgileBoardBuilder;
import jetbrains.youtrack.agile.rest.AgileBacklogSubscriptionResource;
import jetbrains.youtrack.agile.rest.AgileBacklogTreeResource;
import jetbrains.youtrack.agile.rest.AgileIssuesGetterResource;
import jetbrains.youtrack.agile.rest.AgileResource$doCreate$1;
import jetbrains.youtrack.agile.rest.AgileResource$doCreate$2;
import jetbrains.youtrack.agile.rest.AgileTypeMapping;
import jetbrains.youtrack.agile.rest.BacklogTreeResource;
import jetbrains.youtrack.agile.rest.FlatBacklogResource;
import jetbrains.youtrack.agile.rest.NullBacklogResource;
import jetbrains.youtrack.agile.settings.Agile;
import jetbrains.youtrack.agile.templates.AgileTemplate;
import jetbrains.youtrack.agile.templates.AgileTemplates;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import jetbrains.youtrack.gaprest.db.mapping.TypeMapping;
import jetbrains.youtrack.gaprest.db.resource.XodusRootEntitySequenceResource;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.gaprest.filters.ReadWriteTransactional;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdSavedQuery;
import jetbrains.youtrack.persistent.XdUserProfile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

@RestPublic
@Path(value="agiles")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/youtrack/agile/rest/AgileResource;", "Ljetbrains/youtrack/gaprest/db/resource/XodusRootEntitySequenceResource;", "()V", "agileCloner", "Ljetbrains/youtrack/agile/persistence/AgileCloner;", "getAgileCloner", "()Ljetbrains/youtrack/agile/persistence/AgileCloner;", "setAgileCloner", "(Ljetbrains/youtrack/agile/persistence/AgileCloner;)V", "args", "Ljavax/ws/rs/core/UriInfo;", "assertUpdateAccess", "", "cloneBoard", "Ljetbrains/youtrack/agile/settings/Agile;", "id", "", "doCreate", "Ljetbrains/youtrack/gaprest/db/DatabaseEntity;", "entity", "getAccessSettings", "Ljetbrains/youtrack/agile/persistence/builder/AgileAccessSettings;", "isProjectBased", "", "group", "Ljetbrains/charisma/persistent/security/UserGroup;", "getAll", "Lkotlin/sequences/Sequence;", "getElementResource", "", "element", "getProjectsForNewAgile", "", "Ljetbrains/youtrack/persistent/XdProject;", "youtrack-scrumboard"})
public final class AgileResource
extends XodusRootEntitySequenceResource {
    @Context
    private UriInfo args;
    @Autowired
    @NotNull
    public AgileCloner agileCloner;

    @NotNull
    public final AgileCloner getAgileCloner() {
        AgileCloner agileCloner = this.agileCloner;
        if (agileCloner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agileCloner");
        }
        return agileCloner;
    }

    public final void setAgileCloner(@NotNull AgileCloner agileCloner) {
        Intrinsics.checkParameterIsNotNull((Object)agileCloner, (String)"<set-?>");
        this.agileCloner = agileCloner;
    }

    @NotNull
    public Sequence<DatabaseEntity> getAll() {
        TreeKeepingEntityIterable treeKeepingEntityIterable = jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore().getQueryEngine().queryGetAll(XdAgile.Companion.getEntityType());
        Intrinsics.checkExpressionValueIsNotNull((Object)treeKeepingEntityIterable, (String)"transientEntityStore.que\u2026etAll(XdAgile.entityType)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)treeKeepingEntityIterable)), (Function1)((Function1)new Function1<Entity, DatabaseEntity>(this){
            final /* synthetic */ AgileResource this$0;

            @NotNull
            public final DatabaseEntity invoke(Entity it) {
                TypeMapping typeMapping = this.this$0.getTypeMapping();
                Entity entity = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"it");
                return typeMapping.wrap(entity);
            }
            {
                this.this$0 = agileResource;
                super(1);
            }
        }));
    }

    public void assertUpdateAccess() {
        TransientEntity current = jetbrains.charisma.persistent.BeansKt.getLoggedInUser();
        if (((UserImpl)PersistentClassesKt.asPersistentClass((Entity)((Entity)current))).isGuest((Entity)current)) {
            throw (Throwable)new ForbiddenException((String)Localization.INSTANCE.getGuestCantUseAgile().invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DatabaseEntity doCreate(@NotNull DatabaseEntity entity) {
        DatabaseEntity value2;
        Class actualClazz;
        String templateName;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        if (!((charSequence = (CharSequence)(templateName = WebUtilsKt.get((UriInfo)uriInfo, (String)"template"))) == null || charSequence.length() == 0)) {
            Object v1;
            Object object;
            block11: {
                object = AgileTemplates.INSTANCE.getTemplates();
                Iterable iterable2 = object;
                for (Object t : iterable2) {
                    AgileTemplate it = (AgileTemplate)t;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)templateName)) continue;
                    v1 = t;
                    break block11;
                }
                v1 = null;
            }
            AgileTemplate agileTemplate = v1;
            if (agileTemplate == null) {
                object = templateName;
                Function1<Object, String> function1 = Localization.INSTANCE.getNoTemplateWithName();
                Object object2 = object;
                if (object2 == null) {
                    object2 = "";
                }
                Object object3 = object2;
                String string = (String)function1.invoke(object3);
                throw (Throwable)new BadRequestException(string);
            }
            AgileTemplate template = agileTemplate;
            if (entity.provides((KProperty1)AgileResource$doCreate$1.INSTANCE)) {
                Collection<XdProject> collection;
                Entity $receiver$iv$iv;
                XdEntity $receiver$iv;
                Object t;
                Agile value3 = (Agile)entity;
                if (value3.getVisibleForProjectBased() || value3.getVisibleFor() != null) {
                    Agile.Companion.assertVisibilityAllowed();
                }
                AgileBoardBuilder agileBoardBuilder = new AgileBoardBuilder();
                String string = value3.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable3 = value3.getProjects();
                AgileBoardBuilder agileBoardBuilder2 = agileBoardBuilder.withName(string);
                t = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Project project2 = (Project)item$iv$iv;
                    collection = destination$iv$iv;
                    XdProject xdProject = ((Project)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)it), null, (int)1, null)).getXdEntity();
                    collection.add(xdProject);
                }
                collection = (List)destination$iv$iv;
                AgileBoardBuilder builder = agileBoardBuilder2.withProjects((List<XdProject>)collection).withCreator(jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser()).withVisibleFor(this.getAccessSettings(value3.getVisibleForProjectBased(), value3.getVisibleFor())).withUpdatableBy(this.getAccessSettings(value3.getUpdateableByProjectBased(), value3.getUpdateableBy()));
                if (value3.provides((KProperty1)AgileResource$doCreate$2.INSTANCE)) {
                    SavedQuery savedQuery = value3.getBacklog();
                    builder = builder.withBacklog(savedQuery != null && (savedQuery = (SavedQuery)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)savedQuery), null, (int)1, null)) != null && (savedQuery = savedQuery.getEntity()) != null ? (XdSavedQuery)XdExtensionsKt.toXd((Entity)((Entity)savedQuery)) : null);
                }
                $receiver$iv = template.apply(builder).build();
                $receiver$iv$iv = $receiver$iv.getEntity();
                return XodusDatabase.INSTANCE.wrap(Agile.class, $receiver$iv$iv, new Object[0]);
            }
            XdEntity $receiver$iv = template.getAgileBuilder(this.getProjectsForNewAgile()).build();
            Entity $receiver$iv$iv = $receiver$iv.getEntity();
            return XodusDatabase.INSTANCE.wrap(Agile.class, $receiver$iv$iv, new Object[0]);
        }
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)this.getBaseType());
        if (!clazz.isAssignableFrom(actualClazz = POJOKt.sourceClazz((jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)(value2 = (DatabaseEntity)POJOKt.adapt((POJO)((POJO)entity), (Class)clazz)))))) {
            throw (Throwable)new BadRequestException((String)Localization.INSTANCE.getCantCreateEntityOfType().invoke((Object)actualClazz, (Object)clazz));
        }
        DatabaseEntity result2 = (DatabaseEntity)this.create(actualClazz, new Object[0]);
        result2.updateFrom((jetbrains.gap.resource.Entity)value2);
        return result2;
    }

    @Path(value="{id}/clone")
    @POST
    @NotNull
    public final Agile cloneBoard(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.assertUpdateAccess();
        Agile agile2 = (Agile)RestEntityUtilsKt.findById((KClass)Reflection.getOrCreateKotlinClass(Agile.class), (String)id);
        Agile agile3 = agile2;
        if (Intrinsics.areEqual(agile3 != null && (agile3 = agile3.getEntity()) != null && (agile3 = agile3.getPersistentEntity()) != null ? agile3.getType() : null, (Object)"Agile") ^ true) {
            throw (Throwable)new NotFoundException("Agile " + id + " can not be found");
        }
        agile2.assertAccess();
        agile2.assertUpdateAccess();
        AgileCloner agileCloner = this.agileCloner;
        if (agileCloner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agileCloner");
        }
        XdEntity $receiver$iv = agileCloner.clone(agile2.getXdEntity());
        Entity $receiver$iv$iv = $receiver$iv.getEntity();
        return (Agile)XodusDatabase.INSTANCE.wrap(Agile.class, $receiver$iv$iv, new Object[0]);
    }

    private final AgileAccessSettings getAccessSettings(boolean isProjectBased, UserGroup group) {
        UserGroup userGroup;
        return isProjectBased ? AgileAccessSettings.Companion.createProjectBased() : AgileAccessSettings.Companion.createGroupBased((userGroup = group) != null && (userGroup = (UserGroup)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)userGroup), null, (int)1, null)) != null ? userGroup.getXdEntity() : null);
    }

    @NotNull
    public Object getElementResource(@NotNull DatabaseEntity element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return new DelegateBasedSubResourceGetter<DatabaseEntity>(this, element2, (jetbrains.gap.resource.Entity)element2, (RootEntitySequenceResource)this){
            final /* synthetic */ AgileResource this$0;
            final /* synthetic */ DatabaseEntity $element;

            @ReadWriteTransactional
            @NotNull
            public jetbrains.gap.resource.Entity getEntity() {
                return super.getEntity();
            }

            @NotNull
            public Object doGetSubResource(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                if (Intrinsics.areEqual((Object)path, (Object)"issuesGetter")) {
                    DatabaseEntity databaseEntity = this.$element;
                    if (databaseEntity == null) {
                        throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.agile.settings.Agile");
                    }
                    return new AgileIssuesGetterResource((Agile)databaseEntity);
                }
                if (Intrinsics.areEqual((Object)path, (Object)"backlogIssueTree")) {
                    BacklogTreeResource backlogTreeResource;
                    DatabaseEntity databaseEntity = this.$element;
                    if (databaseEntity == null) {
                        throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.agile.settings.Agile");
                    }
                    Agile cfr_ignored_0 = (Agile)databaseEntity;
                    SavedQuery savedQuery = ((Agile)this.$element).getBacklog();
                    if (savedQuery != null) {
                        SavedQuery savedQuery2;
                        SavedQuery it = savedQuery2 = savedQuery;
                        backlogTreeResource = !((Agile)this.$element).getFlatBacklog() ? new AgileBacklogTreeResource((Agile)this.$element) : new FlatBacklogResource((Agile)this.$element);
                    } else {
                        backlogTreeResource = new NullBacklogResource();
                    }
                    return backlogTreeResource;
                }
                if (Intrinsics.areEqual((Object)path, (Object)"backlogSubscription")) {
                    DatabaseEntity databaseEntity = this.$element;
                    if (databaseEntity == null) {
                        throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.agile.settings.Agile");
                    }
                    return new AgileBacklogSubscriptionResource((Agile)databaseEntity);
                }
                return DelegateBasedSubResourceGetter.DefaultImpls.doGetSubResource((DelegateBasedSubResourceGetter)this, (String)path);
            }
            {
                this.this$0 = $outer;
                this.$element = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }

            @Path(value="{path}")
            @NotNull
            public Object getSubResource(@PathParam(value="path") @NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                return DelegateBasedSubResourceGetter.DefaultImpls.getSubResource((DelegateBasedSubResourceGetter)this, (String)path);
            }
        };
    }

    private final List<XdProject> getProjectsForNewAgile() {
        XdUserProfile profile2 = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser().getProfile();
        return profile2.getRelatedProjects();
    }

    public AgileResource() {
        Pair[] pairArray = new Pair[]{};
        Function1 function1 = SecurityFiltersKt.getDefaultSecurityFilter();
        TypeMapping typeMapping = AgileTypeMapping.INSTANCE;
        super(BeansKt.getGapStoreProvider(), pairArray, typeMapping, function1);
    }
}

