/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.templates;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import jetbrains.charisma.customfields.complex.common.XdBundleProjectCustomField;
import jetbrains.charisma.customfields.complex.enumeration.BeansKt;
import jetbrains.charisma.customfields.complex.user.UserFieldType;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototypeKt;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.plugin.XdCustomFieldType;
import jetbrains.charisma.persistent.ProjectBuilder;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.charisma.service.UniqueNameUtilKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumn;
import jetbrains.youtrack.agile.persistence.XdWipLimit;
import jetbrains.youtrack.agile.persistence.builder.BuilderColumn;
import jetbrains.youtrack.agile.templates.AgileField;
import jetbrains.youtrack.agile.templates.AgileProjectBuilder;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.workflow.WorkflowNamesConverter;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import jetbrains.youtrack.workflow.persistence.ScriptExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0018H\u0004J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\t\u001a\u00020\nH\u0004J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0014J\u0018\u0010#\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Ljetbrains/youtrack/agile/templates/AgileProjectBuilder;", "Ljetbrains/charisma/persistent/ProjectBuilder;", "workflowNamesConverter", "Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;", "(Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;)V", "getWorkflowNamesConverter", "()Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;", "attachAssigneeField", "", "project", "Ljetbrains/youtrack/persistent/XdProject;", "attachField", "Ljetbrains/charisma/customfields/complex/common/XdBundleProjectCustomField;", "field", "Ljetbrains/youtrack/agile/templates/AgileField;", "attachWorkflows", "buildProject", "Ljetbrains/exodus/entitystore/Entity;", "createAgileBoards", "createPrototypeWithUniqueName", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "customFieldName", "", "customFieldType", "Ljetbrains/charisma/plugins/CustomFieldType;", "getExistingBoard", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "name", "columns", "", "Ljetbrains/youtrack/agile/persistence/builder/BuilderColumn;", "getPriorityField", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "getWorkflowNames", "", "setDefaultValue", "youtrack-scrumboard"})
public abstract class AgileProjectBuilder
extends ProjectBuilder {
    @NotNull
    private final WorkflowNamesConverter workflowNamesConverter;

    @NotNull
    public Entity buildProject() {
        Entity entity = super.buildProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"super.buildProject()");
        XdProject project2 = (XdProject)XdExtensionsKt.toXd((Entity)entity);
        this.createAgileBoards(project2);
        this.attachAssigneeField(project2);
        this.getPriorityField(project2);
        this.attachWorkflows(project2);
        jetbrains.youtrack.api.statistics.BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription("project-template", ((Object)((Object)this)).getClass().getName()));
        return project2.getEntity();
    }

    protected abstract void createAgileBoards(@NotNull XdProject var1);

    @NotNull
    protected Iterable<String> getWorkflowNames() {
        return CollectionsKt.listOf((Object[])new String[]{"clone-issue", "one-vote-comment", "assignee-visibility-group"});
    }

    @Nullable
    protected final XdProjectCustomField getPriorityField(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Entity entity = jetbrains.charisma.customfields.predefined.BeansKt.getIssuePriority().getPrototypeNullable();
        if (entity == null || (entity = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)entity)) == null) {
            return null;
        }
        Entity priority = entity;
        if (Intrinsics.areEqual((Object)priority.getType(), (Object)BeansKt.getSingleEnumFieldType()) ^ true) {
            return null;
        }
        return priority.findOrCreateProjectCustomField(project2);
    }

    @Nullable
    protected final XdAgile getExistingBoard(@NotNull String name2, @NotNull XdProject project2, @NotNull List<BuilderColumn> columns2) {
        XdAgile xdAgile;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(columns2, (String)"columns");
        XdAgile xdAgile2 = (XdAgile)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdAgile.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdAgile, Unit>(name2){
            final /* synthetic */ String $name;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdAgile it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$name));
            }
            {
                this.$name = string;
                super(2);
            }
        })), (Function2)getExistingBoard.2.INSTANCE));
        if (xdAgile2 != null) {
            XdAgile xdAgile3;
            XdAgile agile2 = xdAgile3 = xdAgile2;
            agile2.getProjects().add((XdEntity)project2);
            int ordinal2 = 0;
            Iterable $receiver$iv = columns2;
            for (Object element$iv : $receiver$iv) {
                BuilderColumn column2 = (BuilderColumn)element$iv;
                XdAgileColumn agileColumn = agile2.getOrCreateColumn(column2.getName());
                int n = ordinal2;
                ordinal2 = n + 1;
                agileColumn.setOrdinal(n);
                if (column2.getMin() == null && column2.getMax() == null) continue;
                agileColumn.setWipLimit((XdWipLimit)XdWipLimit.Companion.new((Function1)new Function1<XdWipLimit, Unit>(column2){
                    final /* synthetic */ BuilderColumn $column;

                    public final void invoke(@NotNull XdWipLimit $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        $receiver.setMax(this.$column.getMax());
                        $receiver.setMin(this.$column.getMin());
                    }
                    {
                        this.$column = builderColumn;
                        super(1);
                    }
                }));
            }
            xdAgile = xdAgile3;
        } else {
            xdAgile = null;
        }
        return xdAgile;
    }

    private final void attachAssigneeField(XdProject project2) {
        Entity assignee;
        Entity entity;
        Entity entity2;
        Entity entity3 = jetbrains.charisma.customfields.predefined.BeansKt.getIssueAssignee().getPrototypeNullable();
        if (entity3 == null || (entity3 = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)entity3)) == null) {
            entity3 = entity2 = (XdCustomFieldPrototype)XdQueryKt.firstOrNull((XdQuery)XdCustomFieldPrototypeKt.getPrototypes((CustomFieldType)((CustomFieldType)jetbrains.charisma.customfields.complex.user.BeansKt.getSingleUserFieldType())));
        }
        if (entity3 == null) {
            entity2 = entity = (XdCustomFieldPrototype)XdQueryKt.firstOrNull((XdQuery)XdCustomFieldPrototypeKt.getPrototypes((CustomFieldType)((CustomFieldType)jetbrains.charisma.customfields.complex.user.BeansKt.getMultiUserFieldType())));
        }
        if (entity2 == null) {
            entity = assignee = jetbrains.charisma.customfields.predefined.BeansKt.getIssueAssignee().getXdPrototype();
        }
        if (!(assignee.getType() instanceof UserFieldType)) {
            assignee = jetbrains.charisma.customfields.complex.user.BeansKt.getSingleUserFieldType().getXdPrototype(UniqueNameUtilKt.generateUniqueName((String)jetbrains.charisma.customfields.predefined.BeansKt.getIssueAssignee().getNonLocalizedFieldName(), (String)('_' + project2.getShortName()), (Function1)attachAssigneeField.1.INSTANCE));
        }
        assignee.findOrCreateProjectCustomField(project2);
    }

    private final void attachWorkflows(XdProject project2) {
        Iterable<String> $receiver$iv = this.getWorkflowNames();
        Iterator<String> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            String oldName;
            String element$iv;
            String it = element$iv = iterator2.next();
            String string = this.workflowNamesConverter.getFullNewName(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"workflowNamesConverter.getFullNewName(it)");
            XdScriptPackage workflow = XdScriptPackage.Companion.find(string);
            if (workflow == null && (oldName = this.workflowNamesConverter.getFullOldName(it)) != null) {
                workflow = XdScriptPackage.Companion.find(oldName);
            }
            if (workflow == null) continue;
            ScriptExtensionsKt.attach((XdScriptPackage)workflow, (XdProject)project2);
        }
    }

    @NotNull
    protected final XdCustomFieldPrototype createPrototypeWithUniqueName(@NotNull XdProject project2, @NotNull String customFieldName, @NotNull CustomFieldType<?, ?> customFieldType) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)customFieldName, (String)"customFieldName");
        Intrinsics.checkParameterIsNotNull(customFieldType, (String)"customFieldType");
        String actualName2 = UniqueNameUtilKt.generateUniqueName((String)customFieldName, (String)('_' + project2.getShortName()), (Function1)((Function1)new Function1<String, Boolean>(customFieldType){
            final /* synthetic */ CustomFieldType $customFieldType;

            public final boolean invoke(@Nullable String it) {
                boolean bl;
                String string = it;
                XdCustomFieldPrototype.Companion companion = XdCustomFieldPrototype.Companion;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                XdCustomFieldPrototype prototype = companion.findPrototype(string3);
                if (prototype == null) {
                    bl = true;
                } else {
                    XdCustomFieldType type = prototype.getType();
                    bl = Intrinsics.areEqual((Object)type, (Object)this.$customFieldType);
                }
                return bl;
            }
            {
                this.$customFieldType = customFieldType;
                super(1);
            }
        }));
        XdCustomFieldPrototype xdCustomFieldPrototype = XdCustomFieldPrototype.Companion.findPrototype(actualName2);
        if (xdCustomFieldPrototype == null) {
            Entity entity = customFieldType.getPrototype(actualName2);
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"customFieldType.getPrototype(actualName)");
            xdCustomFieldPrototype = (XdCustomFieldPrototype)XdExtensionsKt.toXd((Entity)entity);
        }
        return xdCustomFieldPrototype;
    }

    @NotNull
    protected final XdBundleProjectCustomField attachField(@NotNull XdProject project2, @NotNull AgileField<?> field2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(field2, (String)"field");
        XdCustomFieldPrototype prototype = this.createPrototypeWithUniqueName(project2, field2.getFieldName(), field2.getFieldType());
        XdProjectCustomField pcf = prototype.getProjectCustomField(project2);
        if (pcf != null) {
            return (XdBundleProjectCustomField)pcf;
        }
        XdBundleProjectCustomField newProjectField = XdBundleProjectCustomField.Companion.new$default((XdBundleProjectCustomField.Companion)XdBundleProjectCustomField.Companion, (XdCustomFieldPrototype)prototype, (XdProject)project2, null, (int)4, null);
        newProjectField.setBundle(field2.createBundle(project2.getName() + prototype.getName() + UUID.randomUUID().toString()));
        String name2 = field2.getDefaultValueName();
        this.setDefaultValue(newProjectField, name2);
        return newProjectField;
    }

    protected final void setDefaultValue(@NotNull XdBundleProjectCustomField field2, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        XdField defaultValue = (XdField)field2.getBundle().findElement(name2);
        if (defaultValue != null) {
            field2.getDefaultValues().clear();
            field2.getDefaultValues().add((XdEntity)defaultValue);
            field2.setCanBeEmpty(false);
        }
    }

    @NotNull
    protected final WorkflowNamesConverter getWorkflowNamesConverter() {
        return this.workflowNamesConverter;
    }

    public AgileProjectBuilder(@NotNull WorkflowNamesConverter workflowNamesConverter) {
        Intrinsics.checkParameterIsNotNull((Object)workflowNamesConverter, (String)"workflowNamesConverter");
        this.workflowNamesConverter = workflowNamesConverter;
    }
}

