/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.date;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.smartui.parser.date.AbstractDatePeriod;
import jetbrains.charisma.timeTracking.TimeTrackingProvider;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.dates.DateFormats;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public abstract class NamedDatePeriod
extends AbstractDatePeriod
implements Comparable<NamedDatePeriod> {
    private static final List<NamedDatePeriod> PERIODS = ListSequence.fromList(new ArrayList());
    private static int counter = 0;
    public static final NamedDatePeriod TODAY = new DayPeriod("youtrack.dateperiod.today"){

        @Override
        protected DateTime getDay() {
            return AbstractDatePeriod.getNowInCurrentUserTimeZone();
        }
    };
    public static final NamedDatePeriod YESTERDAY = new DayPeriod("youtrack.dateperiod.yesterday"){

        @Override
        protected DateTime getDay() {
            return AbstractDatePeriod.getNowInCurrentUserTimeZone().minusDays(1);
        }
    };
    public static final NamedDatePeriod SATURDAY = new DayOfWeekPeriod("youtrack.dateperiod.saturday", 6);
    public static final NamedDatePeriod FRIDAY = new DayOfWeekPeriod("youtrack.dateperiod.friday", 5);
    public static final NamedDatePeriod THURSDAY = new DayOfWeekPeriod("youtrack.dateperiod.thursday", 4);
    public static final NamedDatePeriod WEDNESDAY = new DayOfWeekPeriod("youtrack.dateperiod.wednesday", 3);
    public static final NamedDatePeriod TUESDAY = new DayOfWeekPeriod("youtrack.dateperiod.tuesday", 2);
    public static final NamedDatePeriod MONDAY = new DayOfWeekPeriod("youtrack.dateperiod.monday", 1);
    public static final NamedDatePeriod SUNDAY = new DayOfWeekPeriod("youtrack.dateperiod.sunday", 7);
    public static final NamedDatePeriod THIS_WEEK = new WeekPeriod("youtrack.dateperiod.this_week", 0);
    public static final NamedDatePeriod LAST_WEEK = new WeekPeriod("youtrack.dateperiod.last_week", 1);
    public static final NamedDatePeriod TWO_WEEKS_AGO = new WeekPeriod("youtrack.dateperiod.two_weeks_ago", 2);
    public static final NamedDatePeriod THREE_WEEKS_AGO = new WeekPeriod("youtrack.dateperiod.three_weeks_ago", 3);
    public static final NamedDatePeriod THIS_MONTH = new MonthPeriod("youtrack.dateperiod.this_month", 0);
    public static final NamedDatePeriod LAST_MONTH = new MonthPeriod("youtrack.dateperiod.last_month", 1);
    public static final NamedDatePeriod OLDER = new MonthPeriod("youtrack.dateperiod.older", 2){

        @Override
        public Long getFrom() {
            return null;
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("NamedDatePeriod.Before_{0}", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.getTo(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())});
        }
    };
    public static final NamedDatePeriod THIS_YEAR = new YearPeriod(0);
    public static final NamedDatePeriod LAST_YEAR = new YearPeriod(1);
    public static final NamedDatePeriod LAST_WORKING_DAY = new DayPeriod("youtrack.dateperiod.last_working_day"){

        @Override
        protected DateTime getDay() {
            return ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).getLastWorkingDay();
        }
    };
    private String localizationId;
    private int ordinal;

    public NamedDatePeriod(String localizationId) {
        this.localizationId = localizationId;
        this.ordinal = counter++;
        ListSequence.fromList(PERIODS).addElement((Object)this);
    }

    public NamedDatePeriod() {
    }

    @Override
    public int compareTo(NamedDatePeriod period) {
        return this.ordinal - period.ordinal;
    }

    public String getName(TimeZone zone) {
        return this.getNameInLocale(ApplicationMetaDataImpl.getLocale());
    }

    public String getNameInLocale(Locale locale) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale(this.localizationId, locale, new Object[0]);
    }

    public static Iterable<NamedDatePeriod> getPeriods() {
        return PERIODS;
    }

    public static Iterable<NamedDatePeriod> getFilterPeriods() {
        IListSequence periods = ListSequence.fromList(new ArrayList());
        DateTime n = new DateTime(DateTimeZone.UTC);
        ListSequence.fromList((List)periods).addElement((Object)TODAY);
        ListSequence.fromList((List)periods).addElement((Object)YESTERDAY);
        int dayOfWeek = n.getDayOfWeek();
        if (dayOfWeek >= 6) {
            ListSequence.fromList((List)periods).addElement((Object)THURSDAY);
        }
        if (dayOfWeek >= 5) {
            ListSequence.fromList((List)periods).addElement((Object)WEDNESDAY);
        }
        if (dayOfWeek >= 4) {
            ListSequence.fromList((List)periods).addElement((Object)TUESDAY);
        }
        if (dayOfWeek >= 3) {
            ListSequence.fromList((List)periods).addElement((Object)MONDAY);
        }
        if (dayOfWeek >= 2) {
            ListSequence.fromList((List)periods).addElement((Object)SUNDAY);
        }
        ListSequence.fromList((List)periods).addElement((Object)LAST_WEEK);
        ListSequence.fromList((List)periods).addElement((Object)THIS_MONTH);
        ListSequence.fromList((List)periods).addElement((Object)LAST_MONTH);
        ListSequence.fromList((List)periods).addElement((Object)OLDER);
        return periods;
    }

    private static class MonthPeriod
    extends NamedDatePeriod {
        private int ago;

        public MonthPeriod(String name, int ago) {
            super(name);
            this.ago = ago;
        }

        public Long getFrom() {
            return DateTimeOperations.convert((DateTime)this.getMonth().dayOfMonth().withMinimumValue().millisOfDay().withMinimumValue());
        }

        public Long getTo() {
            return DateTimeOperations.convert((DateTime)this.getMonth().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
        }

        public DateTime getReferenceDate() {
            return this.getMonth().withDayOfMonth(1).withTimeAtStartOfDay();
        }

        private DateTime getMonth() {
            return MonthPeriod.getNowInCurrentUserTimeZone().minusMonths(this.ago);
        }

        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("NamedDatePeriod.Period_from_{0}_to_{1}_for_month_period", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.getFrom(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale()), DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.getTo(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())});
        }
    }

    public static class YearPeriod
    extends NamedDatePeriod {
        private int ago;

        public YearPeriod(int ago) {
            this.ago = ago;
        }

        public String getDescription() {
            return "does not matter";
        }

        public Long getFrom() {
            return DateTimeOperations.convert((DateTime)this.getYear().dayOfYear().withMinimumValue().millisOfDay().withMinimumValue());
        }

        public Long getTo() {
            return DateTimeOperations.convert((DateTime)this.getYear().dayOfYear().withMaximumValue().millisOfDay().withMaximumValue());
        }

        public DateTime getReferenceDate() {
            return this.getYear().withDayOfYear(1).withTimeAtStartOfDay();
        }

        private DateTime getYear() {
            return YearPeriod.getNowInCurrentUserTimeZone().minusYears(this.ago);
        }
    }

    private static class WeekPeriod
    extends NamedDatePeriod {
        private int ago;

        public WeekPeriod(String name, int ago) {
            super(name);
            this.ago = ago;
        }

        public Long getFrom() {
            return DateTimeOperations.convert((DateTime)this.getWeek().dayOfWeek().withMinimumValue().millisOfDay().withMinimumValue());
        }

        public Long getTo() {
            return DateTimeOperations.convert((DateTime)this.getWeek().dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue());
        }

        public DateTime getReferenceDate() {
            return this.getWeek().withDayOfWeek(1).withTimeAtStartOfDay();
        }

        private DateTime getWeek() {
            return AbstractDatePeriod.getNowInCurrentUserTimeZone().minusWeeks(this.ago);
        }

        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("NamedDatePeriod.Period_from_{0}_to_{1}_for_week_period", new Object[]{DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.getFrom(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale()), DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.getTo(), (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())});
        }
    }

    private static class DayOfWeekPeriod
    extends DayPeriod {
        private int dayOfWeek;

        public DayOfWeekPeriod(String name, int dayOfWeek) {
            super(name);
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        protected DateTime getDay() {
            return DayOfWeekPeriod.getNowInCurrentUserTimeZone().withDayOfWeek(this.dayOfWeek);
        }
    }

    private static abstract class DayPeriod
    extends NamedDatePeriod {
        public DayPeriod(String name) {
            super(name);
        }

        public Long getFrom() {
            return DateTimeOperations.convert((DateTime)this.getDay().millisOfDay().withMinimumValue());
        }

        public Long getTo() {
            return DateTimeOperations.convert((DateTime)this.getDay().millisOfDay().withMaximumValue());
        }

        public DateTime getReferenceDate() {
            return this.getDay();
        }

        protected abstract DateTime getDay();

        public String getDescription() {
            DateTime time = this.getDay();
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("NamedDatePeriod.{0}_from_00_00_to_23_59", new Object[]{DateTimeOperations.print((DateTime)time, (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("humanDate"), (Locale)((Localizer)ServiceLocator.getBean((String)"localizer")).getLocale())});
        }
    }
}

