/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.keyword;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.lexer.CharIterable;
import jetbrains.mps.parser.runtime.prefixTree.IPredicate;
import jetbrains.mps.parser.runtime.prefixTree.Node;
import jetbrains.mps.parser.runtime.prefixTree.PrefixCollection;
import jetbrains.mps.parser.runtime.prefixTree.PrefixIterable;
import jetbrains.youtrack.api.parser.IPrefixTreeCreator;
import jetbrains.youtrack.api.parser.IPrefixTreeInstaller;
import jetbrains.youtrack.api.parser.IPrefixTrees;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.api.parser.TreeKeyLocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrefixTrees
implements IPrefixTrees {
    private static final long LOCK_TIMEOUT = Long.getLong("jetbrains.youtrack.prefixTrees.lockTimeOut", 60000L);
    protected static Log log = LogFactory.getLog(PrefixTrees.class);
    private Map<String, PrefixIterable> prefixTrees = MapSequence.fromMap(new HashMap());
    private ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private ConcurrentHashMap<String, ReadWriteLock> treelocks = new ConcurrentHashMap();
    private final List<String>[] aloneFilterTreeKeys = new List[4];
    private final List<String>[] filterTreeKeys = new List[4];
    private final Map<String, Comparator> comparators = MapSequence.fromMap(new HashMap());
    private volatile boolean inited;
    private List<IPrefixTreeCreator> myCreators;
    private List<IPrefixTreeInstaller> myInstallers;

    public void init() {
        this.writeWith(this.globalLock.writeLock(), new _FunctionTypes._return_P0_E0<Object>(){

            public Object invoke() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create keywords index");
                }
                long t1 = System.currentTimeMillis();
                for (IPrefixTreeCreator creator : ListSequence.fromList((List)PrefixTrees.this.getCreators()).sort((_FunctionTypes._return_P1_E0)new ISelector<IPrefixTreeCreator, Comparable<?>>(){

                    public Comparable<?> select(IPrefixTreeCreator it) {
                        return it.getOrdinal();
                    }
                }, true)) {
                    creator.addPrefixTreeTo((IPrefixTrees)PrefixTrees.this);
                }
                PrefixTrees.this.inited = true;
                for (IPrefixTreeInstaller installer : ListSequence.fromList((List)PrefixTrees.this.getInstallers()).sort((_FunctionTypes._return_P1_E0)new ISelector<IPrefixTreeInstaller, Comparable<?>>(){

                    public Comparable<?> select(IPrefixTreeInstaller it) {
                        return it.getName();
                    }
                }, true)) {
                    installer.install();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finish creating keyword index in [" + (System.currentTimeMillis() - t1) + " ms]"));
                }
                for (IMapping pairs : MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Tree " + (String)pairs.key() + " contains " + ((PrefixIterable)pairs.value()).getNodesCount() + " nodes"));
                }
                return null;
            }
        });
    }

    public boolean isInited() {
        return this.inited;
    }

    public <T> T read(_FunctionTypes._return_P1_E0<? extends T, ? super IPrefixTreesData> read) {
        return (T)read.invoke((Object)new Data());
    }

    public <T> T read(final String treeKey, final _FunctionTypes._return_P1_E0<? extends T, ? super PrefixIterable> read) {
        return this.readWith(this.globalLock.readLock(), new _FunctionTypes._return_P0_E0<T>(){

            public T invoke() {
                return read.invoke(MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees).get((Object)treeKey));
            }
        });
    }

    public void putTree(final String key, final PrefixIterable tree, final TreeKeyLocation putToAloneFilterTrees, final TreeKeyLocation putToFilterTrees, final Comparator comparator) {
        this.writeWith(this.globalLock.writeLock(), new _FunctionTypes._return_P0_E0<Object>(){

            public Object invoke() {
                MapSequence.fromMap((Map)PrefixTrees.this.treelocks).put((Object)key, (Object)new ReentrantReadWriteLock());
                PrefixTrees.this.putTreeLockless(key, tree, putToAloneFilterTrees, putToFilterTrees, comparator);
                return null;
            }
        });
    }

    public boolean hasTree(final String treeKey) {
        return this.readWith(this.globalLock.readLock(), new _FunctionTypes._return_P0_E0<Boolean>(){

            public Boolean invoke() {
                return MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees).containsKey((Object)treeKey);
            }
        });
    }

    public <T> Iterable<T> removePrefixes(final String treeKey, final CharIterable key, final IPredicate<T> predicate) {
        if (this.inited) {
            return (Iterable)this.writeWith(((ReadWriteLock)MapSequence.fromMap(this.treelocks).get((Object)treeKey)).writeLock(), new _FunctionTypes._return_P0_E0<Iterable<T>>(){

                public Iterable<T> invoke() {
                    return ((PrefixCollection)PrefixTrees.as_pdldhd_a0a0a0a0b0a0a0g(MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees).get((Object)treeKey), PrefixCollection.class)).removeValues(key, predicate);
                }
            });
        }
        return Sequence.fromIterable(Collections.emptyList());
    }

    public <T> void putPrefix(final String treeKey, final CharIterable key, final T value) {
        if (this.inited) {
            this.writeWith(((ReadWriteLock)MapSequence.fromMap(this.treelocks).get((Object)treeKey)).writeLock(), new _FunctionTypes._return_P0_E0<Node>(){

                public Node invoke() {
                    return ((PrefixCollection)PrefixTrees.as_pdldhd_a0a0a0a0b0a0a0h(MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees).get((Object)treeKey), PrefixCollection.class)).addValue(key, value);
                }
            });
        }
    }

    private void putTreeLockless(String key, PrefixIterable tree, TreeKeyLocation putToAloneFilterTrees, TreeKeyLocation putToFilterTrees, Comparator comparator) {
        this.putToTreeKeys(key, this.aloneFilterTreeKeys, putToAloneFilterTrees);
        this.putToTreeKeys(key, this.filterTreeKeys, putToFilterTrees);
        if (comparator != null) {
            MapSequence.fromMap(this.comparators).put((Object)key, (Object)comparator);
        }
        MapSequence.fromMap(this.prefixTrees).put((Object)key, (Object)tree);
    }

    private void putToTreeKeys(String key, List<String>[] treeKeys, TreeKeyLocation location) {
        int index = location.getIndex();
        if (index < 0) {
            return;
        }
        if (treeKeys[index] == null) {
            treeKeys[index] = ListSequence.fromList(new ArrayList());
        }
        ListSequence.fromList(treeKeys[index]).addElement((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readWith(Lock lock, _FunctionTypes._return_P0_E0<? extends T> read) {
        try {
            if (!lock.tryLock(LOCK_TIMEOUT, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Prefix tree lock timeout exceeded (" + LOCK_TIMEOUT + ")");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        Object result = null;
        try {
            result = read.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T writeWith(Lock lock, _FunctionTypes._return_P0_E0<? extends T> write) {
        lock.lock();
        Object result = null;
        try {
            result = write.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)result;
    }

    private List<IPrefixTreeCreator> getCreators() {
        return this.myCreators;
    }

    public void setCreators(List<IPrefixTreeCreator> value) {
        this.myCreators = value;
    }

    private List<IPrefixTreeInstaller> getInstallers() {
        return this.myInstallers;
    }

    public void setInstallers(List<IPrefixTreeInstaller> value) {
        this.myInstallers = value;
    }

    private static <T> T as_pdldhd_a0a0a0a0b0a0a0g(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_pdldhd_a0a0a0a0b0a0a0h(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private class Data
    implements IPrefixTreesData {
        private Data() {
        }

        public PrefixIterable getTree(final String treeKey) {
            return (PrefixIterable)PrefixTrees.this.readWith(((ReadWriteLock)MapSequence.fromMap((Map)PrefixTrees.this.treelocks).get((Object)treeKey)).readLock(), (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<PrefixIterable>(){

                public PrefixIterable invoke() {
                    return (PrefixIterable)MapSequence.fromMap((Map)PrefixTrees.this.prefixTrees).get((Object)treeKey);
                }
            });
        }

        public Map<String, PrefixIterable> getPrefixGarden() {
            return (Map)PrefixTrees.this.readWith(PrefixTrees.this.globalLock.readLock(), (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Map<String, PrefixIterable>>(){

                public Map<String, PrefixIterable> invoke() {
                    return PrefixTrees.this.prefixTrees;
                }
            });
        }

        public Iterable<String> getAloneValueTreeKeys() {
            return (Iterable)PrefixTrees.this.readWith(PrefixTrees.this.globalLock.readLock(), (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<IListSequence<String>>(){

                public IListSequence<String> invoke() {
                    return Sequence.fromIterable((Iterable)ListSequence.fromList((List)PrefixTrees.this.aloneFilterTreeKeys[0]).concat((ISequence)ListSequence.fromList((List)PrefixTrees.this.aloneFilterTreeKeys[1]))).concat(ListSequence.fromList((List)PrefixTrees.this.aloneFilterTreeKeys[2]).concat((ISequence)ListSequence.fromList((List)PrefixTrees.this.aloneFilterTreeKeys[3]))).toListSequence();
                }
            });
        }

        public Iterable<String> getFilterTreeKeys() {
            return (Iterable)PrefixTrees.this.readWith(PrefixTrees.this.globalLock.readLock(), (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<IListSequence<String>>(){

                public IListSequence<String> invoke() {
                    return Sequence.fromIterable((Iterable)ListSequence.fromList((List)PrefixTrees.this.filterTreeKeys[0]).concat((ISequence)ListSequence.fromList((List)PrefixTrees.this.filterTreeKeys[1]))).concat(ListSequence.fromList((List)PrefixTrees.this.filterTreeKeys[2]).concat((ISequence)ListSequence.fromList((List)PrefixTrees.this.filterTreeKeys[3]))).toListSequence();
                }
            });
        }

        public <T> Iterable<T> sort(final String treeKey, Iterable<T> values) {
            final Wrappers._T _values = new Wrappers._T(values);
            return (Iterable)PrefixTrees.this.readWith(((ReadWriteLock)PrefixTrees.this.treelocks.get(treeKey)).readLock(), new _FunctionTypes._return_P0_E0<Iterable<T>>(){

                public Iterable<T> invoke() {
                    if (MapSequence.fromMap((Map)PrefixTrees.this.comparators).containsKey((Object)treeKey)) {
                        _values.value = Sequence.fromIterable((Iterable)((Iterable)_values.value)).sort((Comparator)MapSequence.fromMap((Map)PrefixTrees.this.comparators).get((Object)treeKey), true);
                    }
                    return (Iterable)_values.value;
                }
            });
        }

        public <T> T min(final String treeKey, final Iterable<T> values) {
            return (T)PrefixTrees.this.readWith(((ReadWriteLock)PrefixTrees.this.treelocks.get(treeKey)).readLock(), new _FunctionTypes._return_P0_E0<T>(){

                public T invoke() {
                    if (MapSequence.fromMap((Map)PrefixTrees.this.comparators).containsKey((Object)treeKey)) {
                        Comparator comparator = (Comparator)MapSequence.fromMap((Map)PrefixTrees.this.comparators).get((Object)treeKey);
                        Object res = null;
                        for (Object value : Sequence.fromIterable((Iterable)values)) {
                            if (res != null && comparator.compare(value, res) >= 0) continue;
                            res = value;
                        }
                        return res;
                    }
                    return Sequence.fromIterable((Iterable)values).first();
                }
            });
        }
    }
}

