/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistent.IProjectFieldValue;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.SearchRequestParser;

public class AstUtil {
    public static Iterable<ASTNode> getSearchRequestPartWithoutDifferentProject(ASTNode searchRequest, final Entity project) {
        ISequence nodes = ASTUtilExtensions.getTerms(searchRequest);
        nodes = Sequence.fromIterable(nodes).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return AstUtil.checkTermSuitesProject(it, project);
            }
        });
        return Sequence.fromIterable((Iterable)nodes).select((_FunctionTypes._return_P1_E0)new ISelector<ASTNode, ASTNode>(){

            public ASTNode select(ASTNode it) {
                ASTNode result = ASTUtilExtensions.toSingleTermSearchRequest(it);
                return result;
            }
        });
    }

    private static boolean checkTermSuitesProject(ASTNode search, Entity project) {
        IFieldValue value;
        ISetSequence pos = SetSequence.fromSet(new HashSet());
        ISetSequence neg = SetSequence.fromSet(new HashSet());
        for (ASTNode categoryValue : Sequence.fromIterable((Iterable)search.descendants(new ASTType[]{CategoryParser.CATEGORY_VALUE}))) {
            List<IFieldValue> values = ((CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categoryValue, (String)"leftValue")).first())).fieldValues;
            for (IFieldValue value2 : ListSequence.fromList(values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<IFieldValue>(){

                public boolean accept(IFieldValue it) {
                    return it instanceof IProjectFieldValue;
                }
            })) {
                Entity p = ((IProjectFieldValue)value2).getProject();
                if (((CategoryParser.CategoryValueASTNode)categoryValue).pos) {
                    SetSequence.fromSet((Set)pos).addElement((Object)p);
                    continue;
                }
                SetSequence.fromSet((Set)neg).addElement((Object)p);
            }
        }
        for (ASTNode termItem : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)search, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"positiveAlone")).isNotEmpty();
            }
        })) {
            value = (IFieldValue)Sequence.fromIterable(((SearchRequestParser.AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"positiveAlone"), (String)"value")).first())).filterValues).first();
            if (!(value instanceof IProjectFieldValue)) continue;
            SetSequence.fromSet((Set)pos).addElement((Object)((IProjectFieldValue)value).getProject());
        }
        for (ASTNode termItem : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)search, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"negativeAlone")).isNotEmpty();
            }
        })) {
            value = (IFieldValue)Sequence.fromIterable(((SearchRequestParser.AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"negativeAlone"), (String)"value")).first())).filterValues).first();
            if (!(value instanceof IProjectFieldValue)) continue;
            SetSequence.fromSet((Set)neg).addElement((Object)((IProjectFieldValue)value).getProject());
        }
        if (QueryOperations.contains((Iterable)neg, (Entity)project)) {
            return false;
        }
        SetSequence.fromSet((Set)pos).removeSequence((ISequence)SetSequence.fromSet((Set)neg));
        return QueryOperations.isEmpty((Iterable)pos) || QueryOperations.contains((Iterable)pos, (Entity)project);
    }
}

