/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.TextParser;

public class ComplexityAnalyzer {
    public static boolean isComplexRequest(ASTNode _this) {
        return ComplexityAnalyzer.isComplexNode(_this);
    }

    private static <T extends ASTNode> boolean isComplexSequence(Iterable<T> _this) {
        switch (Sequence.fromIterable(_this).count()) {
            case 0: {
                return false;
            }
            case 1: {
                return ComplexityAnalyzer.isComplexNode((ASTNode)Sequence.fromIterable(_this).first());
            }
        }
        return true;
    }

    private static boolean isComplexNode(ASTNode _this) {
        ASTNode _calculatedNode = _this;
        if (_calculatedNode.hasType(SearchRequestParser.SEARCH_REQUEST)) {
            ASTNode searchRequest = _calculatedNode;
            return ComplexityAnalyzer.isComplexSequence(ASTUtilExtensions.getTerms(searchRequest));
        }
        if (_calculatedNode.hasType(SearchRequestParser.TERM)) {
            ASTNode term = _calculatedNode;
            return ComplexityAnalyzer.isComplexSequence(ASTNode.getChildren((ASTNode)term, (String)"item"));
        }
        if (_calculatedNode.hasType(SearchRequestParser.TERM_ITEM)) {
            ASTNode termItem = _calculatedNode;
            return ComplexityAnalyzer.isComplexTermItem(termItem);
        }
        ASTNode any = _calculatedNode;
        return false;
    }

    private static boolean isComplexTermItem(ASTNode _this) {
        ASTNode _calculatedNode = (ASTNode)Sequence.fromIterable((Iterable)_this.children(new ASTType[0])).first();
        if (_calculatedNode.hasType(TextParser.QUOTED_TEXT)) {
            TextParser.QuotedTextASTNode quotedText = (TextParser.QuotedTextASTNode)_calculatedNode;
            return true;
        }
        if (_calculatedNode.hasType(TextParser.NEGATIVE_TEXT)) {
            ASTNode negativeText = _calculatedNode;
            return true;
        }
        if (_calculatedNode.hasType(SearchRequestParser.POSITIVE_ALONE_VALUE)) {
            ASTNode positiveAloneValue = _calculatedNode;
            return false;
        }
        if (_calculatedNode.hasType(SearchRequestParser.NEGATIVE_ALONE_VALUE)) {
            ASTNode negativeAloneValue = _calculatedNode;
            return false;
        }
        if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
            ASTNode categorized = _calculatedNode;
            return true;
        }
        if (_calculatedNode.hasType(SearchRequestParser.ISSUE)) {
            SearchRequestParser.IssueASTNode issue = (SearchRequestParser.IssueASTNode)_calculatedNode;
            return true;
        }
        if (_calculatedNode.hasType(TextParser.TEXT)) {
            TextParser.TextASTNode text = (TextParser.TextASTNode)_calculatedNode;
            return true;
        }
        ASTNode other = _calculatedNode;
        return false;
    }
}

