/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import jetbrains.youtrack.textindex.TextIndexOperationsCompat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IssuesSearchRequestExecutor
extends SearchRequestExecutor<Iterable<Entity>> {
    private final Set<EntityId> positiveProjects = new HashSetDecorator();

    @Override
    @Nullable
    protected Iterable<Entity> filterContextIssueFolder(@NotNull Entity folder, @NotNull IContext context, Entity me) {
        return IssueFolderUtil.getOrderedIssuesProvider((Entity)folder).getIssues(me, context, false, false);
    }

    @Override
    protected Iterable<Entity> hasField(IField field, boolean nodeIsPos) {
        return field.filterHasField(this.context, this.me);
    }

    @Override
    protected Iterable<Entity> getValue(IField field, IFieldValue value, boolean nodeIsPos) {
        return field.filter(value, this.context, this.me);
    }

    @Override
    protected Iterable<Entity> getRangeValue(IField field, List<IFieldValue> leftValue, List<IFieldValue> rightValue, boolean nodeIsPos, _FunctionTypes._void_P1_E0<? super Integer> assertMaxValues) {
        return field.getIssueRange(leftValue, rightValue, this.context, this.me, assertMaxValues);
    }

    @Override
    @NotNull
    protected Iterable<Entity> filterText(boolean pos, String text) {
        return IssuesSearchRequestExecutor.fullTextSearch(pos, text);
    }

    @Override
    protected Iterable<Entity> and(@NotNull Iterable<Entity> left, @NotNull Iterable<Entity> right) {
        return QueryOperations.intersect(left, right);
    }

    @Override
    protected Iterable<Entity> or(@NotNull Iterable<Entity> left, @NotNull Iterable<Entity> right) {
        return QueryOperations.union(left, right);
    }

    @Override
    @NotNull
    protected Iterable<Entity> merge() {
        Iterable result = null;
        for (Iterable p : Sequence.fromIterable((Iterable)MapSequence.fromMap((Map)this.pos).values())) {
            this.considerPositiveProject(p);
            if (result == null) {
                result = p;
                continue;
            }
            result = QueryOperations.intersect((Iterable)result, (Iterable)p);
        }
        for (Iterable n : Sequence.fromIterable((Iterable)MapSequence.fromMap((Map)this.neg).values())) {
            if (result == null) {
                result = QueryOperations.queryGetAll((String)"Issue");
            }
            result = QueryOperations.exclude((Iterable)result, (Iterable)n);
        }
        return result != null ? result : QueryOperations.queryGetAll((String)"Issue");
    }

    private void considerPositiveProject(Iterable<Entity> p) {
        if (p instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable tkei = (TreeKeepingEntityIterable)p;
            NodeBase tree = tkei.getTree();
            this.considerPositiveProjectNode(tree);
        }
    }

    private void considerPositiveProjectNode(NodeBase tree) {
        LinkEqual link;
        if (tree instanceof LinkEqual && IssuesSearchRequestExecutor.eq_1ksneo_a0b0a0j((link = (LinkEqual)tree).getName(), "project")) {
            this.positiveProjects.add(link.getToId());
        }
        if (tree instanceof And) {
            And operator = (And)tree;
            this.considerPositiveProjectNode(operator.getLeft());
            this.considerPositiveProjectNode(operator.getRight());
        }
    }

    @Override
    @NotNull
    protected Iterable<Entity> empty() {
        return QueryOperations.empty((String)"Issue");
    }

    public Set<EntityId> getPositiveProjectIds() {
        return this.positiveProjects;
    }

    public static Iterable<Entity> fullTextSearch(boolean pos, String text) {
        Iterable matchingIssues = TextIndexOperationsCompat.getTextIndexManager().findIssues((Iterable)QueryOperations.queryGetAll((String)"Issue"), text);
        return pos ? matchingIssues : QueryOperations.exclude((Iterable)QueryOperations.queryGetAll((String)"Issue"), (Iterable)matchingIssues);
    }

    private static boolean eq_1ksneo_a0b0a0j(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

