/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import jetbrains.youtrack.textindex.TextIndexManagerCompat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MatchesSearchRequestExecutor
extends SearchRequestExecutor<Boolean> {
    private Entity issue;

    public MatchesSearchRequestExecutor(Entity issue) {
        this.issue = issue;
    }

    @Override
    protected Boolean hasField(IField field, boolean nodeIsPos) {
        return field.matchesHasField(this.issue, this.context, this.me);
    }

    @Override
    @Nullable
    protected Boolean filterContextIssueFolder(@NotNull Entity folder, @NotNull IContext context, Entity me) {
        return ((Parser)ServiceLocator.getBean((String)"parser")).parse(null, IssueFolderUtil.getOrderedIssuesProvider((Entity)folder).getQuery(), context).matchesIssue(this.issue, context, me);
    }

    @Override
    protected Boolean getValue(IField field, IFieldValue value, boolean nodeIsPos) {
        return field.matchesIssue(this.issue, value, this.context, this.me);
    }

    @Override
    protected Boolean getRangeValue(IField field, List<IFieldValue> leftValues, List<IFieldValue> rightValues, boolean nodeIsPos, _FunctionTypes._void_P1_E0<? super Integer> assertMaxValues) {
        Boolean issues = null;
        int values = 0;
        for (IFieldValue leftValue : ListSequence.fromList(leftValues)) {
            for (IFieldValue rightValue : ListSequence.fromList(rightValues)) {
                assertMaxValues.invoke((Object)(++values));
                issues = this.union(issues, field.matchesIssueRange(this.issue, leftValue, rightValue, this.context, this.me));
            }
        }
        return issues;
    }

    @Override
    @NotNull
    protected Boolean filterText(boolean pos, String text) {
        return pos == ((TextIndexManagerCompat)ServiceLocator.getBean((String)"textIndexManager")).matchesQuery(this.issue, text);
    }

    @Override
    protected Boolean and(@NotNull Boolean left, @NotNull Boolean right) {
        return left != false && right != false;
    }

    @Override
    protected Boolean or(@NotNull Boolean left, @NotNull Boolean right) {
        return left != false || right != false;
    }

    @Override
    @NotNull
    protected Boolean merge() {
        boolean result = true;
        for (String filterGroup : SetSequence.fromSet((Set)MapSequence.fromMap((Map)this.pos).keySet()).union((ISequence)SetSequence.fromSet((Set)MapSequence.fromMap((Map)this.neg).keySet()))) {
            boolean p = !MapSequence.fromMap((Map)this.pos).containsKey((Object)filterGroup) || (Boolean)MapSequence.fromMap((Map)this.pos).get((Object)filterGroup) != false;
            boolean n = MapSequence.fromMap((Map)this.neg).containsKey((Object)filterGroup) && (Boolean)MapSequence.fromMap((Map)this.neg).get((Object)filterGroup) != false;
            result = result && p && !n;
        }
        return result;
    }

    @Override
    @NotNull
    protected Boolean empty() {
        return false;
    }
}

