/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.parser.filterCreator.IMyFieldValue;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.MeUserAnalyzer;
import jetbrains.charisma.smartui.parser.search.MeUserData;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.CategoryType;
import jetbrains.youtrack.search.parser.ParseResult;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import org.jetbrains.annotations.NotNull;

public class MeUserAnalyzerImpl
implements MeUserAnalyzer {
    private static final NoMeUserData NO_ME_USER_DATA = new NoMeUserData();

    @NotNull
    public MeUserData getMeData(IParseResult parseResult, Entity issue) {
        if (parseResult instanceof ParseResult) {
            ASTNode term = ASTUtilExtensions.findSingleTerm(((ParseResult)parseResult).getAST());
            if (term == null || Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).count() != 1) {
                return NO_ME_USER_DATA;
            }
            ASTNode termItem = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).first();
            if (Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"categorized")).isEmpty()) {
                return NO_ME_USER_DATA;
            }
            ASTNode categorized = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"categorized")).first();
            if (((SearchRequestParser.CategoryHeadASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"head")).first())).type != CategoryType.SEARCH) {
                return NO_ME_USER_DATA;
            }
            if (Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd"), (String)"tail")).isNotEmpty()) {
                return NO_ME_USER_DATA;
            }
            CategoryParser.CategoryValueASTNode catValue = (CategoryParser.CategoryValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd"), (String)"head")).first());
            if (!catValue.pos || Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)catValue, (String)"rangeEnd"), (String)"rightValue")).isNotEmpty()) {
                return NO_ME_USER_DATA;
            }
            CategoryParser.CategoryFieldASTNode categoryField = (CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)catValue, (String)"leftValue")).first());
            if (ListSequence.fromList(categoryField.fieldValues).count() > 1) {
                return NO_ME_USER_DATA;
            }
            IFieldValue filterField = (IFieldValue)ListSequence.fromList(categoryField.fieldValues).first();
            if (!(filterField instanceof IMyFieldValue)) {
                return NO_ME_USER_DATA;
            }
            IField field = categoryField.field;
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldBy")).equals(field)) {
                return new SingleMeUserData(AssociationSemantics.getToOne((Entity)issue, (String)"reporter"));
            }
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldUpdatedBy")).equals(field)) {
                return new SingleMeUserData(AssociationSemantics.getToOne((Entity)issue, (String)"updatedBy"));
            }
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldCommentedBy")).equals(field)) {
                return new MultiMeUserData(QueryOperations.selectDistinct((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getComments(issue), (String)"author"));
            }
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldVotedBy")).equals(field)) {
                return new MultiMeUserData(AssociationSemantics.getToMany((Entity)issue, (String)"voters"));
            }
            Entity customFieldPrototype = field.getCustomFieldPrototype();
            if (!EntityOperations.equals((Entity)customFieldPrototype, null) && MeUserAnalyzerImpl.eq_krshhw_a0a1a0x0a0a(((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)customFieldPrototype, (String)"AbstractCustomFieldPrototype")).getType(customFieldPrototype).getValueType(), "User")) {
                Object value = ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)customFieldPrototype, (String)"CustomFieldPrototype")).getValue(issue, customFieldPrototype);
                return ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)customFieldPrototype, (String)"CustomFieldPrototype")).isMultivalue(customFieldPrototype) ? new MultiMeUserData((Iterable)value) : new SingleMeUserData(DnqUtils.cast((Object)value, (String)"User"));
            }
        }
        return NO_ME_USER_DATA;
    }

    private static boolean eq_krshhw_a0a1a0x0a0a(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public static class MultiMeUserData
    implements MeUserData {
        private final Iterable<Entity> users;

        private MultiMeUserData(Iterable<Entity> users) {
            this.users = users;
        }

        public Iterable<Entity> filterWatchRules(Iterable<Entity> watchRules) {
            return QueryOperations.intersect((Iterable)QueryOperations.selectManyDistinct(this.users, (String)"watchRules"), watchRules);
        }

        public Iterable<Entity> getUsers() {
            return this.users;
        }

        public boolean hasUser(Entity user) {
            return QueryOperations.contains(this.users, (Entity)user);
        }
    }

    public static class SingleMeUserData
    implements MeUserData {
        private final Entity user;

        private SingleMeUserData(Entity user) {
            this.user = user;
        }

        public Iterable<Entity> filterWatchRules(Iterable<Entity> watchRules) {
            if (this.user == null) {
                return QueryOperations.empty((String)"WatchRule");
            }
            return QueryOperations.query(watchRules, (String)"WatchRule", (NodeBase)new LinkEqual("owner", this.user));
        }

        public Entity getUser() {
            return this.user;
        }

        public boolean hasUser(Entity user) {
            return EntityOperations.equals((Entity)this.user, (Object)user);
        }
    }

    public static class NoMeUserData
    implements MeUserData {
        private NoMeUserData() {
        }

        public Iterable<Entity> filterWatchRules(Iterable<Entity> watchRules) {
            return watchRules;
        }

        public boolean hasUser(Entity user) {
            return true;
        }
    }
}

