/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.smartui.parser.search.HeavyRequestException;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.ComplexityAnalyzer;
import jetbrains.youtrack.search.parser.ErrorAnalyzer;
import jetbrains.youtrack.search.parser.HeavySearchRequestExecutorFactory;
import jetbrains.youtrack.search.parser.IssuesSearchRequestExecutor;
import jetbrains.youtrack.search.parser.MatchesSearchRequestExecutor;
import jetbrains.youtrack.search.parser.ParseErrorImpl;
import jetbrains.youtrack.search.parser.SearchRequestExecutor;
import jetbrains.youtrack.search.parser.TextSearchAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParseResult
implements IParseResult {
    private String inputQuery;
    private ASTNode ast;

    public ParseResult(String inputQuery) {
        this.inputQuery = inputQuery;
    }

    public String getInputQuery() {
        return this.inputQuery;
    }

    public Iterable<Entity> getIssues(@NotNull IContext context, @NotNull Entity me) {
        return this.getIssues(new IssuesSearchRequestExecutor(), context, me);
    }

    public Tuples._2<Iterable<Entity>, Set<EntityId>> getIssuesAndPositiveProjects(@NotNull IContext context, @NotNull Entity me) {
        IssuesSearchRequestExecutor executor = new IssuesSearchRequestExecutor();
        Iterable<Entity> issues = this.getIssues(executor, context, me);
        Tuples._2 result = MultiTuple.from(issues, this.extractPositiveProjectsWithContext(executor, context));
        return result;
    }

    private Set<EntityId> extractPositiveProjectsWithContext(IssuesSearchRequestExecutor executor, IContext context) {
        HashSet result = executor.getPositiveProjectIds();
        if (context != null) {
            HashSet contextIds = context.getPositiveProjectIds();
            if (result.isEmpty()) {
                result = contextIds;
            } else if (!contextIds.isEmpty()) {
                result = new HashSet(result);
                result.addAll(contextIds);
            }
        }
        return result;
    }

    private Iterable<Entity> getIssues(@NotNull IssuesSearchRequestExecutor executor, @NotNull IContext context, @NotNull Entity me) {
        Iterable issues;
        try {
            issues = (Iterable)executor.filter(this.getAST(), context, me);
        }
        catch (HeavyRequestException e) {
            issues = QueryOperations.empty((String)"Issue");
        }
        return issues;
    }

    public boolean matchesIssue(Entity issue, IContext context, Entity me) {
        boolean result;
        try {
            result = (Boolean)new MatchesSearchRequestExecutor(issue).filter(this.getAST(), context, me);
        }
        catch (HeavyRequestException e) {
            result = false;
        }
        return result;
    }

    public Iterable<String> getTextSearch(@Nullable IField field) {
        return TextSearchAnalyzer.getTextSearch(this.ast, field);
    }

    public Iterable<Entity> getLooksLikeSearch(@NotNull IField field) {
        return TextSearchAnalyzer.getLooksLikeSearch(this.ast, field);
    }

    public Iterable<ParseErrorImpl> getParseErrors(IContext context, Entity me) {
        SearchRequestExecutor<List<String>> executor;
        List<String> result;
        Iterable<ParseErrorImpl> parseErrors = this.getSyntaxErrors();
        if (Sequence.fromIterable(parseErrors).isEmpty() && !(result = (executor = ((HeavySearchRequestExecutorFactory)ServiceLocator.getBean((String)"heavySearchRequestExecutorFactory")).createExecutor()).filter(this.getAST(), context, me)).isEmpty()) {
            ArrayList<ParseErrorImpl> errors = new ArrayList<ParseErrorImpl>();
            for (String e : result) {
                errors.add(new ParseErrorImpl(e));
            }
            return errors;
        }
        return parseErrors;
    }

    public Iterable<ParseErrorImpl> getSyntaxErrors() {
        return ErrorAnalyzer.getParseErrors(this.ast);
    }

    public boolean isComplexRequest() {
        return ComplexityAnalyzer.isComplexRequest(this.ast);
    }

    public boolean hasOrExpression() {
        return ASTUtilExtensions.hasOrExpression(this.ast);
    }

    public boolean hasAndExpression() {
        return ASTUtilExtensions.hasAndExpression(this.ast);
    }

    public Iterable<Entity> getSavedQueries() {
        return ASTUtilExtensions.getSavedQueries(this.ast);
    }

    public ASTNode getAST() {
        return this.ast;
    }

    public void setAST(ASTNode searchRequestAST) {
        this.ast = searchRequestAST;
    }
}

