/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistent.IssueFolderFieldValue;
import jetbrains.charisma.smartui.parser.search.FieldSort;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.charisma.smartui.parser.search.SortProperty;
import jetbrains.charisma.smartui.parser.search.UserDefaultSort;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.api.parser.IPrefixTrees;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.ConjunctUtil;
import jetbrains.youtrack.search.parser.CustomOrderSort;
import jetbrains.youtrack.search.parser.ParseResult;
import jetbrains.youtrack.search.parser.PredefinedParser;
import jetbrains.youtrack.search.parser.RenderingUtil;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.ValueParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParseResultUtilImpl
implements ParseResultUtil {
    protected static Log log = LogFactory.getLog(ParseResultUtilImpl.class);

    public boolean hasExplicitSort(IParseResult parseResult, @Nullable Entity folder, boolean considerCustomOrder) {
        ISequence sortProperties = this.getSortProperties(parseResult, folder, false);
        if (!considerCustomOrder) {
            sortProperties = Sequence.fromIterable(sortProperties).where((_FunctionTypes._return_P1_E0)new IWhereFilter<SortProperty>(){

                public boolean accept(SortProperty it) {
                    return it instanceof FieldSort;
                }
            });
        }
        return Sequence.fromIterable(sortProperties).isNotEmpty();
    }

    public boolean canBeSortedByRelevance(IParseResult parseResult, @Nullable Entity folder) {
        return !this.hasExplicitSort(parseResult, folder, true) && !parseResult.hasOrExpression() && this.isRelevanceSearch(parseResult, folder);
    }

    public boolean canBeSortedByRelevance(Entity currentUser, IParseResult parseResult, @Nullable Entity folder) {
        return !this.hasExplicitSort(parseResult, folder, true) && !parseResult.hasOrExpression() && ((EntityOperations.equals((Entity)currentUser, null) || ((UserDefaultSort)ServiceLocator.getBean((String)"userDefaultSort")).isRelevance(currentUser)) && this.isRelevanceSearch(parseResult, folder) || this.isLooksLikeSearch(parseResult, folder));
    }

    public boolean isLooksLikeSearch(IParseResult parseResult, @Nullable Entity folder) {
        IField field = (IField)ServiceLocator.getBean((String)"predefinedFieldSimilarTo");
        return !this.hasExplicitSort(parseResult, folder, true) && !parseResult.hasOrExpression() && (!QueryOperations.isEmpty((Iterable)parseResult.getLooksLikeSearch(field)) || this.shouldBeSortedByLooksLike(field, folder, parseResult.getSavedQueries()));
    }

    public Iterable<SortProperty> getSortProperties(IParseResult parseResult, @Nullable Entity folder) {
        return this.getSortProperties(parseResult, folder, true);
    }

    private boolean isRelevanceSearch(IParseResult parseResult, Entity folder) {
        return Sequence.fromIterable((Iterable)parseResult.getTextSearch(null)).isNotEmpty() || this.canBeSortedByRelevance(folder, parseResult.getSavedQueries());
    }

    public Iterable<SortProperty> getSortProperties(IParseResult parseResult, @Nullable Entity folder, boolean addImplicit) {
        IListSequence sortProperties = ListSequence.fromList(new ArrayList());
        ISetSequence visited = SetSequence.fromSet(new HashSet());
        if (!EntityOperations.equals((Entity)folder, null)) {
            this.findSortProperties(folder, (List<SortProperty>)sortProperties, (Set<Entity>)visited);
        }
        this.findSortProperties(parseResult, (List<SortProperty>)sortProperties, (Set<Entity>)visited);
        if (addImplicit && ListSequence.fromList((List)sortProperties).where((_FunctionTypes._return_P1_E0)new IWhereFilter<SortProperty>(){

            public boolean accept(SortProperty it) {
                return it instanceof FieldSort;
            }
        }).isEmpty()) {
            ListSequence.fromList((List)sortProperties).addElement((Object)new FieldSort((IField)ServiceLocator.getBean((String)"predefinedFieldUpdated"), null));
        }
        return sortProperties;
    }

    private void findSortProperties(final Entity issueFolder, List<SortProperty> sortProperties, Set<Entity> visited) {
        if (!EntityOperations.isRemoved((Entity)issueFolder) && !ListSequence.fromList(sortProperties).any((_FunctionTypes._return_P1_E0)new IWhereFilter<SortProperty>(){

            public boolean accept(SortProperty it) {
                CustomOrderSort cos = (CustomOrderSort)ParseResultUtilImpl.as_tn267t_a0a0a0a0a0a0a0a7(it, CustomOrderSort.class);
                return cos != null && ParseResultUtilImpl.eq_tn267t_a0a1a0a0a0a0a0a7(cos.getFolder(), issueFolder);
            }
        })) {
            Entity savedQuery;
            if (SpecialFolders.hasCustomOrder((Entity)issueFolder)) {
                ListSequence.fromList(sortProperties).addElement((Object)new CustomOrderSort(issueFolder));
            }
            if (!EntityOperations.equals((Entity)(savedQuery = DnqUtils.as((Object)issueFolder, (String)"SavedQuery")), null) && !QueryOperations.contains(visited, (Entity)savedQuery)) {
                SetSequence.fromSet(visited).addElement((Object)savedQuery);
                IParseResult requestNode = ((Parser)ServiceLocator.getBean((String)"parser")).parse(null, ((SavedQueryImpl)DnqUtils.getPersistentClassInstance((Entity)savedQuery, (String)"SavedQuery")).getQuery(savedQuery), (IContext)new Context());
                this.findSortProperties(requestNode, sortProperties, visited);
            }
        }
    }

    private boolean canBeSortedByRelevance(@Nullable Entity folder, Iterable<Entity> savedQueries) {
        IListSequence queries = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)queries).addSequence(Sequence.fromIterable(savedQueries));
        Entity savedQuery = DnqUtils.as((Object)folder, (String)"SavedQuery");
        if (!EntityOperations.equals((Entity)savedQuery, null)) {
            ListSequence.fromList((List)queries).addElement((Object)savedQuery);
        }
        for (Entity it : queries) {
            IParseResult parseResult = ((Parser)ServiceLocator.getBean((String)"parser")).parse(null, ((SavedQueryImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"SavedQuery")).getQuery(it), (IContext)new Context());
            if (parseResult.hasOrExpression() || this.hasExplicitSort(parseResult, null, true)) {
                return false;
            }
            if (!Sequence.fromIterable((Iterable)parseResult.getTextSearch(null)).isNotEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldBeSortedByLooksLike(@NotNull IField field, @Nullable Entity folder, Iterable<Entity> savedQueries) {
        IListSequence queries = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)queries).addSequence(Sequence.fromIterable(savedQueries));
        Entity savedQuery = DnqUtils.as((Object)folder, (String)"SavedQuery");
        if (!EntityOperations.equals((Entity)savedQuery, null)) {
            ListSequence.fromList((List)queries).addElement((Object)savedQuery);
        }
        for (Entity it : queries) {
            IParseResult parseResult = ((Parser)ServiceLocator.getBean((String)"parser")).parse(null, ((SavedQueryImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"SavedQuery")).getQuery(it), (IContext)new Context());
            if (parseResult.hasOrExpression() || this.hasExplicitSort(parseResult, null, true)) {
                return false;
            }
            if (QueryOperations.isEmpty((Iterable)parseResult.getLooksLikeSearch(field))) continue;
            return true;
        }
        return false;
    }

    public Iterable<Entity> sort(Iterable<Entity> issues, Iterable<SortProperty> sortProperies, @NotNull IContext context) {
        int issuesCount;
        IListSequence propertiesLimited = Sequence.fromIterable(sortProperies).take(4).toListSequence();
        if (ListSequence.fromList((List)propertiesLimited).count() == 4 && ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).isPersistentIterable(issues) && (issuesCount = QueryOperations.count(issues)) >= 0 && issuesCount < 1000) {
            issues = Sequence.fromIterable(issues).toListSequence();
            if (log.isInfoEnabled()) {
                log.info((Object)"Forcing in-memory sorting");
            }
        }
        for (SortProperty property : ListSequence.fromList((List)propertiesLimited).reversedList()) {
            issues = property.sort(issues, context);
        }
        return issues;
    }

    public Iterable<Entity> sort(Iterable<Entity> issues, IParseResult parseResult, @NotNull IContext context) {
        Iterable contextFolders = context.getContextFolders();
        Entity contextFolder = contextFolders == null ? null : QueryOperations.getFirst((Iterable)contextFolders);
        return this.sort(issues, this.getSortProperties(parseResult, contextFolder, true), context);
    }

    public String setSortProperties(IParseResult parseResult, Iterable<FieldSort> sortProperties, IPrefixTrees keyWordBundle) {
        if (parseResult instanceof ParseResult) {
            ASTNode searchRequestCopy = ((ParseResult)parseResult).getAST().copy();
            IListSequence sorts = Sequence.fromIterable((Iterable)searchRequestCopy.descendants(new ASTType[]{SearchRequestParser.TERM_ITEM})).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

                public boolean accept(ASTNode it) {
                    return Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)it, (String)"categorized"), (String)"sortEnd")).isNotEmpty();
                }
            }).toListSequence();
            if (Sequence.fromIterable(sortProperties).isEmpty()) {
                Sequence.fromIterable((Iterable)sorts).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>(){

                    public void visit(ASTNode it) {
                        ASTNode.delete((ASTNode)it);
                    }
                });
            } else {
                ASTNode lastSort = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)((ASTNode)Sequence.fromIterable((Iterable)sorts).last()), (String)"categorized")).first();
                int size = Sequence.fromIterable((Iterable)sorts).count();
                if (size > 1) {
                    Sequence.fromIterable((Iterable)sorts).take(size - 1).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>(){

                        public void visit(ASTNode it) {
                            ASTNode.delete((ASTNode)it);
                        }
                    });
                }
                if (lastSort == null) {
                    lastSort = this.createSortCategorized(searchRequestCopy);
                } else {
                    Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)lastSort, (String)"sortEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)lastSort, (String)"sortEnd"), (String)"tail"))).toListSequence().visitAll((_FunctionTypes._void_P1_E0)new IVisitor<PredefinedParser.SortPairASTNode>(){

                        public void visit(PredefinedParser.SortPairASTNode it) {
                            ASTNode.delete((ASTNode)it);
                        }
                    });
                }
                ISetSequence added = SetSequence.fromSet(new HashSet());
                for (FieldSort prop : Sequence.fromIterable(sortProperties)) {
                    IField field = prop.getField();
                    if (SetSequence.fromSet((Set)added).contains((Object)field)) continue;
                    this.createSortPair(lastSort, field, prop.getSortDirection());
                    SetSequence.fromSet((Set)added).addElement((Object)field);
                }
            }
            return RenderingUtil.print(searchRequestCopy);
        }
        return null;
    }

    public String conjugate(IParseResult parseResult, Map<IField, Set<IFieldValue>> values) {
        if (parseResult instanceof ParseResult) {
            ASTNode ast = ((ParseResult)parseResult).getAST();
            if (values == null) {
                return RenderingUtil.print(ast);
            }
            return RenderingUtil.print(ConjunctUtil.conjugate(ast, values));
        }
        return null;
    }

    private ASTNode createSortCategorized(ASTNode node) {
        ASTNode lastTerm = (ASTNode)Sequence.fromIterable((Iterable)node.descendants(new ASTType[]{SearchRequestParser.TERM})).last();
        ASTNode item = ASTNode.addChild((ASTNode)(lastTerm == null ? ASTNode.addChild((ASTNode)ASTNode.addChild((ASTNode)ASTNode.addChild((ASTNode)ASTNode.addChild((ASTNode)node, (String)"body", (ASTNode)new ASTNode(SearchRequestParser.OR_EXPRESSION)), (String)"orHead", (ASTNode)new ASTNode(SearchRequestParser.AND_EXPRESSION)), (String)"andHead", (ASTNode)new ASTNode(SearchRequestParser.AND_OPERAND)), (String)"term", (ASTNode)new ASTNode(SearchRequestParser.TERM)) : lastTerm), (String)"item", (ASTNode)new ASTNode(SearchRequestParser.TERM_ITEM));
        ASTNode categorized = ASTNode.addChild((ASTNode)item, (String)"categorized", (ASTNode)new ASTNode(SearchRequestParser.CATEGORIZED));
        SearchRequestParser.CategoryHeadASTNode categoryHead = (SearchRequestParser.CategoryHeadASTNode)ASTNode.addChild((ASTNode)categorized, (String)"head", (ASTNode)new SearchRequestParser.CategoryHeadASTNode(SearchRequestParser.CATEGORY_HEAD));
        categoryHead.fieldAlias = ((FieldAlias)Sequence.fromIterable((Iterable)((IField)ServiceLocator.getBean((String)"predefinedFieldSortBy")).getAliases()).first()).getAlias();
        ASTNode.addChild((ASTNode)categorized, (String)"sortEnd", (ASTNode)new ASTNode(PredefinedParser.SORT_END));
        return categorized;
    }

    private PredefinedParser.SortPairASTNode createSortPair(ASTNode node, IField field, Boolean asc) {
        PredefinedParser.SortPairASTNode sortPair = Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)node, (String)"sortEnd"), (String)"head")).isEmpty() ? (PredefinedParser.SortPairASTNode)ASTNode.addChild((Iterable)ASTNode.getChildren((ASTNode)node, (String)"sortEnd"), (String)"head", (ASTNode)new PredefinedParser.SortPairASTNode(PredefinedParser.SORT_PAIR)) : (PredefinedParser.SortPairASTNode)ASTNode.addChild((Iterable)ASTNode.getChildren((ASTNode)node, (String)"sortEnd"), (String)"tail", (ASTNode)new PredefinedParser.SortPairASTNode(PredefinedParser.SORT_PAIR));
        ValueParser.ValueASTNode value = (ValueParser.ValueASTNode)ASTNode.addChild((ASTNode)sortPair, (String)"value", (ASTNode)new ValueParser.ValueASTNode(ValueParser.VALUE));
        value.identifier = field.getSortName();
        value.badIdentifier = false;
        if (asc != null) {
            PredefinedParser.SortDirASTNode dir = (PredefinedParser.SortDirASTNode)ASTNode.addChild((ASTNode)sortPair, (String)"d", (ASTNode)new PredefinedParser.SortDirASTNode(PredefinedParser.SORT_DIR));
            dir.asc = asc;
        }
        return sortPair;
    }

    private void findSortProperties(IParseResult parseResult, List<SortProperty> sortProperties, Set<Entity> visited) {
        ASTNode ast = ((ParseResult)parseResult).getAST();
        ISequence sortPairs = Sequence.fromIterable((Iterable)ast.descendants(new ASTType[]{PredefinedParser.SORT_PAIR})).where((_FunctionTypes._return_P1_E0)new IWhereFilter<PredefinedParser.SortPairASTNode>(){

            public boolean accept(PredefinedParser.SortPairASTNode it) {
                return it.field != null;
            }
        });
        if (Sequence.fromIterable((Iterable)sortPairs).isEmpty()) {
            ISetSequence innerWatchFolderLikeValue = SetSequence.fromSet(new LinkedHashSet());
            this.collectSearchedValues(parseResult, (IField)ServiceLocator.getBean((String)"predefinedFieldSavedQuery"), (Set<IFieldValue>)innerWatchFolderLikeValue);
            this.collectSearchedValues(parseResult, (IField)ServiceLocator.getBean((String)"predefinedFieldTag"), (Set<IFieldValue>)innerWatchFolderLikeValue);
            for (IFieldValue filterValue : SetSequence.fromSet((Set)innerWatchFolderLikeValue)) {
                if (!(filterValue instanceof IssueFolderFieldValue)) continue;
                Entity folder = ((IssueFolderFieldValue)filterValue).getFolder();
                this.findSortProperties(folder, sortProperties, visited);
            }
        } else {
            ListSequence.fromList(sortProperties).addSequence(Sequence.fromIterable((Iterable)sortPairs).select((_FunctionTypes._return_P1_E0)new ISelector<PredefinedParser.SortPairASTNode, FieldSort>(){

                public FieldSort select(PredefinedParser.SortPairASTNode it) {
                    PredefinedParser.SortDirASTNode dirNode = (PredefinedParser.SortDirASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"d")).first());
                    return new FieldSort(it.field, dirNode != null ? Boolean.valueOf(dirNode.asc) : null);
                }
            }));
        }
    }

    public void collectSearchedValues(IParseResult parseResult, final IField field, final Set<IFieldValue> searchedValues) {
        if (parseResult != null) {
            Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)((ParseResult)parseResult).getAST().descendants(new ASTType[]{SearchRequestParser.TERM}), (String)"item")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>(){

                public void visit(ASTNode it) {
                    ParseResultUtilImpl.this.collectSearchedValuesFromTermItem(it, field, searchedValues);
                }
            });
        }
    }

    private void collectSearchedValuesFromTermItem(ASTNode node, IField field, Set<IFieldValue> searchedValues) {
        ASTNode _calculatedNode = (ASTNode)Sequence.fromIterable((Iterable)node.children(new ASTType[0])).first();
        if (_calculatedNode.hasType(SearchRequestParser.POSITIVE_ALONE_VALUE)) {
            ASTNode pa = _calculatedNode;
            Context context = new Context();
            SetSequence.fromSet(searchedValues).addSequence(Sequence.fromIterable(((SearchRequestParser.AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)pa, (String)"value")).first())).filterValues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<IFieldValue>((IContext)context, field){
                final /* synthetic */ IContext val$context;
                final /* synthetic */ IField val$field;
                {
                    this.val$context = iContext;
                    this.val$field = iField;
                }

                public boolean accept(IFieldValue it) {
                    return Sequence.fromIterable((Iterable)it.getAloneField().getIdsForFieldValue(it, this.val$context)).contains((Object)this.val$field.getUniqueId());
                }
            }));
        } else if (_calculatedNode.hasType(SearchRequestParser.NEGATIVE_ALONE_VALUE)) {
            ASTNode pa = _calculatedNode;
        } else if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
            ASTNode cat = _calculatedNode;
            SearchRequestParser.CategoryHeadASTNode categoryHead = (SearchRequestParser.CategoryHeadASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)cat, (String)"head")).first());
            if (Sequence.fromIterable(categoryHead.fields).isNotEmpty() && Sequence.fromIterable(categoryHead.fields).contains((Object)field)) {
                for (CategoryParser.CategoryValueASTNode categoryNode : ASTUtilExtensions.getCategoryValues(cat)) {
                    this.collectSearchedValuesFromCategoryValue(categoryNode, field, searchedValues);
                }
            }
        } else if (_calculatedNode.hasType(SearchRequestParser.ISSUE)) {
            SearchRequestParser.IssueASTNode i = (SearchRequestParser.IssueASTNode)_calculatedNode;
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldIssue")).equals(field)) {
                SetSequence.fromSet(searchedValues).addElement((Object)i.issueValue);
            }
        }
    }

    private void collectSearchedValuesFromCategoryValue(CategoryParser.CategoryValueASTNode node, IField field, Set<IFieldValue> searchedValues) {
        if (node.pos) {
            for (CategoryParser.CategoryFieldASTNode categoryField : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)node, (String)"leftValue")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)node, (String)"rangeEnd"), (String)"rightValue")))) {
                if (!ParseResultUtilImpl.eq_tn267t_a0a0b0a0t(categoryField.field, field)) continue;
                SetSequence.fromSet(searchedValues).addSequence((ISequence)ListSequence.fromList(categoryField.fieldValues));
            }
        }
    }

    public String print(IParseResult parseResult, Locale locale) {
        if (parseResult instanceof ParseResult) {
            return RenderingUtil.print(((ParseResult)parseResult).getAST(), locale);
        }
        return null;
    }

    private static <T> T as_tn267t_a0a0a0a0a0a0a0a7(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static boolean eq_tn267t_a0a1a0a0a0a0a0a7(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_tn267t_a0a0b0a0t(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

