/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.keyword.UserFieldService;
import jetbrains.charisma.smartui.parser.search.QueryBuilder;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.RenderingUtil;
import jetbrains.youtrack.search.parser.SearchRequestParser;

public class QueryBuilderImpl
implements QueryBuilder {
    private Map<String, Tuples._2<List<String>, List<String>>> fields = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
    protected Set<String> hasFields = SetSequence.fromSet(new LinkedHashSet());
    protected Set<String> negativeHas = SetSequence.fromSet(new LinkedHashSet());
    private Set<String> positiveAloneValues = SetSequence.fromSet(new LinkedHashSet());
    private Set<String> negativeAloneValues = SetSequence.fromSet(new LinkedHashSet());

    public QueryBuilderImpl appendBy(Entity user) {
        return this.appendUser((IField)ServiceLocator.getBean((String)"predefinedFieldBy"), user);
    }

    public QueryBuilderImpl appendVoter(Entity user) {
        return this.appendUser((IField)ServiceLocator.getBean((String)"predefinedFieldVotedBy"), user);
    }

    public QueryBuilderImpl appendProject(Entity project) {
        return this.append((IField)ServiceLocator.getBean((String)"predefinedFieldProject"), (String)PrimitiveAssociationSemantics.get((Entity)project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
    }

    public QueryBuilderImpl appendTag(Entity issueTag) {
        return this.append((IField)ServiceLocator.getBean((String)"predefinedFieldTag"), (String)PrimitiveAssociationSemantics.get((Entity)issueTag, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
    }

    public QueryBuilderImpl appendIssueFolder(Entity folder) {
        return this.append((IField)ServiceLocator.getBean((String)"predefinedFieldContextFolder"), (String)PrimitiveAssociationSemantics.get((Entity)folder, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
    }

    public QueryBuilderImpl appendPositiveHas(IField field) {
        return this.appendHas(field, true);
    }

    public QueryBuilder appendNegativeHas(IField field) {
        return this.appendHas(field, false);
    }

    public QueryBuilder appendPositiveHas(String field) {
        SetSequence.fromSet(this.hasFields).addElement((Object)field);
        return this;
    }

    public QueryBuilder appendNegativeHas(String field) {
        SetSequence.fromSet(this.negativeHas).addElement((Object)field);
        return this;
    }

    private QueryBuilderImpl appendHas(IField field, boolean pos) {
        FieldAlias hasFieldAlias = (FieldAlias)Sequence.fromIterable((Iterable)field.getAliases()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<FieldAlias>(){

            public boolean accept(FieldAlias it) {
                return it.isHas();
            }
        }).first();
        if (hasFieldAlias == null) {
            throw new IllegalArgumentException();
        }
        String alias = hasFieldAlias.getAlias();
        if (pos) {
            SetSequence.fromSet(this.hasFields).addElement((Object)alias);
        } else {
            SetSequence.fromSet(this.negativeHas).addElement((Object)alias);
        }
        return this;
    }

    public QueryBuilderImpl appendLinks(Entity issue) {
        return this.append((IField)ServiceLocator.getBean((String)"predefinedFieldLinks"), ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue));
    }

    public QueryBuilderImpl appendPositiveAloneValue(String value) {
        SetSequence.fromSet(this.positiveAloneValues).addElement((Object)value);
        return this;
    }

    public QueryBuilderImpl appendNegativeAloneValue(String value) {
        SetSequence.fromSet(this.negativeAloneValues).addElement((Object)value);
        return this;
    }

    private QueryBuilderImpl appendUser(IField userField, Entity user) {
        String filterName = !EntityOperations.equals((Entity)user, null) ? (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>") : ((UserFieldService)ServiceLocator.getBean((String)"userFieldService")).getNoUserDescription();
        return this.append(userField, filterName);
    }

    public String toQuery() {
        ASTNode term = new ASTNode(SearchRequestParser.TERM);
        for (IMapping pair : SetSequence.fromSet((Set)MapSequence.fromMap(this.fields).mappingsSet())) {
            ASTUtilExtensions.addCategorized(term, (String)pair.key(), (Iterable)((Tuples._2)pair.value())._0(), (Iterable)((Tuples._2)pair.value())._1());
        }
        if (SetSequence.fromSet(this.hasFields).isNotEmpty() || SetSequence.fromSet(this.negativeHas).isNotEmpty()) {
            ASTUtilExtensions.addHasFields(term, this.hasFields, this.negativeHas);
        }
        if (SetSequence.fromSet(this.positiveAloneValues).isNotEmpty()) {
            for (String positiveValue : SetSequence.fromSet(this.positiveAloneValues)) {
                ASTUtilExtensions.addPositiveAlone(term, positiveValue);
            }
        }
        if (SetSequence.fromSet(this.negativeAloneValues).isNotEmpty()) {
            for (String value : SetSequence.fromSet(this.negativeAloneValues)) {
                ASTUtilExtensions.addNegativeAlone(term, value);
            }
        }
        return RenderingUtil.print(ASTUtilExtensions.toSingleTermSearchRequest(term));
    }

    public QueryBuilderImpl append(IField field, String value) {
        this.appendPositive(((FieldAlias)Sequence.fromIterable((Iterable)field.getAliases()).first()).getAlias(), value);
        return this;
    }

    public QueryBuilderImpl appendPositive(String field, String value) {
        this.appendValue(field, value, true);
        return this;
    }

    public QueryBuilderImpl appendNegative(String field, String value) {
        this.appendValue(field, value, false);
        return this;
    }

    private void appendValue(String field, String value, boolean pos) {
        if (field != null && field.length() > 0 && value != null && value.length() > 0) {
            Tuples._2 current = (Tuples._2)MapSequence.fromMap(this.fields).get((Object)field);
            if (current == null) {
                current = MultiTuple.from((Object)ListSequence.fromList(new ArrayList()), (Object)ListSequence.fromList(new ArrayList()));
                MapSequence.fromMap(this.fields).put((Object)field, (Object)current);
            }
            ListSequence.fromList((List)(pos ? (List)current._0() : (List)current._1())).addElement((Object)(value == null ? null : value.trim()));
        }
    }
}

