/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.Locale;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.smartui.parser.search.LiteralUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.PredefinedParser;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.TextParser;
import jetbrains.youtrack.search.parser.ValueParser;

public class RenderingUtil {
    public static String print(ASTNode _this) {
        if (_this == null) {
            return null;
        }
        return RenderingUtil.print(_this, ApplicationMetaDataImpl.getLocale());
    }

    public static String print(ASTNode _this, Locale locale) {
        StringBuilder builder = new StringBuilder();
        RenderingUtil.printOrExpression((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"body")).first(), builder, locale);
        return builder.toString();
    }

    private static void printOrExpression(ASTNode _this, StringBuilder builder, final Locale locale) {
        RenderingUtil.join(_this.children(new ASTType[]{SearchRequestParser.AND_EXPRESSION}), builder, new _FunctionTypes._void_P2_E0<StringBuilder, ASTNode>(){

            public void invoke(StringBuilder builder, ASTNode expr) {
                RenderingUtil.printAndExpression(expr, builder, locale);
            }
        }, " ", ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("parser.punctuation.or", locale, new Object[0]), " ");
    }

    private static void printAndExpression(ASTNode _this, StringBuilder builder, final Locale locale) {
        RenderingUtil.join(_this.children(new ASTType[]{SearchRequestParser.AND_OPERAND}), builder, new _FunctionTypes._void_P2_E0<StringBuilder, ASTNode>(){

            public void invoke(StringBuilder builder, ASTNode operand) {
                RenderingUtil.printAndOperand(operand, builder, locale);
            }
        }, " ", ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("parser.punctuation.and", locale, new Object[0]), " ");
    }

    private static void printAndOperand(ASTNode _this, StringBuilder builder, Locale locale) {
        ASTNode term = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"term")).first();
        if (term != null) {
            RenderingUtil.printTerm(term, builder, locale);
        } else {
            builder.append(LiteralUtils.getLeftParenthesis());
            RenderingUtil.printOrExpression((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"orExpression")).first(), builder, locale);
            builder.append(LiteralUtils.getRightParenthesis());
        }
    }

    private static void printTerm(ASTNode _this, StringBuilder builder, final Locale locale) {
        RenderingUtil.join(Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"space")).isEmpty();
            }
        }), builder, new _FunctionTypes._void_P2_E0<StringBuilder, ASTNode>(){

            public void invoke(StringBuilder builder, ASTNode item) {
                RenderingUtil.printItem((ASTNode)Sequence.fromIterable((Iterable)item.children(new ASTType[0])).first(), builder, locale);
            }
        }, new String[]{" "});
    }

    private static void printItem(ASTNode _this, StringBuilder builder, final Locale locale) {
        ASTNode _calculatedNode = _this;
        if (_calculatedNode.hasType(TextParser.QUOTED_TEXT)) {
            TextParser.QuotedTextASTNode quotedText = (TextParser.QuotedTextASTNode)_calculatedNode;
            builder.append("\"").append(quotedText.queryWord).append("\"");
        } else if (_calculatedNode.hasType(TextParser.NEGATIVE_TEXT)) {
            ASTNode negativeText = _calculatedNode;
            builder.append("-");
            RenderingUtil.printItem((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)negativeText, (String)"quotedText")).first(), builder, locale);
        } else if (_calculatedNode.hasType(SearchRequestParser.POSITIVE_ALONE_VALUE)) {
            ASTNode positiveAloneValue = _calculatedNode;
            builder.append("#");
            RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)positiveAloneValue, (String)"value"), (String)"value")).first()), builder, locale);
        } else if (_calculatedNode.hasType(SearchRequestParser.NEGATIVE_ALONE_VALUE)) {
            ASTNode negativeAloneValue = _calculatedNode;
            builder.append("-");
            RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)negativeAloneValue, (String)"value"), (String)"value")).first()), builder, locale);
        } else if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
            ASTNode categorized = _calculatedNode;
            builder.append(((SearchRequestParser.CategoryHeadASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"head")).first())).fieldAlias).append(":").append(" ");
            RenderingUtil.join(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"sortEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"sortEnd"), (String)"tail"))), builder, new _FunctionTypes._void_P2_E0<StringBuilder, PredefinedParser.SortPairASTNode>(){

                public void invoke(StringBuilder builder, PredefinedParser.SortPairASTNode pair) {
                    RenderingUtil.print(pair, builder, locale);
                }
            }, new String[]{",", " "});
            RenderingUtil.join(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"hasEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"hasEnd"), (String)"tail"))), builder, new _FunctionTypes._void_P2_E0<StringBuilder, PredefinedParser.HasFieldASTNode>(){

                public void invoke(StringBuilder builder, PredefinedParser.HasFieldASTNode hasField) {
                    RenderingUtil.print(hasField, builder, locale);
                }
            }, new String[]{",", " "});
            RenderingUtil.join(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd"), (String)"tail"))), builder, new _FunctionTypes._void_P2_E0<StringBuilder, CategoryParser.CategoryValueASTNode>(){

                public void invoke(StringBuilder builder, CategoryParser.CategoryValueASTNode categoryValue) {
                    RenderingUtil.print(categoryValue, builder, locale);
                }
            }, new String[]{",", " "});
        } else if (_calculatedNode.hasType(SearchRequestParser.ISSUE)) {
            SearchRequestParser.IssueASTNode issue = (SearchRequestParser.IssueASTNode)_calculatedNode;
            RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)issue, (String)"value")).first()), builder, locale);
        } else if (_calculatedNode.hasType(TextParser.TEXT)) {
            TextParser.TextASTNode text = (TextParser.TextASTNode)_calculatedNode;
            builder.append(text.queryWord);
        }
    }

    public static void printItem(ASTNode _this, StringBuilder builder) {
        RenderingUtil.printItem(_this, builder, ApplicationMetaDataImpl.getLocale());
    }

    private static void print(ValueParser.ValueASTNode _this, StringBuilder builder, Locale locale) {
        boolean isValueComplex = RenderingUtil.isComplexIdentifier(_this.identifier);
        if (isValueComplex) {
            builder.append("{");
        }
        if (RenderingUtil.isNotEmpty_1k6y4n_a0c0i(_this.identifier)) {
            builder.append(_this.identifier);
        }
        if (isValueComplex) {
            builder.append("}");
        }
    }

    private static void print(PredefinedParser.SortPairASTNode _this, StringBuilder builder, Locale locale) {
        RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"value")).first()), builder, locale);
        PredefinedParser.SortDirASTNode dir = (PredefinedParser.SortDirASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"d")).first());
        if (dir != null) {
            builder.append(" ").append(dir.asc ? ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("predefinedParser.asc", locale, new Object[0]) : ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("predefinedParser.desc", locale, new Object[0]));
        }
    }

    private static void print(PredefinedParser.HasFieldASTNode _this, StringBuilder builder, Locale locale) {
        if (!_this.pos) {
            builder.append("-");
        }
        RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"value")).first()), builder, locale);
    }

    private static void print(CategoryParser.CategoryValueASTNode _this, StringBuilder builder, Locale locale) {
        if (!_this.pos) {
            builder.append("-");
        }
        RenderingUtil.print((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"leftValue"), (String)"value")).first()), builder, locale);
        ValueParser.ValueASTNode rangeRight = (ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)_this, (String)"rangeEnd"), (String)"rightValue"), (String)"value")).first());
        if (rangeRight != null) {
            builder.append(" ").append("..").append(" ");
            RenderingUtil.print(rangeRight, builder, locale);
        }
    }

    private static <T> void join(Iterable<T> _this, StringBuilder builder, _FunctionTypes._void_P2_E0<? super StringBuilder, ? super T> appendElement, String ... separators) {
        int position = builder.length();
        for (Object element : Sequence.fromIterable(_this)) {
            if (position < builder.length() && separators != null) {
                for (String separator : separators) {
                    builder.append(separator);
                }
            }
            position = builder.length();
            appendElement.invoke((Object)builder, element);
        }
    }

    public static boolean isComplexIdentifier(String _this) {
        if (RenderingUtil.isEmpty_1k6y4n_a0a0n(_this)) {
            return false;
        }
        if (_this.indexOf(32) >= 0) {
            return true;
        }
        char c = _this.charAt(0);
        return c == '-' || c == '{' || c == '\"' || c == ',' || c == '.' || c == ':' || c == '#';
    }

    public static boolean isNotEmpty_1k6y4n_a0c0i(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty_1k6y4n_a0a0n(String str) {
        return str == null || str.length() == 0;
    }
}

