/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.charisma.links.persistent.ILinkTypeField;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.links.persistent.SuppliedIssueLink;
import jetbrains.charisma.plugins.SuppliedField;
import jetbrains.charisma.smartui.keyword.IPredefinedFieldAliasesHolder;
import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldNode;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.charisma.smartui.parser.search.SavedSearchesTranslator;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.DefaultSavedQueriesProvider;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IRightCombinator;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.customfields.TranslatableBundleValuesProvider;
import jetbrains.youtrack.api.l10n.ITranslator;
import jetbrains.youtrack.api.l10n.LocalizationService;
import jetbrains.youtrack.api.l10n.TranslatableEnum;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.search.parser.ParseErrorImpl;
import jetbrains.youtrack.search.parser.ParseResult;
import jetbrains.youtrack.search.parser.PredefinedParser;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.StringUtils;
import jetbrains.youtrack.search.parser.ValueParser;
import jetbrains.youtrack.search.parser.ValueTranslatorPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SavedSearchesTranslatorImpl
implements ITranslator,
SavedSearchesTranslator {
    protected static Log log = LogFactory.getLog(SavedSearchesTranslatorImpl.class);
    private List<SuppliedField> myBaseSuppliedFields;
    private List<TranslatableBundleValuesProvider> myTranslatableValuesProviders;

    public int getOrdinal() {
        return 0;
    }

    public void toLocale(Locale fromLocale, Locale locale) {
        ((LocalizationService)ServiceLocator.getBean((String)"localizationController")).setTranslationStatus("Processing saved searches.");
        if (QueryOperations.isEmpty((Iterable)QueryOperations.queryGetAll((String)"Project"))) {
            this.translateSavedQueriesAsText(locale);
        } else {
            this.tryFixSavedSearches(fromLocale, locale);
        }
    }

    private void translateSavedQueriesAsText(Locale locale) {
        final Map namesMapping = ((DefaultSavedQueriesProvider)ServiceLocator.getBean((String)"savedQueriesProvider")).getDefaultSavedSearchesNamesMapping(locale);
        final Map queriesMapping = ((DefaultSavedQueriesProvider)ServiceLocator.getBean((String)"savedQueriesProvider")).getDefaultSavedSearchesQueriesMapping(locale);
        Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"SavedQuery")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                String queryTranslation;
                String nameTranslation = (String)MapSequence.fromMap((Map)namesMapping).get(PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
                if (nameTranslation != null && QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)it, (String)"searchRequest"), (String)"savedQueries"), (String)"SavedQuery", (NodeBase)new PropertyEqual("name", (Comparable)((Object)nameTranslation))))) {
                    PrimitiveAssociationSemantics.set((Entity)it, (String)"name", (Comparable)((Object)nameTranslation), String.class);
                }
                if ((queryTranslation = (String)MapSequence.fromMap((Map)queriesMapping).get(PrimitiveAssociationSemantics.get((Entity)it, (String)"query", String.class, null))) != null && queryTranslation != null && queryTranslation.length() > 0) {
                    PrimitiveAssociationSemantics.set((Entity)it, (String)"query", (Comparable)((Object)queryTranslation), String.class);
                }
                if (SavedSearchesTranslatorImpl.isEmpty_avbbkb_a0e0a0a0a0c0c((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"query", String.class, null))) {
                    PrimitiveAssociationSemantics.set((Entity)it, (String)"query", (Comparable)((Object)"#issues"), String.class);
                }
            }
        });
    }

    private void tryFixSavedSearches(Locale fromLocale, Locale locale) {
        Map namesMapping = ((DefaultSavedQueriesProvider)ServiceLocator.getBean((String)"savedQueriesProvider")).getDefaultSavedSearchesNamesMapping(locale);
        for (Entity savedSearch : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"SavedQuery"))) {
            String oldQuery = (String)PrimitiveAssociationSemantics.get((Entity)savedSearch, (String)"query", String.class, null);
            ((LocalizationService)ServiceLocator.getBean((String)"localizationController")).setTranslationStatus("Processing query: " + StringUtils.substring(oldQuery, 0, 40) + "...");
            String newQuery = this.translateQuery(oldQuery, fromLocale, locale, ((SavedQueryImpl)DnqUtils.getPersistentClassInstance((Entity)savedSearch, (String)"SavedQuery")).getOwner(savedSearch));
            if (newQuery != null && newQuery.length() > 0) {
                PrimitiveAssociationSemantics.set((Entity)savedSearch, (String)"query", (Comparable)((Object)newQuery), String.class);
            }
            this.translateNameForDefaultSavedSearch(savedSearch, namesMapping);
            if (!SavedSearchesTranslatorImpl.isEmpty_avbbkb_a0f0b0d((String)PrimitiveAssociationSemantics.get((Entity)savedSearch, (String)"query", String.class, null))) continue;
            PrimitiveAssociationSemantics.set((Entity)savedSearch, (String)"query", (Comparable)((Object)"#issues"), String.class);
        }
    }

    private void translateNameForDefaultSavedSearch(Entity query, Map<String, String> namesMapping) {
        String translation = (String)MapSequence.fromMap(namesMapping).get(PrimitiveAssociationSemantics.get((Entity)query, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
        if (translation != null && translation != null && translation.length() > 0 && QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)query, (String)"searchRequest"), (String)"savedQueries"), (String)"SavedQuery", (NodeBase)new PropertyEqual("name", (Comparable)((Object)translation))))) {
            PrimitiveAssociationSemantics.set((Entity)query, (String)"name", (Comparable)((Object)translation), String.class);
        }
        if (SavedSearchesTranslatorImpl.isEmpty_avbbkb_a0c0e((String)PrimitiveAssociationSemantics.get((Entity)query, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))) {
            PrimitiveAssociationSemantics.set((Entity)query, (String)"name", (Comparable)((Object)"Saved Query Without Name"), String.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translateQuery(String query, Locale fromLocale, final Locale locale, Entity user) {
        Iterable<ParseErrorImpl> parseErrors;
        ParseResult parseResult;
        final Wrappers._T context = new Wrappers._T();
        Iterable<TranslatableEnum> translatableEnums = this.getTranslatableValues();
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user);
            context.value = new Context();
            parseResult = (ParseResult)((Parser)ServiceLocator.getBean((String)"parser")).parse(null, query, (IContext)context.value);
            parseErrors = parseResult.getParseErrors((IContext)context.value, user);
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
        if (Sequence.fromIterable(parseErrors).isNotEmpty()) {
            StringBuilder msg = new StringBuilder("Got problems translating query [" + query + "]");
            Sequence.fromIterable(parseErrors).foldRight((Object)msg, (_FunctionTypes._return_P2_E0)new IRightCombinator<ParseErrorImpl, StringBuilder>(){

                public StringBuilder combine(ParseErrorImpl it, StringBuilder sb) {
                    return sb.append("\n\t").append(it.getMessage((IContext)context.value));
                }
            });
            if (log.isWarnEnabled()) {
                log.warn((Object)msg);
            }
            return query;
        }
        for (ASTNode node : Sequence.fromIterable((Iterable)parseResult.getAST().descendants(new ASTType[0]))) {
            ASTNode _calculatedNode = node;
            if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
                ASTNode categorized = _calculatedNode;
                SearchRequestParser.CategoryHeadASTNode head = (SearchRequestParser.CategoryHeadASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"head")).first());
                IField field = (IField)Sequence.fromIterable(head.fields).first();
                if (field == null) continue;
                if (field.isPrototyped()) {
                    this.fixSuppliedCustomFieldInSavedSearch(head, field, locale);
                    continue;
                }
                if (field.isPredefined()) {
                    this.fixPredefinedFieldInSavedSearch(head, field, locale);
                    continue;
                }
                if (!(field instanceof ILinkTypeField)) continue;
                this.fixLinkTypeInSavedSearch(head, (ILinkTypeField)field, locale);
                continue;
            }
            if (_calculatedNode.hasType(PredefinedParser.HAS_FIELD)) {
                PredefinedParser.HasFieldASTNode hasField = (PredefinedParser.HasFieldASTNode)_calculatedNode;
                Sequence.fromIterable((Iterable)hasField.descendants(new ASTType[]{ValueParser.VALUE})).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ValueParser.ValueASTNode>(){

                    public void visit(ValueParser.ValueASTNode valueNode) {
                        for (Object value : ListSequence.fromList(valueNode.treeValues)) {
                            IField field;
                            if (!(value instanceof BaseFieldNode) || !(field = ((BaseFieldNode)value).getField()).isPredefined()) continue;
                            SavedSearchesTranslatorImpl.this.translatePredefinedFieldAsValueNode(valueNode, field, locale, (_FunctionTypes._return_P1_E0<? extends Boolean, ? super FieldAlias>)((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, FieldAlias>(){

                                public Boolean invoke(FieldAlias alias) {
                                    return alias.isHas();
                                }
                            }));
                        }
                    }
                });
                continue;
            }
            if (_calculatedNode.hasType(PredefinedParser.SORT_PAIR)) {
                PredefinedParser.SortPairASTNode sortPair = (PredefinedParser.SortPairASTNode)_calculatedNode;
                Sequence.fromIterable((Iterable)sortPair.descendants(new ASTType[]{ValueParser.VALUE})).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ValueParser.ValueASTNode>(){

                    public void visit(ValueParser.ValueASTNode valueNode) {
                        for (Object value : ListSequence.fromList(valueNode.treeValues)) {
                            IField field;
                            if (!(value instanceof BaseFieldNode) || !(field = ((BaseFieldNode)value).getField()).isPredefined()) continue;
                            SavedSearchesTranslatorImpl.this.translatePredefinedFieldAsValueNode(valueNode, field, locale, (_FunctionTypes._return_P1_E0<? extends Boolean, ? super FieldAlias>)((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, FieldAlias>(){

                                public Boolean invoke(FieldAlias alias) {
                                    return alias.isSort();
                                }
                            }));
                        }
                    }
                });
                continue;
            }
            if (!_calculatedNode.hasType(ValueParser.VALUE)) continue;
            ValueParser.ValueASTNode valueNode = (ValueParser.ValueASTNode)_calculatedNode;
            for (Object value : ListSequence.fromList(valueNode.treeValues)) {
                String translation = ((ValueTranslatorPool)ServiceLocator.getBean((String)"valueTranslatorPool")).translateValue(value, valueNode.identifier, fromLocale, locale, translatableEnums);
                if (translation == null) continue;
                valueNode.identifier = translation;
            }
        }
        String translationResult = ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).print((IParseResult)parseResult, locale);
        if (log.isInfoEnabled()) {
            log.info((Object)("Query '" + query + "' translated into '" + translationResult + "'"));
        }
        return translationResult;
    }

    private void fixLinkTypeInSavedSearch(SearchRequestParser.CategoryHeadASTNode head, ILinkTypeField link, Locale locale) {
        String translation = this.translateIssueLinkType(link, locale);
        if (translation != null && translation.length() > 0) {
            head.fieldAlias = translation;
        }
    }

    private String translateIssueLinkType(ILinkTypeField link, Locale locale) {
        Entity prototype = link.getLink().getPrototype();
        String translation = null;
        if (((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)prototype, (String)"IssueLinkPrototype")).isTranslatableLink(prototype)) {
            boolean outward;
            boolean bl = outward = link.getLink().getDirection() != LinkDirection.INWARD;
            if (((LocalizationService)ServiceLocator.getBean((String)"localizationController")).isDefaultLocale(locale)) {
                translation = outward ? (String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"sourceToTarget", String.class, null) : (String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"targetToSource", String.class, null);
            } else {
                SuppliedIssueLink linkPrototypeMessages = SuppliedIssueLink.getByName((String)((String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"name", String.class, null)));
                translation = outward ? linkPrototypeMessages.getSourceToTarget(locale) : linkPrototypeMessages.getTargetToSource(locale);
            }
        }
        return translation;
    }

    private void fixPredefinedFieldInSavedSearch(SearchRequestParser.CategoryHeadASTNode head, IField field, Locale locale) {
        Iterable aliases = ((IPredefinedFieldAliasesHolder)ServiceLocator.getBean((String)"predefinedFieldAliasesHolder")).getFieldAliasesInLocale(field, locale);
        for (FieldAlias alias : Sequence.fromIterable((Iterable)aliases)) {
            if (!alias.isFilter()) continue;
            head.fieldAlias = alias.getAlias();
            return;
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("Cannot find alias for predefined field '" + field.getPresentation() + "' with filter flag"));
        }
    }

    private void translatePredefinedFieldAsValueNode(ValueParser.ValueASTNode valueNode, IField field, Locale locale, _FunctionTypes._return_P1_E0<? extends Boolean, ? super FieldAlias> filter2) {
        Iterable aliases = ((IPredefinedFieldAliasesHolder)ServiceLocator.getBean((String)"predefinedFieldAliasesHolder")).getFieldAliasesInLocale(field, locale);
        for (FieldAlias alias : Sequence.fromIterable((Iterable)aliases)) {
            if (!((Boolean)filter2.invoke((Object)alias)).booleanValue()) continue;
            valueNode.identifier = alias.getAlias();
            return;
        }
        if (log.isErrorEnabled()) {
            log.error((Object)("Not found transaltion for predefined field for 'sort by' or 'has' expression." + field.getPresentation()));
        }
    }

    private void fixSuppliedCustomFieldInSavedSearch(SearchRequestParser.CategoryHeadASTNode head, IField categorizedField, Locale locale) {
        Entity prototype = categorizedField.getCustomFieldPrototype();
        SuppliedField suppliedField = this.getSuppliedFieldByName((String)PrimitiveAssociationSemantics.get((Entity)prototype, (String)"name", String.class, null));
        if (suppliedField != null && EntityOperations.equals((Entity)suppliedField.getPrototypeNullable(), (Object)prototype)) {
            String newName = suppliedField.getFieldName(locale);
            String newAliases = suppliedField.getAliases(locale);
            head.fieldAlias = newAliases != null && newAliases.length() > 0 ? newAliases.split(",")[0] : newName;
        }
    }

    private Iterable<TranslatableEnum> getTranslatableValues() {
        return ListSequence.fromList(this.getTranslatableValuesProviders()).translate((_FunctionTypes._return_P1_E0)new ITranslator2<TranslatableBundleValuesProvider, TranslatableEnum>(){

            public Iterable<TranslatableEnum> translate(TranslatableBundleValuesProvider it) {
                return it.getValues();
            }
        });
    }

    private SuppliedField getSuppliedFieldByName(final String fieldName) {
        return (SuppliedField)ListSequence.fromList(this.getBaseSuppliedFields()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<SuppliedField>(){

            public boolean accept(SuppliedField it) {
                return it.getFieldName(LocaleUtil.DEFAULT_LOCALE).equals(fieldName);
            }
        }).first();
    }

    private List<SuppliedField> getBaseSuppliedFields() {
        return this.myBaseSuppliedFields;
    }

    public void setBaseSuppliedFields(List<SuppliedField> value) {
        this.myBaseSuppliedFields = value;
    }

    public List<TranslatableBundleValuesProvider> getTranslatableValuesProviders() {
        return this.myTranslatableValuesProviders;
    }

    public void setTranslatableValuesProviders(List<TranslatableBundleValuesProvider> value) {
        this.myTranslatableValuesProviders = value;
    }

    public static boolean isEmpty_avbbkb_a0e0a0a0a0c0c(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_avbbkb_a0f0b0d(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_avbbkb_a0c0e(String str) {
        return str == null || str.length() == 0;
    }
}

