/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.smartui.parser.search.HeavyRequestException;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.ErrorAnalyzer;
import jetbrains.youtrack.search.parser.PredefinedParser;
import jetbrains.youtrack.search.parser.RenderingUtil;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.TextSearchAnalyzer;
import jetbrains.youtrack.search.parser.ValueParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchRequestExecutor<T> {
    public static final int MAX_VALUES_HANDLED = Integer.getInteger("youtrack.search.parser.maxValuesHandled", Integer.getInteger("jetbrains.exodus.query.reduceUnionsOfLinksDepth") == null ? 200 : 20000);
    protected Map<String, T> pos;
    protected Map<String, T> neg;
    protected IContext context;
    protected Entity me;

    @NotNull
    public T filter(ASTNode searchRequest, @NotNull IContext context, Entity me) {
        if (this.hasErrors(searchRequest)) {
            return this.empty();
        }
        if (context.getContextFolders() == null || EntityOperations.equals((Entity)QueryOperations.getFirst((Iterable)context.getContextFolders()), null)) {
            return this.filterSearchRequest(searchRequest, context, me);
        }
        Context parentContext = new Context();
        parentContext.setCurrentActivity(context.getCurrentActivity());
        Iterator contextFolders = Sequence.fromIterable((Iterable)context.getContextFolders()).iterator();
        Object contextFoldersResult = null;
        while (contextFolders.hasNext()) {
            Entity folder = (Entity)contextFolders.next();
            if (contextFoldersResult == null) {
                contextFoldersResult = this.filterContextIssueFolder(folder, (IContext)parentContext, me);
                continue;
            }
            contextFoldersResult = this.union(contextFoldersResult, this.filterContextIssueFolder(folder, (IContext)parentContext, me));
        }
        return this.intersect(this.filterSearchRequest(searchRequest, context, me), contextFoldersResult);
    }

    @Nullable
    protected abstract T filterContextIssueFolder(@NotNull Entity var1, @NotNull IContext var2, Entity var3);

    @NotNull
    private T filterSearchRequest(ASTNode searchRequest, @NotNull IContext context, Entity me) {
        return this.filterOrExpression((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)searchRequest, (String)"body")).first(), context, me);
    }

    @NotNull
    private T filterOrExpression(ASTNode orExpression, @NotNull IContext context, Entity me) {
        if (orExpression == null) {
            return this.empty();
        }
        T result = this.filterAndExpression((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)orExpression, (String)"orHead")).first(), context, me);
        for (ASTNode orOperand : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)orExpression, (String)"orTail"))) {
            T issues = this.filterAndExpression(orOperand, context, me);
            result = this.union(result, issues);
        }
        return result;
    }

    @NotNull
    private T filterAndExpression(ASTNode andExpression, @NotNull IContext context, Entity me) {
        T result = this.filterAndOperand((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)andExpression, (String)"andHead")).first(), context, me);
        for (ASTNode andOperand : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)andExpression, (String)"andTail"))) {
            T issues = this.filterAndOperand(andOperand, context, me);
            result = this.intersect(result, issues);
        }
        return result;
    }

    @NotNull
    private T filterAndOperand(ASTNode operand, @NotNull IContext context, Entity me) {
        ASTNode term = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)operand, (String)"term")).first();
        T result = term != null ? this.filterRequestTerm(term, context, me) : this.filterOrExpression((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)operand, (String)"orExpression")).first(), context, me);
        return result;
    }

    @NotNull
    private T filterRequestTerm(ASTNode term, @NotNull IContext context, Entity me) {
        this.pos = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        this.neg = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        this.context = context;
        this.me = me;
        for (ASTNode termItem : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"positiveAlone")).isNotEmpty();
            }
        })) {
            this.appendAloneValueIssues((SearchRequestParser.AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"positiveAlone"), (String)"value")).first()), true);
        }
        for (ASTNode termItem : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"negativeAlone")).isNotEmpty();
            }
        })) {
            this.appendAloneValueIssues((SearchRequestParser.AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)termItem, (String)"negativeAlone"), (String)"value")).first()), false);
        }
        for (ASTNode issueId : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"issue")).isNotEmpty();
            }
        })) {
            this.appendAloneIssueIds((SearchRequestParser.IssueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)issueId, (String)"issue")).first()));
        }
        for (ASTNode hasNode : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)it, (String)"categorized"), (String)"hasEnd")).isNotEmpty();
            }
        })) {
            ISequence hasFields = Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)hasNode, (String)"categorized"), (String)"hasEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)hasNode, (String)"categorized"), (String)"hasEnd"), (String)"tail")));
            for (PredefinedParser.HasFieldASTNode hasField : hasFields) {
                this.appendHasFieldIssues(hasField);
            }
        }
        for (Object fieldNode : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)it, (String)"categorized"), (String)"valueEnd")).isNotEmpty();
            }
        })) {
            ISequence values = Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)fieldNode, (String)"categorized"), (String)"valueEnd"), (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)fieldNode, (String)"categorized"), (String)"valueEnd"), (String)"tail")));
            for (CategoryParser.CategoryValueASTNode node : Sequence.fromIterable((Iterable)values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<CategoryParser.CategoryValueASTNode>(){

                public boolean accept(CategoryParser.CategoryValueASTNode it) {
                    return Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)it, (String)"rangeEnd"), (String)"rightValue")).isEmpty();
                }
            })) {
                this.appendCategorizedValueIssues(node);
            }
            for (CategoryParser.CategoryValueASTNode node : Sequence.fromIterable((Iterable)values).where((_FunctionTypes._return_P1_E0)new IWhereFilter<CategoryParser.CategoryValueASTNode>(){

                public boolean accept(CategoryParser.CategoryValueASTNode it) {
                    return Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)it, (String)"rangeEnd"), (String)"rightValue")).isNotEmpty();
                }
            })) {
                this.appendCategorizedRangeIssues(node);
            }
        }
        T result = this.merge();
        for (ASTNode textSearchNode : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"quotedText")).isNotEmpty() || Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"negativeText")).isNotEmpty();
            }
        })) {
            result = this.and(result, this.filterText(TextSearchAnalyzer.isPositiveText(textSearchNode), TextSearchAnalyzer.getQuery(textSearchNode)));
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode textSearchNode : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)term, (String)"item")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ASTNode>(){

            public boolean accept(ASTNode it) {
                return Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)it, (String)"text")).isNotEmpty();
            }
        })) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(TextSearchAnalyzer.getQuery(textSearchNode));
        }
        if (builder.length() > 0) {
            result = this.and(result, this.filterText(true, builder.toString()));
        }
        return result;
    }

    private void appendAloneValueIssues(SearchRequestParser.AloneValueASTNode aloneValue, boolean pos) {
        Object issues = null;
        int filterValuesCount = 0;
        ISetSequence ids = SetSequence.fromSet(new LinkedHashSet());
        for (IFieldValue value : Sequence.fromIterable(aloneValue.filterValues)) {
            SearchRequestExecutor.assertMaxHandledValues(++filterValuesCount, ASTNode.getParent((ASTNode)aloneValue));
            IField field = value.getAloneField();
            this.pushQuotedValueState((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)aloneValue, (String)"value")).first()));
            T fieldIssues = this.getValue(field, value, pos);
            this.popQuotedValueState();
            issues = this.union(issues, fieldIssues);
            SetSequence.fromSet((Set)ids).addSequence(Sequence.fromIterable((Iterable)field.getIdsForFieldValue(value, this.context)));
        }
        for (String id : SetSequence.fromSet((Set)ids)) {
            this.append(this.get(pos), id, issues);
        }
    }

    private void appendCategorizedValueIssues(CategoryParser.CategoryValueASTNode valueNode) {
        Object issues = null;
        IField field = ((CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueNode, (String)"leftValue")).first())).field;
        List<IFieldValue> fieldValues = ((CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueNode, (String)"leftValue")).first())).fieldValues;
        SearchRequestExecutor.assertMaxHandledValues(ListSequence.fromList(fieldValues).count(), ASTNode.getParent((ASTNode)ASTNode.getParent((ASTNode)valueNode)));
        for (IFieldValue value : ListSequence.fromList(fieldValues)) {
            this.pushQuotedValueState((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)valueNode, (String)"leftValue"), (String)"value")).first()));
            issues = this.union(issues, this.getValue(field, value, valueNode.pos));
            this.popQuotedValueState();
        }
        if (field != null) {
            this.append(this.get(valueNode.pos), field.getUniqueId(), issues);
        }
    }

    private void appendHasFieldIssues(PredefinedParser.HasFieldASTNode hasField) {
        IField field = hasField.field;
        T issues = this.hasField(field, hasField.pos);
        this.append(this.get(hasField.pos), field.getUniqueId(), issues);
    }

    private void appendCategorizedRangeIssues(final CategoryParser.CategoryValueASTNode rangeNode) {
        CategoryParser.CategoryFieldASTNode left = (CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)rangeNode, (String)"leftValue")).first());
        CategoryParser.CategoryFieldASTNode right = (CategoryParser.CategoryFieldASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)rangeNode, (String)"rangeEnd"), (String)"rightValue")).first());
        boolean rangeMatchsNothing = true;
        List<IFieldValue> leftValues = left.fieldValues;
        List<IFieldValue> rightValues = right.fieldValues;
        if (SearchRequestExecutor.eq_lq0825_a0i0k(left.field, right.field)) {
            IField field = left.field;
            T issues = this.getRangeValue(field, leftValues, rightValues, rangeNode.pos, (_FunctionTypes._void_P1_E0<Integer>)new _FunctionTypes._void_P1_E0<Integer>(){

                public void invoke(Integer values) {
                    if (values > MAX_VALUES_HANDLED) {
                        SearchRequestExecutor.throwMaxHandledValuesViolation(ASTNode.getParent((ASTNode)ASTNode.getParent((ASTNode)rangeNode)));
                    }
                }
            });
            this.append(this.get(rangeNode.pos), field.getUniqueId(), issues);
            boolean bl = rangeMatchsNothing = issues == null;
        }
        if (rangeMatchsNothing) {
            SearchRequestExecutor.assertMaxHandledValues(ListSequence.fromList(leftValues).count() + ListSequence.fromList(rightValues).count(), ASTNode.getParent((ASTNode)ASTNode.getParent((ASTNode)rangeNode)));
            Object issues = null;
            for (IFieldValue value : ListSequence.fromList(leftValues)) {
                this.pushQuotedValueState((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)left, (String)"value")).first()));
                issues = this.union(issues, this.getValue(left.field, value, rangeNode.pos));
                this.popQuotedValueState();
            }
            this.append(this.get(rangeNode.pos), left.field.getUniqueId(), issues);
            issues = null;
            for (IFieldValue value : ListSequence.fromList(rightValues)) {
                this.pushQuotedValueState((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)right, (String)"value")).first()));
                issues = this.union(issues, this.getValue(right.field, value, rangeNode.pos));
                this.popQuotedValueState();
            }
            this.append(this.get(rangeNode.pos), right.field.getUniqueId(), issues);
        }
    }

    private void appendAloneIssueIds(SearchRequestParser.IssueASTNode node) {
        IField field = (IField)ServiceLocator.getBean((String)"predefinedFieldIssue");
        T nodeIssues = this.getValue(field, node.issueValue, true);
        nodeIssues = this.or(nodeIssues, this.filterText(true, '\"' + ((ValueParser.ValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)node, (String)"value")).first())).identifier + '\"'));
        this.append(this.pos, field.getUniqueId(), nodeIssues);
    }

    private void append(Map<String, T> map, String field, T appendedValue) {
        if (appendedValue != null) {
            Object currentValue = MapSequence.fromMap(map).get((Object)field);
            currentValue = currentValue == null ? appendedValue : this.or(currentValue, appendedValue);
            MapSequence.fromMap(map).put((Object)field, currentValue);
        }
    }

    protected T union(T left, T right) {
        T result = left;
        if (right != null) {
            result = left == null ? right : this.or(left, right);
        }
        return result;
    }

    private T intersect(T left, T right) {
        T result = left;
        if (right != null) {
            result = left == null ? right : this.and(left, right);
        }
        return result;
    }

    private Map<String, T> get(boolean pos) {
        return pos ? this.pos : this.neg;
    }

    protected boolean hasErrors(ASTNode node) {
        return Sequence.fromIterable(ErrorAnalyzer.getParseErrors(node)).isNotEmpty();
    }

    private void pushQuotedValueState(ValueParser.ValueASTNode value) {
        this.context.setQuotedValue(Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)value, (String)"quotedValue")).isNotEmpty());
    }

    private void popQuotedValueState() {
        this.context.setQuotedValue(false);
    }

    protected abstract T hasField(IField var1, boolean var2);

    protected abstract T getValue(IField var1, IFieldValue var2, boolean var3);

    protected abstract T getRangeValue(IField var1, List<IFieldValue> var2, List<IFieldValue> var3, boolean var4, _FunctionTypes._void_P1_E0<? super Integer> var5);

    @NotNull
    protected abstract T filterText(boolean var1, String var2);

    protected abstract T and(@NotNull T var1, @NotNull T var2);

    protected abstract T or(@NotNull T var1, @NotNull T var2);

    @NotNull
    protected abstract T empty();

    @NotNull
    protected abstract T merge();

    public static void assertMaxHandledValues(int handledValues, ASTNode node) {
        if (++handledValues > MAX_VALUES_HANDLED) {
            SearchRequestExecutor.throwMaxHandledValuesViolation(node);
        }
    }

    public static void throwMaxHandledValuesViolation(ASTNode node) throws HeavyRequestException {
        StringBuilder builder = new StringBuilder("");
        RenderingUtil.printItem(node, builder);
        throw new HeavyRequestException(new LocalizationObject("SearchRequestExecutor.Search_request_was_not_processed_because_its_part_{0}_might_cause_significant_system_slow-down_please_refine_the_query", new Object[]{builder.toString()}));
    }

    private static boolean eq_lq0825_a0i0k(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

