/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistent.IProjectFieldValue;
import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldNode;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.parser.runtime.base.BaseParser;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.mps.parser.runtime.context.Symbol;
import jetbrains.mps.parser.runtime.lexer.Word;
import jetbrains.mps.parser.runtime.prefixTree.AndPredicate;
import jetbrains.mps.parser.runtime.prefixTree.IPredicate;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.CategoryType;
import jetbrains.youtrack.search.parser.ParseErrorImpl;
import jetbrains.youtrack.search.parser.ParseResult;
import jetbrains.youtrack.search.parser.PredefinedParser;
import jetbrains.youtrack.search.parser.PunctuationParser;
import jetbrains.youtrack.search.parser.SuggestProcessor;
import jetbrains.youtrack.search.parser.TextParser;
import jetbrains.youtrack.search.parser.TreeSearchParser;
import jetbrains.youtrack.search.parser.ValueParser;
import jetbrains.youtrack.search.parser.predicate.FilterCategoryPredicate;
import jetbrains.youtrack.search.parser.predicate.MatchProjectsAndCategoryPredicate;
import org.jetbrains.annotations.NotNull;

public class SearchRequestParser
extends BaseParser {
    public static final ASTType<ASTNode> SEARCH_REQUEST = new ASTType("SEARCH_REQUEST");
    public static final ASTType<ASTNode> OR_EXPRESSION = new ASTType("OR_EXPRESSION");
    public static final ASTType<ASTNode> AND_EXPRESSION = new ASTType("AND_EXPRESSION");
    public static final ASTType<ASTNode> AND_OPERAND = new ASTType("AND_OPERAND");
    public static final ASTType<ASTNode> TERM = new ASTType("TERM");
    public static final ASTType<ASTNode> TERM_ITEM = new ASTType("TERM_ITEM");
    public static final ASTType<ASTNode> CATEGORIZED = new ASTType("CATEGORIZED");
    public static final ASTType<CategoryHeadASTNode> CATEGORY_HEAD = new ASTType("CATEGORY_HEAD");
    public static final ASTType<ASTNode> POSITIVE_ALONE_VALUE = new ASTType("POSITIVE_ALONE_VALUE");
    public static final ASTType<ASTNode> NEGATIVE_ALONE_VALUE = new ASTType("NEGATIVE_ALONE_VALUE");
    public static final ASTType<AloneValueASTNode> ALONE_VALUE = new ASTType("ALONE_VALUE");
    public static final ASTType<IssueASTNode> ISSUE = new ASTType("ISSUE");
    private final TreeSearchParser ip_TreeSearch;
    private final PunctuationParser ip_Punctuation;
    private final PredefinedParser ip_Predefined;
    private final ValueParser ip_Value;
    private final TextParser ip_Text;
    private final CategoryParser ip_Category;
    private IPredicate valuePredicate;
    private ParseResult searchRequestNode;
    private Collection<Entity> contextProjects;
    private IContext context;
    private Iterable<String> aloneValueTreeKeys;

    public SearchRequestParser(IPrefixTreesData data, @NotNull IContext context, IPredicate predicate, ParseResult root) {
        this.aloneValueTreeKeys = data.getAloneValueTreeKeys();
        this.valuePredicate = predicate;
        this.context = context;
        this.reuse(root);
        TreeSearchParser treeSearchParser = new TreeSearchParser(data, context);
        PunctuationParser punctuationParser = new PunctuationParser();
        ValueParser valueParser = new ValueParser(treeSearchParser, punctuationParser);
        this.ip_TreeSearch = treeSearchParser;
        this.ip_Punctuation = punctuationParser;
        this.ip_Value = valueParser;
        this.ip_Text = new TextParser(treeSearchParser, this.aloneValueTreeKeys);
        this.ip_Predefined = new PredefinedParser(punctuationParser, valueParser);
        this.ip_Category = new CategoryParser(punctuationParser, valueParser, context, predicate);
    }

    public ASTNode start(List<Word> words, int inPosition, int caret) {
        ASTNode out = this.ruleSearchRequest(words, inPosition, caret);
        return out;
    }

    public ASTNode ruleSearchRequest(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("SearchRequest");
        ASTNode astNode = new ASTNode(SEARCH_REQUEST);
        int concatPosition_qjwyxf_a0 = inPosition;
        Symbol concatSymbol_qjwyxf_a0 = this.createConcatenationSymbol(concatPosition_qjwyxf_a0);
        ASTNode bodySymbol = this.ruleOrExpression(words, concatPosition_qjwyxf_a0, caret);
        astNode.addChild("body", bodySymbol);
        concatSymbol_qjwyxf_a0.append((Symbol)bodySymbol);
        if (bodySymbol.accepted) {
            concatSymbol_qjwyxf_a0.length += bodySymbol.length;
            Symbol eofSymbol_qjwyxf_b0a = this.createEofSymbol(words, concatPosition_qjwyxf_a0 += bodySymbol.length);
            concatSymbol_qjwyxf_a0.append(eofSymbol_qjwyxf_b0a);
            concatSymbol_qjwyxf_a0.accepted = eofSymbol_qjwyxf_b0a.accepted;
            concatSymbol_qjwyxf_a0.length += eofSymbol_qjwyxf_b0a.length;
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a0);
        this.fireNonTerminalExit("SearchRequest", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleOrExpression(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("OrExpression");
        ASTNode astNode = new ASTNode(OR_EXPRESSION);
        int concatPosition_qjwyxf_a1 = inPosition;
        Symbol concatSymbol_qjwyxf_a1 = this.createConcatenationSymbol(concatPosition_qjwyxf_a1);
        ASTNode orHeadSymbol = this.ruleAndExpression(words, concatPosition_qjwyxf_a1, caret);
        astNode.addChild("orHead", orHeadSymbol);
        concatSymbol_qjwyxf_a1.append((Symbol)orHeadSymbol);
        if (orHeadSymbol.accepted) {
            concatSymbol_qjwyxf_a1.length += orHeadSymbol.length;
            int trPosition_qjwyxf_b0b = concatPosition_qjwyxf_a1 += orHeadSymbol.length;
            Symbol transitiveSymbol_qjwyxf_b0b = this.createTransitiveSymbol(trPosition_qjwyxf_b0b);
            while (true) {
                int concatPosition_qjwyxf_a1a1 = trPosition_qjwyxf_b0b;
                Symbol concatSymbol_qjwyxf_a1a1 = this.createConcatenationSymbol(concatPosition_qjwyxf_a1a1);
                ASTNode nonTerminalSymbol_qjwyxf_a0b0b = this.ip_Punctuation.ruleor(words, concatPosition_qjwyxf_a1a1, caret);
                astNode.addChild(null, nonTerminalSymbol_qjwyxf_a0b0b);
                concatSymbol_qjwyxf_a1a1.append((Symbol)nonTerminalSymbol_qjwyxf_a0b0b);
                if (nonTerminalSymbol_qjwyxf_a0b0b.accepted) {
                    concatSymbol_qjwyxf_a1a1.length += nonTerminalSymbol_qjwyxf_a0b0b.length;
                    Symbol customSymbol_qjwyxf_b0b0b = this.createCustomSymbol(concatPosition_qjwyxf_a1a1 += nonTerminalSymbol_qjwyxf_a0b0b.length);
                    this.resetContextProjects();
                    concatSymbol_qjwyxf_a1a1.append(customSymbol_qjwyxf_b0b0b);
                    if (customSymbol_qjwyxf_b0b0b.accepted) {
                        concatSymbol_qjwyxf_a1a1.length += customSymbol_qjwyxf_b0b0b.length;
                        int trPosition_qjwyxf_c0b0b = concatPosition_qjwyxf_a1a1 += customSymbol_qjwyxf_b0b0b.length;
                        Symbol transitiveSymbol_qjwyxf_c0b0b = this.createTransitiveSymbol(trPosition_qjwyxf_c0b0b);
                        while (true) {
                            int concatPosition_qjwyxf_a2a1a1 = trPosition_qjwyxf_c0b0b;
                            Symbol concatSymbol_qjwyxf_a2a1a1 = this.createConcatenationSymbol(concatPosition_qjwyxf_a2a1a1);
                            ASTNode nonTerminalSymbol_qjwyxf_a0c0b0b = this.ip_Punctuation.rulespace(words, concatPosition_qjwyxf_a2a1a1, caret);
                            astNode.addChild(null, nonTerminalSymbol_qjwyxf_a0c0b0b);
                            concatSymbol_qjwyxf_a2a1a1.append((Symbol)nonTerminalSymbol_qjwyxf_a0c0b0b);
                            concatSymbol_qjwyxf_a2a1a1.accepted = nonTerminalSymbol_qjwyxf_a0c0b0b.accepted;
                            concatSymbol_qjwyxf_a2a1a1.length += nonTerminalSymbol_qjwyxf_a0c0b0b.length;
                            transitiveSymbol_qjwyxf_c0b0b.append(concatSymbol_qjwyxf_a2a1a1);
                            if (!concatSymbol_qjwyxf_a2a1a1.accepted) break;
                            transitiveSymbol_qjwyxf_c0b0b.length += concatSymbol_qjwyxf_a2a1a1.length;
                            trPosition_qjwyxf_c0b0b += concatSymbol_qjwyxf_a2a1a1.length;
                        }
                        concatSymbol_qjwyxf_a1a1.append(transitiveSymbol_qjwyxf_c0b0b);
                        if (transitiveSymbol_qjwyxf_c0b0b.accepted) {
                            concatSymbol_qjwyxf_a1a1.length += transitiveSymbol_qjwyxf_c0b0b.length;
                            ASTNode orTailSymbol = this.ruleAndExpression(words, concatPosition_qjwyxf_a1a1 += transitiveSymbol_qjwyxf_c0b0b.length, caret);
                            astNode.addChild("orTail", orTailSymbol);
                            concatSymbol_qjwyxf_a1a1.append((Symbol)orTailSymbol);
                            concatSymbol_qjwyxf_a1a1.accepted = orTailSymbol.accepted;
                            concatSymbol_qjwyxf_a1a1.length += orTailSymbol.length;
                        }
                    }
                }
                transitiveSymbol_qjwyxf_b0b.append(concatSymbol_qjwyxf_a1a1);
                if (!concatSymbol_qjwyxf_a1a1.accepted) break;
                transitiveSymbol_qjwyxf_b0b.length += concatSymbol_qjwyxf_a1a1.length;
                trPosition_qjwyxf_b0b += concatSymbol_qjwyxf_a1a1.length;
            }
            concatSymbol_qjwyxf_a1.append(transitiveSymbol_qjwyxf_b0b);
            concatSymbol_qjwyxf_a1.accepted = transitiveSymbol_qjwyxf_b0b.accepted;
            concatSymbol_qjwyxf_a1.length += transitiveSymbol_qjwyxf_b0b.length;
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a1);
        this.fireNonTerminalExit("OrExpression", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleAndExpression(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("AndExpression");
        ASTNode astNode = new ASTNode(AND_EXPRESSION);
        int concatPosition_qjwyxf_a2 = inPosition;
        Symbol concatSymbol_qjwyxf_a2 = this.createConcatenationSymbol(concatPosition_qjwyxf_a2);
        ASTNode andHeadSymbol = this.ruleAndOperand(words, concatPosition_qjwyxf_a2, caret);
        astNode.addChild("andHead", andHeadSymbol);
        concatSymbol_qjwyxf_a2.append((Symbol)andHeadSymbol);
        if (andHeadSymbol.accepted) {
            concatSymbol_qjwyxf_a2.length += andHeadSymbol.length;
            int trPosition_qjwyxf_b0c = concatPosition_qjwyxf_a2 += andHeadSymbol.length;
            Symbol transitiveSymbol_qjwyxf_b0c = this.createTransitiveSymbol(trPosition_qjwyxf_b0c);
            while (true) {
                int concatPosition_qjwyxf_a1a2 = trPosition_qjwyxf_b0c;
                Symbol concatSymbol_qjwyxf_a1a2 = this.createConcatenationSymbol(concatPosition_qjwyxf_a1a2);
                ASTNode nonTerminalSymbol_qjwyxf_a0b0c = this.ip_Punctuation.ruleand(words, concatPosition_qjwyxf_a1a2, caret);
                astNode.addChild(null, nonTerminalSymbol_qjwyxf_a0b0c);
                concatSymbol_qjwyxf_a1a2.append((Symbol)nonTerminalSymbol_qjwyxf_a0b0c);
                if (nonTerminalSymbol_qjwyxf_a0b0c.accepted) {
                    concatSymbol_qjwyxf_a1a2.length += nonTerminalSymbol_qjwyxf_a0b0c.length;
                    Symbol customSymbol_qjwyxf_b0b0c = this.createCustomSymbol(concatPosition_qjwyxf_a1a2 += nonTerminalSymbol_qjwyxf_a0b0c.length);
                    concatSymbol_qjwyxf_a1a2.append(customSymbol_qjwyxf_b0b0c);
                    if (customSymbol_qjwyxf_b0b0c.accepted) {
                        concatSymbol_qjwyxf_a1a2.length += customSymbol_qjwyxf_b0b0c.length;
                        int trPosition_qjwyxf_c0b0c = concatPosition_qjwyxf_a1a2 += customSymbol_qjwyxf_b0b0c.length;
                        Symbol transitiveSymbol_qjwyxf_c0b0c = this.createTransitiveSymbol(trPosition_qjwyxf_c0b0c);
                        while (true) {
                            int concatPosition_qjwyxf_a2a1a2 = trPosition_qjwyxf_c0b0c;
                            Symbol concatSymbol_qjwyxf_a2a1a2 = this.createConcatenationSymbol(concatPosition_qjwyxf_a2a1a2);
                            ASTNode nonTerminalSymbol_qjwyxf_a0c0b0c = this.ip_Punctuation.rulespace(words, concatPosition_qjwyxf_a2a1a2, caret);
                            astNode.addChild(null, nonTerminalSymbol_qjwyxf_a0c0b0c);
                            concatSymbol_qjwyxf_a2a1a2.append((Symbol)nonTerminalSymbol_qjwyxf_a0c0b0c);
                            concatSymbol_qjwyxf_a2a1a2.accepted = nonTerminalSymbol_qjwyxf_a0c0b0c.accepted;
                            concatSymbol_qjwyxf_a2a1a2.length += nonTerminalSymbol_qjwyxf_a0c0b0c.length;
                            transitiveSymbol_qjwyxf_c0b0c.append(concatSymbol_qjwyxf_a2a1a2);
                            if (!concatSymbol_qjwyxf_a2a1a2.accepted) break;
                            transitiveSymbol_qjwyxf_c0b0c.length += concatSymbol_qjwyxf_a2a1a2.length;
                            trPosition_qjwyxf_c0b0c += concatSymbol_qjwyxf_a2a1a2.length;
                        }
                        concatSymbol_qjwyxf_a1a2.append(transitiveSymbol_qjwyxf_c0b0c);
                        if (transitiveSymbol_qjwyxf_c0b0c.accepted) {
                            concatSymbol_qjwyxf_a1a2.length += transitiveSymbol_qjwyxf_c0b0c.length;
                            ASTNode andTailSymbol = this.ruleAndOperand(words, concatPosition_qjwyxf_a1a2 += transitiveSymbol_qjwyxf_c0b0c.length, caret);
                            astNode.addChild("andTail", andTailSymbol);
                            concatSymbol_qjwyxf_a1a2.append((Symbol)andTailSymbol);
                            concatSymbol_qjwyxf_a1a2.accepted = andTailSymbol.accepted;
                            concatSymbol_qjwyxf_a1a2.length += andTailSymbol.length;
                        }
                    }
                }
                transitiveSymbol_qjwyxf_b0c.append(concatSymbol_qjwyxf_a1a2);
                if (!concatSymbol_qjwyxf_a1a2.accepted) break;
                transitiveSymbol_qjwyxf_b0c.length += concatSymbol_qjwyxf_a1a2.length;
                trPosition_qjwyxf_b0c += concatSymbol_qjwyxf_a1a2.length;
            }
            concatSymbol_qjwyxf_a2.append(transitiveSymbol_qjwyxf_b0c);
            concatSymbol_qjwyxf_a2.accepted = transitiveSymbol_qjwyxf_b0c.accepted;
            concatSymbol_qjwyxf_a2.length += transitiveSymbol_qjwyxf_b0c.length;
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a2);
        this.fireNonTerminalExit("AndExpression", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleAndOperand(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("AndOperand");
        ASTNode astNode = new ASTNode(AND_OPERAND);
        Symbol alterSymbol_qjwyxf_a3 = this.createAlternationSymbol(inPosition);
        if (!alterSymbol_qjwyxf_a3.accepted) {
            int concatPosition_qjwyxf_a0d = inPosition;
            Symbol concatSymbol_qjwyxf_a0d = this.createConcatenationSymbol(concatPosition_qjwyxf_a0d);
            ASTNode nonTerminalSymbol_qjwyxf_a0a3 = this.ip_Punctuation.ruleleftParenthesis(words, concatPosition_qjwyxf_a0d, caret);
            astNode.addChild(null, nonTerminalSymbol_qjwyxf_a0a3);
            concatSymbol_qjwyxf_a0d.append((Symbol)nonTerminalSymbol_qjwyxf_a0a3);
            if (nonTerminalSymbol_qjwyxf_a0a3.accepted) {
                concatSymbol_qjwyxf_a0d.length += nonTerminalSymbol_qjwyxf_a0a3.length;
                ASTNode orExpressionSymbol = this.ruleOrExpression(words, concatPosition_qjwyxf_a0d += nonTerminalSymbol_qjwyxf_a0a3.length, caret);
                astNode.addChild("orExpression", orExpressionSymbol);
                concatSymbol_qjwyxf_a0d.append((Symbol)orExpressionSymbol);
                if (orExpressionSymbol.accepted) {
                    concatSymbol_qjwyxf_a0d.length += orExpressionSymbol.length;
                    ASTNode nonTerminalSymbol_qjwyxf_c0a3 = this.ip_Punctuation.rulerightParenthesis(words, concatPosition_qjwyxf_a0d += orExpressionSymbol.length, caret);
                    astNode.addChild(null, nonTerminalSymbol_qjwyxf_c0a3);
                    concatSymbol_qjwyxf_a0d.append((Symbol)nonTerminalSymbol_qjwyxf_c0a3);
                    if (nonTerminalSymbol_qjwyxf_c0a3.accepted) {
                        concatSymbol_qjwyxf_a0d.length += nonTerminalSymbol_qjwyxf_c0a3.length;
                        ASTNode nonTerminalSymbol_qjwyxf_d0a3 = this.ip_Punctuation.ruleoptSpace(words, concatPosition_qjwyxf_a0d += nonTerminalSymbol_qjwyxf_c0a3.length, caret);
                        astNode.addChild(null, nonTerminalSymbol_qjwyxf_d0a3);
                        concatSymbol_qjwyxf_a0d.append((Symbol)nonTerminalSymbol_qjwyxf_d0a3);
                        concatSymbol_qjwyxf_a0d.accepted = nonTerminalSymbol_qjwyxf_d0a3.accepted;
                        concatSymbol_qjwyxf_a0d.length += nonTerminalSymbol_qjwyxf_d0a3.length;
                    }
                }
            }
            alterSymbol_qjwyxf_a3.accepted = concatSymbol_qjwyxf_a0d.accepted;
            alterSymbol_qjwyxf_a3.append(concatSymbol_qjwyxf_a0d);
            if (concatSymbol_qjwyxf_a0d.accepted) {
                alterSymbol_qjwyxf_a3.length = concatSymbol_qjwyxf_a0d.length;
            }
        }
        if (!alterSymbol_qjwyxf_a3.accepted) {
            ASTNode termSymbol = this.ruleTerm(words, inPosition, caret);
            astNode.addChild("term", termSymbol);
            alterSymbol_qjwyxf_a3.accepted = termSymbol.accepted;
            alterSymbol_qjwyxf_a3.append((Symbol)termSymbol);
            if (termSymbol.accepted) {
                alterSymbol_qjwyxf_a3.length = termSymbol.length;
            }
        }
        astNode.setSymbol(words, alterSymbol_qjwyxf_a3);
        this.fireNonTerminalExit("AndOperand", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleTerm(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("Term");
        ASTNode astNode = new ASTNode(TERM);
        int trPosition_qjwyxf_a4 = inPosition;
        Symbol transitiveSymbol_qjwyxf_a4 = this.createTransitiveSymbol(trPosition_qjwyxf_a4);
        while (true) {
            ASTNode itemSymbol = this.ruleTermItem(words, trPosition_qjwyxf_a4, caret);
            astNode.addChild("item", itemSymbol);
            transitiveSymbol_qjwyxf_a4.append((Symbol)itemSymbol);
            if (!itemSymbol.accepted) break;
            transitiveSymbol_qjwyxf_a4.length += itemSymbol.length;
            trPosition_qjwyxf_a4 += itemSymbol.length;
        }
        astNode.setSymbol(words, transitiveSymbol_qjwyxf_a4);
        this.fireNonTerminalExit("Term", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleTermItem(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("TermItem");
        ASTNode astNode = new ASTNode(TERM_ITEM);
        Symbol alterSymbol_qjwyxf_a5 = this.createAlternationSymbol(inPosition);
        if (!alterSymbol_qjwyxf_a5.accepted) {
            TextParser.QuotedTextASTNode quotedTextSymbol = this.ip_Text.ruleQuotedText(words, inPosition, caret);
            astNode.addChild("quotedText", (ASTNode)quotedTextSymbol);
            alterSymbol_qjwyxf_a5.accepted = quotedTextSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)quotedTextSymbol);
            if (quotedTextSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = quotedTextSymbol.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            ASTNode negativeTextSymbol = this.ip_Text.ruleNegativeText(words, inPosition, caret);
            astNode.addChild("negativeText", negativeTextSymbol);
            alterSymbol_qjwyxf_a5.accepted = negativeTextSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)negativeTextSymbol);
            if (negativeTextSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = negativeTextSymbol.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            int concatPosition_qjwyxf_c0f = inPosition;
            Symbol concatSymbol_qjwyxf_c0f = this.createConcatenationSymbol(concatPosition_qjwyxf_c0f);
            ASTNode positiveAloneSymbol = this.rulePositiveAloneValue(words, concatPosition_qjwyxf_c0f, caret);
            astNode.addChild("positiveAlone", positiveAloneSymbol);
            concatSymbol_qjwyxf_c0f.append((Symbol)positiveAloneSymbol);
            if (positiveAloneSymbol.accepted) {
                concatSymbol_qjwyxf_c0f.length += positiveAloneSymbol.length;
                Symbol customSymbol_qjwyxf_b2a5 = this.createCustomSymbol(concatPosition_qjwyxf_c0f += positiveAloneSymbol.length);
                this.addContextProjectForAloneValue(positiveAloneSymbol);
                concatSymbol_qjwyxf_c0f.append(customSymbol_qjwyxf_b2a5);
                concatSymbol_qjwyxf_c0f.accepted = customSymbol_qjwyxf_b2a5.accepted;
                concatSymbol_qjwyxf_c0f.length += customSymbol_qjwyxf_b2a5.length;
            }
            alterSymbol_qjwyxf_a5.accepted = concatSymbol_qjwyxf_c0f.accepted;
            alterSymbol_qjwyxf_a5.append(concatSymbol_qjwyxf_c0f);
            if (concatSymbol_qjwyxf_c0f.accepted) {
                alterSymbol_qjwyxf_a5.length = concatSymbol_qjwyxf_c0f.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            ASTNode negativeAloneSymbol = this.ruleNegativeAloneValue(words, inPosition, caret);
            astNode.addChild("negativeAlone", negativeAloneSymbol);
            alterSymbol_qjwyxf_a5.accepted = negativeAloneSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)negativeAloneSymbol);
            if (negativeAloneSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = negativeAloneSymbol.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            int concatPosition_qjwyxf_e0f = inPosition;
            Symbol concatSymbol_qjwyxf_e0f = this.createConcatenationSymbol(concatPosition_qjwyxf_e0f);
            ASTNode categorizedSymbol = this.ruleCategorized(words, concatPosition_qjwyxf_e0f, caret);
            astNode.addChild("categorized", categorizedSymbol);
            concatSymbol_qjwyxf_e0f.append((Symbol)categorizedSymbol);
            if (categorizedSymbol.accepted) {
                concatSymbol_qjwyxf_e0f.length += categorizedSymbol.length;
                Symbol customSymbol_qjwyxf_b4a5 = this.createCustomSymbol(concatPosition_qjwyxf_e0f += categorizedSymbol.length);
                this.addContextProjectForCategorized(categorizedSymbol);
                concatSymbol_qjwyxf_e0f.append(customSymbol_qjwyxf_b4a5);
                concatSymbol_qjwyxf_e0f.accepted = customSymbol_qjwyxf_b4a5.accepted;
                concatSymbol_qjwyxf_e0f.length += customSymbol_qjwyxf_b4a5.length;
            }
            alterSymbol_qjwyxf_a5.accepted = concatSymbol_qjwyxf_e0f.accepted;
            alterSymbol_qjwyxf_a5.append(concatSymbol_qjwyxf_e0f);
            if (concatSymbol_qjwyxf_e0f.accepted) {
                alterSymbol_qjwyxf_a5.length = concatSymbol_qjwyxf_e0f.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            IssueASTNode issueSymbol = this.ruleIssue(words, inPosition, caret);
            astNode.addChild("issue", (ASTNode)issueSymbol);
            alterSymbol_qjwyxf_a5.accepted = issueSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)issueSymbol);
            if (issueSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = issueSymbol.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            TextParser.TextASTNode textSymbol = this.ip_Text.ruleText(words, inPosition, caret, this.createLocalPredicate(caret, this.valuePredicate));
            astNode.addChild("text", (ASTNode)textSymbol);
            alterSymbol_qjwyxf_a5.accepted = textSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)textSymbol);
            if (textSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = textSymbol.length;
            }
        }
        if (!alterSymbol_qjwyxf_a5.accepted) {
            ASTNode spaceSymbol = this.ip_Punctuation.rulespace(words, inPosition, caret);
            astNode.addChild("space", spaceSymbol);
            alterSymbol_qjwyxf_a5.accepted = spaceSymbol.accepted;
            alterSymbol_qjwyxf_a5.append((Symbol)spaceSymbol);
            if (spaceSymbol.accepted) {
                alterSymbol_qjwyxf_a5.length = spaceSymbol.length;
            }
        }
        astNode.setSymbol(words, alterSymbol_qjwyxf_a5);
        this.fireNonTerminalExit("TermItem", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleCategorized(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("Categorized");
        ASTNode astNode = new ASTNode(CATEGORIZED);
        int concatPosition_qjwyxf_a6 = inPosition;
        Symbol concatSymbol_qjwyxf_a6 = this.createConcatenationSymbol(concatPosition_qjwyxf_a6);
        CategoryHeadASTNode headSymbol = this.ruleCategoryHead(words, concatPosition_qjwyxf_a6, caret);
        astNode.addChild("head", (ASTNode)headSymbol);
        concatSymbol_qjwyxf_a6.append((Symbol)headSymbol);
        if (headSymbol.accepted) {
            concatSymbol_qjwyxf_a6.length += headSymbol.length;
            ASTNode nonTerminalSymbol_qjwyxf_b0g = this.ip_Punctuation.ruleoptSpace(words, concatPosition_qjwyxf_a6 += headSymbol.length, caret);
            astNode.addChild(null, nonTerminalSymbol_qjwyxf_b0g);
            concatSymbol_qjwyxf_a6.append((Symbol)nonTerminalSymbol_qjwyxf_b0g);
            if (nonTerminalSymbol_qjwyxf_b0g.accepted) {
                concatSymbol_qjwyxf_a6.length += nonTerminalSymbol_qjwyxf_b0g.length;
                Symbol alterSymbol_qjwyxf_c0g = this.createAlternationSymbol(concatPosition_qjwyxf_a6 += nonTerminalSymbol_qjwyxf_b0g.length);
                if (!alterSymbol_qjwyxf_c0g.accepted) {
                    Symbol alterSymbol_qjwyxf_a2a6 = this.createAlternationSymbol(concatPosition_qjwyxf_a6);
                    if (!alterSymbol_qjwyxf_a2a6.accepted) {
                        int concatPosition_qjwyxf_a0c0g = concatPosition_qjwyxf_a6;
                        Symbol concatSymbol_qjwyxf_a0c0g = this.createConcatenationSymbol(concatPosition_qjwyxf_a0c0g);
                        Symbol customSymbol_qjwyxf_a0a2a6 = this.createCustomSymbol(concatPosition_qjwyxf_a0c0g);
                        customSymbol_qjwyxf_a0a2a6.accepted = headSymbol.type == CategoryType.SORT;
                        concatSymbol_qjwyxf_a0c0g.append(customSymbol_qjwyxf_a0a2a6);
                        if (customSymbol_qjwyxf_a0a2a6.accepted) {
                            concatSymbol_qjwyxf_a0c0g.length += customSymbol_qjwyxf_a0a2a6.length;
                            ASTNode sortEndSymbol = this.ip_Predefined.ruleSortEnd(words, concatPosition_qjwyxf_a0c0g += customSymbol_qjwyxf_a0a2a6.length, caret);
                            astNode.addChild("sortEnd", sortEndSymbol);
                            concatSymbol_qjwyxf_a0c0g.append((Symbol)sortEndSymbol);
                            concatSymbol_qjwyxf_a0c0g.accepted = sortEndSymbol.accepted;
                            concatSymbol_qjwyxf_a0c0g.length += sortEndSymbol.length;
                        }
                        alterSymbol_qjwyxf_a2a6.accepted = concatSymbol_qjwyxf_a0c0g.accepted;
                        alterSymbol_qjwyxf_a2a6.append(concatSymbol_qjwyxf_a0c0g);
                        if (concatSymbol_qjwyxf_a0c0g.accepted) {
                            alterSymbol_qjwyxf_a2a6.length = concatSymbol_qjwyxf_a0c0g.length;
                        }
                    }
                    if (!alterSymbol_qjwyxf_a2a6.accepted) {
                        int concatPosition_qjwyxf_b0c0g = concatPosition_qjwyxf_a6;
                        Symbol concatSymbol_qjwyxf_b0c0g = this.createConcatenationSymbol(concatPosition_qjwyxf_b0c0g);
                        Symbol customSymbol_qjwyxf_a1a2a6 = this.createCustomSymbol(concatPosition_qjwyxf_b0c0g);
                        customSymbol_qjwyxf_a1a2a6.accepted = headSymbol.type == CategoryType.HAS;
                        concatSymbol_qjwyxf_b0c0g.append(customSymbol_qjwyxf_a1a2a6);
                        if (customSymbol_qjwyxf_a1a2a6.accepted) {
                            concatSymbol_qjwyxf_b0c0g.length += customSymbol_qjwyxf_a1a2a6.length;
                            ASTNode hasEndSymbol = this.ip_Predefined.ruleHasEnd(words, concatPosition_qjwyxf_b0c0g += customSymbol_qjwyxf_a1a2a6.length, caret, this.contextProjects);
                            astNode.addChild("hasEnd", hasEndSymbol);
                            concatSymbol_qjwyxf_b0c0g.append((Symbol)hasEndSymbol);
                            concatSymbol_qjwyxf_b0c0g.accepted = hasEndSymbol.accepted;
                            concatSymbol_qjwyxf_b0c0g.length += hasEndSymbol.length;
                        }
                        alterSymbol_qjwyxf_a2a6.accepted = concatSymbol_qjwyxf_b0c0g.accepted;
                        alterSymbol_qjwyxf_a2a6.append(concatSymbol_qjwyxf_b0c0g);
                        if (concatSymbol_qjwyxf_b0c0g.accepted) {
                            alterSymbol_qjwyxf_a2a6.length = concatSymbol_qjwyxf_b0c0g.length;
                        }
                    }
                    if (!alterSymbol_qjwyxf_a2a6.accepted) {
                        int concatPosition_qjwyxf_c0c0g = concatPosition_qjwyxf_a6;
                        Symbol concatSymbol_qjwyxf_c0c0g = this.createConcatenationSymbol(concatPosition_qjwyxf_c0c0g);
                        Symbol customSymbol_qjwyxf_a2a2a6 = this.createCustomSymbol(concatPosition_qjwyxf_c0c0g);
                        customSymbol_qjwyxf_a2a2a6.accepted = headSymbol.type == CategoryType.SEARCH;
                        concatSymbol_qjwyxf_c0c0g.append(customSymbol_qjwyxf_a2a2a6);
                        if (customSymbol_qjwyxf_a2a2a6.accepted) {
                            concatSymbol_qjwyxf_c0c0g.length += customSymbol_qjwyxf_a2a2a6.length;
                            ASTNode valueEndSymbol = this.ip_Category.ruleNamedAttributeEnd(words, concatPosition_qjwyxf_c0c0g += customSymbol_qjwyxf_a2a2a6.length, caret, this.contextProjects, headSymbol.fields);
                            astNode.addChild("valueEnd", valueEndSymbol);
                            concatSymbol_qjwyxf_c0c0g.append((Symbol)valueEndSymbol);
                            concatSymbol_qjwyxf_c0c0g.accepted = valueEndSymbol.accepted;
                            concatSymbol_qjwyxf_c0c0g.length += valueEndSymbol.length;
                        }
                        alterSymbol_qjwyxf_a2a6.accepted = concatSymbol_qjwyxf_c0c0g.accepted;
                        alterSymbol_qjwyxf_a2a6.append(concatSymbol_qjwyxf_c0c0g);
                        if (concatSymbol_qjwyxf_c0c0g.accepted) {
                            alterSymbol_qjwyxf_a2a6.length = concatSymbol_qjwyxf_c0c0g.length;
                        }
                    }
                    alterSymbol_qjwyxf_c0g.accepted = alterSymbol_qjwyxf_a2a6.accepted;
                    alterSymbol_qjwyxf_c0g.append(alterSymbol_qjwyxf_a2a6);
                    if (alterSymbol_qjwyxf_a2a6.accepted) {
                        alterSymbol_qjwyxf_c0g.length = alterSymbol_qjwyxf_a2a6.length;
                    }
                }
                concatSymbol_qjwyxf_a6.append(alterSymbol_qjwyxf_c0g);
                concatSymbol_qjwyxf_a6.accepted = alterSymbol_qjwyxf_c0g.accepted;
                concatSymbol_qjwyxf_a6.length += alterSymbol_qjwyxf_c0g.length;
            }
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a6);
        this.fireNonTerminalExit("Categorized", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public CategoryHeadASTNode ruleCategoryHead(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("CategoryHead");
        CategoryHeadASTNode astNode = new CategoryHeadASTNode(CATEGORY_HEAD);
        int concatPosition_qjwyxf_a7 = inPosition;
        Symbol concatSymbol_qjwyxf_a7 = this.createConcatenationSymbol(concatPosition_qjwyxf_a7);
        TreeSearchParser.TreeValueGreedASTNode fieldSymbol = this.ip_TreeSearch.ruleTreeValueGreed(words, concatPosition_qjwyxf_a7, caret, (Iterable<String>)Sequence.singleton((Object)"CATEGORY"), this.createLocalPredicate(caret, FilterCategoryPredicate.get(caret >= 0)), SuggestProcessor.CATEGORY_PROCESSOR, "keyword");
        astNode.addChild("field", fieldSymbol);
        concatSymbol_qjwyxf_a7.append((Symbol)fieldSymbol);
        if (fieldSymbol.accepted) {
            concatSymbol_qjwyxf_a7.length += fieldSymbol.length;
            Symbol terminalSymbol_qjwyxf_b0h = this.createTerminalSymbol(words, concatPosition_qjwyxf_a7 += fieldSymbol.length, ":", caret, "", false);
            concatSymbol_qjwyxf_a7.append(terminalSymbol_qjwyxf_b0h);
            if (terminalSymbol_qjwyxf_b0h.accepted) {
                concatSymbol_qjwyxf_a7.length += terminalSymbol_qjwyxf_b0h.length;
                Symbol customSymbol_qjwyxf_c0h = this.createCustomSymbol(concatPosition_qjwyxf_a7 += terminalSymbol_qjwyxf_b0h.length);
                astNode.fieldAlias = Word.toString(words, (int)fieldSymbol.position, (int)(fieldSymbol.position + fieldSymbol.length - 1));
                astNode.fields = SetSequence.fromSetWithValues(new LinkedHashSet(), (Iterable)ListSequence.fromList(fieldSymbol.treeValues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Object>(){

                    public boolean accept(Object it) {
                        return it instanceof BaseFieldNode && ((BaseFieldNode)it).isPrimary();
                    }
                }).select((_FunctionTypes._return_P1_E0)new ISelector<Object, IField>(){

                    public IField select(Object it) {
                        return ((BaseFieldNode)it).getField();
                    }
                }).sort((_FunctionTypes._return_P1_E0)new ISelector<IField, Comparable<?>>(){

                    public Comparable<?> select(IField it) {
                        return it.getOrdinal();
                    }
                }, true));
                astNode.type = CategoryType.fromField((IField)Sequence.fromIterable(astNode.fields).first());
                concatSymbol_qjwyxf_a7.append(customSymbol_qjwyxf_c0h);
                concatSymbol_qjwyxf_a7.accepted = customSymbol_qjwyxf_c0h.accepted;
                concatSymbol_qjwyxf_a7.length += customSymbol_qjwyxf_c0h.length;
            }
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a7);
        this.fireNonTerminalExit("CategoryHead", astNode.accepted, words, inPosition, astNode.length);
        astNode.setAtom(true, true);
        return astNode;
    }

    public ASTNode rulePositiveAloneValue(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("PositiveAloneValue");
        ASTNode astNode = new ASTNode(POSITIVE_ALONE_VALUE);
        int concatPosition_qjwyxf_a8 = inPosition;
        Symbol concatSymbol_qjwyxf_a8 = this.createConcatenationSymbol(concatPosition_qjwyxf_a8);
        Symbol terminalSymbol_qjwyxf_a0i = this.createTerminalSymbol(words, concatPosition_qjwyxf_a8, "#", caret, "SearchRequest.filter_by_value", false);
        concatSymbol_qjwyxf_a8.append(terminalSymbol_qjwyxf_a0i);
        if (terminalSymbol_qjwyxf_a0i.accepted) {
            concatSymbol_qjwyxf_a8.length += terminalSymbol_qjwyxf_a0i.length;
            ASTNode nonTerminalSymbol_qjwyxf_b0i = this.ip_Punctuation.rulenoSpaceNoEof(words, concatPosition_qjwyxf_a8 += terminalSymbol_qjwyxf_a0i.length, caret);
            astNode.addChild(null, nonTerminalSymbol_qjwyxf_b0i);
            concatSymbol_qjwyxf_a8.append((Symbol)nonTerminalSymbol_qjwyxf_b0i);
            if (nonTerminalSymbol_qjwyxf_b0i.accepted) {
                concatSymbol_qjwyxf_a8.length += nonTerminalSymbol_qjwyxf_b0i.length;
                AloneValueASTNode valueSymbol = this.ruleAloneValue(words, concatPosition_qjwyxf_a8 += nonTerminalSymbol_qjwyxf_b0i.length, caret);
                astNode.addChild("value", (ASTNode)valueSymbol);
                concatSymbol_qjwyxf_a8.append((Symbol)valueSymbol);
                concatSymbol_qjwyxf_a8.accepted = valueSymbol.accepted;
                concatSymbol_qjwyxf_a8.length += valueSymbol.length;
            }
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a8);
        this.fireNonTerminalExit("PositiveAloneValue", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public ASTNode ruleNegativeAloneValue(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("NegativeAloneValue");
        ASTNode astNode = new ASTNode(NEGATIVE_ALONE_VALUE);
        int concatPosition_qjwyxf_a9 = inPosition;
        Symbol concatSymbol_qjwyxf_a9 = this.createConcatenationSymbol(concatPosition_qjwyxf_a9);
        Symbol terminalSymbol_qjwyxf_a0j = this.createTerminalSymbol(words, concatPosition_qjwyxf_a9, "-", caret, "SearchRequest.exclude_value", false);
        concatSymbol_qjwyxf_a9.append(terminalSymbol_qjwyxf_a0j);
        if (terminalSymbol_qjwyxf_a0j.accepted) {
            concatSymbol_qjwyxf_a9.length += terminalSymbol_qjwyxf_a0j.length;
            ASTNode nonTerminalSymbol_qjwyxf_b0j = this.ip_Punctuation.rulenoSpaceNoEof(words, concatPosition_qjwyxf_a9 += terminalSymbol_qjwyxf_a0j.length, caret);
            astNode.addChild(null, nonTerminalSymbol_qjwyxf_b0j);
            concatSymbol_qjwyxf_a9.append((Symbol)nonTerminalSymbol_qjwyxf_b0j);
            if (nonTerminalSymbol_qjwyxf_b0j.accepted) {
                concatSymbol_qjwyxf_a9.length += nonTerminalSymbol_qjwyxf_b0j.length;
                AloneValueASTNode valueSymbol = this.ruleAloneValue(words, concatPosition_qjwyxf_a9 += nonTerminalSymbol_qjwyxf_b0j.length, caret);
                astNode.addChild("value", (ASTNode)valueSymbol);
                concatSymbol_qjwyxf_a9.append((Symbol)valueSymbol);
                concatSymbol_qjwyxf_a9.accepted = valueSymbol.accepted;
                concatSymbol_qjwyxf_a9.length += valueSymbol.length;
            }
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a9);
        this.fireNonTerminalExit("NegativeAloneValue", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public AloneValueASTNode ruleAloneValue(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("AloneValue");
        AloneValueASTNode astNode = new AloneValueASTNode(ALONE_VALUE);
        int concatPosition_qjwyxf_a01 = inPosition;
        Symbol concatSymbol_qjwyxf_a01 = this.createConcatenationSymbol(concatPosition_qjwyxf_a01);
        ValueParser.ValueASTNode valueSymbol = this.ip_Value.ruleValue(words, concatPosition_qjwyxf_a01, caret, this.aloneValueTreeKeys, this.contextProjects, null, this.valuePredicate, SuggestProcessor.ALONE_VALUE_PROCESSOR);
        astNode.addChild("value", valueSymbol);
        concatSymbol_qjwyxf_a01.append((Symbol)valueSymbol);
        if (valueSymbol.accepted) {
            concatSymbol_qjwyxf_a01.length += valueSymbol.length;
            Symbol customSymbol_qjwyxf_b0k = this.createCustomSymbol(concatPosition_qjwyxf_a01 += valueSymbol.length);
            if (valueSymbol.badIdentifier) {
                astNode.error = new ParseErrorImpl(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SearchRequest.Can_t_find_value_{0}", new Object[]{valueSymbol.identifier}));
            } else if (valueSymbol.length == 0) {
                astNode.error = new ParseErrorImpl(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SearchRequest.Value_is_expected", new Object[0]));
            } else {
                astNode.filterValues = valueSymbol.treeValues;
            }
            concatSymbol_qjwyxf_a01.append(customSymbol_qjwyxf_b0k);
            concatSymbol_qjwyxf_a01.accepted = customSymbol_qjwyxf_b0k.accepted;
            concatSymbol_qjwyxf_a01.length += customSymbol_qjwyxf_b0k.length;
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a01);
        this.fireNonTerminalExit("AloneValue", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public IssueASTNode ruleIssue(List<Word> words, int inPosition, int caret) {
        this.fireNonTerminalEnter("Issue");
        IssueASTNode astNode = new IssueASTNode(ISSUE);
        int concatPosition_qjwyxf_a11 = inPosition;
        Symbol concatSymbol_qjwyxf_a11 = this.createConcatenationSymbol(concatPosition_qjwyxf_a11);
        Symbol customSymbol_qjwyxf_a0l = this.createCustomSymbol(concatPosition_qjwyxf_a11);
        customSymbol_qjwyxf_a0l.accepted = caret < 0;
        concatSymbol_qjwyxf_a11.append(customSymbol_qjwyxf_a0l);
        if (customSymbol_qjwyxf_a0l.accepted) {
            concatSymbol_qjwyxf_a11.length += customSymbol_qjwyxf_a0l.length;
            ValueParser.ValueASTNode valueSymbol = this.ip_Value.ruleValue(words, concatPosition_qjwyxf_a11 += customSymbol_qjwyxf_a0l.length, caret, (Iterable<String>)Sequence.singleton((Object)"ISSUE_ID"), this.contextProjects, null, this.valuePredicate, SuggestProcessor.VALUE_PROCESSOR);
            astNode.addChild("value", valueSymbol);
            concatSymbol_qjwyxf_a11.append((Symbol)valueSymbol);
            if (valueSymbol.accepted) {
                concatSymbol_qjwyxf_a11.length += valueSymbol.length;
                Symbol customSymbol_qjwyxf_c0l = this.createCustomSymbol(concatPosition_qjwyxf_a11 += valueSymbol.length);
                if (ListSequence.fromList(valueSymbol.treeValues).isNotEmpty()) {
                    astNode.issueValue = (IFieldValue)ListSequence.fromList(valueSymbol.treeValues).first();
                } else {
                    customSymbol_qjwyxf_c0l.accepted = false;
                }
                concatSymbol_qjwyxf_a11.append(customSymbol_qjwyxf_c0l);
                concatSymbol_qjwyxf_a11.accepted = customSymbol_qjwyxf_c0l.accepted;
                concatSymbol_qjwyxf_a11.length += customSymbol_qjwyxf_c0l.length;
            }
        }
        astNode.setSymbol(words, concatSymbol_qjwyxf_a11);
        this.fireNonTerminalExit("Issue", astNode.accepted, words, inPosition, astNode.length);
        return astNode;
    }

    public void reuse(ParseResult node) {
        this.searchRequestNode = node;
        this.resetContextProjects();
    }

    private void resetContextProjects() {
        this.contextProjects = this.context.getContextProjects();
    }

    private void addContextProjectForCategorized(ASTNode categorized) {
        ISetSequence projects = SetSequence.fromSet(new HashSet());
        for (CategoryParser.CategoryValueASTNode categoryValue : ASTUtilExtensions.getCategoryValues(categorized)) {
            for (CategoryParser.CategoryFieldASTNode categoryField : Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categoryValue, (String)"leftValue")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((Iterable)ASTNode.getChildren((ASTNode)categoryValue, (String)"rangeEnd"), (String)"rightValue")))) {
                if (!SearchRequestParser.eq_8mjioj_a0a0a0c0p(categoryField.field, (IField)ServiceLocator.getBean((String)"predefinedFieldProject"))) continue;
                for (IFieldValue fieldValue : ListSequence.fromList(categoryField.fieldValues)) {
                    if (!(fieldValue instanceof IProjectFieldValue) || !categoryValue.pos) continue;
                    SetSequence.fromSet((Set)projects).addElement((Object)((IProjectFieldValue)fieldValue).getProject());
                }
            }
        }
        if (!QueryOperations.isEmpty((Iterable)projects)) {
            SetSequence.fromSet((Set)projects).addSequence((ISequence)CollectionSequence.fromCollection(this.contextProjects));
            this.contextProjects = projects;
        }
    }

    private void addContextProjectForAloneValue(ASTNode value) {
        IFieldValue fieldValue = (IFieldValue)Sequence.fromIterable(((AloneValueASTNode)((Object)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)value, (String)"value")).first())).filterValues).first();
        if (fieldValue == null) {
            return;
        }
        if (!(fieldValue instanceof IProjectFieldValue)) {
            return;
        }
        Entity maybeProject = ((IProjectFieldValue)fieldValue).getProject();
        if (!Sequence.fromIterable((Iterable)fieldValue.getAloneField().getIdsForFieldValue(fieldValue, this.context)).contains((Object)((IField)ServiceLocator.getBean((String)"predefinedFieldProject")).getUniqueId())) {
            return;
        }
        Collection<Entity> current = this.contextProjects;
        if (current == null) {
            this.contextProjects = new NanoSet((Object)DnqUtils.cast((Object)maybeProject, (String)"Project"));
        } else {
            HashSet<Entity> updated = new HashSet<Entity>(current);
            updated.add(DnqUtils.cast((Object)maybeProject, (String)"Project"));
            this.contextProjects = updated;
        }
    }

    private IPredicate createLocalPredicate(int caret, IPredicate localPredicate) {
        MatchProjectsAndCategoryPredicate matchProjectsAndCategoryPredicate = new MatchProjectsAndCategoryPredicate(this.context, caret >= 0 ? IContext.Activity.SUGGESTING_QUERY : IContext.Activity.PARSING_QUERY, this.contextProjects, null);
        return localPredicate != null ? new AndPredicate(new IPredicate[]{localPredicate, matchProjectsAndCategoryPredicate}) : matchProjectsAndCategoryPredicate;
    }

    protected BaseParser[] getImportedParsers() {
        return new BaseParser[]{this.ip_TreeSearch, this.ip_Punctuation, this.ip_Predefined, this.ip_Value, this.ip_Text, this.ip_Category};
    }

    private static boolean eq_8mjioj_a0a0a0c0p(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public static class IssueASTNode
    extends ASTNode {
        public IFieldValue issueValue;

        public IssueASTNode(ASTType astType) {
            super(astType);
        }
    }

    public static class AloneValueASTNode
    extends ASTNode {
        public Iterable<IFieldValue> filterValues;
        public ParseErrorImpl error;

        public AloneValueASTNode(ASTType astType) {
            super(astType);
        }
    }

    public static class CategoryHeadASTNode
    extends ASTNode {
        public String fieldAlias;
        public Iterable<IField> fields;
        public CategoryType type;

        public CategoryHeadASTNode(ASTType astType) {
            super(astType);
        }
    }
}

