/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldNode;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.LocalContext;
import jetbrains.youtrack.api.parser.Suggestable;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.search.parser.RenderingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestProcessor {
    public static final SuggestProcessor CATEGORY_PROCESSOR = new SuggestProcessor(null, ": ");
    public static final SuggestProcessor TEXT_ALONE_VALUE_PROCESSOR = new SuggestProcessor("#", " ", "#{", "} ");
    public static final SuggestProcessor VALUE_PROCESSOR;
    public static final SuggestProcessor SORT_FIELD_PROCESSOR;
    public static final SuggestProcessor HAS_FIELD_PROCESSOR;
    public static final SuggestProcessor ALONE_VALUE_PROCESSOR;
    private String simplePrefix;
    private String simpleSuffix;
    private String complexPrefix;
    private String complexSuffix;

    public SuggestProcessor() {
    }

    public SuggestProcessor(String prefix, String suffix) {
        this.simplePrefix = prefix;
        this.simpleSuffix = suffix;
        this.complexPrefix = prefix;
        this.complexSuffix = suffix;
    }

    public SuggestProcessor(String simplePrefix, String simpleSuffix, String complexPrefix, String complexSuffix) {
        this.simplePrefix = simplePrefix;
        this.simpleSuffix = simpleSuffix;
        this.complexPrefix = complexPrefix;
        this.complexSuffix = complexSuffix;
    }

    @Nullable
    public Suggestion getSuggestion(@NotNull LocalContext context, Suggestable suggestable, String matching, int completionStart, int completionEnd) {
        Suggestion suggestion = this.createSuggestion(context, suggestable, matching, completionStart, completionEnd);
        if (suggestion == null) {
            return null;
        }
        if (RenderingUtil.isComplexIdentifier(suggestion.getOption())) {
            suggestion.setPrefix(this.complexPrefix);
            suggestion.setSuffix(this.complexSuffix);
        } else {
            suggestion.setPrefix(this.simplePrefix);
            suggestion.setSuffix(this.simpleSuffix);
        }
        return suggestion;
    }

    @Nullable
    protected Suggestion createSuggestion(@NotNull LocalContext context, Suggestable suggestable, String matching, int completionStart, int completionEnd) {
        return suggestable.getSuggestion(context, matching, completionStart, completionEnd);
    }

    static {
        SORT_FIELD_PROCESSOR = VALUE_PROCESSOR = new SuggestProcessor(null, " ", "{", "} ");
        HAS_FIELD_PROCESSOR = new SuggestProcessor(null, " ", "{", "} "){

            @Override
            protected Suggestion createSuggestion(@NotNull LocalContext context, Suggestable suggestable, String matching, int completionStart, int completionEnd) {
                if (suggestable instanceof BaseFieldNode) {
                    BaseFieldNode fieldNode = (BaseFieldNode)suggestable;
                    return fieldNode.getSuggestion(matching, completionStart, completionEnd, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("SuggestProcessor.has_{field_name}", new Object[]{fieldNode.getFieldAlias().getAlias()}));
                }
                return super.createSuggestion(context, suggestable, matching, completionStart, completionEnd);
            }
        };
        ALONE_VALUE_PROCESSOR = VALUE_PROCESSOR;
    }
}

