/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser;

import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistent.IssueFieldValue;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.context.ASTNode;
import jetbrains.mps.parser.runtime.context.ASTType;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.search.keyword.TextSearchValue;
import jetbrains.youtrack.search.parser.ASTUtilExtensions;
import jetbrains.youtrack.search.parser.CategoryParser;
import jetbrains.youtrack.search.parser.SearchRequestParser;
import jetbrains.youtrack.search.parser.TextParser;

public class TextSearchAnalyzer {
    public static Iterable<String> getTextSearch(ASTNode _this, final IField field) {
        IListSequence queryWords = ListSequence.fromList(new ArrayList());
        if (_this != null) {
            Sequence.fromIterable(ASTUtilExtensions.getTermItems(_this)).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>((List)queryWords){
                final /* synthetic */ List val$queryWords;
                {
                    this.val$queryWords = list;
                }

                public void visit(ASTNode it) {
                    TextSearchAnalyzer.addQueryWords(it, field, this.val$queryWords);
                }
            });
        }
        return queryWords;
    }

    public static Iterable<Entity> getLooksLikeSearch(ASTNode _this, final IField field) {
        IListSequence queryWords = ListSequence.fromList(new ArrayList());
        if (_this != null) {
            Sequence.fromIterable(ASTUtilExtensions.getTermItems(_this)).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ASTNode>((List)queryWords){
                final /* synthetic */ List val$queryWords;
                {
                    this.val$queryWords = list;
                }

                public void visit(ASTNode it) {
                    TextSearchAnalyzer.addLooksLike(it, field, this.val$queryWords);
                }
            });
        }
        return queryWords;
    }

    public static String getQuery(ASTNode _this) {
        return TextSearchAnalyzer.getQueryForText((ASTNode)Sequence.fromIterable((Iterable)_this.children(new ASTType[0])).first());
    }

    public static boolean isPositiveText(ASTNode _this) {
        ASTNode _calculatedNode = (ASTNode)Sequence.fromIterable((Iterable)_this.children(new ASTType[0])).first();
        if (_calculatedNode.hasType(TextParser.QUOTED_TEXT)) {
            TextParser.QuotedTextASTNode quotedText = (TextParser.QuotedTextASTNode)_calculatedNode;
            return true;
        }
        if (_calculatedNode.hasType(TextParser.NEGATIVE_TEXT)) {
            ASTNode negativeText = _calculatedNode;
            return false;
        }
        if (_calculatedNode.hasType(TextParser.TEXT)) {
            TextParser.TextASTNode text = (TextParser.TextASTNode)_calculatedNode;
            return true;
        }
        ASTNode any = _calculatedNode;
        throw new UnsupportedOperationException("Can't say if node " + any + " is positive text");
    }

    private static String getQueryForText(ASTNode _this) {
        ASTNode _calculatedNode = _this;
        if (_calculatedNode.hasType(TextParser.QUOTED_TEXT)) {
            TextParser.QuotedTextASTNode quotedText = (TextParser.QuotedTextASTNode)_calculatedNode;
            return '\"' + quotedText.queryWord + '\"';
        }
        if (_calculatedNode.hasType(TextParser.NEGATIVE_TEXT)) {
            ASTNode negativeText = _calculatedNode;
            return TextSearchAnalyzer.getQueryForText((ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)negativeText, (String)"quotedText")).first());
        }
        if (_calculatedNode.hasType(TextParser.TEXT)) {
            TextParser.TextASTNode text = (TextParser.TextASTNode)_calculatedNode;
            return text.queryWord;
        }
        ASTNode any = _calculatedNode;
        return null;
    }

    private static void addQueryWords(ASTNode _this, IField field, List<String> queryWords) {
        ASTNode _calculatedNode = (ASTNode)Sequence.fromIterable((Iterable)_this.children(new ASTType[0])).first();
        if (_calculatedNode.hasType(TextParser.QUOTED_TEXT)) {
            TextParser.QuotedTextASTNode qt = (TextParser.QuotedTextASTNode)_calculatedNode;
            ListSequence.fromList(queryWords).addElement((Object)('\"' + qt.queryWord + '\"'));
        } else if (_calculatedNode.hasType(TextParser.TEXT)) {
            TextParser.TextASTNode text = (TextParser.TextASTNode)_calculatedNode;
            ListSequence.fromList(queryWords).addElement((Object)text.queryWord);
        } else if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
            ASTNode categorized = _calculatedNode;
            ASTNode valueEnd = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd")).first();
            for (CategoryParser.CategoryFieldASTNode value : ASTNode.getChildren((Iterable)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueEnd, (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueEnd, (String)"tail"))), (String)"leftValue")) {
                if (field != null && !TextSearchAnalyzer.eq_smzwct_a0a0a2a1b0a0f(field, value.field)) continue;
                for (IFieldValue fieldValue : ListSequence.fromList(value.fieldValues)) {
                    if (!(fieldValue instanceof TextSearchValue)) continue;
                    TextSearchValue creator = (TextSearchValue)fieldValue;
                    ListSequence.fromList(queryWords).addElement((Object)creator.getFieldValue());
                }
            }
        }
    }

    private static void addLooksLike(ASTNode _this, IField field, List<Entity> queryWords) {
        ASTNode _calculatedNode = (ASTNode)Sequence.fromIterable((Iterable)_this.children(new ASTType[0])).first();
        if (_calculatedNode.hasType(SearchRequestParser.CATEGORIZED)) {
            ASTNode categorized = _calculatedNode;
            ASTNode valueEnd = (ASTNode)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)categorized, (String)"valueEnd")).first();
            for (CategoryParser.CategoryFieldASTNode value : ASTNode.getChildren((Iterable)Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueEnd, (String)"head")).concat(Sequence.fromIterable((Iterable)ASTNode.getChildren((ASTNode)valueEnd, (String)"tail"))), (String)"leftValue")) {
                if (!TextSearchAnalyzer.eq_smzwct_a0a0c0b0a0g(field, value.field)) continue;
                for (IFieldValue fieldValue : ListSequence.fromList(value.fieldValues)) {
                    if (!(fieldValue instanceof IssueFieldValue)) continue;
                    IssueFieldValue creator = (IssueFieldValue)fieldValue;
                    ListSequence.fromList(queryWords).addElement((Object)creator.getIssueEntity());
                }
            }
        }
    }

    private static boolean eq_smzwct_a0a0a2a1b0a0f(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_smzwct_a0a0c0b0a0g(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

