/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.search.parser.predicate;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueFieldValue;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.parser.filterCreator.ProjectContextual;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.parser.runtime.prefixTree.IPredicate;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;

public class CanReadIssuePredicate
implements IPredicate<Object> {
    private static CanReadIssuePredicate instance = new CanReadIssuePredicate();

    public boolean matches(Object value) {
        Entity project;
        if (value instanceof ProjectContextual && !EntityOperations.equals((Entity)(project = ((ProjectContextual)value).getMatchingProject()), null)) {
            Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission(Permission.READ_PROJECT_BASIC, project, currentUser)) {
                return false;
            }
            if (value instanceof IssueFieldValue) {
                Entity issue = ((IssueFieldValue)value).getIssueEntity();
                return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, currentUser, issue);
            }
            return true;
        }
        return true;
    }

    public static CanReadIssuePredicate get() {
        return instance;
    }
}

