/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.vfs.IOCancellingPolicy;
import jetbrains.exodus.vfs.IOCancellingPolicyProvider;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import org.jetbrains.annotations.NotNull;

class CancellingPolicyProvider
implements IOCancellingPolicyProvider {
    private static final TrivialPolicy TRIVIAL_POLICY = new TrivialPolicy();
    @NotNull
    private final TextIndexManagerImpl tim;

    CancellingPolicyProvider(@NotNull TextIndexManagerImpl tim) {
        this.tim = tim;
    }

    @NotNull
    public IOCancellingPolicy getPolicy() {
        QueryCancellingPolicy txnCancellingPolicy;
        QueryCancellingPolicy sessionCancellingPolicy;
        TransientEntityStore store = this.tim.getTransientStore();
        TransientStoreSession session = store.getThreadSession();
        QueryCancellingPolicy queryCancellingPolicy = sessionCancellingPolicy = session != null ? session.getQueryCancellingPolicy() : null;
        if (sessionCancellingPolicy != null) {
            return new IOCancellingPolicy(){

                public boolean needToCancel() {
                    return sessionCancellingPolicy.needToCancel();
                }

                public void doCancel() {
                    sessionCancellingPolicy.doCancel();
                }
            };
        }
        StoreTransaction txn = store.getPersistentStore().getCurrentTransaction();
        QueryCancellingPolicy queryCancellingPolicy2 = txnCancellingPolicy = txn != null ? txn.getQueryCancellingPolicy() : null;
        if (txnCancellingPolicy != null) {
            return new IOCancellingPolicy(){

                public boolean needToCancel() {
                    return txnCancellingPolicy.needToCancel();
                }

                public void doCancel() {
                    txnCancellingPolicy.doCancel();
                }
            };
        }
        return TRIVIAL_POLICY;
    }

    private static class TrivialPolicy
    implements IOCancellingPolicy {
        private TrivialPolicy() {
        }

        public boolean needToCancel() {
            return false;
        }

        public void doCancel() {
        }
    }
}

