/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.io.IOException;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.youtrack.textindex.SearchSection;
import jetbrains.youtrack.textindex.TextIndexManagerBase;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import jetbrains.youtrack.textindex.api.HitsEntityIterable;
import org.apache.lucene.index.CorruptIndexException;
import org.jetbrains.annotations.NotNull;

public abstract class HitsEntityIterableBase
extends EntityIterableBase
implements HitsEntityIterable {
    @NotNull
    protected final TextIndexManagerImpl textIndexManager;
    final int entityTypeId;

    public HitsEntityIterableBase(@NotNull TextIndexManagerImpl textIndexManager, int entityTypeId) {
        super(textIndexManager.getPersistentStore().getAndCheckCurrentTransaction());
        this.textIndexManager = textIndexManager;
        this.entityTypeId = entityTypeId;
    }

    public int getEntityTypeId() {
        return this.entityTypeId >= 0 ? this.entityTypeId : super.getEntityTypeId();
    }

    EntityIterator optimisticGetIterator(int attempts, GetIteratorFunction getIterator) {
        Throwable e = null;
        for (int i = 0; i < attempts; ++i) {
            block19: {
                Throwable throwable = null;
                try (SearchSection ignored = new SearchSection(this.textIndexManager);){
                    EntityIterator entityIterator = getIterator.get();
                    return entityIterator;
                }
                catch (IOException ioe) {
                    e = ioe;
                    TextIndexManagerBase.log.warn((Object)("Failed to get HitsEntityIterator, attempt = " + i), (Throwable)ioe);
                    if (ioe instanceof CorruptIndexException) {
                        if (ioe.getCause() == null) {
                            this.textIndexManager.checkIndex();
                        }
                        break block19;
                    }
                    throw ExodusException.toExodusException((Throwable)(e.getCause() == null ? e : e.getCause()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            this.textIndexManager.clearIndexReaders();
        }
        throw ExodusException.toExodusException((Throwable)(e.getCause() == null ? e : e.getCause()));
    }

    protected static interface GetIteratorFunction {
        public EntityIterator get() throws IOException;
    }
}

