/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.io.IOException;
import java.util.Arrays;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.youtrack.textindex.DocumentBooster;
import jetbrains.youtrack.textindex.HitsEntityIterableBase;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HitsEntityIterator
extends EntityIteratorBase
implements PropertyValueIterator {
    static final boolean STATIC_BOOST = !Boolean.getBoolean("jetbrains.dnq.textIndex.staticBoostOff");
    private static final boolean DYNAMIC_BOOST = Boolean.getBoolean("jetbrains.dnq.textIndex.dynamicBoost");
    private static final int MAX_SCORE_MULTIPLE = Integer.getInteger("jetbrains.dnq.textIndex.maxScoreMultiple", 3);
    private final TopDocs docs;
    private final EntityId[] entityIds;
    private int pos;

    HitsEntityIterator(@NotNull HitsEntityIterableBase iterable, @NotNull Query query, @NotNull IndexSearcher indexSearcher, @NotNull Document2EntityIdConverter doc2idFun, boolean dynamicBoostAllowed, @Nullable Float threshold) throws IOException {
        super((EntityIterableBase)iterable);
        this.docs = indexSearcher.search(query, Integer.MAX_VALUE);
        int totalHits = (int)this.docs.totalHits;
        this.entityIds = new EntityId[totalHits];
        if (dynamicBoostAllowed && DYNAMIC_BOOST) {
            ScoreDoc scoreDoc;
            int i;
            IntHashMap docs2Ids = new IntHashMap(totalHits);
            for (int i2 = 0; i2 < totalHits; ++i2) {
                int doc = this.docs.scoreDocs[i2].doc;
                docs2Ids.put(doc, (Object)doc2idFun.getId(indexSearcher.doc(doc, TextIndexManagerImpl.ENTITY_ID_FIELD_SET)));
            }
            DocumentBooster booster = iterable.textIndexManager.getDocumentBooster();
            PersistentEntityStoreImpl store = iterable.getStore();
            for (i = 0; i < totalHits; ++i) {
                scoreDoc = this.docs.scoreDocs[i];
                scoreDoc.score *= booster.getBoost((Entity)store.getEntity((EntityId)docs2Ids.get(scoreDoc.doc)));
            }
            for (i = 0; i < totalHits; ++i) {
                scoreDoc = this.docs.scoreDocs[i];
                scoreDoc.score = (float)((int)(scoreDoc.score * 20.0f)) / 20.0f;
            }
            Arrays.sort(this.docs.scoreDocs, (o1, o2) -> {
                int result = Float.compare(o2.score, o1.score);
                return result != 0 ? result : Integer.compare(o1.doc, o2.doc);
            });
            this.fillEntityIds(arg_0 -> ((IntHashMap)docs2Ids).get(arg_0), threshold);
        } else {
            this.fillEntityIds(docId -> doc2idFun.getId(indexSearcher.doc(docId, TextIndexManagerImpl.ENTITY_ID_FIELD_SET)), threshold);
        }
        this.pos = -1;
    }

    private void fillEntityIds(@NotNull DocId2EntityIdConverter docId2idFun, @Nullable Float threshold) throws IOException {
        int totalHits = (int)this.docs.totalHits;
        if (threshold == null) {
            for (int i = 0; i < totalHits; ++i) {
                this.entityIds[i] = docId2idFun.getId(this.docs.scoreDocs[i].doc);
            }
        } else {
            float adjustedThreshold = threshold.floatValue();
            boolean adjust = true;
            for (int i = 0; i < totalHits; ++i) {
                ScoreDoc scoreDoc = this.docs.scoreDocs[i];
                EntityId id = docId2idFun.getId(scoreDoc.doc);
                if (id == null) continue;
                if (adjust) {
                    adjust = false;
                    this.entityIds[i] = id;
                    adjustedThreshold = Math.max(threshold.floatValue(), scoreDoc.score / (float)MAX_SCORE_MULTIPLE);
                    continue;
                }
                if (!(scoreDoc.score < adjustedThreshold)) {
                    this.entityIds[i] = id;
                    continue;
                }
                break;
            }
        }
    }

    protected boolean hasNextImpl() {
        while (this.pos < this.entityIds.length - 1) {
            if (this.entityIds[this.pos + 1] != null) {
                return true;
            }
            ++this.pos;
        }
        return false;
    }

    @Nullable
    protected EntityId nextIdImpl() {
        return this.entityIds[++this.pos];
    }

    @Nullable
    public Comparable currentValue() {
        return Float.valueOf(this.docs.scoreDocs[this.pos].score);
    }

    private static interface DocId2EntityIdConverter {
        @Nullable
        public EntityId getId(int var1) throws IOException;
    }

    static interface Document2EntityIdConverter {
        @Nullable
        public EntityId getId(@NotNull Document var1);
    }
}

