/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.youtrack.textindex.HitsEntityIterableBase;
import jetbrains.youtrack.textindex.HitsEntityIterableHandleBase;
import jetbrains.youtrack.textindex.HitsEntityIterator;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;

final class SearchResultsEntityIterable
extends HitsEntityIterableBase
implements HitsEntityIterator.Document2EntityIdConverter {
    @NotNull
    private final Query query;
    @NotNull
    private final String queryString;

    SearchResultsEntityIterable(@NotNull TextIndexManagerImpl manager, @NotNull Query query, int entityTypeId) {
        super(manager, entityTypeId);
        this.query = query;
        this.queryString = query.toString();
    }

    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new HitsEntityIterableHandleBase((PersistentEntityStore)this.getStore()){

            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append("search-");
                builder.append(SearchResultsEntityIterable.this.queryString);
                if (SearchResultsEntityIterable.this.entityTypeId >= 0) {
                    builder.append('-');
                    builder.append(SearchResultsEntityIterable.this.entityTypeId);
                }
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply("search-");
                hash.apply(SearchResultsEntityIterable.this.queryString);
                if (SearchResultsEntityIterable.this.entityTypeId >= 0) {
                    hash.applyDelimiter();
                    hash.apply(SearchResultsEntityIterable.this.entityTypeId);
                }
            }
        };
    }

    public boolean isSortedById() {
        return false;
    }

    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return this.optimisticGetIterator(10, () -> new HitsEntityIterator(this, this.query, this.textIndexManager.getCurrentSearchReference().get(), this, true, null));
    }

    @Override
    public EntityId getId(@NotNull Document doc) {
        if (this.entityTypeId < 0) {
            return TextIndexManagerImpl.getDocumentEntityId(doc);
        }
        return new PersistentEntityId(this.entityTypeId, TextIndexManagerImpl.getDocumentEntityLocalId(doc));
    }
}

