/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.util.Collections;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jetbrains.exodus.env.EnvironmentConfig;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StaticSettings {
    @NotNull
    @NonNls
    static final String DEBUG_DIRECTORY_SETTING = "jetbrains.dnq.textIndex.debugDirectory";
    @NotNull
    @NonNls
    static final String RAM_DIRECTORY_SETTING = "jetbrains.dnq.textIndex.RAMDirectory";
    @NotNull
    @NonNls
    static final String NRT_CACHE_SIZE = "jetbrains.dnq.textIndex.NRTCacheSizeMB";
    @NotNull
    @NonNls
    static final String USE_PATRICIA_AS_VFS_TREE_SETTING = "jetbrains.dnq.textIndex.usePatriciaAsVFSTree";
    private static final boolean USE_PATRICIA_AS_VFS_TREE_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("jetbrains.dnq.textIndex.usePatriciaAsVFSTree", "true"));
    @NotNull
    @NonNls
    static final String INDEX_INPUT_BUFFER_SIZE = "jetbrains.dnq.textIndex.indexInputBufferSize";
    @NotNull
    @NonNls
    static final String INDEX_INPUT_MERGE_BUFFER_SIZE = "jetbrains.dnq.textIndex.indexInputMergeBufferSize";
    @NotNull
    @NonNls
    static final String STOP_WORD_EXCEPTIONS_SETTING = "jetbrains.dnq.textIndex.stopWordExceptions";
    @NotNull
    @NonNls
    static final String VFS_CLUSTER_SIZE_SETTING = "jetbrains.dnq.textIndex.vfsClusterSize";
    @NotNull
    @NonNls
    static final String COMPRESSION_TYPE_SETTING = "jetbrains.dnq.textIndex.compression";
    @NotNull
    @NonNls
    private static final String DEFAULT_COMPRESSION = "lz4";
    @NotNull
    @NonNls
    static final String FAIR_LOCK_SETTING = "jetbrains.dnq.textIndex.fairLock";
    @NotNull
    @NonNls
    static final String READ_LOCK_TIMEOUT_SETTING = "jetbrains.dnq.textIndex.readLockTimeout";
    private static final long READ_LOCK_TIMEOUT = Long.getLong("jetbrains.dnq.textIndex.readLockTimeout", 60000L);
    @NotNull
    @NonNls
    static final String CHECK_INDEX_ON_ERROR_SETTING = "jetbrains.dnq.textIndex.chackIndexOnError";
    @NotNull
    @NonNls
    static final String FILES_DELETION_DELAY_SETTING = "jetbrains.dnq.textIndex.filesDeletionDelay";
    @NotNull
    @NonNls
    static final String MAX_INDEXING_TRANSACTION_DURATION_SETTING = "jetbrains.dnq.textIndex.maxTxnDuration";
    private static long MAX_INDEXING_TRANSACTION_DURATION = Long.getLong("jetbrains.dnq.textIndex.maxTxnDuration", 3000L);
    @NotNull
    @NonNls
    static final String INITIAL_INDEXING_DELAY_SETTING = "jetbrains.dnq.textIndex.initialIndexingDelay";
    private static final long INITIAL_INDEXING_DELAY = Long.getLong("jetbrains.dnq.textIndex.initialIndexingDelay", 1000L);
    @NotNull
    @NonNls
    static final String IGNORE_VERSION_SETTING = "jetbrains.dnq.textIndex.ignoreVersion";
    @NotNull
    @NonNls
    static final String START_SUSPENDED_SETTING = "jetbrains.dnq.textIndex.startSuspended";
    @NotNull
    @NonNls
    static final String IGNORE_BRACES_SETTING = "jetbrains.dnq.textIndex.ignoreBraces";
    @NotNull
    @NonNls
    public static final String MIN_PREFIX_QUERY_LENGTH_SETTING = "jetbrains.dnq.textIndex.minPrefixQueryLength";
    private static final Pattern STOP_WORD_SPLIT_PATTERN = Pattern.compile(",");
    private static final String[] STOP_WORD_EXCEPTIONS = StaticSettings.mergeStopWordExceptions("as", System.getProperty("jetbrains.dnq.textIndex.stopWordExceptions"));

    StaticSettings() {
    }

    static boolean useDebugDirectory() {
        return Boolean.getBoolean(DEBUG_DIRECTORY_SETTING);
    }

    static boolean useRAMDirectory() {
        return Boolean.getBoolean(RAM_DIRECTORY_SETTING);
    }

    static double getNRTCacheSizeMb() {
        double nrtSize = 0.0;
        try {
            nrtSize = Double.parseDouble(System.getProperty(NRT_CACHE_SIZE, "0.0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return nrtSize;
    }

    static boolean usePatriciaAsVFSDefaultTree() {
        return USE_PATRICIA_AS_VFS_TREE_BY_DEFAULT;
    }

    static int getIndexInputBufferSize(int defaultValue) {
        return Integer.getInteger(INDEX_INPUT_BUFFER_SIZE, defaultValue);
    }

    static int getIndexInputMergeBufferSize(int defaultValue) {
        return Integer.getInteger(INDEX_INPUT_MERGE_BUFFER_SIZE, defaultValue);
    }

    @NotNull
    static String[] getStopWordExceptions() {
        return STOP_WORD_EXCEPTIONS;
    }

    static int getVfsClusterSize() {
        return Integer.getInteger(VFS_CLUSTER_SIZE_SETTING, 4096);
    }

    @NotNull
    static String getCompressionType() {
        return System.getProperty(COMPRESSION_TYPE_SETTING, DEFAULT_COMPRESSION);
    }

    static boolean useFairLock() {
        return Boolean.getBoolean(FAIR_LOCK_SETTING);
    }

    static long getReadLockTimeout() {
        return READ_LOCK_TIMEOUT;
    }

    static boolean checkIndexOnError() {
        return Boolean.getBoolean(CHECK_INDEX_ON_ERROR_SETTING);
    }

    static int getFilesDeletionDelay() {
        return Integer.getInteger(FILES_DELETION_DELAY_SETTING, EnvironmentConfig.DEFAULT.getGcFilesDeletionDelay());
    }

    static long getMaxIndexingTxnDuration() {
        return MAX_INDEXING_TRANSACTION_DURATION;
    }

    static long getInitialIndexingDelay() {
        return INITIAL_INDEXING_DELAY;
    }

    static boolean ignoreVersion() {
        return Boolean.getBoolean(IGNORE_VERSION_SETTING);
    }

    static boolean startSuspended() {
        String startSuspended = System.getProperty(START_SUSPENDED_SETTING);
        return startSuspended == null || "true".equalsIgnoreCase(startSuspended);
    }

    static boolean ignoreBraces() {
        return Boolean.getBoolean(IGNORE_BRACES_SETTING);
    }

    static int getMinPrefixQueryLength() {
        return Integer.getInteger(MIN_PREFIX_QUERY_LENGTH_SETTING, 3);
    }

    private static String[] mergeStopWordExceptions(@NotNull String hardCodedExceptions, @Nullable String configuredExceptions) {
        TreeSet set = new TreeSet();
        Collections.addAll(set, STOP_WORD_SPLIT_PATTERN.split(hardCodedExceptions));
        if (configuredExceptions != null) {
            Collections.addAll(set, STOP_WORD_SPLIT_PATTERN.split(configuredExceptions));
        }
        return set.toArray(new String[0]);
    }
}

