/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.SoftObjectCache;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashMap;
import jetbrains.exodus.core.execution.DecoratorJob;
import jetbrains.exodus.core.execution.DelegatingJobProcessor;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.util.StringHashMap;
import jetbrains.youtrack.textindex.BeansKt;
import jetbrains.youtrack.textindex.DocumentBooster;
import jetbrains.youtrack.textindex.HitsEntityIterableBase;
import jetbrains.youtrack.textindex.StaticSettings;
import jetbrains.youtrack.textindex.analysis.GenericAnalyzer;
import jetbrains.youtrack.textindex.analysis.StringReplace;
import jetbrains.youtrack.textindex.api.TextIndexEntityMetaData;
import jetbrains.youtrack.textindex.api.TextIndexListener;
import jetbrains.youtrack.textindex.api.TextIndexManager;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import jetbrains.youtrack.textindex.async.ClearIndexJob;
import jetbrains.youtrack.textindex.async.QueueDeletionOfObsoleteDocuments;
import jetbrains.youtrack.textindex.async.QueueUnindexedDocumentsJob;
import jetbrains.youtrack.textindex.async.ReindexJob;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanCreationException;
import webr.framework.controller.WebLocalScope;

public abstract class TextIndexManagerBase
extends DelegatingJobProcessor<ThreadJobProcessor>
implements TextIndexManager {
    public static final Log log = LogFactory.getLog(TextIndexManager.class);
    private static final int INDEX_VERSION = 20;
    private static final int QUERY_CACHE_SIZE = 1024;
    private static final int MAX_DOCUMENTS_PER_TRANSACTION = 1000;
    @NotNull
    @NonNls
    public static final String TEXT_INDEX_MANAGER_THREAD_NAME = "TextIndexManager";
    @NotNull
    @NonNls
    private static final String TEXT_INDEX_VERSION = "Text Index Version";
    @NotNull
    @NonNls
    private static final String TEXT_INDEX_VERSION_INTERNAL = "Text Index Version Internal";
    @NotNull
    @NonNls
    private static final String INTERNAL_SETTINGS = "----internal.settings----";
    @NotNull
    @NonNls
    static final String ENTIRE_DOCUMENT_FIELD = "entire_doc";
    @NotNull
    @NonNls
    static final String ENTIRE_DOCUMENT_REVERSED_FIELD = "entire_doc_reversed";
    private static final List<int[]> EMPTY_OFFSETS = Collections.unmodifiableList(Collections.emptyList());
    private static final Map<String, String> HARD_CODED_PREFIXES;
    @NotNull
    private final TextIndexMetaData textIndexMetaData;
    @NotNull
    protected final PersistentEntityStoreImpl store;
    @NotNull
    private final TransientEntityStore transientStore;
    @NotNull
    private final DecoratorJob batchIndexingJob;
    @NotNull
    protected final ContextualEnvironment environment;
    protected Store internalSettings;
    @NotNull
    private final Set<TextIndexListener> listeners;
    private final LinkedHashMap<EntityId, Boolean> pendingDocuments;
    private boolean isSuspended;
    private long lastIndexJobStartTime = 0L;
    @NotNull
    protected final SoftObjectCache<QueryCacheKey, Query> queriesCache;
    private boolean stemRussian;
    private boolean stemGerman;
    private boolean stemFrench;
    private boolean stemSpanish;
    private boolean stemPortuguese;
    private boolean stemItalian;
    private boolean stemDutch;
    private boolean stemFinnish;
    private boolean stemSwedish;
    private boolean stemNorwegian;
    private boolean stemDanish;
    private boolean stemPolish;
    private boolean stemCzech;
    private boolean stemGreek;
    private boolean stemLatvian;
    private boolean stemArabic;
    private boolean stemTurkish;
    private boolean stemChinese;
    private boolean stemJapanese;
    private boolean stemKorean;
    private final GenericAnalyzer queryAnalyzer;
    private final GenericAnalyzer textAnalyzer;
    @NotNull
    private DocumentBooster documentBooster;
    private boolean boostWordFormsFlagCached;

    protected TextIndexManagerBase(@NotNull ContextualEnvironment environment, @NotNull TextIndexMetaData metaData, @NotNull PersistentEntityStoreImpl store, @NotNull TransientEntityStore transientStore, @NotNull DecoratorJob transactionalDecoratorJob) {
        super((JobProcessorAdapter)ThreadJobProcessorPool.getOrCreateJobProcessor((String)TEXT_INDEX_MANAGER_THREAD_NAME));
        this.environment = environment;
        TextIndexManagerBase.adjustEnvironmentSettings((Environment)environment);
        this.textIndexMetaData = metaData;
        this.store = store;
        this.transientStore = transientStore;
        this.batchIndexingJob = transactionalDecoratorJob.newDecoratorJob((Job)new BatchIndexingJob());
        this.listeners = new HashSet();
        this.pendingDocuments = new LinkedHashMap();
        this.isSuspended = StaticSettings.startSuspended();
        this.queriesCache = new SoftObjectCache(1024);
        this.queryAnalyzer = new GenericAnalyzer();
        this.textAnalyzer = new GenericAnalyzer(true);
        Store settings = (Store)environment.computeInTransaction(txn -> environment.openStore(INTERNAL_SETTINGS, StoreConfig.WITHOUT_DUPLICATES, txn, false));
        this.documentBooster = DocumentBooster.TRIVIAL;
        if (settings == null) {
            this.initSettings();
        } else {
            this.internalSettings = settings;
            if (this.shouldRebuild()) {
                environment.clear();
                this.initSettings();
            }
        }
    }

    protected void initSettings() {
        this.internalSettings = (Store)this.environment.computeInTransaction(txn -> this.environment.openStore(INTERNAL_SETTINGS, StoreConfig.WITHOUT_DUPLICATES, txn, true));
        Settings.set((Store)this.internalSettings, (String)TEXT_INDEX_VERSION, (String)this.textIndexMetaData.getVersionLabel());
        Settings.set((Store)this.internalSettings, (String)TEXT_INDEX_VERSION_INTERNAL, (String)Integer.toString(20));
    }

    protected boolean shouldRebuild() {
        if (StaticSettings.useDebugDirectory()) {
            return true;
        }
        if (!StaticSettings.ignoreVersion()) {
            String version = Settings.get((Store)this.internalSettings, (String)TEXT_INDEX_VERSION);
            if (version == null || !version.equalsIgnoreCase(this.textIndexMetaData.getVersionLabel())) {
                return true;
            }
            int currentInternalVersion = -1;
            try {
                String internalVersion = Settings.get((Store)this.internalSettings, (String)TEXT_INDEX_VERSION_INTERNAL);
                if (internalVersion != null) {
                    currentInternalVersion = Integer.parseInt(internalVersion);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return currentInternalVersion != 20;
        }
        return false;
    }

    public void init() {
        this.setExceptionHandler((processor, job, t) -> log.error((Object)t.getLocalizedMessage(), t));
        this.start();
        this.queueUnindexedDocuments();
        new QueueDeletionOfObsoleteDocuments(this);
        log.debug((Object)"Inited successfully.");
    }

    public void close() {
        this.environment.close();
    }

    public long getStoreSize() {
        return this.environment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE).getTotal();
    }

    public void clearIndex() {
        new ClearIndexJob(this);
    }

    public void reindex() {
        new ReindexJob(this);
    }

    public void queueUnindexedDocuments() {
        new QueueUnindexedDocumentsJob(this);
    }

    public void indexDocument(@NotNull EntityId id, boolean forceReindexing) {
        if (forceReindexing || !this.isIndexed(id)) {
            this.updatePendingDocumentsQueue(id, false);
        }
    }

    public void deleteDocument(@NotNull EntityId id) {
        this.updatePendingDocumentsQueue(id, true);
    }

    @NotNull
    public EntityIterable searchFor(@Nullable String queryString) {
        return this.searchFor(queryString, null);
    }

    @NotNull
    public EntityIterable searchFor(@Nullable String queryString, @Nullable String entityType) {
        return this.searchFor(queryString, entityType, ENTIRE_DOCUMENT_FIELD);
    }

    @NotNull
    public EntityIterable searchFor(@Nullable String queryString, @Nullable String entityType, @NotNull String field) {
        if (queryString != null && queryString.length() > 0) {
            PersistentStoreTransaction txn = this.store.getAndCheckCurrentTransaction();
            int entityTypeId = entityType == null ? -1 : this.store.getEntityTypeId(txn, entityType, false);
            Query query = this.getQuery(queryString, field, entityTypeId);
            if (StringUtils.isEmpty((String)query.toString()) && entityTypeId >= 0) {
                return new EntitiesOfTypeIterable(txn, entityTypeId);
            }
            return this.getSearchResults(query, entityTypeId);
        }
        return EntityIterableBase.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingDocs() {
        int pendingJobs = this.pendingJobs() + this.pendingTimedJobs();
        LinkedHashMap<EntityId, Boolean> linkedHashMap = this.pendingDocuments;
        synchronized (linkedHashMap) {
            return this.pendingDocuments.size() + pendingJobs;
        }
    }

    public void waitForPendingDocs() {
        this.waitForLatchJob(new LatchJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute() {
                int pendingDocs;
                LinkedHashMap linkedHashMap = TextIndexManagerBase.this.pendingDocuments;
                synchronized (linkedHashMap) {
                    pendingDocs = TextIndexManagerBase.this.pendingDocuments.size();
                }
                if (pendingDocs == 0) {
                    this.release();
                } else {
                    JobProcessor processor = this.getProcessor();
                    processor.queue(processor.getCurrentJob(), Priority.lowest);
                }
            }
        }, 100L, Priority.lowest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendIndexing() {
        LinkedHashMap<EntityId, Boolean> linkedHashMap = this.pendingDocuments;
        synchronized (linkedHashMap) {
            this.isSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIndexing() {
        boolean queueTheJob;
        LinkedHashMap<EntityId, Boolean> linkedHashMap = this.pendingDocuments;
        synchronized (linkedHashMap) {
            queueTheJob = !this.pendingDocuments.isEmpty();
            this.isSuspended = false;
        }
        if (queueTheJob) {
            this.queueBatchIndexingJobImmediate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        LinkedHashMap<EntityId, Boolean> linkedHashMap = this.pendingDocuments;
        synchronized (linkedHashMap) {
            return this.isSuspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull TextIndexListener listener) {
        Set<TextIndexListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull TextIndexListener listener) {
        Set<TextIndexListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextIndexListener[] getListeners() {
        Set<TextIndexListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new TextIndexListener[0]);
        }
    }

    @NotNull
    public List<int[]> getOffsets(@NotNull String text, @NotNull String query) {
        int startOffset;
        int queryLen = query.length();
        if (queryLen == 0 || text.length() == 0) {
            return EMPTY_OFFSETS;
        }
        text = text.toLowerCase();
        query = query.toLowerCase();
        ArrayList<int[]> result = new ArrayList<int[]>();
        BitSet filter2 = new BitSet(text.length());
        String phrase = queryLen > 2 && query.charAt(0) == '\"' && query.charAt(queryLen - 1) == '\"' ? query.substring(1, queryLen - 1) : query;
        int fromOffset = 0;
        while ((startOffset = text.indexOf(phrase, fromOffset)) >= 0) {
            fromOffset = startOffset + phrase.length();
            TextIndexManagerBase.updateOffsets(result, filter2, startOffset, fromOffset);
        }
        HashSet words = new HashSet();
        try {
            try (TokenStream queryStream = TextIndexManagerBase.tokenStream(this.queryAnalyzer, "", query);){
                while (queryStream.incrementToken()) {
                    words.add(((CharTermAttribute)queryStream.getAttribute(CharTermAttribute.class)).toString());
                }
            }
            var10_13 = null;
            try (TokenStream textStream = TextIndexManagerBase.tokenStream(this.textAnalyzer, "", text);){
                while (textStream.incrementToken()) {
                    String term = ((CharTermAttribute)textStream.getAttribute(CharTermAttribute.class)).toString();
                    if (!words.contains(term)) continue;
                    OffsetAttribute offset = (OffsetAttribute)textStream.getAttribute(OffsetAttribute.class);
                    int startOffset2 = offset.startOffset();
                    int endOffset = offset.endOffset();
                    TextIndexManagerBase.updateOffsets(result, filter2, startOffset2, endOffset);
                }
            }
            catch (Throwable term) {
                var10_13 = term;
                throw term;
            }
            boolean swapped = true;
            int i = result.size();
            while (swapped) {
                swapped = false;
                for (int j = 1; j < i; ++j) {
                    int[] second;
                    int[] first = (int[])result.get(j - 1);
                    if (first[0] <= (second = (int[])result.get(j))[0]) continue;
                    swapped = true;
                    result.set(j - 1, second);
                    result.set(j, first);
                }
                --i;
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), null);
            throw (RuntimeException)(e instanceof RuntimeException ? e : new RuntimeException(e));
        }
    }

    private static void updateOffsets(List<int[]> result, BitSet filter2, int startOffset, int endOffset) {
        int i = filter2.nextSetBit(startOffset);
        if (i < startOffset || i >= endOffset) {
            result.add(new int[]{startOffset, endOffset});
            filter2.set(startOffset, endOffset);
        }
    }

    public boolean getUseRussianStemmer() {
        return this.stemRussian;
    }

    public void setUseRussianStemmer(boolean stemming) {
        if (this.stemRussian != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Russian");
            this.stemRussian = stemming;
        }
    }

    public boolean getUseGermanStemmer() {
        return this.stemGerman;
    }

    public void setUseGermanStemmer(boolean stemming) {
        if (this.stemGerman != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "German");
            this.stemGerman = stemming;
        }
    }

    public boolean getUseFrenchStemmer() {
        return this.stemFrench;
    }

    public void setUseFrenchStemmer(boolean stemming) {
        if (this.stemFrench != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "French");
            this.stemFrench = stemming;
        }
    }

    public boolean getUseSpanishStemmer() {
        return this.stemSpanish;
    }

    public void setUseSpanishStemmer(boolean stemming) {
        if (this.stemSpanish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Spanish");
            this.stemSpanish = stemming;
        }
    }

    public boolean getUsePortugueseStemmer() {
        return this.stemPortuguese;
    }

    public void setUsePortugueseStemmer(boolean stemming) {
        if (this.stemPortuguese != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Portuguese");
            this.stemPortuguese = stemming;
        }
    }

    public boolean getUseItalianStemmer() {
        return this.stemItalian;
    }

    public void setUseItalianStemmer(boolean stemming) {
        if (this.stemItalian != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Italian");
            this.stemItalian = stemming;
        }
    }

    public boolean getUseDutchStemmer() {
        return this.stemDutch;
    }

    public void setUseDutchStemmer(boolean stemming) {
        if (this.stemDutch != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Dutch");
            this.stemDutch = stemming;
        }
    }

    public boolean getUseFinnishStemmer() {
        return this.stemFinnish;
    }

    public void setUseFinnishStemmer(boolean stemming) {
        if (this.stemFinnish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Finnish");
            this.stemFinnish = stemming;
        }
    }

    public boolean getUseSwedishStemmer() {
        return this.stemSwedish;
    }

    public void setUseSwedishStemmer(boolean stemming) {
        if (this.stemSwedish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Swedish");
            this.stemSwedish = stemming;
        }
    }

    public boolean getUseNorwegianStemmer() {
        return this.stemNorwegian;
    }

    public void setUseNorwegianStemmer(boolean stemming) {
        if (this.stemNorwegian != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Norwegian");
            this.stemNorwegian = stemming;
        }
    }

    public boolean getUseDanishStemmer() {
        return this.stemDanish;
    }

    public void setUseDanishStemmer(boolean stemming) {
        if (this.stemDanish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Danish");
            this.stemDanish = stemming;
        }
    }

    public boolean getUsePolishStemmer() {
        return this.stemPolish;
    }

    public void setUsePolishStemmer(boolean stemming) {
        if (this.stemPolish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Polish");
            this.stemPolish = stemming;
        }
    }

    public boolean getUseCzechStemmer() {
        return this.stemCzech;
    }

    public void setUseCzechStemmer(boolean stemming) {
        if (this.stemCzech != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Czech");
            this.stemCzech = stemming;
        }
    }

    public boolean getUseGreekStemmer() {
        return this.stemGreek;
    }

    public void setUseGreekStemmer(boolean stemming) {
        if (this.stemGreek != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Greek");
            this.stemGreek = stemming;
        }
    }

    public boolean getUseLatvianStemmer() {
        return this.stemLatvian;
    }

    public void setUseLatvianStemmer(boolean stemming) {
        if (this.stemLatvian != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Latvian");
            this.stemLatvian = stemming;
        }
    }

    public boolean getUseArabicStemmer() {
        return this.stemArabic;
    }

    public void setUseArabicStemmer(boolean stemming) {
        if (this.stemArabic != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Arabic");
            this.stemArabic = stemming;
        }
    }

    public boolean getUseTurkishStemmer() {
        return this.stemTurkish;
    }

    public void setUseTurkishStemmer(boolean stemming) {
        if (this.stemTurkish != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Turkish");
            this.stemTurkish = stemming;
        }
    }

    public boolean getUseChineseStemmer() {
        return this.stemChinese;
    }

    public void setUseChineseStemmer(boolean stemming) {
        if (this.stemChinese != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Chinese");
            this.stemChinese = stemming;
        }
    }

    public boolean getUseJapaneseStemmer() {
        return this.stemJapanese;
    }

    public void setUseJapaneseStemmer(boolean stemming) {
        if (this.stemJapanese != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Japanese");
            this.stemJapanese = stemming;
        }
    }

    public boolean getUseKoreanStemmer() {
        return this.stemKorean;
    }

    public void setUseKoreanStemmer(boolean stemming) {
        if (this.stemKorean != stemming) {
            this.addRemoveAnalyzerLanguage(stemming, "Korean");
            this.stemKorean = stemming;
        }
    }

    @NotNull
    public TextIndexMetaData getMetaData() {
        return this.textIndexMetaData;
    }

    public TextIndexEntityMetaData getEntityMetaData(@NotNull Entity entity) {
        String entityType;
        TextIndexMetaData metaData = this.getMetaData();
        TextIndexEntityMetaData entityMetaData = metaData.getEntityMetaData(entityType = entity.getType());
        if (entityMetaData == null) {
            throw new RuntimeException("No text index metadata for entity type " + entityType);
        }
        return entityMetaData;
    }

    public PersistentEntityStoreImpl getPersistentStore() {
        return this.store;
    }

    @NotNull
    public TransientEntityStore getTransientStore() {
        return this.transientStore;
    }

    public GenericAnalyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public GenericAnalyzer getTextAnalyzer() {
        return this.textAnalyzer;
    }

    public Transaction beginReadonlyTransaction() {
        return this.environment.beginReadonlyTransaction();
    }

    public <T> T computeInReadonlyTransaction(@NotNull TransactionalComputable<T> computable) {
        return (T)this.environment.computeInReadonlyTransaction(computable);
    }

    public String getLocation() {
        return this.environment.getLocation();
    }

    @NotNull
    public DocumentBooster getDocumentBooster() {
        return this.documentBooster;
    }

    public void setDocumentBooster(@NotNull DocumentBooster documentBooster) {
        this.documentBooster = documentBooster;
    }

    public abstract long totalDocs();

    public abstract void clearIndexImpl() throws Exception;

    public abstract void indexDocumentImpl(@NotNull IndexingContext var1, @NotNull Entity var2, @NotNull TextIndexEntityMetaData var3) throws Exception;

    public abstract void deleteDocumentImpl(@NotNull IndexingContext var1, @NotNull EntityId var2) throws Exception;

    public abstract void queueDeletionOfObsoleteDocuments(@NotNull StoreTransaction var1);

    protected abstract IndexingContext createIndexingContext() throws IOException;

    protected abstract boolean isIndexed(@NotNull EntityId var1);

    protected abstract HitsEntityIterableBase getSearchResults(@NotNull Query var1, int var2);

    protected abstract boolean hasTermsStartingWith(@NotNull String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getQuery(@NotNull String queryString, @NotNull String field, int entityTypeId) {
        Query query;
        queryString = TextIndexManagerBase.preProcessQueryString(queryString);
        QueryCacheKey cacheKey = new QueryCacheKey(entityTypeId, queryString, field);
        SoftObjectCache<QueryCacheKey, Query> softObjectCache = this.queriesCache;
        synchronized (softObjectCache) {
            query = (Query)this.queriesCache.tryKey((Object)cacheKey);
        }
        if (query == null) {
            QueryParser queryParser = new QueryParser(field, (Analyzer)this.queryAnalyzer);
            queryParser.setAllowLeadingWildcard(true);
            queryParser.setDefaultOperator(QueryParser.Operator.AND);
            try {
                query = TextIndexManagerBase.modifyAloneAsterisks(queryParser, queryString);
                query = query instanceof PrefixQuery || query instanceof WildcardQuery ? (queryString.indexOf(46) >= 0 ? TextIndexManagerBase.modifyPrefixOrWildcardQuery(queryParser, queryString, '.') : (queryString.indexOf(95) >= 0 ? TextIndexManagerBase.modifyPrefixOrWildcardQuery(queryParser, queryString, '_') : this.adjustPrefixQuery(query, entityTypeId))) : this.adjustBooleanQuery(query, entityTypeId);
                query = this.boostSpecifiedWordForms(query, queryString);
            }
            catch (ParseException e) {
                if (queryString.indexOf(40) >= 0 || queryString.indexOf(41) >= 0 || queryString.indexOf(58) >= 0 || queryString.indexOf(91) >= 0 || queryString.indexOf(93) >= 0) {
                    queryString = queryString.replace('(', ' ').replace(')', ' ').replace(':', ' ').replace('[', ' ').replace(']', ' ');
                    return this.getQuery(queryString, field, entityTypeId);
                }
                query = new TermQuery(new Term(field, queryString));
            }
            catch (IllegalArgumentException e) {
                if (queryString.indexOf(126) >= 0) {
                    queryString = queryString.replace('~', ' ');
                    return this.getQuery(queryString, field, entityTypeId);
                }
                log.info((Object)("Failed to parse: " + queryString), (Throwable)e);
                query = new TermQuery(new Term(field, queryString));
            }
            SoftObjectCache<QueryCacheKey, Query> softObjectCache2 = this.queriesCache;
            synchronized (softObjectCache2) {
                if (this.queriesCache.getObject((Object)cacheKey) == null) {
                    this.queriesCache.cacheObject((Object)cacheKey, (Object)query);
                }
            }
        }
        return query;
    }

    public static TokenStream tokenStream(@NotNull Analyzer analyzer, @NotNull String field, @NotNull String text) throws IOException {
        TokenStream result = analyzer.tokenStream(field, (Reader)new StringReader(text));
        result.reset();
        return result;
    }

    boolean boostWordForms() {
        try {
            if (WebLocalScope.getContainerDontCreate() != null) {
                this.boostWordFormsFlagCached = BeansKt.getBoostWordFormsFeatureFlag().isEnabled();
            }
        }
        catch (BeanCreationException beanCreationException) {
            // empty catch block
        }
        return this.boostWordFormsFlagCached;
    }

    private static void adjustEnvironmentSettings(@NotNull Environment environment) {
        environment.getEnvironmentConfig().setGcFilesDeletionDelay(StaticSettings.getFilesDeletionDelay());
    }

    private void addRemoveAnalyzerLanguage(boolean stemming, @NotNull String language) {
        if (stemming) {
            this.queryAnalyzer.addLanguage(language);
            this.textAnalyzer.addLanguage(language);
        } else {
            this.queryAnalyzer.removeLanguage(language);
            this.textAnalyzer.removeLanguage(language);
        }
    }

    private Query adjustPrefixQuery(@NotNull Query query, int entityTypeId) {
        if (query instanceof PrefixQuery) {
            boolean stemGerman = this.getUseGermanStemmer();
            Term term = ((PrefixQuery)query).getPrefix();
            String prefix = GenericAnalyzer.removeAccents(term.text());
            String field = term.field();
            BooleanQuery.Builder result = new BooleanQuery.Builder();
            if (stemGerman && prefix.startsWith("alt")) {
                result.add((Query)new PrefixQuery(new Term(field, "alt")), BooleanClause.Occur.SHOULD);
            } else {
                result.add((Query)new PrefixQuery(new Term(field, this.getMinLengthPrefix(prefix))), BooleanClause.Occur.SHOULD);
            }
            result.add(this.getQuery(prefix, field, entityTypeId), BooleanClause.Occur.SHOULD);
            return result.build();
        }
        if (query instanceof WildcardQuery) {
            WildcardQuery wq = (WildcardQuery)query;
            Term term = wq.getTerm();
            String field = term.field();
            String text = GenericAnalyzer.removeAccents(term.text());
            int length = text.length();
            if (length > 2 && text.charAt(0) == '*' && text.charAt(length - 1) == '*') {
                BooleanQuery.Builder result = new BooleanQuery.Builder();
                String wildcard = text.substring(1, length - 1);
                Query tq = this.getQuery(wildcard, field, entityTypeId);
                result.add(tq, BooleanClause.Occur.SHOULD);
                result.add((Query)new WildcardQuery(new Term(field, '*' + this.getMinLengthPrefix(wildcard) + '*')), BooleanClause.Occur.SHOULD);
                return result.build();
            }
            return new WildcardQuery(new Term(field, text));
        }
        return query;
    }

    @NotNull
    private String getMinLengthPrefix(@NotNull String prefix) {
        int length;
        String hardcoded = HARD_CODED_PREFIXES.get(prefix);
        if (hardcoded != null) {
            return hardcoded;
        }
        int minPrefixQueryLength = Math.max(1, StaticSettings.getMinPrefixQueryLength());
        while ((length = prefix.length()) > minPrefixQueryLength && !this.hasTermsStartingWith(prefix)) {
            prefix = prefix.substring(0, length - 1);
        }
        return prefix;
    }

    private static Query modifyPrefixOrWildcardQuery(@NotNull QueryParser queryParser, @NotNull String queryString, char delimiter) throws ParseException {
        return TextIndexManagerBase.modifyAloneAsterisks(queryParser, queryString.replace(delimiter, ' '));
    }

    private static Query modifyAloneAsterisks(@NotNull QueryParser queryParser, @NotNull String queryString) throws ParseException {
        int queryLen = queryString.length();
        char[] chars = new char[queryLen];
        queryString.getChars(0, queryLen, chars, 0);
        boolean prevIsAsterisk = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (prevIsAsterisk && c == '*') {
                chars[i] = 32;
            }
            prevIsAsterisk = c == '*';
        }
        boolean prevIsDelimiter = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '*' && prevIsDelimiter && (i == chars.length - 1 || !Character.isLetterOrDigit(chars[i + 1]))) {
                chars[i] = 32;
            }
            prevIsDelimiter = !Character.isLetterOrDigit(chars[i]);
        }
        return queryParser.parse(new String(chars));
    }

    private static String preProcessQueryString(@NotNull String queryString) {
        String result = queryString.replace('!', ' ');
        result = result.replace('/', ' ');
        result = result.replace('\\', ' ');
        result = StringReplace.replaceAll(result, "debugger", "debug");
        result = StringReplace.replaceAll(result, "aliases", "alias");
        result = StringReplace.replaceAll(result, "focused", "focus");
        if (StaticSettings.ignoreBraces()) {
            result = result.replace('{', ' ');
            result = result.replace('}', ' ');
        }
        if ((result = result.replace('\\', '/')).indexOf(34) < 0) {
            int length = result.length();
            if (length > 0 && result.charAt(length - 1) == ':') {
                result = result.substring(0, length - 1);
            }
            if (result.indexOf(63) >= 0 || result.indexOf(58) >= 0) {
                String withoutColon = result.replace(':', ' ');
                result = '(' + result + ") || \"" + withoutColon + "\" || (" + withoutColon.replace('?', ' ') + ')';
            }
        } else {
            result = result.replace(':', ' ');
        }
        return result;
    }

    private Query adjustBooleanQuery(@NotNull Query query, int entityTypeId) {
        if (query instanceof BooleanQuery) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : (BooleanQuery)query) {
                builder.add(this.adjustPrefixQuery(clause.getQuery(), entityTypeId), clause.getOccur());
            }
            return builder.build();
        }
        return query;
    }

    private Query boostSpecifiedWordForms(@NotNull Query query, @NotNull String queryString) throws ParseException {
        int queryLen = queryString.length();
        if (queryLen > 2 && this.boostWordForms()) {
            boolean phrase;
            boolean bl = phrase = queryString.charAt(0) == '\"' && queryString.charAt(queryLen - 1) == '\"';
            if (phrase || TextIndexManagerBase.isGroupOfTermQueries(query)) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add(query, BooleanClause.Occur.MUST);
                QueryParser queryParser = new QueryParser(ENTIRE_DOCUMENT_REVERSED_FIELD, (Analyzer)this.queryAnalyzer);
                String reversedQuery = new StringBuilder(queryString).reverse().toString();
                builder.add(queryParser.parse(phrase ? reversedQuery.replace('\"', ' ') : reversedQuery), phrase && query instanceof TermQuery ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
                return builder.build();
            }
        }
        return query;
    }

    private static boolean isGroupOfTermQueries(@NotNull Query query) {
        if (query instanceof TermQuery) {
            return true;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (TextIndexManagerBase.isGroupOfTermQueries(clause.getQuery())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePendingDocumentsQueue(@NotNull EntityId id, boolean deleteDoc) {
        boolean queueTimedJob;
        LinkedHashMap<EntityId, Boolean> linkedHashMap = this.pendingDocuments;
        synchronized (linkedHashMap) {
            queueTimedJob = this.pendingDocuments.isEmpty();
            this.pendingDocuments.put((Object)id, (Object)deleteDoc);
        }
        if (queueTimedJob) {
            this.queueBatchIndexingJobDeferred();
        } else if (System.currentTimeMillis() - this.lastIndexJobStartTime > StaticSettings.getMaxIndexingTxnDuration()) {
            this.queueBatchIndexingJobImmediate();
        }
    }

    private void queueBatchIndexingJobImmediate() {
        this.queue((Job)this.batchIndexingJob);
    }

    private void queueBatchIndexingJobDeferred() {
        this.queueIn((Job)this.batchIndexingJob, StaticSettings.getInitialIndexingDelay());
    }

    static {
        StringHashMap hardCodedPrefixes = new StringHashMap();
        hardCodedPrefixes.put("notificatio", (Object)"notif");
        hardCodedPrefixes.put("notificati", (Object)"notif");
        hardCodedPrefixes.put("notificat", (Object)"notif");
        hardCodedPrefixes.put("notifica", (Object)"notif");
        hardCodedPrefixes.put("notific", (Object)"notif");
        hardCodedPrefixes.put("notifi", (Object)"notif");
        HARD_CODED_PREFIXES = Collections.unmodifiableMap(hardCodedPrefixes);
    }

    private static final class QueryCacheKey {
        private final int entityType;
        @NotNull
        private final String queryString;
        @NotNull
        private final String field;
        private final int hc;

        private QueryCacheKey(int entityType, @NotNull String queryString, @NotNull String field) {
            this.entityType = entityType;
            this.queryString = queryString;
            this.field = field;
            this.hc = queryString.toLowerCase().hashCode() + field.toLowerCase().hashCode() + this.entityType;
        }

        public boolean equals(Object o) {
            QueryCacheKey that = (QueryCacheKey)o;
            return this.entityType == that.entityType && this.queryString.equalsIgnoreCase(that.queryString) && this.field.equalsIgnoreCase(that.field);
        }

        public int hashCode() {
            return this.hc;
        }
    }

    private final class BatchIndexingJob
    extends Job {
        private BatchIndexingJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() {
            Map.Entry<EntityId, Boolean> doc = this.getNextDocument();
            if (doc != null) {
                TextIndexManagerBase.this.lastIndexJobStartTime = System.currentTimeMillis();
                ArrayList<Map.Entry<EntityId, Boolean>> txnDocuments = new ArrayList<Map.Entry<EntityId, Boolean>>();
                Transaction txn = TextIndexManagerBase.this.environment.beginTransaction();
                try {
                    boolean bl;
                    if (txn.isReadonly()) {
                        LinkedHashMap linkedHashMap = TextIndexManagerBase.this.pendingDocuments;
                        synchronized (linkedHashMap) {
                            TextIndexManagerBase.this.pendingDocuments.put((Object)doc.getKey(), (Object)doc.getValue());
                        }
                        return;
                    }
                    long jobStarted = System.currentTimeMillis();
                    IndexingContext indexingContext = TextIndexManagerBase.this.createIndexingContext();
                    try {
                        TransientStoreSession transientStoreSession = TextIndexManagerBase.this.getTransientStore().getThreadSession();
                        do {
                            transientStoreSession.revert();
                            txnDocuments.add(doc);
                            EntityId entityId = doc.getKey();
                            if (doc.getValue().booleanValue()) {
                                TextIndexManagerBase.this.deleteDocumentImpl(indexingContext, entityId);
                                for (TextIndexListener listener : TextIndexManagerBase.this.getListeners()) {
                                    listener.documentDeleted(entityId);
                                }
                            } else {
                                Entity entity = null;
                                try {
                                    entity = transientStoreSession.getEntity(entityId);
                                }
                                catch (EntityRemovedInDatabaseException entityRemovedInDatabaseException) {
                                    // empty catch block
                                }
                                if (entity != null) {
                                    TextIndexManagerBase.this.indexDocumentImpl(indexingContext, entity, TextIndexManagerBase.this.getEntityMetaData(entity));
                                }
                            }
                            long currentRunDuration = System.currentTimeMillis() - jobStarted;
                            if (txnDocuments.size() >= 1000) break;
                            if (currentRunDuration <= StaticSettings.getMaxIndexingTxnDuration()) continue;
                            break;
                        } while ((doc = this.getNextDocument()) != null);
                    }
                    finally {
                        indexingContext.close(() -> {
                            if (!txn.flush()) {
                                throw new RuntimeException("Failed to flush batch indexing transaction");
                            }
                        });
                    }
                    LinkedHashMap linkedHashMap = TextIndexManagerBase.this.pendingDocuments;
                    synchronized (linkedHashMap) {
                        bl = !TextIndexManagerBase.this.pendingDocuments.isEmpty();
                    }
                    if (bl) {
                        TextIndexManagerBase.this.queueBatchIndexingJobImmediate();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to index " + txnDocuments.size() + " documents"), t);
                    LinkedHashMap linkedHashMap = TextIndexManagerBase.this.pendingDocuments;
                    synchronized (linkedHashMap) {
                        for (Map.Entry entry : txnDocuments) {
                            TextIndexManagerBase.this.pendingDocuments.put(entry.getKey(), entry.getValue());
                        }
                    }
                    TextIndexManagerBase.this.queueBatchIndexingJobDeferred();
                }
                finally {
                    txn.abort();
                }
            }
        }

        public JobProcessor getProcessor() {
            return TextIndexManagerBase.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Map.Entry<EntityId, Boolean> getNextDocument() {
            LinkedHashMap linkedHashMap = TextIndexManagerBase.this.pendingDocuments;
            synchronized (linkedHashMap) {
                if (TextIndexManagerBase.this.isSuspended) {
                    return null;
                }
                Iterator it = TextIndexManagerBase.this.pendingDocuments.entrySet().iterator();
                if (!it.hasNext()) {
                    return null;
                }
                Map.Entry next = (Map.Entry)it.next();
                TextIndexManagerBase.this.pendingDocuments.remove(next.getKey());
                return next;
            }
        }
    }

    protected static interface IndexingContext {
        public void close(@Nullable Runnable var1) throws Exception;
    }
}

