/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.SoftLongObjectCache;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.vfs.ClusterConverter;
import org.jetbrains.annotations.NotNull;

class VfsContentCache
implements ClusterConverter {
    static final int CLUSTER_CACHE_SIZE = Integer.getInteger("jetbrains.dnq.textIndex.vfsContentCacheSize", 20000000);
    private static volatile LongObjectCacheBase<CachedEntry> clusterCacheInstance = null;
    @NotNull
    private final ContextualEnvironment env;
    @NotNull
    private final ClusterConverter decorated;
    private final LongObjectCacheBase<CachedEntry> clusterCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LongObjectCacheBase<CachedEntry> getCache(int clusterSize) {
        SoftLongObjectCache result = clusterCacheInstance;
        if (result != null) return result;
        Class<VfsContentCache> clazz = VfsContentCache.class;
        synchronized (VfsContentCache.class) {
            result = clusterCacheInstance;
            if (result != null) return result;
            clusterCacheInstance = new SoftLongObjectCache(CLUSTER_CACHE_SIZE / clusterSize);
            return clusterCacheInstance;
        }
    }

    VfsContentCache(@NotNull ContextualEnvironment env, int clusterSize, @NotNull ClusterConverter decorated) {
        this.env = env;
        this.clusterCache = VfsContentCache.getCache(clusterSize);
        this.decorated = decorated;
    }

    @NotNull
    public ByteIterable onRead(final @NotNull ByteIterable raw) {
        return new ByteIterableBase(){
            ByteIterator it = null;

            protected ByteIterator getIterator() {
                if (this.it == null) {
                    FixedLengthByteIterable flRaw;
                    ByteIterable source;
                    if (raw instanceof FixedLengthByteIterable && (source = (flRaw = (FixedLengthByteIterable)raw).getSource()) instanceof ByteIterableWithAddress) {
                        ArrayByteIterable cached;
                        Transaction txn = VfsContentCache.this.env.getCurrentTransaction();
                        boolean isReadonlyTxn = txn != null && txn.isReadonly();
                        int rawLength = raw.getLength();
                        ByteIterableWithAddress addressedSource = (ByteIterableWithAddress)source;
                        long address = addressedSource.getDataAddress() + (long)flRaw.getOffset();
                        int envId = ((EnvironmentImpl)VfsContentCache.this.env).getLog().getIdentity();
                        long cacheKey = address + ((long)(envId & Integer.MAX_VALUE) << 32) + ((long)rawLength << 46);
                        CachedEntry entry = (CachedEntry)VfsContentCache.this.clusterCache.tryKey(cacheKey);
                        if (entry != null && entry.address == address && entry.length == rawLength && entry.envId == envId) {
                            cached = entry.cached;
                        } else {
                            cached = (ArrayByteIterable)VfsContentCache.this.decorated.onRead(raw);
                            if (isReadonlyTxn) {
                                VfsContentCache.this.clusterCache.cacheObject(cacheKey, (Object)new CachedEntry(envId, address, rawLength, cached));
                            }
                        }
                        this.it = cached.iterator();
                    }
                    if (this.it == null) {
                        this.it = VfsContentCache.this.decorated.onRead(raw).iterator();
                    }
                }
                return this.it;
            }
        };
    }

    @NotNull
    public ByteIterable onWrite(@NotNull ByteIterable source) {
        return this.decorated.onWrite(source);
    }

    private static class CachedEntry {
        final int envId;
        final long address;
        final int length;
        @NotNull
        final ArrayByteIterable cached;

        CachedEntry(int envId, long address, int length, @NotNull ArrayByteIterable cached) {
            this.envId = envId;
            this.address = address;
            this.length = length;
            this.cached = cached;
        }
    }
}

