/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex.settings;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.maintenance.TextIndexSettingsImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.service.MarkupRender;
import jetbrains.youtrack.api.service.MarkupRenderFactory;
import jetbrains.youtrack.textindex.TextIndexManagerImpl;
import jetbrains.youtrack.textindex.TextIndexSettingsFactory;
import jetbrains.youtrack.textindex.api.TextIndexManager;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/textindex/settings/TextIndexSettingsFactoryImpl;", "Ljetbrains/youtrack/textindex/TextIndexSettingsFactory;", "()V", "manager", "Ljetbrains/youtrack/textindex/api/TextIndexManager;", "getManager", "()Ljetbrains/youtrack/textindex/api/TextIndexManager;", "getOrCreateSettings", "Ljetbrains/exodus/entitystore/Entity;", "initSettings", "", "settings", "initTextIndexManager", "initTextIndexManagerAndReindex", "youtrack-text-search"})
public final class TextIndexSettingsFactoryImpl
implements TextIndexSettingsFactory {
    @NotNull
    public final TextIndexManager getManager() {
        String name$iv = "textIndexManager";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexManager");
        }
        return (TextIndexManager)object;
    }

    @NotNull
    public Entity getOrCreateSettings() {
        Entity result = QueryOperations.getFirst((Iterable)((Iterable)QueryOperations.queryGetAll((String)"TextIndexSettings")));
        if (EntityOperations.equals((Entity)result, null)) {
            result = TextIndexSettingsImpl.constructor();
        } else {
            Entity entity = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"result");
            this.initTextIndexManager(entity);
        }
        Object object = ServiceLocator.getBean((String)"textIndexMetaData");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexMetaData");
        }
        ((TextIndexMetaData)object).setRemoveWikiFunction(new TextIndexMetaData.RemoveWikiFunction(){

            @NotNull
            public String removeWiki(@NotNull Entity entity, @NotNull String source) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Object object = ServiceLocator.getBean((String)"markupRenderFactory");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.service.MarkupRenderFactory");
                }
                MarkupRender builder = ((MarkupRenderFactory)object).createBuilder();
                if (Intrinsics.areEqual((Object)Boolean.TRUE, (Object)entity.getProperty("usesMarkdown"))) {
                    String string2 = builder.markdown(true).removeMarkup(source);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.markdown(true).removeMarkup(source)");
                } else {
                    String string3 = builder.removeMarkup(source);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.removeMarkup(source)");
                }
                return string;
            }
        });
        this.getManager().setSimilarityIgnoredField("Issue", "issue id");
        this.getManager().setSimilarityIgnoredField("Issue", "attachments");
        this.getManager().setSimilarityIgnoredField("Issue", "comments");
        this.getManager().setSimilarityIgnoredField("Issue", "fields");
        this.getManager().setSimilarityIgnoredField("Issue", "work items");
        Entity entity = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"result");
        return entity;
    }

    public void initSettings(@NotNull Entity settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemRussian", (Comparable)Boolean.valueOf(this.getManager().getUseRussianStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemGerman", (Comparable)Boolean.valueOf(this.getManager().getUseGermanStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemFrench", (Comparable)Boolean.valueOf(this.getManager().getUseFrenchStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemSpanish", (Comparable)Boolean.valueOf(this.getManager().getUseSpanishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemItalian", (Comparable)Boolean.valueOf(this.getManager().getUseItalianStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemPortuguese", (Comparable)Boolean.valueOf(this.getManager().getUsePortugueseStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemDutch", (Comparable)Boolean.valueOf(this.getManager().getUseDutchStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemSwedish", (Comparable)Boolean.valueOf(this.getManager().getUseSwedishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemFinnish", (Comparable)Boolean.valueOf(this.getManager().getUseFinnishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemDanish", (Comparable)Boolean.valueOf(this.getManager().getUseDanishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemNorwegian", (Comparable)Boolean.valueOf(this.getManager().getUseNorwegianStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemCzech", (Comparable)Boolean.valueOf(this.getManager().getUseCzechStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemPolish", (Comparable)Boolean.valueOf(this.getManager().getUsePolishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemLatvian", (Comparable)Boolean.valueOf(this.getManager().getUseLatvianStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemGreek", (Comparable)Boolean.valueOf(this.getManager().getUseGreekStemmer()), Boolean.TYPE);
        Object object = ServiceLocator.getBean((String)"textIndexManager");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexManager");
        }
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemTurkish", (Comparable)Boolean.valueOf(((TextIndexManager)object).getUseTurkishStemmer()), Boolean.TYPE);
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemArabic", (Comparable)Boolean.valueOf(this.getManager().getUseArabicStemmer()), Boolean.TYPE);
        Object object2 = ServiceLocator.getBean((String)"textIndexManager");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexManager");
        }
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemChinese", (Comparable)Boolean.valueOf(((TextIndexManager)object2).getUseChineseStemmer()), Boolean.TYPE);
        Object object3 = ServiceLocator.getBean((String)"textIndexManager");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexManager");
        }
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemJapanese", (Comparable)Boolean.valueOf(((TextIndexManager)object3).getUseJapaneseStemmer()), Boolean.TYPE);
        Object object4 = ServiceLocator.getBean((String)"textIndexManager");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.api.TextIndexManager");
        }
        PrimitiveAssociationSemantics.set((Entity)settings, (String)"stemKorean", (Comparable)Boolean.valueOf(((TextIndexManager)object4).getUseKoreanStemmer()), Boolean.TYPE);
    }

    public void initTextIndexManager(@NotNull Entity settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        TextIndexManager textIndexManager = this.getManager();
        Object object = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemRussian", Boolean.TYPE, null);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager.setUseRussianStemmer(((Boolean)object).booleanValue());
        TextIndexManager textIndexManager2 = this.getManager();
        Object object2 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemGerman", Boolean.TYPE, null);
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager2.setUseGermanStemmer(((Boolean)object2).booleanValue());
        TextIndexManager textIndexManager3 = this.getManager();
        Object object3 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemFrench", Boolean.TYPE, null);
        if (object3 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager3.setUseFrenchStemmer(((Boolean)object3).booleanValue());
        TextIndexManager textIndexManager4 = this.getManager();
        Object object4 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemSpanish", Boolean.TYPE, null);
        if (object4 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager4.setUseSpanishStemmer(((Boolean)object4).booleanValue());
        TextIndexManager textIndexManager5 = this.getManager();
        Object object5 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemItalian", Boolean.TYPE, null);
        if (object5 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager5.setUseItalianStemmer(((Boolean)object5).booleanValue());
        TextIndexManager textIndexManager6 = this.getManager();
        Object object6 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemPortuguese", Boolean.TYPE, null);
        if (object6 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager6.setUsePortugueseStemmer(((Boolean)object6).booleanValue());
        TextIndexManager textIndexManager7 = this.getManager();
        Object object7 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemDutch", Boolean.TYPE, null);
        if (object7 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager7.setUseDutchStemmer(((Boolean)object7).booleanValue());
        TextIndexManager textIndexManager8 = this.getManager();
        Object object8 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemSwedish", Boolean.TYPE, null);
        if (object8 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager8.setUseSwedishStemmer(((Boolean)object8).booleanValue());
        TextIndexManager textIndexManager9 = this.getManager();
        Object object9 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemFinnish", Boolean.TYPE, null);
        if (object9 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager9.setUseFinnishStemmer(((Boolean)object9).booleanValue());
        TextIndexManager textIndexManager10 = this.getManager();
        Object object10 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemDanish", Boolean.TYPE, null);
        if (object10 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager10.setUseDanishStemmer(((Boolean)object10).booleanValue());
        TextIndexManager textIndexManager11 = this.getManager();
        Object object11 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemNorwegian", Boolean.TYPE, null);
        if (object11 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager11.setUseNorwegianStemmer(((Boolean)object11).booleanValue());
        TextIndexManager textIndexManager12 = this.getManager();
        Object object12 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemCzech", Boolean.TYPE, null);
        if (object12 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager12.setUseCzechStemmer(((Boolean)object12).booleanValue());
        TextIndexManager textIndexManager13 = this.getManager();
        Object object13 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemPolish", Boolean.TYPE, null);
        if (object13 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager13.setUsePolishStemmer(((Boolean)object13).booleanValue());
        TextIndexManager textIndexManager14 = this.getManager();
        Object object14 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemLatvian", Boolean.TYPE, null);
        if (object14 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager14.setUseLatvianStemmer(((Boolean)object14).booleanValue());
        TextIndexManager textIndexManager15 = this.getManager();
        Object object15 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemGreek", Boolean.TYPE, null);
        if (object15 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager15.setUseGreekStemmer(((Boolean)object15).booleanValue());
        TextIndexManager textIndexManager16 = this.getManager();
        Object object16 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemTurkish", Boolean.TYPE, null);
        if (object16 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager16.setUseTurkishStemmer(((Boolean)object16).booleanValue());
        TextIndexManager textIndexManager17 = this.getManager();
        Object object17 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemArabic", Boolean.TYPE, null);
        if (object17 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager17.setUseArabicStemmer(((Boolean)object17).booleanValue());
        TextIndexManager textIndexManager18 = this.getManager();
        Object object18 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemChinese", Boolean.TYPE, null);
        if (object18 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager18.setUseChineseStemmer(((Boolean)object18).booleanValue());
        TextIndexManager textIndexManager19 = this.getManager();
        Object object19 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemJapanese", Boolean.TYPE, null);
        if (object19 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager19.setUseJapaneseStemmer(((Boolean)object19).booleanValue());
        TextIndexManager textIndexManager20 = this.getManager();
        Object object20 = PrimitiveAssociationSemantics.get((Entity)settings, (String)"stemKorean", Boolean.TYPE, null);
        if (object20 == null) {
            Intrinsics.throwNpe();
        }
        textIndexManager20.setUseKoreanStemmer(((Boolean)object20).booleanValue());
    }

    public void initTextIndexManagerAndReindex(@NotNull Entity settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.initTextIndexManager(settings);
        TextIndexManager textIndexManager = this.getManager();
        if (textIndexManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.textindex.TextIndexManagerImpl");
        }
        ((TextIndexManagerImpl)textIndexManager).reindex();
    }
}

