/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.event;

import java.util.Locale;
import jetbrains.charisma.timeTracking.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/timetracking/event/WorkItemAdapter;", "", "item", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "author", "getAuthor", "()Ljetbrains/exodus/entitystore/Entity;", "date", "", "getDate", "()Ljava/lang/String;", "description", "getDescription", "duration", "getDuration", "entity", "getEntity$youtrack_time_tracking", "localizer", "Ljetbrains/mps/internationalization/runtime/Localizer;", "getLocalizer", "()Ljetbrains/mps/internationalization/runtime/Localizer;", "type", "getType", "xdWorkItem", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "youtrack-time-tracking"})
public final class WorkItemAdapter {
    private final XdIssueWorkItem xdWorkItem;

    private final Localizer getLocalizer() {
        String name$iv = "localizer";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.mps.internationalization.runtime.Localizer");
        }
        return (Localizer)object;
    }

    @NotNull
    public final Entity getAuthor() {
        return this.xdWorkItem.getAuthor().getEntity();
    }

    @Nullable
    public final String getDescription() {
        return this.xdWorkItem.getDescription();
    }

    @NotNull
    public final String getDuration() {
        String string = BeansKt.getTimeTrackingProvider().getPeriodFormatter().print((ReadablePeriod)this.xdWorkItem.getTimePeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"timeTrackingProvider.per\u2026nt(xdWorkItem.timePeriod)");
        return string;
    }

    @NotNull
    public final String getDate() {
        DateTime date2 = DateTimeOperations.convert((Long)this.xdWorkItem.getDate(), (DateTimeZone)DateTimeZone.UTC);
        DateTimeFormatter formatter = DateFormats.INSTANCE.getFormatter("humanDate");
        String string = DateTimeOperations.print((DateTime)date2, (DateTimeFormatter)formatter, (Locale)this.getLocalizer().getLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateTimeOperations.print\u2026matter, localizer.locale)");
        return string;
    }

    @NotNull
    public final String getType() {
        Object object = this.xdWorkItem.getType();
        if (object == null || (object = object.getName()) == null) {
            object = XdWorkItemType.Companion.getEmptyValue();
        }
        return object;
    }

    @NotNull
    public final Entity getEntity$youtrack_time_tracking() {
        return this.xdWorkItem.getEntity();
    }

    public WorkItemAdapter(@NotNull Entity item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this.xdWorkItem = (XdIssueWorkItem)XdExtensionsKt.toXd((Entity)item);
    }
}

