/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.periodField;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jetbrains.gap.resource.Entity;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.periodField.PeriodValue$getPeriod$1;
import jetbrains.youtrack.timetracking.periodField.PeriodValue$getPeriod$2;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/timetracking/periodField/PeriodValue;", "Ljetbrains/gap/resource/Entity;", "_period", "Lorg/joda/time/Period;", "(Lorg/joda/time/Period;)V", "id", "", "getId", "()Ljava/lang/String;", "minutes", "", "getMinutes", "()I", "presentation", "getPresentation", "getPeriod", "youtrack-time-tracking"})
public class PeriodValue
extends Entity {
    private final Period _period;

    @NotNull
    public String getId() {
        return String.valueOf(this.getPeriod());
    }

    public int getMinutes() {
        XdWorkTimeSettings xdWorkTimeSettings = BeansKt.getWorkTimeSettings();
        Period period = this._period;
        if (period == null) {
            Intrinsics.throwNpe();
        }
        return xdWorkTimeSettings.getMinutes(period);
    }

    @NotNull
    public String getPresentation() {
        String string = jetbrains.charisma.timeTracking.BeansKt.getTimeTrackingProvider().getPeriodFormatter().print((ReadablePeriod)this._period);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"timeTrackingProvider.per\u2026dFormatter.print(_period)");
        return string;
    }

    @JsonIgnore
    @Nullable
    public final Period getPeriod() {
        CharSequence charSequence;
        if (this._period != null) {
            return this._period;
        }
        Period result2 = null;
        if (this.provides(PeriodValue$getPeriod$1.INSTANCE)) {
            result2 = BeansKt.getWorkTimeSettings().getPeriod(this.getMinutes());
        }
        if (this.provides(PeriodValue$getPeriod$2.INSTANCE) && !((charSequence = (CharSequence)this.getPresentation()).length() == 0)) {
            if (result2 != null) {
                if (Intrinsics.areEqual((Object)result2, (Object)jetbrains.charisma.timeTracking.BeansKt.getTimeTrackingProvider().parse(this.getPresentation())) ^ true) {
                    throw (Throwable)new LocalizedBadRequestException("PeriodIssueCustomField.conflict_in_period_value", new Object[0]);
                }
            } else {
                result2 = jetbrains.charisma.timeTracking.BeansKt.getTimeTrackingProvider().parse(this.getPresentation());
            }
        }
        return result2;
    }

    public PeriodValue(@Nullable Period _period) {
        this._period = _period;
    }

    public /* synthetic */ PeriodValue(Period period, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            period = null;
        }
        this(period);
    }

    public PeriodValue() {
        this(null, 1, null);
    }
}

