/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.periodField.parser;

import java.util.Locale;
import javax.ws.rs.ForbiddenException;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\t*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/timetracking/periodField/parser/AddWorkItemCommandExecutor;", "Ljetbrains/youtrack/api/commands/ICommandExecutor;", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "date", "", "duration", "", "description", "", "(Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;JILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getDuration", "()I", "getType", "()Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "execute", "", "issue", "Ljetbrains/exodus/entitystore/Entity;", "getDebugDescription", "getField", "Ljetbrains/youtrack/api/parser/IField;", "getPresentation", "isTailCommand", "", "toStringWithoutYear", "youtrack-time-tracking"})
public class AddWorkItemCommandExecutor
implements ICommandExecutor {
    private final long date;
    @Nullable
    private final XdWorkItemType type;
    private final int duration;
    @Nullable
    private final String description;

    @NotNull
    public String getDebugDescription() {
        StringBuilder sb = new StringBuilder("");
        if (this.type != null) {
            sb.append(this.type.getName()).append(":");
        }
        GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        DateTimeZone userTimeZone = generalUserProfile.getTimeZone();
        if (new DateTime(this.date, DateTimeZone.UTC).getDayOfMonth() != new DateTime(System.currentTimeMillis(), userTimeZone).getDayOfMonth()) {
            sb.append(this.toStringWithoutYear(this.date)).append(":");
        }
        sb.append(BeansKt.getWorkTimeSettings().format(this.duration));
        CharSequence charSequence = this.description;
        if (!(charSequence == null || charSequence.length() == 0)) {
            sb.append(":").append(this.description);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String getPresentation() {
        String durationStr = BeansKt.getWorkTimeSettings().format(this.duration);
        String dateStr = this.toStringWithoutYear(this.date);
        Object object = this.type;
        if (object == null || (object = object.getName()) == null) {
            object = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("TimeTracking.work", new Object[0]);
        }
        Object workType = object;
        CharSequence charSequence = this.description;
        if (charSequence == null || charSequence.length() == 0) {
            return jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("AddWorkItemCommandExecutor.Add_{period}_of_work_on_{date}", new Object[]{durationStr, workType, dateStr});
        }
        return jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("AddWorkItemCommandExecutor.Add_{period}_of_work_on_{date}_with_description_{2}", new Object[]{durationStr, workType, dateStr, this.description});
    }

    public void execute(@NotNull Entity issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdIssue xdIssue = (XdIssue)XdExtensionsKt.toXd((Entity)issue2);
        if (!XdTimeTrackingSettingsKt.getTimeTrackingSettings(xdIssue.getProject()).getEnabled()) {
            throw (Throwable)new IllegalStateException("Time tracking is disabled");
        }
        if (!XdTimeTrackingSettingsKt.canCreateWorkItem$default(xdIssue.getProject(), null, 1, null)) {
            throw (Throwable)new ForbiddenException("You are not allowed to create work item");
        }
        XdIssueWorkItem.Companion.new(xdIssue, jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser(), this.date, (Function1<? super XdIssueWorkItem, Unit>)((Function1)new Function1<XdIssueWorkItem, Unit>(this){
            final /* synthetic */ AddWorkItemCommandExecutor this$0;

            public final void invoke(@NotNull XdIssueWorkItem $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setDuration(this.this$0.getDuration());
                $receiver.setDescription(this.this$0.getDescription());
                $receiver.setType(this.this$0.getType());
            }
            {
                this.this$0 = addWorkItemCommandExecutor;
                super(1);
            }
        }));
    }

    @NotNull
    public IField getField() {
        return jetbrains.charisma.keyword.BeansKt.getPredefinedFieldWork();
    }

    public boolean isTailCommand() {
        return false;
    }

    private final String toStringWithoutYear(long $receiver) {
        String string = DateTimeOperations.print((DateTime)new DateTime($receiver, DateTimeZone.UTC), (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("date-no-year"), (Locale)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateTimeOperations.print\u2026year\"), localizer.locale)");
        return string;
    }

    @Nullable
    public final XdWorkItemType getType() {
        return this.type;
    }

    public final int getDuration() {
        return this.duration;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public AddWorkItemCommandExecutor(@Nullable XdWorkItemType type2, long date2, int duration2, @Nullable String description) {
        this.type = type2;
        this.duration = duration2;
        this.description = description;
        this.date = XdWorkItemKt.toMidnightInUTC$default(date2, null, 1, null);
    }
}

