/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.timetracking.workflow;

import jetbrains.charisma.customfields.persistence.XdAbstractCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.api.workflow.annotations.ApiDocReturns;
import jetbrains.youtrack.api.workflow.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.api.workflow.annotations.ApiJsIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiJsOptional;
import jetbrains.youtrack.api.workflow.annotations.ApiMethod;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsType;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsTypes;
import jetbrains.youtrack.api.workflow.annotations.ApiScope;
import jetbrains.youtrack.api.workflow.annotations.ApiSince;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.timetracking.BeansKt;
import jetbrains.youtrack.timetracking.persistence.XdBaseWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemType;
import jetbrains.youtrack.timetracking.persistence.XdWorkTimeSettings;
import jetbrains.youtrack.timetracking.workflow.TimeTrackingExtensionsKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.TransientEntityUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0007\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0007\u001a\f\u0010\u0010\u001a\u00020\u0006*\u00020\u0011H\u0007\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0006H\u0007\u001a)\u0010\u0014\u001a\u00020\u0015*\u00020\u00112\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0018\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0007\u001a#\u0010\u001c\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u001e\u001a\u0014\u0010\u001f\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0006H\u0007\u001a\u0014\u0010 \u001a\u00020\u0013*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001aH\u0007\u001a\u0012\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001aM\u0010\"\u001a\u00020\u0002*\u00020\u00032\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u00152\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010)H\u0007\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"editedWorkItems", "", "Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "Ljetbrains/youtrack/persistent/XdIssue;", "findPeriodFieldPrototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "Ljetbrains/youtrack/timetracking/persistence/XdTimeTrackingSettings;", "name", "", "getPeriodCustomField", "Ljetbrains/youtrack/timetracking/persistence/XdPeriodProjectCustomField;", "localizationId", "getPeriodFieldOldValueInMinutes", "", "fieldName", "getPeriodFieldValueInMinutes", "getTimeTrackingSettings", "Ljetbrains/youtrack/persistent/XdProject;", "initDefaults", "", "intervalToWorkingMinutes", "", "start", "end", "(Ljetbrains/youtrack/persistent/XdProject;Ljava/lang/Long;Ljava/lang/Long;)J", "isUsingMarkdown", "", "Ljetbrains/youtrack/timetracking/persistence/XdBaseWorkItem;", "setPeriodFieldValueInMinutes", "value", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/String;Ljava/lang/Integer;)V", "setTimeTrackingSettings", "setUsingMarkdown", "workItems", "workflowAddWorkItem", "description", "date", "author", "Ljetbrains/youtrack/persistent/XdUser;", "duration", "type", "Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;", "(Ljetbrains/youtrack/persistent/XdIssue;Ljava/lang/String;Ljava/lang/Long;Ljetbrains/youtrack/persistent/XdUser;Ljava/lang/Integer;Ljetbrains/youtrack/timetracking/persistence/XdWorkItemType;)Ljetbrains/youtrack/timetracking/persistence/XdIssueWorkItem;", "youtrack-time-tracking"})
public final class TimeTrackingExtensionsKt {
    @Deprecated(message="for Workflow only")
    @ApiDoc(value="Adds a work item to the issue.")
    @ApiDocReturns(value="The new work item.")
    @ApiMethod(name="addWorkItem", scopes={})
    @ApiJsAcceptsJson
    @NotNull
    public static final XdIssueWorkItem workflowAddWorkItem(@NotNull XdIssue $receiver, @ApiDoc(value="The description of the work item.") @Nullable String description, @ApiJsOptional @ApiDoc(value="The date that is assigned to the work item.") @ApiMpsType(value=ApiMpsTypes.INSTANT) @Nullable Long date2, @ApiJsOptional @ApiDoc(value="The user who performed the work.") @Nullable XdUser author, @ApiDoc(value="The work duration in minutes.") @Nullable Integer duration2, @ApiJsOptional @ApiDoc(value="The work item type.") @Nullable XdWorkItemType type2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        XdUser xdUser = author;
        if (xdUser == null) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        Long l = date2;
        return XdIssueWorkItem.Companion.new($receiver, xdUser, l != null ? l : System.currentTimeMillis(), (Function1<? super XdIssueWorkItem, Unit>)((Function1)new Function1<XdIssueWorkItem, Unit>(duration2, type2, description){
            final /* synthetic */ Integer $duration;
            final /* synthetic */ XdWorkItemType $type;
            final /* synthetic */ String $description;

            public final void invoke(@NotNull XdIssueWorkItem $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setDuration(this.$duration == null || this.$duration <= 0 ? 1 : this.$duration);
                $receiver.setType(this.$type);
                $receiver.setDescription(this.$description);
            }
            {
                this.$duration = n;
                this.$type = xdWorkItemType;
                this.$description = string;
                super(1);
            }
        }));
    }

    @ApiDoc(value="Gets the number of minutes that occurred during working hours in a specified interval.\nFor example, if the interval is two days and the number of working hours in a day is set to 8, the result is 2 * 8 * 60 = 960")
    @ApiDocReturns(value="The number of minutes that occurred during working hours in the specified interval.")
    @ApiMethod(scopes={})
    public static final long intervalToWorkingMinutes(@NotNull XdProject $receiver, @ApiDoc(value="Start of the interval.") @Nullable Long start, @ApiDoc(value="End of the interval.") @Nullable Long end) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Long l = end;
        Long l2 = start;
        long duration2 = (l != null ? l : 0L) - (l2 != null ? l2 : 0L);
        int minutes = (int)(duration2 / (long)1000 / (long)60);
        int hours = minutes / 60;
        minutes = Math.min(minutes % 60, 60);
        int days = hours / 24;
        hours = Math.min(hours % 24, BeansKt.getWorkTimeSettings().getMinutesADay() / 60);
        int weeks = days / 7;
        days = Math.min(days % 7, BeansKt.getWorkTimeSettings().getDaysAWeek());
        XdWorkTimeSettings xdWorkTimeSettings = BeansKt.getWorkTimeSettings();
        Period period = new Period().withWeeks(weeks).withDays(days).withHours(hours).withMinutes(minutes);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period().withWeeks(weeks\u2026urs).withMinutes(minutes)");
        return xdWorkTimeSettings.getMinutes(period);
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="The set of work items that have been added to the issue.")
    @ApiMethod(name="getWorkItems", scopes={})
    @NotNull
    public static final Iterable<XdIssueWorkItem> workItems(@NotNull XdIssue $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return XdQueryKt.asIterable(XdWorkItemKt.getWorkItems($receiver));
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="The set of work items that are edited in the current transaction.\nWork items that are added and removed are not considered to be edited.\nInstead, these are represented by the `issue.workItems.added` and\n`issue.workItems.removed` properties.")
    @ApiSince(value="2017.4.37824")
    @ApiMethod(name="getEditedWorkItems", scopes={})
    @NotNull
    public static final Iterable<XdIssueWorkItem> editedWorkItems(@NotNull XdIssue $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SequencesKt.asIterable((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(XdWorkItemKt.getWorkItems($receiver)), (Function1)editedWorkItems.1.INSTANCE));
    }

    @Deprecated(message="for Workflow only")
    @ApiDoc(value="When `true`, the work item description is parsed as Markdown. When `false`, the work item description is parsed as YouTrack Wiki.\nChanging this value does not transform the markup from one syntax to another.")
    @ApiSince(value="2017.4.38870")
    @ApiMethod(scopes={})
    public static final boolean isUsingMarkdown(@NotNull XdBaseWorkItem $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        return $receiver.getUsesMarkdown();
    }

    @Deprecated(message="for Workflow only")
    @ApiMethod(scopes={})
    public static final void setUsingMarkdown(@NotNull XdBaseWorkItem $receiver, boolean value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        $receiver.setUsesMarkdown(value2);
    }

    @Deprecated(message="for Workflow only")
    @ApiMethod(scopes={ApiScope.PLUGIN})
    public static final void initDefaults(@NotNull XdTimeTrackingSettings $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        $receiver.setEstimate(TimeTrackingExtensionsKt.getPeriodCustomField($receiver, "youtrack.timetracking.estimation"));
        $receiver.setSpentTime(TimeTrackingExtensionsKt.getPeriodCustomField($receiver, "youtrack.timetracking.spent_time"));
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final int getPeriodFieldValueInMinutes(@NotNull XdIssue $receiver, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$receiver.getProject(), (String)fieldName);
        if (field != null) {
            Integer value2;
            XdCustomFieldPrototype prototype = field.getPrototype();
            Integer n = value2 = BeansKt.getPeriodFieldType().getValueInMinutes($receiver, (XdAbstractCustomFieldPrototype)prototype);
            return n != null ? n : 0;
        }
        throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $receiver.getProject().getShortName());
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final int getPeriodFieldOldValueInMinutes(@NotNull XdIssue $receiver, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$receiver.getProject(), (String)fieldName);
        if (field != null) {
            Integer value2;
            XdCustomFieldPrototype prototype = field.getPrototype();
            Integer n = value2 = (Integer)TransientEntityUtilKt.getOldPrimitiveValue((XdEntity)((XdEntity)$receiver), (String)prototype.getId());
            return n != null ? n : 0;
        }
        throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $receiver.getProject().getShortName());
    }

    @Deprecated(message="for OLD WORKFLOW only")
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsIgnore
    public static final void setPeriodFieldValueInMinutes(@NotNull XdIssue $receiver, @NotNull String fieldName, @Nullable Integer value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProjectCustomField field = XdProjectCustomFieldKt.getProjectCustomField((XdProject)$receiver.getProject(), (String)fieldName);
        if (field == null) {
            throw (Throwable)new IllegalArgumentException("Field " + fieldName + " is not found in project " + $receiver.getProject().getShortName());
        }
        XdCustomFieldPrototype prototype = field.getPrototype();
        BeansKt.getPeriodFieldType().setValueInMinutes($receiver, prototype, value2, true);
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    @ApiDoc(value="Time tracking settings of the project.")
    @NotNull
    public static final XdTimeTrackingSettings getTimeTrackingSettings(@NotNull XdProject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return XdTimeTrackingSettingsKt.getTimeTrackingSettings($receiver);
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    public static final void setTimeTrackingSettings(@NotNull XdProject $receiver, @NotNull XdTimeTrackingSettings value2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
        XdTimeTrackingSettingsKt.setTimeTrackingSettings($receiver, value2);
    }

    private static final XdPeriodProjectCustomField getPeriodCustomField(@NotNull XdTimeTrackingSettings $receiver, String localizationId) {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getDefaultMsg(localizationId, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.getDefaultMsg(localizationId)");
        XdCustomFieldPrototype prototype = TimeTrackingExtensionsKt.findPeriodFieldPrototype($receiver, string);
        XdProjectCustomField projectCustomField = jetbrains.charisma.customfields.simple.common.BeansKt.getXdProjectField((CustomFieldType)((CustomFieldType)BeansKt.getPeriodFieldType()), (XdProject)$receiver.getProject(), (XdCustomFieldPrototype)prototype);
        if (!jetbrains.charisma.installation.BeansKt.getLocalizationService().isDefaultLocale()) {
            projectCustomField.getPrototype().setLocalizedName(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getMsgInLocale(localizationId, jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLocale(), new Object[0]));
        }
        XdProjectCustomField xdProjectCustomField = projectCustomField;
        if (xdProjectCustomField == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.timetracking.persistence.XdPeriodProjectCustomField");
        }
        return (XdPeriodProjectCustomField)xdProjectCustomField;
    }

    private static final XdCustomFieldPrototype findPeriodFieldPrototype(@NotNull XdTimeTrackingSettings $receiver, String name2) {
        XdCustomFieldPrototype prototype = BeansKt.getPeriodFieldType().getXdPrototype(name2);
        if (Intrinsics.areEqual((Object)prototype.getType().getName(), (Object)BeansKt.getPeriodFieldType().getName()) ^ true) {
            TimeTrackingExtensionsKt.findPeriodFieldPrototype($receiver, name2 + "_");
        }
        return prototype;
    }
}

