/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.upsource.changes;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.HubUuidResolver;
import jetbrains.youtrack.api.ring.RingAPI;
import jetbrains.youtrack.api.ring.RingConfig;
import jetbrains.youtrack.api.ring.RingDataStore;
import jetbrains.youtrack.api.ring.RingServiceDiscovery;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.integration.misc.ExceptionOutputUtils;
import jetbrains.youtrack.integration.misc.ProgressStateHolder;
import jetbrains.youtrack.integration.misc.RestClientCache;
import jetbrains.youtrack.integration.vcs.ChangesProcessorImpl;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.NoUserReasonImpl;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import jetbrains.youtrack.upsource.changes.UpsourceAux;
import jetbrains.youtrack.upsource.changes.UpsourceChangesProcessorImpl;
import jetbrains.youtrack.upsource.dto.UpsourceChangeDTO;
import jetbrains.youtrack.upsource.rest.UpsourceChange;
import jetbrains.youtrack.upsource.rest.UpsourceRest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class UpsourceServerImpl
extends VcsServerImpl {
    private static String __ENTITY_TYPE__ = "UpsourceServer";
    public static final String REVIEW_PROJECT_PERMISSION_OBSOLETE = "jetbrains.upsource.permission.project.edit";
    public static final String READ_CODE_PROJECT_PERMISSION = "jetbrains.upsource.project.code.read";
    public static final int TIMEOUT = 60;
    public static final boolean DISABLE_UPSOURCE_INTEGRATION = Boolean.getBoolean("jetbrains.youtrack.disableUpsourceIntegration");
    protected static Log log = LogFactory.getLog(UpsourceServerImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String url, String serviceId, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"url", (Comparable)((Object)url), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"serviceId", (Comparable)((Object)serviceId), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"enabled", (Comparable)Boolean.valueOf(true), Boolean.class);
        return entity;
    }

    public CommonChangeDTO getChange(Iterable<Entity> processors, String version, Entity entity) {
        UpsourceRest rest = ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).getRest(entity);
        for (Entity processor : processors) {
            Entity cp = DnqUtils.cast((Object)processor, (String)"UpsourceChangesProcessor");
            UpsourceChange commit = rest.getCommit((String)PrimitiveAssociationSemantics.get((Entity)cp, (String)"upsourceHubResourceKey", String.class, null), version);
            if (commit == null) continue;
            Tuples._2<Entity, Entity> u = ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).resolveUser(commit.authorId, entity);
            return new UpsourceChangeDTO(null, (Entity)u._0(), (Entity)u._1(), commit, cp);
        }
        return null;
    }

    public Tuples._2<Entity, Entity> resolveUser(String userId, Entity entity) {
        if (userId.startsWith("~")) {
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.UPSOURCE_NO_USER.get());
        }
        try {
            Entity resolvedUser = ((HubUuidResolver)ServiceLocator.getBean((String)"hubUuidResolver")).resolveUser(userId);
            return MultiTuple.from((Object)resolvedUser, (Object)(EntityOperations.equals((Entity)resolvedUser, null) ? NoUserReasonImpl.HUB_NULL_USER.get() : null));
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Error while forcedly syncing a user [" + userId + "]"), (Throwable)e);
            }
            return MultiTuple.from((Object)DnqUtils.cast(null, (String)"User"), (Object)NoUserReasonImpl.HUB_ERROR_FORCE_SYNC.get());
        }
    }

    private UpsourceRest getRest(final Entity entity) {
        UpsourceRest r = (UpsourceRest)((RestClientCache)ServiceLocator.getBean((String)"restClientCache")).get(entity, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<UpsourceRest>(){

            public UpsourceRest invoke() {
                return new UpsourceRest((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null), 60, 60, AssociationSemantics.getToOne((Entity)entity, (String)"sslKey"));
            }
        });
        return r;
    }

    public String getProjectHref(String projectId, Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + "/" + projectId;
    }

    protected void doProcess(boolean async, final Iterable<Entity> cps, final Entity entity) {
        UpsourceServerImpl.run(new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                try {
                    ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).getRest(entity).test();
                }
                catch (ServerErrorException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error when connecting to Upsource server " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + " : " + e.getMessage()));
                    }
                }
                catch (WebApplicationException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error when connecting to Upsource server " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null) + " : " + e.getMessage()));
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error when connecting to Upsource server " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"url", String.class, null)), (Throwable)e);
                    }
                    return;
                }
                Sequence.fromIterable((Iterable)cps).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                    public void visit(Entity it) {
                        block4: {
                            try {
                                ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).process(it, entity);
                                DnqUtils.getCurrentTransientSession().flush();
                            }
                            catch (WebApplicationException e) {
                                if (log.isErrorEnabled()) {
                                    log.error((Object)("Communication error while processing Upsource integration for project [" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + "] with " + e.getMessage()));
                                }
                            }
                            catch (Throwable e) {
                                if (!log.isErrorEnabled()) break block4;
                                log.error((Object)("Error while processing Upsource integration for project [" + (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + "]"), e);
                            }
                        }
                    }
                });
            }
        }, async);
    }

    private void process(Entity it, final Entity entity) {
        final Wrappers._T hsh = new Wrappers._T(PrimitiveAssociationSemantics.get((Entity)DnqUtils.cast((Object)it, (String)"UpsourceChangesProcessor"), (String)"hash", String.class, null));
        _FunctionTypes._return_P1_E0<IListSequence<CommonChangeDTO>, Entity> changesProvider = new _FunctionTypes._return_P1_E0<IListSequence<CommonChangeDTO>, Entity>(){

            public IListSequence<CommonChangeDTO> invoke(final Entity cp) {
                Entity p = DnqUtils.cast((Object)cp, (String)"UpsourceChangesProcessor");
                PrimitiveAssociationSemantics.set((Entity)p, (String)"hash", (Comparable)((Comparable)hsh.value), String.class);
                Tuples._2<Iterable<UpsourceChange>, String> callResult = ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).getRest(entity).getChanges((String)PrimitiveAssociationSemantics.get((Entity)p, (String)"upsourceHubResourceKey", String.class, null), (String)hsh.value, (Iterable<String>)Sequence.singleton((Object)((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)p, (String)"project"), (String)"shortName", String.class, null) + "-")));
                hsh.value = callResult._1();
                return Sequence.fromIterable((Iterable)((Iterable)callResult._0())).select((_FunctionTypes._return_P1_E0)new ISelector<UpsourceChange, CommonChangeDTO>(){

                    public CommonChangeDTO select(UpsourceChange uc) {
                        Tuples._2<Entity, Entity> u = ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"UpsourceServer")).resolveUser(uc.authorId, entity);
                        return new UpsourceChangeDTO(null, (Entity)u._0(), (Entity)u._1(), uc, cp);
                    }
                }).toListSequence();
            }
        };
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ChangesProcessor")).process((_FunctionTypes._return_P1_E0)changesProvider, it);
    }

    public boolean shouldResetClient(Entity entity) {
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"url");
    }

    public void sync(Service service, Entity entity) {
        ISetSequence newCps = SetSequence.fromSet(new HashSet());
        for (Entity project : QueryOperations.queryGetAll((String)"Project")) {
            String projectRingId = UpsourceServerImpl.getProjectRingId(project);
            if (projectRingId == null) continue;
            ISetSequence cps = SetSequence.fromSet(new HashSet());
            for (Resource r : ((Project)((RingAPI)ServiceLocator.getBean((String)"ringApi")).getProjectDAO().get(projectRingId)).getResources()) {
                if (!r.getService().getId().equals(service.getId())) continue;
                Entity cp = UpsourceChangesProcessorImpl.findOrCreate(project, r.getKey(), new String[]{"project", "upsourceHubResourceKey"});
                PrimitiveAssociationSemantics.set((Entity)cp, (String)"upsourceHubResourceId", (Comparable)((Object)r.getId()), String.class);
                DirectedAssociationSemantics.setToOne((Entity)cp, (String)"server", (Entity)entity);
                PrimitiveAssociationSemantics.set((Entity)cp, (String)"upsourceProjectName", (Comparable)((Object)r.getName()), String.class);
                if (EntityOperations.isNew((Entity)cp)) {
                    PrimitiveAssociationSemantics.set((Entity)cp, (String)"enabled", (Comparable)Boolean.valueOf(true), Boolean.class);
                    PrimitiveAssociationSemantics.set((Entity)cp, (String)"taxidermy", (Comparable)Boolean.valueOf(true), Boolean.class);
                    SetSequence.fromSet((Set)newCps).addElement((Object)cp);
                }
                SetSequence.fromSet((Set)cps).addElement((Object)cp);
            }
            Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"UpsourceChangesProcessor", (NodeBase)new And((NodeBase)new LinkEqual("server", entity), (NodeBase)new LinkEqual("project", project)))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Set)cps){
                final /* synthetic */ Set val$cps;
                {
                    this.val$cps = set;
                }

                public void visit(Entity it) {
                    if (!QueryOperations.contains((Iterable)this.val$cps, (Entity)it) && ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ChangesProcessor")).isEnabled(it)) {
                        PrimitiveAssociationSemantics.set((Entity)it, (String)"orphan", (Comparable)Boolean.valueOf(true), Boolean.class);
                        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setStateMessage(it, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UpsourceServer.No_corresponding_Upsource_project_found", new Object[0]));
                    }
                }
            });
        }
        DnqUtils.getCurrentTransientSession().flush();
        this.processAsync((Iterable)newCps, entity);
    }

    @Nullable
    public String getReadRevisionsPermissionId(Entity entity) {
        if (!((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled()) {
            return null;
        }
        Service service = (Service)((RingAPI)ServiceLocator.getBean((String)"ringApi")).getServiceDAO().get((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"serviceId", String.class, null));
        if (service == null) {
            return null;
        }
        String obsoletePermissionId = null;
        for (Permission permission : Sequence.fromIterable((Iterable)service.getPermissions())) {
            if (permission == null || permission.getKey() == null) continue;
            if (permission.getKey().equals(REVIEW_PROJECT_PERMISSION_OBSOLETE)) {
                obsoletePermissionId = permission.getId();
            }
            if (!permission.getKey().equals(READ_CODE_PROJECT_PERMISSION)) continue;
            return permission.getId();
        }
        return obsoletePermissionId;
    }

    public boolean isEnabled(Entity entity) {
        return !DISABLE_UPSOURCE_INTEGRATION && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    public static Entity constructor(String url, String serviceId) {
        return ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(url, serviceId, __ENTITY_TYPE__);
    }

    public static String getProjectRingId(Entity project) {
        String projectRingId = ((RingDataStore)ServiceLocator.getBean((String)"ringDataStore")).getProjectRingId(project);
        if (projectRingId == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No valid Hub id found for project " + (String)PrimitiveAssociationSemantics.get((Entity)project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())));
            }
            return null;
        }
        return projectRingId;
    }

    public static String discover() {
        final String[] res = new String[1];
        UpsourceServerImpl.doDiscover(false, (_FunctionTypes._void_P1_E0<? super String>)new _FunctionTypes._void_P1_E0<String>(){

            public void invoke(String message) {
                res[0] = message;
            }
        });
        return res[0];
    }

    public static void discoverAsync(_FunctionTypes._void_P1_E0<? super String> callback) {
        UpsourceServerImpl.doDiscover(true, callback);
    }

    private static void doDiscover(boolean async, final _FunctionTypes._void_P1_E0<? super String> callback) {
        UpsourceServerImpl.run(new _FunctionTypes._void_P0_E0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke() {
                if (!((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled()) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"[Upsource integration] Hub integration is not active, skipping discovery");
                    }
                    return;
                }
                if (!((UpsourceAux)ServiceLocator.getBean((String)"upsourceAux")).startDiscovery()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"[Upsource integration] Discovery already in progress");
                    }
                    return;
                }
                try {
                    for (Service service : ((RingServiceDiscovery)ServiceLocator.getBean((String)"ringServiceDiscovery")).allByType("Upsource")) {
                        Entity server = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UpsourceServer", (NodeBase)new PropertyEqual("url", (Comparable)((Object)service.getHomeUrl()))));
                        if (EntityOperations.equals((Entity)server, null)) {
                            UpsourceServerImpl.constructor(service.getHomeUrl(), service.getId());
                        } else {
                            PrimitiveAssociationSemantics.set((Entity)server, (String)"serviceId", (Comparable)((Object)service.getId()), String.class);
                        }
                        if (!((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"UpsourceServer")).isEnabled(server)) continue;
                        ((UpsourceServerImpl)DnqUtils.getPersistentClassInstance((Entity)server, (String)"UpsourceServer")).sync(service, server);
                    }
                    callback.invoke(null);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Something went wrong when discovering Upsource servers and projects", (Throwable)e);
                    }
                    callback.invoke((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UpsourceServer.Something_went_wrong_when_discovering_Upsource_servers_and_projects_{0}", new Object[]{ExceptionOutputUtils.createLocalizationObject((Exception)e).getLocalizedMessage()}));
                }
                finally {
                    if (!((UpsourceAux)ServiceLocator.getBean((String)"upsourceAux")).endDiscovery() && log.isErrorEnabled()) {
                        log.error((Object)"[Upsource integration] Something went wrong. Discovery fired several times");
                    }
                }
            }
        }, async);
    }

    public static void run(final _FunctionTypes._void_P0_E0 body, boolean async) {
        if (async) {
            ((Executor)ServiceLocator.getBean((String)"quartzThreadExecutor")).execute(new Runnable(){

                @Override
                public void run() {
                    body.invoke();
                }
            });
        } else {
            body.invoke();
        }
    }
}

