/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.misc;

import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.youtrack.integration.misc.StringUtils;

public class BranchSpec {
    private static final BranchSpecLine SKIP = new BranchSpecLine(false, -2, -2, -2);
    public static final String LINE_SEP = "\n";

    public static Iterable<Boolean> check(String spec) {
        if (BranchSpec.isEmpty_ro8fv2_a0a0a(spec == null ? null : spec.trim())) {
            return Sequence.singleton((Object)true);
        }
        spec = spec.toLowerCase();
        return Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])spec.split(LINE_SEP))).select((_FunctionTypes._return_P1_E0)new ISelector<String, Boolean>(){

            public Boolean select(String it) {
                return BranchSpec.parseLine(it) != null;
            }
        });
    }

    private static BranchSpecLine parseLine(String line) {
        if ((line = line.replace(" ", "")) == null || line.length() == 0) {
            return SKIP;
        }
        if (line.startsWith("#")) {
            return SKIP;
        }
        boolean include = line.startsWith("+:");
        if (!include && !line.startsWith("-:")) {
            return null;
        }
        line = StringUtils.substring(line, 2);
        int o = line.indexOf("(");
        int c = line.indexOf(")");
        if (line.indexOf("(", o + 1) > -1 || line.indexOf(")", c + 1) > -1 || o > -1 && c == -1 || o == -1 && c > -1 || o > c || c - o == 1) {
            return null;
        }
        int ast = line.indexOf("*");
        if (ast == -1 || o == -1 || o < ast && ast < c) {
            return new BranchSpecLine(include, o, c, ast);
        }
        return null;
    }

    public static String match(String spec, String orig) {
        orig = (orig == null ? null : orig.trim()).toLowerCase();
        if (!Sequence.fromIterable(BranchSpec.check(spec = spec.toLowerCase())).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Boolean>(){

            public boolean accept(Boolean it) {
                return it;
            }
        })) {
            return null;
        }
        boolean meaningful = false;
        BranchMatch existingMatch = null;
        for (String line : spec.split(LINE_SEP)) {
            int offset;
            BranchSpecLine branchSpecLine = BranchSpec.parseLine(line = line.replace(" ", ""));
            if (branchSpecLine == SKIP) continue;
            meaningful = true;
            line = StringUtils.substring(line, 2);
            boolean hasBraces = branchSpecLine.getOpen() != -1;
            line = line.replaceAll("[\\(\\*\\)]", "");
            if (branchSpecLine.getAsterisk() == -1) {
                if (!orig.equals(line)) continue;
                existingMatch = BranchSpec.replace(existingMatch, new BranchMatch(branchSpecLine.getInclude(), 0, hasBraces ? StringUtils.substring(orig, branchSpecLine.getOpen(), branchSpecLine.getClose() - 1) : orig));
                continue;
            }
            int n = offset = hasBraces ? 1 : 0;
            if (!orig.startsWith(StringUtils.substring(line, 0, branchSpecLine.getAsterisk() - offset)) || !orig.endsWith(StringUtils.substring(line, branchSpecLine.getAsterisk() + offset))) continue;
            existingMatch = BranchSpec.replace(existingMatch, new BranchMatch(branchSpecLine.getInclude(), orig.length() - line.length(), hasBraces ? StringUtils.substring(orig, branchSpecLine.getOpen(), orig.length() - (line.length() - branchSpecLine.getClose() + 2)) : StringUtils.substring(orig, branchSpecLine.getAsterisk(), orig.length() - (line.length() - branchSpecLine.getAsterisk()))));
        }
        if (meaningful) {
            if (existingMatch != null && existingMatch.getInclude()) {
                return existingMatch.getMatch();
            }
            return null;
        }
        return orig;
    }

    private static BranchMatch replace(BranchMatch existingMatch, BranchMatch newMatch) {
        if (existingMatch == null || existingMatch.getLogicalNameLenght() >= newMatch.getLogicalNameLenght()) {
            return newMatch;
        }
        return existingMatch;
    }

    public static boolean isEmpty_ro8fv2_a0a0a(String str) {
        return str == null || str.length() == 0;
    }

    public static class BranchMatch {
        private boolean myInclude;
        private int myLogicalNameLenght;
        private String myMatch;

        public BranchMatch(boolean include, int logicalNameLenght, String match) {
            this.setInclude(include);
            this.setLogicalNameLenght(logicalNameLenght);
            this.setMatch(match);
        }

        public boolean getInclude() {
            return this.myInclude;
        }

        private void setInclude(boolean value) {
            this.myInclude = value;
        }

        public int getLogicalNameLenght() {
            return this.myLogicalNameLenght;
        }

        private void setLogicalNameLenght(int value) {
            this.myLogicalNameLenght = value;
        }

        public String getMatch() {
            return this.myMatch;
        }

        private void setMatch(String value) {
            this.myMatch = value;
        }
    }

    public static class BranchSpecLine {
        private boolean myInclude;
        private int myOpen;
        private int myClose;
        private int myAsterisk;

        public BranchSpecLine(boolean include, int open, int close, int asterisk) {
            this.setInclude(include);
            this.setOpen(open);
            this.setClose(close);
            this.setAsterisk(asterisk);
        }

        public boolean getInclude() {
            return this.myInclude;
        }

        private void setInclude(boolean value) {
            this.myInclude = value;
        }

        public int getOpen() {
            return this.myOpen;
        }

        private void setOpen(int value) {
            this.myOpen = value;
        }

        public int getClose() {
            return this.myClose;
        }

        private void setClose(int value) {
            this.myClose = value;
        }

        public int getAsterisk() {
            return this.myAsterisk;
        }

        private void setAsterisk(int value) {
            this.myAsterisk = value;
        }
    }
}

